/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenant.impl;

import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.tenant.TenantBatchService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRelationWithUserService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantBatchServiceImpl
implements TenantBatchService {
    @Autowired
    private TenantService tenantService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private TenantRelationWithUserService tenantRelationWithUserService;
    @Autowired
    private UserCrudService userCrudService;

    @Override
    public void batchDelUserFromTenant(AuthoredUser user, List<Long> userToDel) {
        AppAuthContext context = AppAuthContextHolder.getContext();
        context.setAuthoredUser(user);
        for (Long userSid : userToDel) {
            User targetUser = (User)this.userCrudService.findBySid(userSid);
            try {
                this.tenantService.delUserFromTenant(user, userSid);
                this.changeLogService.saveBatchDeleteUserFromTenantLog(user, targetUser, null);
            }
            catch (Exception e) {
                this.changeLogService.saveBatchDeleteUserFromTenantLog(user, targetUser, e);
            }
        }
    }

    @Override
    public void batchDisableUserFromTenant(AuthoredUser user, List<Long> userToDisable) {
        AppAuthContext context = AppAuthContextHolder.getContext();
        context.setAuthoredUser(user);
        for (Long userSid : userToDisable) {
            try {
                User targetUser = (User)this.userCrudService.findBySid(userSid);
                this.tenantRelationWithUserService.disableTenantUser(targetUser, user);
                this.changeLogService.saveBatchDisableUserFromTenantLog(user, userSid, null);
            }
            catch (Exception e) {
                this.changeLogService.saveBatchDisableUserFromTenantLog(user, userSid, e);
            }
        }
    }
}

