/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenant.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.TenantConfirmEnum;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.tenant.IsvRelationDevCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCancelService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.service.CascadeDeleteEntityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TenantCancelServiceImpl
implements TenantCancelService {
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private CascadeDeleteEntityService cascadeDeleteEntityService;
    @Autowired
    private IsvRelationDevCrudService isvRelationDevCrudService;

    @Override
    public void cancelTenant(long tenantSid, long userSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        Assert.notNull((Object)((Object)tenant), (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728", tenantSid));
        User user = (User)this.userCrudService.findBySid(userSid);
        Assert.notNull((Object)((Object)tenant), (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728", userSid));
        if (tenant.getOwnerUserSid() != userSid) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_CREATE_BY_USER, new Object[]{tenant.getId(), user.getId()});
        }
        if (TenantConfirmEnum.APPROVED.getValue().equals(tenant.getConfirm())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_HAS_BEEN_APPROVED, new Object[]{tenant.getId()});
        }
        this.tenantCrudService.deleteById(tenantSid);
        this.userInTenantCrudService.deleteByUnionKey(tenantSid, user.getSid());
        this.cascadeDeleteEntityService.deleteRelation("userrelationwithtenant", Long.valueOf(user.getSid()), Long.valueOf(tenantSid));
        if (user.getDefaultTenantSid() > 0L && user.getDefaultTenantSid() == tenantSid) {
            user.setDefaultTenantSid(0L);
            this.userCrudService.update((BaseEntity)user);
        }
        this.isvRelationDevCrudService.deleteByIsvTenantSid(tenantSid);
    }
}

