/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenant.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.constant.enums.ResAcquireModeEnum;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithIdManagerService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantCrudServiceImpl
extends BaseEntityWithIdManagerService<Tenant>
implements TenantCrudService {
    @Autowired
    private TenantRepository tenantRepository;

    protected TenantRepository getRepository() {
        return this.tenantRepository;
    }

    public long create(Tenant tenant) {
        if (tenant.getResAcquireMode() == null) {
            tenant.setResAcquireMode(ResAcquireModeEnum.DEVELOPMENT_SUBSCRIPTIONS.getValue());
        }
        return super.create((BaseEntity)tenant);
    }

    public void validate(Tenant tenant) {
        if (!StringUtil.checkTenantId(tenant.getId())) {
            throw new IllegalArgumentException("\u6cd5\u4eba\u4f01\u4e1aID\u4e3a\u7a7a\u6216\u5305\u542b\u201c/\u201d,\u201c\\\u201d,\u201c.\u201d\uff0c\u8bf7\u68c0\u67e5");
        }
    }

    @Override
    public List<Tenant> queryTenantByOwnerUserSid(long userSid) {
        return this.tenantRepository.findByOwnerUserSid(userSid);
    }

    @Override
    public Tenant findIndividualTenant(long ownerUserSid, Integer enterpriseType) {
        if (enterpriseType == null) {
            return this.tenantRepository.findDevByOwnerUserSid(ownerUserSid);
        }
        return this.tenantRepository.findFirstByOwnerUserSidAndEnterpriseType(ownerUserSid, enterpriseType);
    }

    @Override
    public List<Tenant> findBySourceTenantSid(long sourceTenantSid) {
        return this.tenantRepository.findBySourceTenantSid(sourceTenantSid);
    }

    @Override
    public Tenant findTenantByTenantId(String tenantId) {
        return this.tenantRepository.findByTenantId(tenantId);
    }

    @Override
    public List<Tenant> findBySidIn(List<Long> tenantSids) {
        return this.tenantRepository.findAllById(tenantSids);
    }
}

