/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenant.impl;

import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.policy.ConsolePolicyExportScopeVO;
import com.digiwin.dap.middleware.iam.domain.tenant.PermissionExportDataVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantExportDataVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.TenantDataExportRecord;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.repository.TenantDataExportRecordRepository;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantDataExportRecordService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TenantDataExportRecordCrudServiceImpl
extends BaseEntityManagerService<TenantDataExportRecord>
implements TenantDataExportRecordService {
    @Autowired
    private TenantDataExportRecordRepository tenantDataExportRecordRepository;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private SysCrudService sysCrudService;

    @Override
    public List<TenantDataExportRecord> queryTenantDataExportRecordList(long tenantSid, int monthInt) {
        return this.tenantMapper.findTenantDataExportRecord(tenantSid, monthInt);
    }

    @Override
    public List<TenantExportDataVO> queryTenantDataExportRecordList(TenantExportDataVO tenantExportDataVO) {
        List<TenantExportDataVO> vos = this.tenantMapper.findTenantDataExportRecordByContent(tenantExportDataVO.getPageNum(), tenantExportDataVO.getPageSize(), tenantExportDataVO.getOrderBy(), tenantExportDataVO);
        this.populateSysInfo(vos);
        return vos;
    }

    private void populateSysInfo(List<TenantExportDataVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        vos.forEach(TenantExportDataVO::unboxParams);
        List<String> appIds = vos.stream().map(TenantExportDataVO::getExportParams).filter(Objects::nonNull).map(ConsolePolicyExportScopeVO::getAppIds).flatMap(Collection::stream).collect(Collectors.toList());
        List<Sys> sys = this.sysCrudService.findByIdIn(appIds);
        List sysVOS = sys.stream().map(SysVO::new).collect(Collectors.toList());
        Map sysMap = sysVOS.stream().collect(Collectors.toMap(SysVO::getId, Function.identity(), (a, b) -> a));
        vos.forEach(vo -> {
            ConsolePolicyExportScopeVO exportParams = vo.getExportParams();
            if (exportParams != null && exportParams.getAppIds() != null) {
                List<SysVO> matchedApps = exportParams.getAppIds().stream().map(sysMap::get).filter(Objects::nonNull).collect(Collectors.toList());
                exportParams.setApps(matchedApps);
            }
        });
    }

    @Override
    public List<PermissionExportDataVO> queryPermissionExportRecord(TenantExportDataVO tenantExportDataVO) {
        return this.tenantMapper.queryPermissionExportRecord(tenantExportDataVO.getPageNum(), tenantExportDataVO.getPageSize(), tenantExportDataVO.getOrderBy(), tenantExportDataVO);
    }

    protected JpaRepository getRepository() {
        return this.tenantDataExportRecordRepository;
    }
}

