/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenant.impl;

import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dict.constant.enums.DictEnum;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.entity.BaseEntityWithPartition;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.TeamEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.MessageTargetVO;
import com.digiwin.dap.middleware.iam.domain.SiteMessageDTO;
import com.digiwin.dap.middleware.iam.domain.app.ModuleVO;
import com.digiwin.dap.middleware.iam.domain.app.SysCascadeVO;
import com.digiwin.dap.middleware.iam.domain.app.SysQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysDTO;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopLanguage;
import com.digiwin.dap.middleware.iam.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.iam.domain.servicer.ServicerVO;
import com.digiwin.dap.middleware.iam.domain.tenant.DevTenantCertificationVO;
import com.digiwin.dap.middleware.iam.domain.tenant.DevTenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.QuerySysInTenantPageVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ServicerTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.SubTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantContactInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCorpConfigDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantIdDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantRelevantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantSearchVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantSimpleVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.entity.DevCertificationDO;
import com.digiwin.dap.middleware.iam.entity.Module;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.ServicerMapper;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.repository.CertificationRepository;
import com.digiwin.dap.middleware.iam.repository.ModuleRepository;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceInfoService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteIamService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.CacAuth;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplication;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplicationDTO;
import com.digiwin.dap.middleware.iam.support.remote.domain.cbm.TenantAppIamVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.GoodsAlias;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.GoodsLanguage;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import com.digiwin.dap.middleware.language.service.LanguageService;
import com.digiwin.dap.middleware.util.EnvUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TenantQueryServiceImpl
implements TenantQueryService {
    private static final Logger log = LoggerFactory.getLogger(TenantQueryServiceImpl.class);
    @Autowired
    private LanguageService languageService;
    @Autowired
    private LanguageCrudService languageCrudService;
    @Autowired
    private CacService cacService;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private SysInTenantQueryService sysInTenantQueryService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private CertificationRepository certificationRepository;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private ServicerMapper servicerMapper;
    @Autowired
    private DevSysService devSysService;
    @Autowired
    private SysRepository sysRepository;
    @Autowired
    private ModuleRepository moduleRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private SysInTenantCrudService sysInTenantCrudService;
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private InvoiceInfoService invoiceInfoService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RemoteIamService remoteIamService;

    @Override
    public List<TenantApplication> getTenantApplicationByTenant(String tenantId, String categoryId) {
        return this.getTenantApplication(tenantId, categoryId, false, false);
    }

    @Override
    public void fillTenantApplicationByTenant(TenantAppIamVO input, String categoryId) {
        this.fillTenantApplicationV2(input, categoryId, false);
    }

    @Override
    public TenantInfoVO getTenantSimpleInfo(String tenantId) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        Assert.notNull((Object)((Object)tenant), (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728", tenantId));
        TenantInfoVO tenantInfoVO = new TenantInfoVO(tenant);
        tenantInfoVO.setEmail(tenant.getEmail());
        tenantInfoVO.setIsv(tenant.isIsv());
        tenantInfoVO.setOffline(tenant.isOffline());
        tenantInfoVO.setBackUri(tenant.getBackUri());
        tenantInfoVO.setComeFrom(tenant.getComeFrom());
        return tenantInfoVO;
    }

    @Override
    public TenantInfoVO getTenantSimpleInfo(Long sid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(sid);
        Assert.notNull((Object)((Object)tenant), (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728", sid));
        TenantInfoVO vo = new TenantInfoVO(tenant);
        vo.setCreateDate(tenant.getCreateDate());
        vo.setCreateBy(tenant.getCreateBy());
        Long createBy = Optional.ofNullable(tenant.getCreateBy()).orElse(0L);
        List<Long> userSidList = Arrays.asList(tenant.getOwnerUserSid(), createBy);
        List userList = this.userRepository.findAllById(userSidList);
        Map<Long, User> userMap = userList.stream().collect(Collectors.toMap(BaseEntity::getSid, x -> x));
        vo.setOwnerUserSid(tenant.getOwnerUserSid());
        vo.setOwnerUserId(Optional.ofNullable(userMap.get(tenant.getOwnerUserSid())).map(BaseEntityWithId::getId).orElse(null));
        vo.setCreateBy(tenant.getCreateBy());
        vo.setCreateById(Optional.ofNullable(userMap.get(createBy)).map(BaseEntityWithId::getId).orElse(null));
        return vo;
    }

    @Override
    public List<TenantSimpleVO> getTenantList(TenantSearchVO tenantSearchVO, int pageNum, int pageSize) {
        return this.tenantMapper.getTenantList(pageNum, pageSize, tenantSearchVO.getAppIds(), tenantSearchVO.getTenantContent());
    }

    @Override
    public List<TenantApplication> getTenantApplicationAndPlatFormByTenant(TenantApplicationDTO dto) {
        return this.getTenantApplication(dto.getTenantId(), GoodsCategoryEnum.APP.id(), true, Boolean.TRUE.equals(dto.getCountApiInvoke()));
    }

    @Override
    public List<TenantApplication> getTenantApplicationByTenant(TenantApplicationDTO dto) {
        List<TenantApplication> tenantApplication = this.getTenantApplication(dto.getTenantId(), dto.getCategoryId(), Boolean.TRUE.equals(dto.getIncludePlatForm()), Boolean.TRUE.equals(dto.getCountApiInvoke()));
        if (CollectionUtils.isEmpty(tenantApplication)) {
            return Collections.emptyList();
        }
        if (!StringUtils.isEmpty((Object)dto.getPlatformCode())) {
            tenantApplication = tenantApplication.stream().filter(x -> Optional.ofNullable(x.getPlatformCodes()).orElse(Collections.emptyList()).contains(dto.getPlatformCode())).collect(Collectors.toList());
        }
        if (dto.getDisabled() != null) {
            tenantApplication = tenantApplication.stream().filter(x -> dto.getDisabled().equals(x.getDisabled())).collect(Collectors.toList());
        }
        if (dto.getShowEntry() != null) {
            tenantApplication = tenantApplication.stream().filter(x -> dto.getShowEntry().equals(x.getShowEntry())).collect(Collectors.toList());
        }
        if (dto.getShowConsole() != null) {
            tenantApplication = tenantApplication.stream().filter(o -> dto.getShowConsole().equals(o.getShowConsole())).collect(Collectors.toList());
        }
        if (dto.getExpired() != null) {
            tenantApplication = tenantApplication.stream().filter(o -> dto.getExpired().equals(o.isExpired())).collect(Collectors.toList());
        }
        if (StringUtils.hasText((String)dto.getEocEntrance())) {
            tenantApplication = tenantApplication.stream().filter(o -> dto.getEocEntrance().equals(o.getEocEntrance())).collect(Collectors.toList());
        }
        return tenantApplication;
    }

    private List<TenantApplication> getTenantApplication(String tenantId, String categoryId, boolean isIncludePlatForm, boolean countApiInvoke) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        ArrayList<TenantApplication> tenantApplications = new ArrayList<TenantApplication>();
        this.getCacAuthorizationApplication(tenant, categoryId, isIncludePlatForm, tenantApplications, countApiInvoke);
        if (GoodsCategoryEnum.APP.id().equals(categoryId) || isIncludePlatForm && GoodsCategoryEnum.PLATFORM.id().equals(categoryId)) {
            this.getInsideApplication(tenant, tenantApplications);
        }
        return tenantApplications;
    }

    private void fillTenantApplicationV2(TenantAppIamVO input, String categoryId, boolean isIncludePlatForm) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(input.getTenantId());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{input.getTenantId()});
        }
        input.setTenant(tenant);
        ArrayList<TenantApplication> tenantApplications = new ArrayList<TenantApplication>();
        input.setTenantApplications(tenantApplications);
        this.getCacAuthorizationApplicationV2(input, categoryId, isIncludePlatForm);
        if (GoodsCategoryEnum.APP.id().equals(categoryId) || isIncludePlatForm && GoodsCategoryEnum.PLATFORM.id().equals(categoryId)) {
            this.getInsideApplication(tenant, tenantApplications);
        }
    }

    private void getCacAuthorizationApplicationV2(TenantAppIamVO input, String categoryId, boolean isIncludePlatForm) {
        List<AuthorizationResultVO> authorizationResultVOS = input.getCacAuthorization();
        if (CollectionUtils.isEmpty(authorizationResultVOS)) {
            return;
        }
        List<String> goodsCodes = authorizationResultVOS.stream().map(AuthorizationResultVO::getCode).collect(Collectors.toList());
        input.setDevSys(this.devSysService.findDevSyses(new DevSysDTO(goodsCodes)));
        input.setSys(this.sysRepository.findByIdIn(goodsCodes));
        Map<String, Sys> sysMap = input.getSys().stream().collect(Collectors.toMap(BaseEntityWithId::getId, a -> a));
        for (AuthorizationResultVO authorizationResultVO : authorizationResultVOS) {
            List<String> moduleIds;
            long sysSid;
            if (!categoryId.equals(authorizationResultVO.getCategoryId()) && (!isIncludePlatForm || !GoodsCategoryEnum.PLATFORM.id().equals(authorizationResultVO.getCategoryId())) || (sysSid = sysMap.getOrDefault(authorizationResultVO.getCode(), new Sys()).getSid()) <= 0L) continue;
            if ("BOSS".equals(authorizationResultVO.getCode())) {
                String sysName = this.languageCrudService.findContent(sysSid, "sysName");
                authorizationResultVO.setDisplayName(sysName);
            }
            if ((moduleIds = authorizationResultVO.getEnabledModules().stream().map(AuthorizationModuleVO::getId).collect(Collectors.toList())).isEmpty()) continue;
            List<Module> modules = this.moduleRepository.findByAppSidAndIdIn(sysSid, moduleIds);
            Map<String, Long> moduleMap = modules.stream().collect(Collectors.toMap(Module::getId, BaseEntity::getSid));
            authorizationResultVO.getEnabledModules().forEach(module -> module.setSid(moduleMap.getOrDefault(module.getId(), 0L)));
            this.languageService.parse(authorizationResultVO.getEnabledModules(), new ArrayList<Long>(moduleMap.values()), Collections.singletonMap("name", "moduleName"), AuthorizationModuleVO.class);
        }
    }

    private void getCacAuthorizationApplication(Tenant tenant, String categoryId, boolean isIncludePlatForm, List<TenantApplication> tenantApplications, boolean countApiInvoke) {
        List<AuthorizationResultVO> authorizationResultVOS = this.cacService.queryAllAuthorization(tenant.getId(), countApiInvoke);
        if (CollectionUtils.isEmpty(authorizationResultVOS)) {
            return;
        }
        List<String> goodsCodes = authorizationResultVOS.stream().map(AuthorizationResultVO::getCode).collect(Collectors.toList());
        List<GoodsLanguage> goodsLanguage = this.gmcService.getGoodsLanguage(goodsCodes);
        Map<String, GoodsLanguage> goodsMap = goodsLanguage.stream().collect(Collectors.toMap(GoodsLanguage::getGoodsCode, a -> a, (k1, k2) -> k1));
        List<DevSysVO> devSyses = this.devSysService.findDevSyses(new DevSysDTO(goodsCodes));
        Map<String, String> appTokenMap = devSyses.stream().collect(Collectors.toMap(DevSysVO::getId, DevSysVO::getAppToken, (k1, k2) -> k1));
        List<Sys> sysList = this.sysRepository.findByIdIn(goodsCodes);
        Map<String, Sys> sysMap = sysList.stream().collect(Collectors.toMap(BaseEntityWithId::getId, a -> a));
        List<String> categoryIds = GoodsCategoryEnum.getCategoryIds(categoryId, isIncludePlatForm);
        for (AuthorizationResultVO authorizationResultVO : authorizationResultVOS) {
            if (!categoryIds.contains(authorizationResultVO.getCategoryId())) continue;
            Sys sys = sysMap.getOrDefault(authorizationResultVO.getCode(), new Sys());
            if (sys.getSid() > 0L) {
                List<String> moduleIds;
                if ("BOSS".equals(authorizationResultVO.getCode())) {
                    String sysName = this.languageCrudService.findContent(sys.getSid(), "sysName");
                    authorizationResultVO.setDisplayName(sysName);
                }
                if (!(moduleIds = authorizationResultVO.getEnabledModules().stream().map(AuthorizationModuleVO::getId).collect(Collectors.toList())).isEmpty()) {
                    List<Module> modules = this.moduleRepository.findByAppSidAndIdIn(sys.getSid(), moduleIds);
                    Map<String, Long> moduleMap = modules.stream().collect(Collectors.toMap(Module::getId, BaseEntity::getSid));
                    authorizationResultVO.getEnabledModules().forEach(module -> module.setSid(moduleMap.getOrDefault(module.getId(), 0L)));
                    this.languageService.parse(authorizationResultVO.getEnabledModules(), new ArrayList<Long>(moduleMap.values()), Collections.singletonMap("name", "moduleName"), AuthorizationModuleVO.class);
                }
            }
            TenantApplication tenantApplication = new TenantApplication(tenant, authorizationResultVO, (Boolean)false);
            GoodsLanguage goods = goodsMap.get(tenantApplication.getId());
            tenantApplication.setLinked(sys.getLinked());
            tenantApplication.setShowEntry(sys.getShowEntry());
            tenantApplication.setShowConsolePolicy(sys.getShowConsolePolicy());
            tenantApplication.setActionFilterUrl(sys.getActionFilterUrl());
            if (goods != null) {
                tenantApplication.setSid(sys.getSid());
                tenantApplication.setName(goods.getGoodsName());
                tenantApplication.setCustomUnit(goods.getCustomunit());
                tenantApplication.setServicerId(goods.getServicerId());
                tenantApplication.setServicerName(goods.getServicerName());
                tenantApplication.setMaintainServiceStatus(goods.getMaintainServiceStatus());
                tenantApplication.setGoodsCategoryList(goods.getGoodsCategoryList());
                tenantApplication.setLogoImage(goods.getLogoImage());
                tenantApplication.setDescription(goods.getDescription());
                tenantApplication.setCloudwebsite(goods.getCloudwebsite());
                tenantApplication.setTags(goods.getTags());
                tenantApplication.setDisabled(goods.getDisabled());
                tenantApplication.setShowEntry(goods.getShowEntry());
                tenantApplication.setPlatformCodes(goods.getPlatformCodes());
                tenantApplication.setAppToken(appTokenMap.get(tenantApplication.getId()));
                tenantApplication.setShowConsole(goods.getShowConsole());
                tenantApplication.setShowConsoleManagement(goods.getShowConsoleManagement());
                tenantApplication.setProductCode(sys.getProductCode());
                tenantApplication.setProductName(sys.getProductName());
                tenantApplication.setShowConsolePolicy(goods.getShowConsolePolicy());
                tenantApplication.setEocEntrance(goods.getEocEntrance());
                if (StrUtils.isNotEmpty((String)tenantApplication.getGoodsAliasId()) && null != goods.getGoodsAliases()) {
                    Optional<GoodsAlias> goodsAlias = goods.getGoodsAliases().stream().filter(o -> o.getGoodsAliasId().equals(tenantApplication.getGoodsAliasId())).findFirst();
                    goodsAlias.ifPresent(alias -> tenantApplication.setGoodsAliasName(alias.getGoodsAliasName()));
                }
                tenantApplication.setEnableMultiRow(sysMap.getOrDefault(goods.getGoodsCode(), new Sys()).isEnableMultiRow());
                tenantApplication.getResourceGoods().forEach(p -> p.setName(goodsMap.getOrDefault(p.getCode(), new GoodsLanguage()).getGoodsName()));
                tenantApplication.getMainGoods().forEach(p -> p.setName(goodsMap.getOrDefault(p.getCode(), new GoodsLanguage()).getGoodsName()));
            }
            tenantApplications.add(tenantApplication);
        }
    }

    private void getInsideApplication(Tenant tenant, List<TenantApplication> tenantApplications) {
        List<SysQueryResultVO> sysInTenants = this.sysInTenantQueryService.getSysVOByTenantSid(tenant.getSid());
        List sysIds = sysInTenants.stream().map(DevelopLanguage::getSid).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sysIds)) {
            log.warn("sysIds is empty, query multi Language failed , sysId :{} , tenantSid :{} ", sysIds, (Object)tenant.getSid());
            return;
        }
        Map contentMapping = this.languageCrudService.findContent(sysIds, "sysName");
        List<GoodsLanguage> goodsLanguage = this.gmcService.getGoodsLanguage(sysInTenants.stream().map(SysQueryResultVO::getId).collect(Collectors.toList()));
        Map<String, GoodsLanguage> goodsMap = goodsLanguage.stream().collect(Collectors.toMap(GoodsLanguage::getGoodsCode, a -> a, (k1, k2) -> k1));
        for (SysQueryResultVO current : sysInTenants) {
            TenantApplication newTenantApplication = null;
            if (current.isInside() && current.isHasPermission() && tenantApplications.stream().noneMatch(tenantApplication -> tenantApplication.getId().equals(current.getId()))) {
                String content = (String)contentMapping.get(current.getSid());
                if (!StringUtils.isEmpty((Object)content)) {
                    current.setName(content);
                }
                newTenantApplication = new TenantApplication(tenant, current);
            }
            if ("99990000".equals(tenant.getId()) && "boss;mmc;".contains(current.getId().toLowerCase() + ";") && tenantApplications.stream().noneMatch(tenantApplication -> tenantApplication.getId().equals(current.getId()))) {
                newTenantApplication = new TenantApplication(tenant, current);
            }
            if (tenant.isIsv() && "ISV".equals(current.getId()) && tenantApplications.stream().noneMatch(tenantApplication -> tenantApplication.getId().equals(current.getId()))) {
                newTenantApplication = new TenantApplication(tenant, current);
            }
            if ("dev".equals(current.getId()) && tenantApplications.stream().noneMatch(tenantApplication -> tenantApplication.getId().equals(current.getId()))) {
                newTenantApplication = new TenantApplication(tenant, current);
            }
            if (null != newTenantApplication) {
                GoodsLanguage goods = goodsMap.get(current.getId());
                if (null != goods) {
                    newTenantApplication.setCustomUnit(goods.getCustomunit());
                    newTenantApplication.setServicerId(goods.getServicerId());
                    newTenantApplication.setServicerName(goods.getServicerName());
                    newTenantApplication.setMaintainServiceStatus(goods.getMaintainServiceStatus());
                    newTenantApplication.setGoodsCategoryList(goods.getGoodsCategoryList());
                    newTenantApplication.setLogoImage(goods.getLogoImage());
                    newTenantApplication.setDescription(goods.getDescription());
                    newTenantApplication.setCloudwebsite(goods.getCloudwebsite());
                    newTenantApplication.setTags(goods.getTags());
                    newTenantApplication.setDisabled(goods.getDisabled());
                    newTenantApplication.setShowConsoleManagement(goods.getShowConsoleManagement());
                }
                tenantApplications.add(newTenantApplication);
            }
            tenantApplications.stream().filter(cacApp -> cacApp.getId().equals(current.getId())).forEach(cacApp -> {
                cacApp.setSecretKey(current.getSecretKey());
                cacApp.setBackUri(current.getBackUri());
            });
        }
    }

    @Override
    public List<String> getTenantApplication(String tenantId, List<String> categoryIds) {
        ArrayList<String> apps = new ArrayList<String>();
        List<AuthorizationResultVO> authorizationResultVOS = this.cacService.queryAllAuthorization(tenantId);
        for (AuthorizationResultVO authorizationResultVO : authorizationResultVOS) {
            if (!categoryIds.contains(authorizationResultVO.getCategoryId())) continue;
            apps.add(authorizationResultVO.getCode());
        }
        return apps;
    }

    @Override
    public Set<String> getTenantBundleChildren(String tenantId) {
        List<AuthorizationResultVO> authorizationResultVOS = this.cacService.queryAllAuthorization(tenantId);
        return authorizationResultVOS.stream().filter(a -> StringUtils.hasLength((String)a.getBundleCode())).map(AuthorizationResultVO::getCode).collect(Collectors.toSet());
    }

    @Override
    public List<TenantRelevantInfoVO> getTenantRelevantInfoVos(String tenantContent, String unifiedTaxationCode) {
        List<TenantRelevantInfoVO> tenantRelevantInfoVOS = StringUtils.isEmpty((Object)tenantContent) && StringUtils.isEmpty((Object)unifiedTaxationCode) ? new ArrayList<TenantRelevantInfoVO>() : this.tenantMapper.getTenantRelevantInfo(tenantContent, unifiedTaxationCode);
        return tenantRelevantInfoVOS;
    }

    @Override
    public List<String> getTenantIdsByAppId(String appId) {
        if (StringUtils.isEmpty((Object)appId)) {
            throw new IllegalArgumentException("appId is null");
        }
        return this.tenantMapper.getTenantIdsByAppId(appId);
    }

    @Override
    public TenantContactInfoVO getTenantContactInfoVO(String tenantId) {
        return this.tenantMapper.getTenantContactInfoVO(tenantId);
    }

    @Override
    public Map<String, Long> getTenantSidsByTenantIds(List<String> tenantIds) {
        if (tenantIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<TenantSimpleVO> tenants = this.tenantMapper.getTenantSidsByTenantIds(tenantIds);
        return tenants.stream().collect(Collectors.toMap(TenantSimpleVO::getTenantId, TenantSimpleVO::getTenantSid));
    }

    @Override
    public List<SubTenantVO> findSubTenantBySid(long sid, boolean test) {
        return this.tenantMapper.findSubTenantBySid(sid, test);
    }

    @Override
    public boolean checkTenantCustomerId(long sid) {
        return this.tenantMapper.checkTenantCustomerId(sid);
    }

    @Override
    public DevTenantInfoVO findTenantInfo(long tenantSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        DevTenantInfoVO devTenantInfoVO = new DevTenantInfoVO();
        if (tenant != null) {
            User owner;
            BeanUtils.mergeDifferentTypeObject((Object)((Object)tenant), (Object)devTenantInfoVO);
            if (!StringUtils.isEmpty((Object)tenant.getTeamId())) {
                DictData team = this.dictDataService.selectDictData(new DictDataDTO(DictEnum.TEAM.getId(), tenant.getTeamId()));
                Optional.ofNullable(team).map(DictData::getDictValue).ifPresent(devTenantInfoVO::setTeamName);
            }
            if (tenant.isIsv()) {
                ServicerVO servicerVO = this.servicerMapper.getServicerInfo(tenantSid);
                devTenantInfoVO.setServicer(servicerVO);
            }
            if ((owner = (User)this.userCrudService.findBySid(tenant.getOwnerUserSid())) != null) {
                devTenantInfoVO.setOwnerId(owner.getId());
                devTenantInfoVO.setOwnerName(owner.getName());
            }
        }
        DevCertificationDO devCertificationDO = this.certificationRepository.findByTenantSid(tenantSid);
        DevTenantCertificationVO devTenantCertificationVO = new DevTenantCertificationVO();
        if (devCertificationDO != null) {
            devTenantInfoVO.setLegalName(devCertificationDO.getLegalName());
            BeanUtils.mergeDifferentTypeObject((Object)((Object)devCertificationDO), (Object)devTenantCertificationVO);
        }
        devTenantInfoVO.setTenantCertification(devTenantCertificationVO);
        devTenantInfoVO.setInvoiceInfo(this.invoiceInfoService.getInvoiceInfoContainReceiver(tenantSid));
        return devTenantInfoVO;
    }

    @Override
    public ServicerTenantVO findServicerTenantInfo(long tenantSid) {
        DevCertificationDO devCertificationDO;
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        ServicerTenantVO servicerTenantVO = new ServicerTenantVO(tenant);
        if (!StringUtils.isEmpty((Object)tenant.getTeamId())) {
            DictData team = this.dictDataService.selectDictData(new DictDataDTO(DictEnum.TEAM.getId(), tenant.getTeamId()));
            Optional.ofNullable(team).map(DictData::getDictValue).ifPresent(servicerTenantVO::setTeamName);
        }
        if (tenant.isIsv()) {
            ServicerVO servicerVO = this.servicerMapper.getServicerInfo(tenantSid);
            servicerTenantVO.setServicer(servicerVO);
        }
        if ((devCertificationDO = this.certificationRepository.findByTenantSid(tenantSid)) != null) {
            servicerTenantVO.setDevCertification(devCertificationDO);
        }
        return servicerTenantVO;
    }

    @Override
    public TenantCorpConfigDTO getTenantCorpIdAndAppConfig(long tenantSid) {
        TenantCorpConfigDTO dto = new TenantCorpConfigDTO();
        String corpId = this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid, "contact", "corpId");
        dto.setCorpId(corpId);
        if (ObjectUtils.isEmpty((Object)corpId)) {
            dto.setAppConfig(Boolean.FALSE);
            return dto;
        }
        Tenant tenant = (Tenant)((Object)this.tenantRepository.findById(tenantSid).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid})));
        List<Map<String, Object>> appConfigs = this.remoteEMCService.findAppConfigByTenantId(tenant.getId());
        dto.setAppConfig(!CollectionUtils.isEmpty(appConfigs));
        return dto;
    }

    @Override
    public TenantCorpConfigDTO getTenantCorpIdAndAppConfig4CBM(long tenantSid) {
        TenantCorpConfigDTO map = new TenantCorpConfigDTO();
        String corpId = this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid, "contact", "corpId");
        map.setCorpId(corpId);
        if (ObjectUtils.isEmpty((Object)corpId)) {
            map.setAppConfig(Boolean.FALSE);
        }
        return map;
    }

    @Override
    public List<DevCertificationDO> getByLicenseNumberAndEnterPriseTypeNoTenantSid(String licenseNumber, Long tenantSid, Integer enterpriseType) {
        return this.tenantMapper.getByLicenseNumberAndEnterPriseTypeNoTenantSid(licenseNumber, tenantSid, enterpriseType);
    }

    @Override
    public List<TenantVO> getTenantsByPurchaseApp(String appId, String customerId) {
        List<TenantVO> tenantVOS = this.tenantMapper.getTenantsByAppId(appId, customerId);
        List<String> tenantIds = tenantVOS.stream().map(TenantVO::getId).collect(Collectors.toList());
        if (tenantIds.isEmpty()) {
            return new ArrayList<TenantVO>();
        }
        List<CacAuth> cacAuths = this.cacService.getTenantsAndApps(tenantIds, Collections.singletonList(appId));
        tenantVOS.forEach(t -> {
            CacAuth cacAuth = cacAuths.stream().filter(c -> c.getTenantId().equals(t.getId())).findFirst().orElse(null);
            if (null != cacAuth) {
                t.setAuths(cacAuth.getApps());
            }
        });
        return tenantVOS;
    }

    @Override
    public PageSerializable<TenantVO> getTenantsByPurchaseApps(QuerySysInTenantPageVO vo) {
        PageMethod.startPage((int)vo.getPageNum(), (int)vo.getPageSize(), (String)vo.getOrderBy());
        List<TenantVO> tenantVOS = this.tenantMapper.getTenantsByAppIds(vo);
        return new PageSerializable(tenantVOS);
    }

    @Override
    public List<DevCertificationDO> getByLicenseNumber(String licenseNumber, Long tenantSid) {
        return this.tenantMapper.getByLicenseNumber(licenseNumber, tenantSid);
    }

    @Override
    public List<SiteMessageDTO> getSiteContacts(MessageTargetVO target) {
        ArrayList<SiteMessageDTO> result = new ArrayList<SiteMessageDTO>();
        String tenantId = target.getTenantId();
        if (ObjectUtils.isEmpty((Object)tenantId)) {
            if (StringUtils.hasLength((String)target.getUserId())) {
                User user = (User)this.userCrudService.findById(target.getUserId());
                if (user == null) {
                    log.error("user [{}] not found", (Object)target.getUserId());
                    return result;
                }
                SiteMessageDTO siteMessageDTO = new SiteMessageDTO();
                siteMessageDTO.setUserSid(user.getSid());
                siteMessageDTO.setUserId(user.getId());
                siteMessageDTO.setUserName(user.getName());
                siteMessageDTO.setTelephone(user.getTelephone());
                result.add(siteMessageDTO);
            }
            return result;
        }
        switch (target.getOpType()) {
            case "currentUser": {
                if (ObjectUtils.isEmpty((Object)target.getUserId())) {
                    return result;
                }
                return this.tenantMapper.getContact4CurrentUser(tenantId, target.getUserId());
            }
            case "currentTenant": {
                return this.getCurrentTenantUser(result, tenantId);
            }
            case "superAdmin": {
                return this.tenantMapper.getTenantSuperAdmin(tenantId);
            }
            case "currentCreator": {
                this.getTenantCreator(result, tenantId);
                return result;
            }
            case "tenantOnly": {
                return this.getTenantOnly(tenantId);
            }
        }
        return result;
    }

    @Override
    public Map<String, List<TenantVO>> getSysTenantListMap(List<String> appIds) {
        List<Sys> sysList = this.sysRepository.findByIdIn(appIds);
        if (CollectionUtils.isEmpty(sysList)) {
            return Collections.emptyMap();
        }
        List<SysInTenant> sysInTenants = this.sysInTenantCrudService.findBySysSidIn(sysList.stream().map(BaseEntity::getSid).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(sysInTenants)) {
            return Collections.emptyMap();
        }
        List<Tenant> tenants = this.tenantCrudService.findBySidIn(sysInTenants.stream().map(BaseEntityWithPartition::getTenantSid).collect(Collectors.toList()));
        HashMap<String, List<TenantVO>> sysTenantListMap = new HashMap<String, List<TenantVO>>();
        for (Sys sys : sysList) {
            List tenantSidList = sysInTenants.stream().filter(x -> x.getSysSid() == sys.getSid()).map(BaseEntityWithPartition::getTenantSid).collect(Collectors.toList());
            ArrayList tenantVOS = new ArrayList();
            tenants.stream().filter(x -> tenantSidList.contains(x.getSid())).forEach(tenant -> {
                TenantVO tenantVO = new TenantVO((Tenant)((Object)tenant), true);
                tenantVOS.add(tenantVO);
            });
            sysTenantListMap.put(sys.getId(), tenantVOS);
        }
        return sysTenantListMap;
    }

    @Override
    public Map<String, Object> getTenantApplicationList(String tenantId, Integer type, List<SysCascadeVO> filterSyses) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        result.put("tenant", (Object)tenant);
        ArrayList<TenantApplication> tenantApplications = new ArrayList<TenantApplication>();
        if (0 == type || 2 == type) {
            List<String> goodsCodes = filterSyses.stream().map(SysCascadeVO::getId).collect(Collectors.toList());
            List<SysQueryResultVO> sysQueryResultVOList = this.sysMapper.getSysVOListByTenant(tenant.getSid(), goodsCodes);
            for (SysQueryResultVO sys : sysQueryResultVOList) {
                SysCascadeVO matchSys;
                TenantApplication tenantApplication = new TenantApplication(tenant, sys, (Boolean)false);
                if ("BOSS".equals(sys.getId())) {
                    String sysName = this.languageCrudService.findContent(sys.getSid().longValue(), "sysName");
                    tenantApplication.setName(sysName);
                }
                if (null != (matchSys = (SysCascadeVO)filterSyses.stream().filter(s -> sys.getId().equals(s.getId())).findFirst().orElse(null)) && !CollectionUtils.isEmpty(matchSys.getModules())) {
                    List<Module> modules = this.moduleRepository.findByAppSidAndIdIn(sys.getSid(), matchSys.getModules().stream().map(ModuleVO::getId).collect(Collectors.toList()));
                    Map<String, Long> moduleMap = modules.stream().collect(Collectors.toMap(Module::getId, BaseEntity::getSid));
                    matchSys.getModules().forEach(module -> module.setSid(moduleMap.getOrDefault(module.getId(), 0L)));
                    this.languageService.parse(matchSys.getModules(), new ArrayList<Long>(moduleMap.values()), Collections.singletonMap("name", "moduleName"), ModuleVO.class);
                    tenantApplication.updateModuleLanguage(matchSys.getModules());
                }
                tenantApplications.add(tenantApplication);
            }
        }
        if (0 == type || 1 == type) {
            this.getInsideApplication(tenant, tenantApplications);
        }
        result.put("authApplications", tenantApplications);
        return result;
    }

    private List<SiteMessageDTO> getTenantOnly(String tenantId) {
        Tenant byId = (Tenant)this.tenantCrudService.findById(tenantId);
        ArrayList<SiteMessageDTO> result = new ArrayList<SiteMessageDTO>();
        Optional.ofNullable(byId).ifPresent(a -> {
            SiteMessageDTO siteMessageDTO = new SiteMessageDTO();
            siteMessageDTO.setTenantName(byId.getName());
            siteMessageDTO.setTenantId(byId.getId());
            siteMessageDTO.setTenantSid(byId.getSid());
            result.add(siteMessageDTO);
        });
        return result;
    }

    private void getTenantCreator(List<SiteMessageDTO> result, String tenantId) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (null != tenant) {
            SiteMessageDTO siteMessageDTO = new SiteMessageDTO();
            result.add(siteMessageDTO);
            siteMessageDTO.setTenantId(tenant.getId());
            siteMessageDTO.setTenantSid(tenant.getSid());
            siteMessageDTO.setTenantName(tenant.getName());
            siteMessageDTO.setUserSid(tenant.getOwnerUserSid());
            User user = (User)this.userCrudService.findBySid(tenant.getOwnerUserSid());
            Optional.ofNullable(user).ifPresent(a -> {
                siteMessageDTO.setUserId(a.getId());
                siteMessageDTO.setUserName(a.getName());
                siteMessageDTO.setEmail(a.getEmail());
                siteMessageDTO.setTelephone(a.getTelephone());
            });
        }
    }

    private List<SiteMessageDTO> getCurrentTenantUser(List<SiteMessageDTO> result, String tenantId) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (null != tenant && null != tenant.getEmail() && tenant.getEmail().contains("@")) {
            User firstByEmail = this.userRepository.findFirstByEmail(tenant.getEmail());
            if (firstByEmail != null) {
                SiteMessageDTO siteMessageDTO = new SiteMessageDTO();
                result.add(siteMessageDTO);
                siteMessageDTO.setTenantId(tenant.getId());
                siteMessageDTO.setTenantSid(tenant.getSid());
                siteMessageDTO.setTenantName(tenant.getName());
                siteMessageDTO.setUserSid(firstByEmail.getSid());
                siteMessageDTO.setUserId(firstByEmail.getId());
                siteMessageDTO.setUserName(firstByEmail.getName());
                siteMessageDTO.setTelephone(firstByEmail.getTelephone());
            }
            return result;
        }
        return result;
    }

    @Override
    public int getTenantPasswordMinLength(Long tenantSid) {
        return Integer.parseInt(Optional.ofNullable(this.tenantMetadataCrudService.getTenantMetadataValue((long)tenantSid, "basic", "pwMinLength")).orElse("8"));
    }

    @Override
    public PageSerializable<Tenant> getTenantNameByPage(Integer pageNum, Integer pageSize, TenantSearchVO tenantSearchVO) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<Tenant> tenantList = this.tenantMapper.getTenantNameList(tenantSearchVO.getTenantContent());
        return PageSerializable.of(tenantList);
    }

    @Override
    public boolean existsMultiAreas(TenantIdDTO dto, Long userSid) {
        DeployAreaEnum deployAreaEnum = DeployAreaEnum.get((String)this.envProperties.getDeployArea());
        ArrayList<DeployAreaEnum> deployAreas = new ArrayList<DeployAreaEnum>(dto.getDeployAreas());
        if (deployAreaEnum != null && deployAreas.contains(deployAreaEnum)) {
            Tenant existed = (Tenant)this.tenantCrudService.findById(dto.getId());
            if (!(existed == null || userSid != null && Objects.equals(existed.getOwnerUserSid(), userSid))) {
                return true;
            }
            deployAreas.remove(deployAreaEnum);
        }
        for (DeployAreaEnum anEnum : deployAreas) {
            String iamUri = EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)anEnum);
            boolean exists = this.remoteIamService.existsTenantById(iamUri, dto.getId());
            if (!exists) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkExistsMuiltAreas(TenantVO tenantVO, Long userSid) {
        this.checkExistsMuiltAreas(tenantVO, userSid, true);
    }

    @Override
    public void checkExistsMuiltAreas(TenantVO tenantVO, Long userSid, boolean checkAreaProd) {
        DeployAreaEnum currentArea = DeployAreaEnum.get((String)this.envProperties.getDeployArea());
        if (currentArea == null) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_DEPLOY_AREA_NOT_CONFIG);
        }
        if (checkAreaProd && !Arrays.asList(DeployAreaEnum.AliyunProd, DeployAreaEnum.AzureProd).contains(currentArea)) {
            return;
        }
        if (!Objects.equals(tenantVO.getComeFrom(), "intelly")) {
            return;
        }
        List<DeployAreaEnum> allAreas = Arrays.asList(DeployAreaEnum.AliyunTest, DeployAreaEnum.AliyunProd, DeployAreaEnum.AzureTest, DeployAreaEnum.AzureProd);
        TenantIdDTO dto = new TenantIdDTO();
        dto.setId(tenantVO.getId());
        if (Objects.equals(tenantVO.getTeamId(), TeamEnum.INTERNAL_ISV.getId())) {
            dto.setDeployAreas(allAreas);
        } else if (Objects.equals(tenantVO.getTeamId(), TeamEnum.EXTERNAL_ISV.getId())) {
            List<DeployAreaEnum> filteredAreas = allAreas.stream().filter(x -> Objects.equals(currentArea.getCloud(), x.getCloud())).collect(Collectors.toList());
            dto.setDeployAreas(filteredAreas);
        } else {
            return;
        }
        if (this.existsMultiAreas(dto, userSid)) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ALREADY_EXISTED, new Object[]{tenantVO.getId()});
        }
    }
}

