/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenant.impl;

import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.TeamEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantConfirmEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.domain.CacRecordSourceEnum;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.servicer.ServicerVO;
import com.digiwin.dap.middleware.iam.domain.tenant.DevRegisterTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.DevTenantCertificationVO;
import com.digiwin.dap.middleware.iam.domain.tenant.RegisterTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ServicerRegisterTenantDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.domain.user.ContactVO;
import com.digiwin.dap.middleware.iam.domain.user.UserConditionVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInTenantsWithSysAuthInfo;
import com.digiwin.dap.middleware.iam.entity.DevCertificationDO;
import com.digiwin.dap.middleware.iam.entity.InvoiceInfo;
import com.digiwin.dap.middleware.iam.entity.IsvRelationDev;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantCertification;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.repository.CertificationRepository;
import com.digiwin.dap.middleware.iam.repository.InvoiceInfoRepository;
import com.digiwin.dap.middleware.iam.service.authentication.impl.TenantCertificationCrudServiceImpl;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceInfoCrudService;
import com.digiwin.dap.middleware.iam.service.servicer.ServicerService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.IsvRelationDevCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.PurchaseApplicationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRegisterService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserWholeService;
import com.digiwin.dap.middleware.iam.support.initialize.TenantInitializeService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.OmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteLMCService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.GoodsAuthDO;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TenantRegisterServiceImpl
implements TenantRegisterService {
    private static final Logger log = LoggerFactory.getLogger(TenantRegisterServiceImpl.class);
    private static final String TENANTID_PREFIX = "ath_";
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantInitializeService tenantInitializeService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private TenantMetadataUpdateService tenantMetadataUpdateService;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private TenantCertificationCrudServiceImpl tenantCertificationCrudService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private InvoiceInfoRepository invoiceInfoRepository;
    @Autowired
    private CertificationRepository certificationRepository;
    @Autowired
    private InvoiceInfoCrudService invoiceInfoCrudService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private ServicerService servicerService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private IsvRelationDevCrudService isvRelationDevCrudService;
    @Autowired
    private UserWholeService userWholeService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private CacService cacService;
    @Autowired
    private PurchaseApplicationService purchaseApplicationService;
    @Autowired
    private RemoteLMCService remoteLMCService;
    @Autowired
    private SysInTenantQueryService sysInTenantQueryService;
    @Autowired
    private OmcService omcService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RemoteEocService remoteEocService;

    @Override
    public void register(RegisterTenantVO registerTenantVO, long userSid) {
        long tenantSid;
        Tenant existed = (Tenant)this.tenantCrudService.findById(registerTenantVO.getTenant().getId());
        if (registerTenantVO.getTenant().getEnterpriseType() == null) {
            log.info("register tenant {} enterprisetype {}", (Object)registerTenantVO.getTenant().getId(), (Object)1);
            registerTenantVO.getTenant().setEnterpriseType(TenantEnterpriseTypeEnum.ENTERPRISE_TENANT.getValue());
        }
        if (existed != null) {
            if (existed.getOwnerUserSid() != userSid) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_ALREADY_EXISTED, new Object[]{registerTenantVO.getTenant().getId()});
            }
            if (!TenantConfirmEnum.REJECTION.getValue().equals(existed.getConfirm())) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_REGISTER_EXISTED);
            }
            registerTenantVO.getTenant().setConfirm(TenantConfirmEnum.NOT_REVIEWED.getValue());
            this.updateRegisterTenantVO(registerTenantVO);
            tenantSid = existed.getSid();
        } else {
            InvoiceInfo invoiceInfo;
            DevCertificationDO devCertificationDO;
            DevTenantCertificationVO certificationVO;
            Tenant tenant = new Tenant(registerTenantVO.getTenant());
            tenant.setOwnerUserSid(Optional.ofNullable(this.alterOwner(registerTenantVO)).orElse(userSid));
            tenant.setConfirm(TenantConfirmEnum.NOT_REVIEWED.getValue());
            tenantSid = this.tenantCrudService.create((BaseEntity)tenant);
            if (registerTenantVO.getTenantCertification() != null) {
                TenantCertification tenantCertification = new TenantCertification();
                BeanUtils.mergeDifferentTypeObject((Object)registerTenantVO.getTenantCertification(), (Object)((Object)tenantCertification));
                tenantCertification.setTenantSid(tenantSid);
                this.tenantCertificationCrudService.create((BaseEntity)tenantCertification);
            }
            if ((certificationVO = registerTenantVO.getCertification()) != null && (devCertificationDO = this.certificationRepository.findByTenantSid(tenantSid)) == null) {
                DevCertificationDO devCertification = new DevCertificationDO();
                devCertification.setTenantSid(tenantSid);
                BeanUtils.mergeDifferentTypeObject((Object)certificationVO, (Object)((Object)devCertification));
                EntityUtils.setCreateFields((BaseEntity)devCertification);
                devCertification.setLegalName(tenant.getName());
                this.certificationRepository.save((Object)devCertification);
            }
            if (registerTenantVO.getInvoice() != null && (invoiceInfo = this.invoiceInfoRepository.getByTenantSid(tenantSid)) == null) {
                invoiceInfo = registerTenantVO.getInvoice().generateInvoiceInfo();
                invoiceInfo.setTenantSid(tenantSid);
                this.invoiceInfoCrudService.create(invoiceInfo);
            }
            this.tenantMetadataUpdateService.update(tenant, registerTenantVO.getMetadatas());
            UserInTenant userInTenantTemp = this.userInTenantCrudService.findByUnionKey(tenantSid, userSid);
            if (userInTenantTemp == null) {
                UserInTenant userInTenant = new UserInTenant();
                userInTenant.setTenantSid(tenantSid);
                userInTenant.setUserSid(userSid);
                this.userInTenantCrudService.create(userInTenant);
            }
        }
        if (!StringUtils.isEmpty((Object)registerTenantVO.getTenant().getDefaultLanguage())) {
            this.tenantMetadataUpdateService.updateTenantMetadataValue(tenantSid, "basic", "defaultLanguage", registerTenantVO.getTenant().getDefaultLanguage());
        }
    }

    private Long alterOwner(RegisterTenantVO registerTenantVO) {
        User byId;
        if (StringUtils.hasLength((String)registerTenantVO.getOwnerUserId()) && (byId = (User)this.userCrudService.findById(registerTenantVO.getOwnerUserId())) != null) {
            return byId.getSid();
        }
        return null;
    }

    @Override
    public long registerIndividualTenant(long userSid, String userId, TenantVO tenantVO) {
        Tenant tenant = this.saveIndividualTenant(userSid, userId, tenantVO);
        return tenant.getSid();
    }

    private Tenant saveIndividualTenant(long userSid, String userId, TenantVO tenantVO) {
        if (StringUtils.hasLength((String)userId) && userId.contains(".")) {
            userId = userId.replace(".", "-");
        }
        String defaultId = this.getDefaultId(userId);
        String tenantId = Optional.ofNullable(tenantVO.getId()).orElse(defaultId);
        Tenant tenant = this.tenantCrudService.findIndividualTenant(userSid, 0);
        if (tenant == null) {
            tenant = new Tenant(tenantVO);
            tenant.setOpen(false);
            tenant.setConfirm(TenantConfirmEnum.APPROVED.getValue());
            tenant.setId(this.generateIndividualTenantId(tenantId, 0));
            tenant.setEnterpriseType(TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue());
            tenant.setOwnerUserSid(userSid);
            tenant.setTeamId(TeamEnum.SELF_DEV_ENTERPRISE_CUSTOMERS.getId());
            tenant.setEoc(Optional.ofNullable(tenantVO.getEoc()).orElse(false));
            tenant.setTestTenant(Optional.ofNullable(tenantVO.getTestTenant()).orElse(false));
            tenant.setExperience(Optional.ofNullable(tenantVO.getExperience()).orElse(false));
            this.tenantCrudService.create((BaseEntity)tenant);
            this.tenantInitializeService.initDefaultTenant(tenant.getId(), tenant.getSid(), null, userSid);
            if (Boolean.TRUE.equals(tenantVO.getEoc())) {
                this.remoteEocService.initialize(new TenantInfoVO(tenant.getSid(), tenant.getId(), tenant.getName()));
            }
            UserInTenant userInTenant = new UserInTenant();
            userInTenant.setTenantSid(tenant.getSid());
            userInTenant.setUserSid(userSid);
            this.userInTenantCrudService.create(userInTenant);
        } else {
            long tenantSid = tenant.getSid();
            BeanUtils.mergeDifferentTypeObject((Object)tenantVO, (Object)((Object)tenant));
            tenant.setSid(tenantSid);
            this.tenantCrudService.update((BaseEntity)tenant);
        }
        String appId = Optional.ofNullable(UserUtils.getAuthoredSys()).map(AuthoredSys::getId).orElse("DigiwinCloud".toLowerCase());
        this.remoteLMCService.saveAgreeCertificationAgreementChangeLog(tenant, UserUtils.getAuthoredUser(), appId.equalsIgnoreCase("DigiwinCloud") ? appId.toLowerCase() : appId, tenantVO.getAgreeCertificationAgreement());
        return tenant;
    }

    private String getDefaultId(String userId) {
        if (userId != null && userId.contains("@")) {
            userId = userId.substring(0, userId.indexOf("@"));
        }
        return "pro-" + userId;
    }

    @Override
    public void updateRegisterTenantVO(RegisterTenantVO registerTenantVO) {
        TenantVO tenantVO = registerTenantVO.getTenant();
        Tenant existedTenant = (Tenant)this.tenantCrudService.findById(tenantVO.getId());
        if (existedTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantVO.getId()});
        }
        ContactVO contactVO = new ContactVO();
        contactVO.setOldEmail(existedTenant.getEmail());
        if (!StringUtils.isEmpty((Object)existedTenant.getTelephone())) {
            contactVO.setOldTelephone(existedTenant.getTelephone().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2"));
        }
        long tenantSid = existedTenant.getSid();
        BeanUtils.mergeDifferentTypeObject((Object)tenantVO, (Object)((Object)existedTenant));
        existedTenant.setSid(tenantSid);
        this.tenantCrudService.update((BaseEntity)existedTenant);
        String corpId = this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid, "contact", "corpId");
        if (StringUtils.hasText((String)tenantVO.getCorpId()) && !Objects.equals(corpId, tenantVO.getCorpId())) {
            this.tenantMetadataUpdateService.updateTenantMetadataValue(tenantSid, "contact", "corpId", tenantVO.getCorpId());
            this.remoteEMCService.updateCorpids(tenantVO.getId(), tenantVO.getCorpId());
        }
        contactVO.setTenantSid(tenantSid);
        if (!StringUtils.isEmpty((Object)tenantVO.getTelephone())) {
            contactVO.setTelephone(tenantVO.getTelephone().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2"));
        }
        contactVO.setEmail(tenantVO.getEmail());
        this.messageService.sendChangeContactMessage(contactVO);
    }

    @Override
    public void updateRegisterTenantVO4CBM(RegisterTenantVO registerTenantVO) {
        TenantVO tenantVO = registerTenantVO.getTenant();
        Tenant existedTenant = (Tenant)this.tenantCrudService.findById(tenantVO.getId());
        if (existedTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantVO.getId()});
        }
        ContactVO contactVO = new ContactVO();
        contactVO.setOldEmail(existedTenant.getEmail());
        if (!StringUtils.isEmpty((Object)existedTenant.getTelephone())) {
            contactVO.setOldTelephone(existedTenant.getTelephone().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2"));
        }
        long tenantSid = existedTenant.getSid();
        BeanUtils.mergeDifferentTypeObject((Object)tenantVO, (Object)((Object)existedTenant));
        existedTenant.setSid(tenantSid);
        this.tenantCrudService.update((BaseEntity)existedTenant);
        String corpId = this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid, "contact", "corpId");
        if (!Objects.equals(corpId, tenantVO.getCorpId())) {
            if (tenantVO.getCorpId() == null) {
                this.tenantMetadataUpdateService.deleteTenantMetadataValue(tenantSid, "contact", "corpId");
            } else {
                this.tenantMetadataUpdateService.updateTenantMetadataValue(tenantSid, "contact", "corpId", tenantVO.getCorpId());
            }
        }
        contactVO.setTenantSid(tenantSid);
        if (!StringUtils.isEmpty((Object)tenantVO.getTelephone())) {
            contactVO.setTelephone(tenantVO.getTelephone().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2"));
        }
        contactVO.setEmail(tenantVO.getEmail());
        this.messageService.sendChangeContactMessage(contactVO);
    }

    private String generateIndividualTenantId(String tenantId, int count) {
        if (this.tenantCrudService.existsById(tenantId)) {
            tenantId = ++count > 1 ? StringUtil.truncateString(tenantId, tenantId.length() - String.valueOf(count - 1).length()) + count : tenantId + count;
            return this.generateIndividualTenantId(tenantId, count);
        }
        return tenantId;
    }

    @Override
    public long registerDevIndividualTenant(long userSid, DevRegisterTenantVO registerTenantVO) {
        Tenant tenant = this.tenantCrudService.findIndividualTenant(userSid, null);
        registerTenantVO.setEnterpriseType(TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue());
        registerTenantVO.setOwnerUserSid(userSid);
        tenant = this.saveDevTenant(tenant, registerTenantVO);
        this.tenantInitializeService.initDefaultTenant(tenant.getId(), tenant.getSid(), null, userSid);
        return tenant.getSid();
    }

    @Override
    public long registerDevTenant(long userSid, DevRegisterTenantVO registerTenantVO) {
        Tenant tenant = this.tenantCrudService.findIndividualTenant(userSid, null);
        registerTenantVO.setEnterpriseType(TenantEnterpriseTypeEnum.ENTERPRISE_TENANT.getValue());
        registerTenantVO.setOwnerUserSid(userSid);
        tenant = this.saveDevTenant(tenant, registerTenantVO);
        if (!StringUtils.isEmpty((Object)registerTenantVO.getTaxCode())) {
            this.saveInvoiceInfo(registerTenantVO, tenant);
        }
        return tenant.getSid();
    }

    private void saveInvoiceInfo(DevRegisterTenantVO registerTenantVO, Tenant tenant) {
        List<InvoiceInfo> invoiceInfos = this.tenantMapper.getByTaxCodeAndEnterPriseTypeNoTenantSid(registerTenantVO.getTaxCode(), tenant.getSid(), tenant.getEnterpriseType());
        if (invoiceInfos.size() > 0) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_INFO_HAS_EXIST, new Object[]{registerTenantVO.getTaxCode(), TenantEnterpriseTypeEnum.getName(tenant.getEnterpriseType()), invoiceInfos.get(0).getTenantSid()});
        }
        InvoiceInfo existedInvoiceInfo = this.invoiceInfoRepository.getByTenantSid(tenant.getSid());
        if (existedInvoiceInfo != null) {
            existedInvoiceInfo.setTaxCode(registerTenantVO.getTaxCode());
            existedInvoiceInfo.setInvoiceTitle(registerTenantVO.getInvoiceTitle());
            this.invoiceInfoCrudService.update(existedInvoiceInfo);
        } else {
            InvoiceInfo invoiceInfo = new InvoiceInfo();
            invoiceInfo.setTenantSid(tenant.getSid());
            invoiceInfo.setTaxCode(registerTenantVO.getTaxCode());
            invoiceInfo.setInvoiceTitle(registerTenantVO.getInvoiceTitle());
            this.invoiceInfoCrudService.create(invoiceInfo);
        }
    }

    @Override
    public long registerServicerTenant(long userSid, ServicerRegisterTenantDTO dto) {
        List<DevCertificationDO> certifications;
        boolean sendEmail = true;
        Tenant tenant = dto.getSid() != null ? (Tenant)this.tenantCrudService.findBySid(dto.getSid()) : this.tenantCrudService.findIndividualTenant(userSid, TenantEnterpriseTypeEnum.ENTERPRISE_TENANT.getValue());
        if (tenant != null) {
            if (TenantConfirmEnum.APPROVED.getValue().equals(tenant.getConfirm())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_21021);
            }
            if (!tenant.isIsv()) {
                throw new BusinessException((ErrorHandler)I18nError.APPLICATION_INFORMATION_ERROR1);
            }
            if (userSid != tenant.getOwnerUserSid()) {
                throw new BusinessException((ErrorHandler)I18nError.APPLICATION_INFORMATION_ERROR2, new Object[]{tenant.getId()});
            }
            certifications = this.tenantQueryService.getByLicenseNumberAndEnterPriseTypeNoTenantSid(dto.getLicenseNumber(), tenant.getSid(), tenant.getEnterpriseType());
            if (!certifications.isEmpty()) {
                throw new BusinessException((ErrorHandler)I18nError.SERVICER_TENANT_LICENSE_NUMBER_EXISTED, new Object[]{dto.getLicenseNumber()});
            }
            if (TenantConfirmEnum.NOT_REVIEWED.getValue().equals(tenant.getConfirm())) {
                sendEmail = false;
            }
        } else {
            certifications = this.tenantQueryService.getByLicenseNumber(dto.getLicenseNumber(), null);
            if (!certifications.isEmpty()) {
                throw new BusinessException((ErrorHandler)I18nError.SERVICER_TENANT_LICENSE_NUMBER_EXISTED, new Object[]{dto.getLicenseNumber()});
            }
        }
        dto.setEnterpriseType(TenantEnterpriseTypeEnum.ENTERPRISE_TENANT.getValue());
        dto.setOwnerUserSid(userSid);
        tenant = this.saveServicerTenant(tenant, dto);
        if (!StringUtils.isEmpty((Object)dto.getTaxCode())) {
            this.saveInvoiceInfo(dto, tenant);
        }
        if (sendEmail) {
            this.messageService.sendRegisterMessage(tenant, "ISV");
        }
        if (0L != dto.getDevTenantSid() && !this.isvRelationDevCrudService.existsByDevTenantSid(dto.getDevTenantSid())) {
            IsvRelationDev isvRelationDev = new IsvRelationDev();
            isvRelationDev.setDevTenantSid(dto.getDevTenantSid());
            isvRelationDev.setIsvTenantSid(tenant.getSid());
            this.isvRelationDevCrudService.create(isvRelationDev);
        }
        return tenant.getSid();
    }

    @Override
    public Map registerIndividualTenantWithAuth(UserConditionVO userConditionVO) {
        List<UserInTenantsWithSysAuthInfo> userInTenants = this.userWholeService.getUsersByEmailOrTel(userConditionVO);
        UserInTenantsWithSysAuthInfo userInfo = userInTenants.get(0);
        TenantVO tenantVO = new TenantVO();
        tenantVO.setName(userInfo.getUserName());
        tenantVO.setTelephone(userInfo.getTelephone());
        tenantVO.setEmail(userInfo.getEmail());
        tenantVO.setPhone(userInfo.getPhone());
        tenantVO.setCellphonePrefix(userInfo.getCellphonePrefix());
        tenantVO.setAddress(userInfo.getAddress());
        tenantVO.setImageUrl(userInfo.getHeadImageUrl());
        Tenant tenant = this.saveIndividualTenant(userInfo.getUserSid(), userInfo.getUserId(), tenantVO);
        if (!StringUtils.isEmpty((Object)userConditionVO.getAppId())) {
            GoodsAuthDO goodsAuthDO = new GoodsAuthDO(tenant);
            goodsAuthDO.setSourceId(CacRecordSourceEnum.DirectAuthorization.getId());
            goodsAuthDO.setMemo("\u6ce8\u518c\u4e2a\u4eba\u79df\u6237\u5e76\u6388\u6743\u5e94\u7528");
            goodsAuthDO.setAppId(userConditionVO.getAppId());
            goodsAuthDO.setStrategyCode(userConditionVO.getStrategyCode());
            goodsAuthDO.setAction(0);
            goodsAuthDO.setUpdateTenantAuth(true);
            goodsAuthDO.setUserId(userInfo.getUserId());
            try {
                Boolean result = this.omcService.purchaseApp(tenant.getId(), Collections.singletonList(goodsAuthDO));
                log.error("registerIndividualTenantWithAuth:\u6ce8\u518c\u4e2a\u4eba\u79df\u6237{}\u5e76\u6388\u6743\u5e94\u7528{}\u7ed3\u679c\uff1a{}", new Object[]{tenant.getId(), goodsAuthDO.getAppId(), result});
                AuthorizationVO authorizationVO = null;
                if (!result.booleanValue()) {
                    authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(tenant.getId(), goodsAuthDO.getAppId());
                }
                log.error("registerIndividualTenantWithAuth:\u6ce8\u518c\u4e2a\u4eba\u79df\u6237{}\u5e76\u6388\u6743\u5e94\u7528{}\u6388\u6743\u4fe1\u606f", new Object[]{tenant.getId(), goodsAuthDO.getAppId(), null != authorizationVO ? JsonUtils.writeValue((Object)authorizationVO) : null});
                if (result.booleanValue() || null != authorizationVO) {
                    SysVO sysVO = new SysVO();
                    sysVO.setId(userConditionVO.getAppId());
                    sysVO.setIdFirst(userConditionVO.getAppId());
                    this.purchaseApplicationService.purchaseApplication(tenant, userInfo.getUserId(), sysVO, true);
                }
            }
            catch (Exception ex) {
                log.error("\u6ce8\u518c\u4e2a\u4eba\u79df\u6237{}\uff0c\u5f00\u901a\u5e94\u7528{}\u6388\u6743\u5931\u8d25", new Object[]{tenant.getId(), userConditionVO.getAppId(), ex});
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sid", tenant.getSid());
        result.put("id", tenant.getId());
        result.put("name", tenant.getName());
        result.put("userId", userInfo.getUserId());
        return result;
    }

    @Override
    public void purchaseAuth(Tenant tenant, GoodsAuthDO goodsAuthDO) {
        if (StringUtils.hasText((String)goodsAuthDO.getAppId())) {
            AuthorizationVO authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(tenant.getId(), goodsAuthDO.getAppId());
            goodsAuthDO.setTenantName(tenant.getName());
            goodsAuthDO.setCustomerServiceCode(tenant.getCustomerId());
            goodsAuthDO.setTenantSid(tenant.getSid());
            goodsAuthDO.setPotentialCustomerId(tenant.getPotentialCustomerId());
            if (authorizationVO == null) {
                goodsAuthDO.setAction(0);
                goodsAuthDO.setUpdateTenantAuth(true);
                if (!StringUtils.hasText((String)goodsAuthDO.getSourceId())) {
                    goodsAuthDO.setSourceId(CacRecordSourceEnum.DirectAuthorization.getId());
                    goodsAuthDO.setSourceCode(UserUtils.getTenantId());
                    goodsAuthDO.setMemo(String.format("\u7ed9\u5f53\u524d\u79df\u6237%s\u540c\u5ba2\u4ee3\u79df\u6237\u5f00\u901a\u6388\u6743\u4ee5\u53ca\u6388\u6743\u7528\u6237", UserUtils.getTenantId()));
                } else {
                    goodsAuthDO.setSourceCode(tenant.getCustomerId());
                    goodsAuthDO.setMemo(String.format("\u7ed9\u6307\u5b9a\u5ba2\u4ee3%s\u7684\u79df\u6237\u5f00\u901a\u6388\u6743\u4ee5\u53ca\u6388\u6743\u7528\u6237", tenant.getCustomerId()));
                }
                boolean result = this.omcService.purchaseAppWithException(tenant.getId(), Collections.singletonList(goodsAuthDO));
                log.error("purchaseAuth:\u6ce8\u518c\u4e2a\u4eba\u79df\u6237{}\u5e76\u6388\u6743\u5e94\u7528{}\u7ed3\u679c\uff1a{}", new Object[]{tenant.getId(), goodsAuthDO.getAppId(), result});
            } else {
                goodsAuthDO.setAction(1);
                goodsAuthDO.setUpdateTenantAuth(false);
                goodsAuthDO.setSourceId(CacRecordSourceEnum.DirectAuthorization.getId());
                goodsAuthDO.setSourceCode(UserUtils.getTenantId());
                goodsAuthDO.setMemo(String.format("\u7ed9\u5f53\u524d\u79df\u6237%s\u7684\u540c\u5ba2\u4ee3\u79df\u6237\u6388\u6743\u7528\u6237", UserUtils.getTenantId()));
                this.omcService.purchaseAppWithException(tenant.getId(), Collections.singletonList(goodsAuthDO));
            }
        }
    }

    private Tenant saveServicerTenant(Tenant tenant, ServicerRegisterTenantDTO dto) {
        tenant = this.saveDevTenant(tenant, dto);
        dto.setSid(tenant.getSid());
        this.servicerService.createServicer(new ServicerVO(dto));
        return tenant;
    }

    private Tenant saveDevTenant(Tenant tenant, DevRegisterTenantVO registerTenantVO) {
        long tenantSid;
        this.checkVerifyCode(registerTenantVO);
        if (tenant != null) {
            tenantSid = tenant.getSid();
            String tenantId = tenant.getId();
            BeanUtils.mergeDifferentTypeObject((Object)registerTenantVO, (Object)((Object)tenant));
            tenant.setSid(tenantSid);
            tenant.setId(tenantId);
            tenant.setConfirm(0);
            this.tenantCrudService.update((BaseEntity)tenant);
            DevCertificationDO devCertificationDO = this.certificationRepository.findByTenantSid(tenantSid);
            if (devCertificationDO == null) {
                devCertificationDO = new DevCertificationDO(registerTenantVO);
                devCertificationDO.setTenantSid(tenantSid);
                EntityUtils.setCreateFields((BaseEntity)devCertificationDO);
                this.certificationRepository.save((Object)devCertificationDO);
            } else {
                devCertificationDO.setLegalName(registerTenantVO.getLegalName());
                devCertificationDO.setLicenseNumber(registerTenantVO.getLicenseNumber());
                devCertificationDO.setLicenseNumberFrontImageUrl(registerTenantVO.getLicenseNumberFrontImageUrl());
                devCertificationDO.setLicenseNumberBackImageUrl(registerTenantVO.getLicenseNumberBackImageUrl());
                devCertificationDO.setLicenseNumberGroupImageUrl(registerTenantVO.getLicenseNumberGroupImageUrl());
                devCertificationDO.setLicenseNumberImageUrl(registerTenantVO.getLicenseNumberImageUrl());
                EntityUtils.setModifyFields((BaseEntity)devCertificationDO);
                this.certificationRepository.save((Object)devCertificationDO);
            }
        } else {
            tenant = new Tenant(registerTenantVO);
            tenant.setOpen(true);
            tenant.setConfirm(TenantConfirmEnum.NOT_REVIEWED.getValue());
            tenantSid = this.tenantCrudService.create((BaseEntity)tenant);
            DevCertificationDO devCertificationDO = new DevCertificationDO(registerTenantVO);
            devCertificationDO.setTenantSid(tenantSid);
            EntityUtils.setCreateFields((BaseEntity)devCertificationDO);
            this.certificationRepository.save((Object)devCertificationDO);
        }
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenantSid, registerTenantVO.getOwnerUserSid());
        if (userInTenant == null) {
            userInTenant = new UserInTenant();
            userInTenant.setTenantSid(tenantSid);
            userInTenant.setUserSid(registerTenantVO.getOwnerUserSid());
            userInTenant.setVisible(true);
            this.userInTenantCrudService.create(userInTenant);
        }
        String appId = Optional.ofNullable(UserUtils.getAuthoredSys()).map(AuthoredSys::getId).orElse("DigiwinCloud".toLowerCase());
        this.remoteLMCService.saveAgreeCertificationAgreementChangeLog(tenant, UserUtils.getAuthoredUser(), appId.equalsIgnoreCase("DigiwinCloud") ? appId.toLowerCase() : appId, registerTenantVO.getAgreeCertificationAgreement());
        return tenant;
    }

    private boolean checkVerifyCode(DevRegisterTenantVO tenantVO) {
        String scene = "register";
        this.verifyRegisterBody(tenantVO, true, false, true);
        if (this.remoteEMCService.checkVerificationCode(tenantVO.getEmail(), scene, tenantVO.getVerificationCode())) {
            return true;
        }
        throw new BusinessException((ErrorHandler)I18nError.USER_VERIFICATION_CODE_ERROR);
    }

    public void verifyRegisterBody(DevRegisterTenantVO body, boolean checkVerificationCode, boolean checkTelephone, boolean checkEmail) {
        StringBuilder stringBuilder = new StringBuilder();
        if (checkEmail && StringUtils.isEmpty((Object)body.getEmail())) {
            stringBuilder.append("tenant.Email\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (checkTelephone && StringUtils.isEmpty((Object)body.getTelephone())) {
            stringBuilder.append("tenant.Telephone\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (checkVerificationCode && StringUtils.isEmpty((Object)body.getVerificationCode())) {
            stringBuilder.append("tenant.VerificationCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!Strings.isBlank((String)stringBuilder.toString())) {
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        if (checkEmail && !StringUtil.checkEmail(body.getEmail())) {
            stringBuilder.append(String.format("user.Email\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a[%s]\uff01", body.getEmail()));
        }
        if (checkTelephone && !StringUtil.isInt(body.getTelephone())) {
            stringBuilder.append(String.format("user.Telephone\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a[%s]\uff01", body.getTelephone()));
        }
        if (!Strings.isBlank((String)stringBuilder.toString())) {
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    @Override
    public String tenantId() {
        Integer id = this.tenantMapper.tenantId();
        if (id == null) {
            id = 0;
        }
        return TENANTID_PREFIX + String.format("%06d", id + 1);
    }
}

