/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenant.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.domain.ComeFromEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.GeneralParametersVO;
import com.digiwin.dap.middleware.iam.domain.tenant.InvitedUserVO;
import com.digiwin.dap.middleware.iam.domain.tenant.UserRelationWithTenantWithStatusVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.user.UserTenantSimpleVO;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.InvitedUserHistory;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.InvitedUserHistoryMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInOrgMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.repository.InvitedUserHistoryRepository;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.repository.UserInTenantRepository;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataQueryService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.AutoEOCService;
import com.digiwin.dap.middleware.iam.service.tenant.InvitedUserHistoryCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRelationWithUserService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantOperationService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.DataPermissionFilterable;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.service.CascadeDeleteEntityService;
import com.digiwin.dap.middleware.util.I18nUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TenantRelationWithUserServiceImpl
implements TenantRelationWithUserService {
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserInTenantRepository userInTenantRepository;
    @Autowired
    private InvitedUserHistoryCrudService invitedUserHistoryCrudService;
    @Autowired
    private InvitedUserHistoryRepository invitedUserHistoryRepository;
    @Autowired
    private UserInTenantOperationService userInTenantOperationService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private InvitedUserHistoryMapper invitedUserHistoryMapper;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private CascadeDeleteEntityService cascadeDeleteEntityService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private UserInOrgMapper userInOrgMapper;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private CacService cacService;
    @Autowired
    private MetadataQueryService metadataQueryService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private SysRepository sysRepository;
    @Autowired
    private DataPolicyService dataPolicyService;
    @Autowired
    private AutoEOCService autoEOCService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private UserMappingService userMappingService;

    @Override
    public List<UserRelationWithTenantWithStatusVO> tenantGetUserList(String type, long tenantSid) {
        switch (type) {
            case "all": {
                ArrayList<UserRelationWithTenantWithStatusVO> result = new ArrayList<UserRelationWithTenantWithStatusVO>();
                result.addAll(this.tenantGetApplyList(tenantSid));
                result.addAll(this.tenantGetInvitedList(tenantSid));
                return result;
            }
            case "joined": {
                return this.tenantGetJoinedList(tenantSid);
            }
            case "apply": {
                return this.tenantGetApplyList(tenantSid);
            }
            case "invited": {
                return this.tenantGetInvitedList(tenantSid);
            }
        }
        throw new IllegalArgumentException("\u53c3\u6578\u932f\u8aa4: input.type");
    }

    @Override
    public List<UserRelationWithTenantWithStatusVO> tenantGetJoinedList(long tenantSid) {
        ArrayList<UserRelationWithTenantWithStatusVO> result = new ArrayList<UserRelationWithTenantWithStatusVO>();
        List<UserInTenant> userInTenantList = this.userInTenantRepository.findByTenantSid(tenantSid);
        userInTenantList.forEach(userInTenant -> {
            User user = (User)this.userCrudService.findBySid(userInTenant.getUserSid());
            if (user != null) {
                result.add(new UserRelationWithTenantWithStatusVO(userInTenant.getSid(), tenantSid, user, IamConstants.AcceptedStatus.Joined.toString(), userInTenant.getCreateDate()));
            }
        });
        return result;
    }

    @Override
    public List<UserRelationWithTenantWithStatusVO> tenantGetApplyList(long tenantSid) {
        return this.invitedUserHistoryMapper.findByTenantSidAndType(tenantSid, true);
    }

    @Override
    public List<UserRelationWithTenantWithStatusVO> tenantGetUnConfirmApplyList(long tenantSid) {
        List<UserRelationWithTenantWithStatusVO> result = this.invitedUserHistoryMapper.findByTenantSidAndAcceptedStatusAndType(tenantSid, IamConstants.AcceptedStatus.ApplyWaitAgree.toString(), true);
        for (UserRelationWithTenantWithStatusVO aResult : result) {
            List<DataPermissionFilterable> apps = new ArrayList<DataPermissionFilterable>(GeneralParametersVO.parseList(aResult.getAppString()));
            apps = this.dataPolicyService.getActionData(tenantSid, UserUtils.getUserSid(), apps, "DigiwinCloud", "djc-cloud-management", "djc-mang-service");
            aResult.setApp(apps);
            aResult.setOrg(GeneralParametersVO.parseList(aResult.getOrgString()));
            aResult.setRole(GeneralParametersVO.parseList(aResult.getRoleString()));
        }
        return result;
    }

    @Override
    public List<UserRelationWithTenantWithStatusVO> tenantGetInvitedList(long tenantSid) {
        ArrayList<UserRelationWithTenantWithStatusVO> result = new ArrayList<UserRelationWithTenantWithStatusVO>();
        List<InvitedUserHistory> histories = this.invitedUserHistoryRepository.findByTenantSidAndType(tenantSid, false);
        histories.forEach(history -> {
            User user;
            String target;
            if (history.getUserSid() == -1L) {
                if (!Strings.isEmpty((CharSequence)history.getUserEmail())) {
                    target = history.getUserEmail();
                    user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(target, target, target, null);
                } else {
                    if (Strings.isEmpty((CharSequence)history.getUserTel())) return;
                    target = history.getUserTel();
                    user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(target, target, target, null);
                }
            } else {
                target = String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728", history.getUserSid());
                user = (User)this.userCrudService.findBySid(history.getUserSid());
            }
            if (user != null) {
                result.add(new UserRelationWithTenantWithStatusVO((InvitedUserHistory)((Object)history), user));
                return;
            } else {
                result.add(new UserRelationWithTenantWithStatusVO((InvitedUserHistory)((Object)history), target));
            }
        });
        return result;
    }

    @Override
    public void invitedUserJoinNew(InvitedUserVO body, Tenant tenant, Sys sys, Map resultMap) {
        String language = StringUtils.isEmpty((Object)body.getLanguage()) ? LocaleContextHolder.getLocale().getLanguage() + "_" + LocaleContextHolder.getLocale().getCountry() : body.getLanguage();
        Locale currentLocale = Locale.forLanguageTag(language.replace("_", "-"));
        User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(body.getUser(), body.getUser(), body.getUser(), null);
        ArrayList<String> appIds = new ArrayList<String>();
        appIds.add(sys.getId());
        if (null == user) {
            String content = I18nUtils.getMessage((String)I18nCode.USER_INVITE_EMAIL_CONTENT.getCode(), (Object[])new Object[]{tenant.getName() + "(" + tenant.getId() + ")"}, (String)"", (Locale)currentLocale);
            InvitedUserHistory invitedUserHistory = null;
            if (StringUtil.checkEmail(body.getUser())) {
                invitedUserHistory = new InvitedUserHistory().generateHistoryTenantInviteUser(tenant.getSid(), 0, body.getUser(), content);
                Long invitedSid = this.updateInvitedUserHistory(tenant.getSid(), null, body.getUser(), null, invitedUserHistory);
                this.messageService.sendInviteMessage(tenant.getSid(), body.getUser(), content, appIds, true, body.getInviteApp(), invitedSid, language);
            } else if (StringUtil.checkMobilePhone(body.getUser())) {
                invitedUserHistory = new InvitedUserHistory().generateHistoryTenantInviteUser(tenant.getSid(), 1, body.getUser(), content);
                Long invitedSid = this.updateInvitedUserHistory(tenant.getSid(), null, null, body.getUser(), invitedUserHistory);
                this.messageService.inviteUserRegisterOrLoginSms(tenant.getSid(), body.getUser(), "", invitedSid, true, body.getInviteApp());
            } else {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_NOT_EXISTED);
            }
            resultMap.put("code", I18nError.USER_INVITING.getErrorCode());
            resultMap.put("message", I18nUtils.getMessage((String)I18nError.USER_INVITING.getCode(), null, (String)"", (Locale)LocaleContextHolder.getLocale()));
        } else if (!this.userInTenantRepository.existsByTenantSidAndUserSid(tenant.getSid(), user.getSid())) {
            String content = I18nUtils.getMessage((String)I18nCode.USER_INVITE_EMAIL_CONTENT.getCode(), (Object[])new Object[]{tenant.getName() + "(" + tenant.getId() + ")"}, (String)"", (Locale)currentLocale);
            InvitedUserHistory invitedUserHistory = new InvitedUserHistory().generateHistoryTenantInviteUser(tenant.getSid(), 3, String.valueOf(user.getSid()), content);
            Long invitedSid = this.updateInvitedUserHistory(tenant.getSid(), user.getSid(), user.getEmail(), user.getTelephone(), invitedUserHistory);
            if (StringUtil.checkEmail(body.getUser())) {
                this.messageService.sendInviteMessage(tenant.getSid(), body.getUser(), content, appIds, false, body.getInviteApp(), invitedSid, language);
            } else if (StringUtil.checkMobilePhone(body.getUser())) {
                this.messageService.inviteUserRegisterOrLoginSms(tenant.getSid(), body.getUser(), user.getId(), invitedSid, false, body.getInviteApp());
            }
        } else {
            Map map = this.cacService.addUserAuthorization(this.envProperties.getCacUri(), tenant.getId(), sys.getId(), user.getId());
            if (map != null) {
                if (!((Boolean)map.get("isSuccess")).booleanValue()) {
                    if (0 == (Integer)map.get("totalCount") && 0 == (Integer)map.get("currentCount")) {
                        throw new BusinessException((ErrorHandler)I18nError.ERROR_21006);
                    }
                    resultMap.put("code", I18nError.USER_COUNTING_FULL.getErrorCode());
                    resultMap.put("message", I18nUtils.getMessage((String)I18nError.USER_COUNTING_FULL.getCode(), null, (String)"", (Locale)currentLocale));
                } else {
                    resultMap.put("code", I18nError.USER_INVITED.getErrorCode());
                    resultMap.put("message", I18nUtils.getMessage((String)I18nError.USER_INVITED.getCode(), null, (String)"", (Locale)currentLocale));
                }
            }
        }
    }

    @Override
    public Long invitedUserJoin(long tenantSid, InvitedUserVO invitedUserVO, Boolean isBatch) {
        User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(invitedUserVO.getUser(), invitedUserVO.getUser(), invitedUserVO.getUser(), null);
        List<String> appIds = invitedUserVO.getApp().stream().map(GeneralParametersVO::getId).collect(Collectors.toList());
        Long invitedSid = 0L;
        if (StringUtil.checkEmail(invitedUserVO.getUser())) {
            this.createInvitedUserHistory(0, tenantSid, invitedUserVO, appIds, user);
        } else if (StringUtil.checkMobilePhone(invitedUserVO.getUser()) || StringUtil.checkTWMobilePhone(invitedUserVO.getUser())) {
            this.createInvitedUserHistory(1, tenantSid, invitedUserVO, appIds, user);
        } else {
            if (null == user) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_NOT_EXISTED);
            }
            if (ObjectUtils.nullSafeEquals((Object)1, (Object)user.getType())) {
                throw new BusinessException((ErrorHandler)I18nError.EXCEL_INVITED_ERROR_USER_TYPE);
            }
            if (!this.userInTenantRepository.existsByTenantSidAndUserSid(tenantSid, user.getSid())) {
                UserMetadataVO userMetadataVO;
                if (Boolean.TRUE.equals(isBatch)) {
                    UserMetadataVO userMetadataVO2 = this.metadataQueryService.getUserMetadataValue(0L, user.getSid(), "basic", "dapAcceptLanguage");
                    if (userMetadataVO2 != null && !StringUtils.isEmpty((Object)userMetadataVO2.getValue())) {
                        invitedUserVO.setLanguage(userMetadataVO2.getValue());
                        invitedUserVO.setContent(String.format(I18nUtils.getMessage((String)I18nCode.EXCEL_INVITED_CONTENT.getCode(), (Locale)Locale.forLanguageTag(userMetadataVO2.getValue().replace("_", "-"))), UserUtils.getTenantName()));
                    } else if (!StringUtils.isEmpty((Object)invitedUserVO.getLanguage())) {
                        invitedUserVO.setContent(String.format(I18nUtils.getMessage((String)I18nCode.EXCEL_INVITED_CONTENT.getCode(), (Locale)Locale.forLanguageTag(invitedUserVO.getLanguage().replace("_", "-"))), UserUtils.getTenantName()));
                    }
                } else if (StringUtils.isEmpty((Object)invitedUserVO.getLanguage()) && (userMetadataVO = this.metadataQueryService.getUserMetadataValue(0L, user.getSid(), "basic", "dapAcceptLanguage")) != null && !StringUtils.isEmpty((Object)userMetadataVO.getValue())) {
                    invitedUserVO.setLanguage(userMetadataVO.getValue());
                }
                this.createInvitedUserHistory(2, tenantSid, invitedUserVO, appIds, user);
            } else if (isBatch.booleanValue()) {
                this.invitedUserJoinWithTenantExist(tenantSid, invitedUserVO, user);
            }
        }
        return invitedSid;
    }

    private InvitedUserHistory createInvitedUserHistory(Integer type, Long tenantSid, InvitedUserVO invitedUserVO, List<String> appIds, User user) {
        InvitedUserHistory invitedUserHistory = new InvitedUserHistory().generateHistoryTenantInviteUser(tenantSid, type, invitedUserVO.getUser(), invitedUserVO.getContent());
        try {
            invitedUserHistory.setOrg(objectMapper.writeValueAsString(invitedUserVO.getOrg()));
            invitedUserHistory.setRole(objectMapper.writeValueAsString(invitedUserVO.getRole()));
            invitedUserHistory.setApp(objectMapper.writeValueAsString(invitedUserVO.getApp()));
        }
        catch (JsonProcessingException e) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        if (!StringUtils.isEmpty((Object)invitedUserVO.getDueDate())) {
            invitedUserVO.setDueDate(invitedUserVO.getDueDate().substring(0, 10) + " 23:59:59");
            try {
                invitedUserHistory.setDueDate(LocalDateTimeUtil.parse((CharSequence)invitedUserVO.getDueDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            catch (Exception ex) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
        }
        invitedUserHistory.setWechat(invitedUserVO.getWechat());
        invitedUserHistory.setEmpId(invitedUserVO.getEmpId());
        if (this.autoEOCService.isConsole(tenantSid) && this.autoEOCService.isAutoEOC(tenantSid) && invitedUserVO.getUserType().booleanValue()) {
            invitedUserHistory.setEmpId(null);
        }
        invitedUserHistory.setUserType(invitedUserVO.getUserType());
        Long invitedSid = 0L;
        Boolean isNeedRegister = ObjectUtils.isEmpty((Object)((Object)user));
        if (0 == type) {
            invitedSid = this.updateInvitedUserHistory(tenantSid, null, invitedUserVO.getUser(), null, invitedUserHistory);
            this.messageService.sendInviteMessage(tenantSid, invitedUserVO.getUser(), invitedUserVO.getContent(), appIds, isNeedRegister, invitedUserVO.getInviteApp(), invitedSid, invitedUserVO.getLanguage());
        } else if (1 == type) {
            invitedSid = this.updateInvitedUserHistory(tenantSid, null, null, invitedUserVO.getUser(), invitedUserHistory);
            this.messageService.inviteUserRegisterOrLoginSms(tenantSid, invitedUserVO.getUser(), "", 0L, isNeedRegister, invitedUserVO.getInviteApp());
        } else {
            if (isNeedRegister.booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_NOT_EXISTED);
            }
            invitedSid = this.updateInvitedUserHistory(tenantSid, user.getSid(), user.getEmail(), user.getTelephone(), invitedUserHistory);
            if (StringUtil.checkEmail(invitedUserVO.getUser())) {
                this.messageService.sendInviteMessage(tenantSid, invitedUserVO.getUser(), invitedUserVO.getContent(), appIds, isNeedRegister, invitedUserVO.getInviteApp(), invitedSid, invitedUserVO.getLanguage());
            } else if (StringUtil.checkMobilePhone(invitedUserVO.getUser())) {
                this.messageService.inviteUserRegisterOrLoginSms(tenantSid, invitedUserVO.getUser(), user.getId(), invitedSid, isNeedRegister, invitedUserVO.getInviteApp());
            } else if (!StringUtils.isEmpty((Object)user.getEmail())) {
                this.messageService.sendInviteMessage(tenantSid, user.getEmail(), invitedUserVO.getContent(), appIds, isNeedRegister, invitedUserVO.getInviteApp(), invitedSid, invitedUserVO.getLanguage());
            } else if (!StringUtils.isEmpty((Object)user.getTelephone())) {
                this.messageService.inviteUserRegisterOrLoginSms(tenantSid, user.getTelephone(), user.getId(), invitedSid, isNeedRegister, invitedUserVO.getInviteApp());
            }
        }
        return invitedUserHistory;
    }

    public void invitedUserJoinWithTenantExist(long tenantSid, InvitedUserVO invitedUserVO, User user) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        List<InvitedUserHistory> histories = this.invitedUserHistoryCrudService.findInvitedUserHistories(tenantSid, user.getSid(), user.getEmail(), user.getTelephone());
        if (!CollectionUtils.isEmpty(histories)) {
            InvitedUserHistory history = histories.get(0);
            ArrayList needNewRoleList = new ArrayList();
            ArrayList needNewOrgList = new ArrayList();
            ArrayList needNewAppList = new ArrayList();
            try {
                if (!StringUtils.isEmpty((Object)history.getRole())) {
                    List oldRoleList = (List)objectMapper.readValue(history.getRole(), (TypeReference)new TypeReference<List<GeneralParametersVO>>(){});
                    List oldRoleIdList = oldRoleList.stream().map(GeneralParametersVO::getId).collect(Collectors.toList());
                    invitedUserVO.getRole().stream().forEach(invitedRole -> {
                        if (CollectionUtils.isEmpty((Collection)oldRoleIdList) || !oldRoleIdList.contains(invitedRole.getId())) {
                            needNewRoleList.add(invitedRole);
                        }
                    });
                    oldRoleList.addAll(needNewRoleList);
                    history.setRole(objectMapper.writeValueAsString((Object)oldRoleList));
                }
                if (!StringUtils.isEmpty((Object)history.getOrg())) {
                    List oldOrgList = (List)objectMapper.readValue(history.getOrg(), (TypeReference)new TypeReference<List<GeneralParametersVO>>(){});
                    List oldOrgIdList = oldOrgList.stream().map(GeneralParametersVO::getId).collect(Collectors.toList());
                    invitedUserVO.getOrg().stream().forEach(invitedOrg -> {
                        if (CollectionUtils.isEmpty((Collection)oldOrgIdList) || !oldOrgIdList.contains(invitedOrg.getId())) {
                            needNewOrgList.add(invitedOrg);
                        }
                    });
                    oldOrgList.addAll(needNewOrgList);
                    history.setOrg(objectMapper.writeValueAsString((Object)oldOrgList));
                }
                if (!StringUtils.isEmpty((Object)history.getApp())) {
                    List oldAppList = (List)objectMapper.readValue(history.getApp(), (TypeReference)new TypeReference<List<GeneralParametersVO>>(){});
                    List oldAppIdList = oldAppList.stream().map(GeneralParametersVO::getId).collect(Collectors.toList());
                    invitedUserVO.getApp().stream().forEach(invitedApp -> {
                        if (CollectionUtils.isEmpty((Collection)oldAppIdList) || !oldAppIdList.contains(invitedApp.getId())) {
                            needNewAppList.add(invitedApp);
                        }
                    });
                    oldAppList.addAll(needNewAppList);
                    history.setApp(objectMapper.writeValueAsString((Object)oldAppList));
                }
                this.invitedUserHistoryCrudService.update(history);
            }
            catch (IOException e) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
        }
        ArrayList<GeneralParametersVO> needNewRoleDbList = new ArrayList<GeneralParametersVO>();
        ArrayList oldRoleDbList = new ArrayList();
        ArrayList<GeneralParametersVO> needNewOrgDbList = new ArrayList<GeneralParametersVO>();
        ArrayList needNewAppDbList = new ArrayList();
        ArrayList oldOrgDbList = new ArrayList();
        List<QueryRoleResultVO> roleDBList = this.userInRoleMapper.queryUserInRoleByUser(tenantSid, user.getSid());
        List<QueryUserInOrgResultVO> orgDBList = this.userInOrgMapper.queryUserInOrgByUser(tenantSid, user.getSid());
        ArrayList<String> allGoodsCodeList = new ArrayList<String>();
        ArrayList<String> needNewGoodsCodeList = new ArrayList<String>();
        roleDBList.stream().forEach(roleDB -> {
            GeneralParametersVO temp = new GeneralParametersVO();
            temp.setSid(roleDB.getSid());
            temp.setId(roleDB.getId());
            temp.setName(roleDB.getName());
            oldRoleDbList.add(temp);
        });
        List oldRoleDbIdList = oldRoleDbList.stream().map(GeneralParametersVO::getId).collect(Collectors.toList());
        invitedUserVO.getRole().stream().forEach(invitedRole -> {
            if (CollectionUtils.isEmpty((Collection)oldRoleDbIdList) || !oldRoleDbIdList.contains(invitedRole.getId())) {
                needNewRoleDbList.add((GeneralParametersVO)invitedRole);
            }
        });
        orgDBList.stream().forEach(orgDB -> {
            GeneralParametersVO temp = new GeneralParametersVO();
            temp.setSid(orgDB.getSid());
            temp.setId(orgDB.getOrgLabel());
            temp.setName(orgDB.getOrgName());
            oldOrgDbList.add(temp);
        });
        List oldOrgDbIdList = oldOrgDbList.stream().map(GeneralParametersVO::getId).collect(Collectors.toList());
        invitedUserVO.getOrg().stream().forEach(invitedOrg -> {
            if (CollectionUtils.isEmpty((Collection)oldOrgDbIdList) || !oldOrgDbIdList.contains(invitedOrg.getId())) {
                needNewOrgDbList.add((GeneralParametersVO)invitedOrg);
            }
        });
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (null != authoredUser) {
            List<String> oldAppDbList;
            User operationUser = new User();
            operationUser.setId(authoredUser.getUserId());
            operationUser.setName(authoredUser.getUserName());
            if (!CollectionUtils.isEmpty(needNewRoleDbList)) {
                String originRoleName = oldRoleDbList.stream().map(GeneralParametersVO::getName).collect(Collectors.joining(","));
                needNewRoleDbList.addAll(oldRoleDbList);
                String destRoleName = needNewRoleDbList.stream().map(GeneralParametersVO::getName).collect(Collectors.joining(","));
                this.changeLogService.saveAssociationChangeLogs(user, operationUser, originRoleName, destRoleName);
            }
            if (!CollectionUtils.isEmpty(needNewOrgDbList)) {
                String originOrgName = oldOrgDbList.stream().map(GeneralParametersVO::getName).collect(Collectors.joining(","));
                needNewOrgDbList.addAll(oldOrgDbList);
                String destOrgName = needNewOrgDbList.stream().map(GeneralParametersVO::getName).collect(Collectors.joining(","));
                this.changeLogService.saveOrgInUserChangeLogs(user, operationUser, originOrgName, destOrgName);
            }
            List<String> finalOldAppDbList = oldAppDbList = this.cacService.queryGoodsCodeByCurrentAndUserId(user.getId(), authoredUser.getToken());
            invitedUserVO.getApp().stream().forEach(app -> {
                if (CollectionUtils.isEmpty((Collection)finalOldAppDbList) || !finalOldAppDbList.contains(app.getId())) {
                    needNewAppDbList.add(app);
                    needNewGoodsCodeList.add(app.getId());
                }
            });
            if (!CollectionUtils.isEmpty(needNewAppDbList)) {
                allGoodsCodeList.addAll(oldAppDbList);
                allGoodsCodeList.addAll(needNewGoodsCodeList);
                needNewGoodsCodeList.addAll(oldAppDbList);
                List<Sys> sysList = this.sysRepository.findByIdIn(allGoodsCodeList);
                Map<String, String> goodsMap = sysList.stream().collect(Collectors.toMap(BaseEntityWithId::getId, Sys::getName));
                StringBuilder origin = new StringBuilder();
                StringBuilder dest = new StringBuilder();
                oldAppDbList.forEach(app -> {
                    if (null != goodsMap.get(app)) {
                        origin.append((String)goodsMap.get(app)).append("(").append((String)app).append(")").append(",");
                    }
                });
                needNewGoodsCodeList.forEach(app -> {
                    if (null != goodsMap.get(app)) {
                        dest.append((String)goodsMap.get(app)).append("(").append((String)app).append(")").append(",");
                    }
                });
                if (!StringUtils.isEmpty((Object)dest.toString())) {
                    String originStr = "";
                    if (!StringUtils.isEmpty((Object)origin.toString())) {
                        originStr = origin.toString().substring(0, origin.toString().length() - 1);
                    }
                    this.changeLogService.saveAppInUserChangeLogs(user, operationUser, originStr, dest.toString().substring(0, dest.toString().length() - 1), tenant);
                }
            }
        }
        this.userInTenantOperationService.initializeUserData(tenant, user, needNewRoleDbList, needNewOrgDbList, invitedUserVO.getApp(), null, false);
    }

    @Override
    public List<GeneralParametersVO> tenantAgreeApply(Tenant tenant, InvitedUserVO userVO) {
        List<GeneralParametersVO> authorizationFailureApps = new ArrayList<GeneralParametersVO>();
        if (this.invitedUserHistoryRepository.existsById(userVO.getSid())) {
            InvitedUserHistory history = (InvitedUserHistory)this.invitedUserHistoryCrudService.findBySid(userVO.getSid());
            if (history.getTenantSid().longValue() != tenant.getSid()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_COMMON_ERROR, new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), Base64.encode((String)JsonUtils.writeValue((Object)userVO))});
            }
            if (!history.getType().booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_AGREE_ACTION_NO_AUTH);
            }
            if (!IamConstants.AcceptedStatus.ApplyWaitAgree.toString().equals(history.getAcceptedStatus())) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_AGREED_OR_REJECTED);
            }
            User user = (User)this.userCrudService.findBySid(history.getUserSid());
            if (user == null) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_NOT_EXISTED);
            }
            history.setConfirmDate(LocalDateTime.now());
            history.setAcceptedstatus(IamConstants.AcceptedStatus.Joined.toString());
            this.invitedUserHistoryCrudService.update(history);
            if (!this.userInTenantRepository.existsByTenantSidAndUserSid(tenant.getSid(), user.getSid())) {
                UserInTenant userInTenant = new UserInTenant(user.getSid(), tenant.getSid());
                userInTenant.setUserType(history.getUserType());
                if (!StringUtils.isEmpty((Object)userVO.getDueDate())) {
                    try {
                        userInTenant.setDueDate(LocalDateTimeUtil.parse((CharSequence)userVO.getDueDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    catch (Exception ex) {
                        throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
                    }
                } else if (null != history.getDueDate()) {
                    userInTenant.setDueDate(history.getDueDate());
                }
                this.userInTenantCrudService.create(userInTenant);
            }
            this.autoEOCService.userJoinTenant(userVO.getEmpId(), user, tenant.getSid(), history.getUserType(), false);
            userVO.setUserType(history.getUserType());
            authorizationFailureApps = this.userInTenantOperationService.initializeUserData(tenant, user, userVO);
            this.messageService.sendApplyJoinTenantMessage(user.getSid(), tenant.getSid());
        }
        return authorizationFailureApps;
    }

    @Override
    public void tenantRefuseApply(long tenantSid, long sid) {
        if (this.invitedUserHistoryRepository.existsById(sid)) {
            InvitedUserHistory history = (InvitedUserHistory)this.invitedUserHistoryCrudService.findBySid(sid);
            if (history.getTenantSid() != tenantSid) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_AGREE_NO_AUTH);
            }
            if (!history.getType().booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_AGREE_ACTION_NO_AUTH);
            }
            if (!IamConstants.AcceptedStatus.ApplyWaitAgree.toString().equals(history.getAcceptedStatus())) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_AGREED_OR_REJECTED);
            }
            User user = (User)this.userCrudService.findBySid(history.getUserSid());
            if (user == null) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_NOT_EXISTED);
            }
            history.setConfirmDate(LocalDateTime.now());
            history.setAcceptedstatus(IamConstants.AcceptedStatus.Refuse.toString());
            this.invitedUserHistoryCrudService.update(history);
            this.messageService.sendRefuseJoinTenantMessage(user.getSid(), tenantSid);
        }
    }

    @Override
    public void tenantRemoveApply(long tenantSid, long sid) {
        Optional history = this.invitedUserHistoryRepository.findById(sid);
        if (history.isPresent()) {
            if (((InvitedUserHistory)((Object)history.get())).getTenantSid() != tenantSid) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_AGREE_NO_AUTH);
            }
            this.invitedUserHistoryRepository.delete(history.get());
        }
    }

    @Override
    public void tenantTransferOwnerUser(AuthoredUser authoredUser, UserTenantSimpleVO userTenantSimpleVO) {
        this.userInTenantCrudService.deleteByUnionKey(authoredUser.getTenantSid(), authoredUser.getSid());
        this.cascadeDeleteEntityService.deleteRelation("userrelationwithtenant", Long.valueOf(authoredUser.getSid()), Long.valueOf(authoredUser.getTenantSid()));
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
        tenant.setOwnerUserSid(userTenantSimpleVO.getUserSid());
        this.tenantCrudService.update((BaseEntity)tenant);
        UserInTenant userInTenantTemp = this.userInTenantCrudService.findByUnionKey(authoredUser.getTenantSid(), userTenantSimpleVO.getUserSid());
        if (userInTenantTemp == null) {
            UserInTenant userInTenant = new UserInTenant();
            userInTenant.setTenantSid(authoredUser.getTenantSid());
            userInTenant.setUserSid(userTenantSimpleVO.getUserSid());
            this.userInTenantCrudService.create(userInTenant);
        }
        long adminRoleSid = this.roleCrudService.getSidByTenantAndId(authoredUser.getTenantSid(), "superadmin");
        Association associationTemp = this.userInRoleCrudService.findByUnionKey(authoredUser.getTenantSid(), userTenantSimpleVO.getUserSid(), adminRoleSid);
        if (associationTemp == null) {
            associationTemp = new Association();
            associationTemp.setTenantSid(authoredUser.getTenantSid());
            associationTemp.setUserSid(userTenantSimpleVO.getUserSid());
            associationTemp.setRoleSid(adminRoleSid);
            associationTemp.setStatus(Boolean.TRUE);
            this.userInRoleCrudService.create((BaseEntity)associationTemp);
        }
    }

    @Override
    public Long updateInvitedUserHistory(long tenantSid, Long userSid, String userEmail, String userTel, InvitedUserHistory invitedUserInfo) {
        List<InvitedUserHistory> histories = this.invitedUserHistoryCrudService.findInvitedUserHistories(tenantSid, userSid, userEmail, userTel);
        Long sid = 0L;
        if (!CollectionUtils.isEmpty(histories)) {
            InvitedUserHistory history = histories.get(0);
            if (IamConstants.AcceptedStatus.InvitedWaitAgree.toString().equals(history.getAcceptedStatus())) {
                history.setRequestDate(LocalDateTime.now());
                history.setApp(invitedUserInfo.getApp());
                history.setOrg(invitedUserInfo.getOrg());
                history.setRole(invitedUserInfo.getRole());
                history.setWechat(invitedUserInfo.getWechat());
                history.setDueDate(invitedUserInfo.getDueDate());
                this.invitedUserHistoryCrudService.update(history);
                sid = history.getSid();
            } else {
                sid = this.invitedUserHistoryCrudService.create(invitedUserInfo);
            }
        } else {
            sid = this.invitedUserHistoryCrudService.create(invitedUserInfo);
        }
        return sid;
    }

    @Override
    public void disableTenantUser(User user, AuthoredUser authoredUser) {
        this.tenantService.disableUser(authoredUser.getTenantSid(), user);
        this.remoteEocService.changeEmpStatus(authoredUser.getTenantSid(), user.getId(), false, authoredUser.getToken());
        this.cacService.deleteUser(authoredUser.getTenantId(), user.getId());
        this.userMappingService.deleteAccountMapping(authoredUser.getTenantSid(), user.getId(), Collections.singletonList(ComeFromEnum.DINGDING.getId()));
    }

    @Override
    public void enableTenantUser(User user, AuthoredUser authoredUser) {
        this.userInTenantCrudService.enable(authoredUser.getTenantSid(), user.getSid());
        this.remoteEocService.changeEmpStatus(authoredUser.getTenantSid(), user.getId(), true, authoredUser.getToken());
    }
}

