/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenant.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.entity.BaseEntityWithIdAndTenant;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.PaymentTypeEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantConfirmEnum;
import com.digiwin.dap.middleware.iam.domain.CacRecordSourceEnum;
import com.digiwin.dap.middleware.iam.domain.CommonVO;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.app.SysQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.auth.AuthDataDO;
import com.digiwin.dap.middleware.iam.domain.datapolicy.CopyDataPolicyCascadeVO;
import com.digiwin.dap.middleware.iam.domain.enumeration.StopTypeEnum;
import com.digiwin.dap.middleware.iam.domain.org.OrgCatalogCascadeVO;
import com.digiwin.dap.middleware.iam.domain.org.OrgResultVO;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.role.RoleInfo;
import com.digiwin.dap.middleware.iam.domain.role.RoleQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.CopyAppAuthVO;
import com.digiwin.dap.middleware.iam.domain.tenant.QueryWechatTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAppVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantApplicationVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuthDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuthQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuthQueryVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuthVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantBatchAuthVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCopyCountVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCopyVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantDoubleCheckVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantIdDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantMiswsDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.UserStatusResultVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserConditionVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInTenantsWithSysAuthInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.user.UserTenantSimpleVO;
import com.digiwin.dap.middleware.iam.domain.user.UserVO;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.DataPolicy;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnOrg;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnRole;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnUser;
import com.digiwin.dap.middleware.iam.entity.DevCertificationDO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.OrgAspect;
import com.digiwin.dap.middleware.iam.entity.OrgCatalog;
import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.RoleCatalog;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantCertification;
import com.digiwin.dap.middleware.iam.entity.TenantMetadata;
import com.digiwin.dap.middleware.iam.entity.TenantMetadataColumn;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInOrg;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.entity.UserMapping;
import com.digiwin.dap.middleware.iam.mapper.DataPolicyMapper;
import com.digiwin.dap.middleware.iam.mapper.OrgMapper;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInOrgMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.AssociationRepository;
import com.digiwin.dap.middleware.iam.repository.CertificationRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicyOnOrgRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicyOnRoleRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicyOnUserRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicyRepository;
import com.digiwin.dap.middleware.iam.repository.DataStatementRepository;
import com.digiwin.dap.middleware.iam.repository.OrgRepository;
import com.digiwin.dap.middleware.iam.repository.RoleCatalogRepository;
import com.digiwin.dap.middleware.iam.repository.SysInTenantRepository;
import com.digiwin.dap.middleware.iam.repository.TenantCertificationRepository;
import com.digiwin.dap.middleware.iam.repository.TenantMetadataColumnRepository;
import com.digiwin.dap.middleware.iam.repository.TenantMetadataRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.repository.UserInOrgRepository;
import com.digiwin.dap.middleware.iam.repository.UserMappingRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.auth.AppAuthCheckService;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogQueryService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCopyService;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleQueryService;
import com.digiwin.dap.middleware.iam.service.service.authorization.record.ServiceAuthorizationRecordService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.InvitedUserHistoryCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.PurchaseApplicationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserWholeService;
import com.digiwin.dap.middleware.iam.support.clean.PolicyCascadeDeleteService;
import com.digiwin.dap.middleware.iam.support.initialize.ImportDataService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.MiswsService;
import com.digiwin.dap.middleware.iam.support.remote.OmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteIamService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.CacAuth;
import com.digiwin.dap.middleware.iam.support.remote.domain.EmpInfoVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.GoodsAuthDO;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantShippingVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.cac.CountResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.SellingStrategyVO;
import com.digiwin.dap.middleware.iam.util.LanguageUtil;
import com.digiwin.dap.middleware.iam.util.SecretKeyUtil;
import com.digiwin.dap.middleware.language.entity.LanguageResource;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import com.digiwin.dap.middleware.service.CascadeDeleteEntityService;
import com.digiwin.dap.middleware.support.EnvSupport;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TenantServiceImpl
implements TenantService {
    private static final Logger log = LoggerFactory.getLogger(TenantServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantServiceImpl.class);
    private static final long TENANT_SID = 3L;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private CacService cacService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleQueryService roleQueryService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private OrgMapper orgMapper;
    @Autowired
    private OrgRepository orgRepository;
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private OrgCatalogQueryService orgCatalogQueryService;
    @Autowired
    private OrgAspectCrudService orgAspectCrudService;
    @Autowired
    private OrgTypeCrudService orgTypeCrudService;
    @Autowired
    private UserInOrgRepository userInOrgRepository;
    @Autowired
    private UserInOrgMapper userInOrgMapper;
    @Autowired
    private LanguageCrudService languageCrudService;
    @Autowired
    private RoleCatalogCrudService roleCatalogCrudService;
    @Autowired
    private RoleCatalogRepository roleCatalogRepository;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private AssociationRepository associationRepository;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private SysInTenantRepository sysInTenantRepository;
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private DataPolicyMapper dataPolicyMapper;
    @Autowired
    private DataPolicyOnRoleRepository dataPolicyOnRoleRepository;
    @Autowired
    private DataPolicyOnOrgRepository dataPolicyOnOrgRepository;
    @Autowired
    private DataPolicyOnUserRepository dataPolicyOnUserRepository;
    @Autowired
    private DataPolicyRepository dataPolicyRepository;
    @Autowired
    private DataStatementRepository dataStatementRepository;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TenantCertificationRepository tenantCertificationRepository;
    @Autowired
    private UserWholeService userWholeService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private PurchaseApplicationService purchaseApplicationService;
    @Autowired
    private OmcService omcService;
    @Autowired
    private EnvSupport envSupport;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private RemoteIamService remoteIamService;
    @Autowired
    private MiswsService miswsService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private CertificationRepository certificationRepository;
    @Autowired
    private MetadataUpdateService metadataUpdateService;
    @Autowired
    private ImportDataService importDataService;
    @Autowired
    private PolicyCopyService policyCopyService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private AppAuthCheckService appAuthCheckService;
    @Autowired
    private UserInRoleQueryService userInRoleQueryService;
    @Autowired
    private CascadeDeleteEntityService cascadeDeleteEntityService;
    @Autowired
    private ServiceAuthorizationRecordService serviceAuthorizationRecordService;
    @Autowired
    private PolicyCascadeDeleteService policyCascadeDeleteService;
    @Autowired
    private InvitedUserHistoryCrudService invitedUserHistoryCrudService;
    @Autowired
    private AuthoredUserService authoredUserService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private TenantMetadataColumnRepository tenantMetadataColumnRepository;
    @Autowired
    private TenantMetadataRepository tenantMetadataRepository;
    @Autowired
    private UserMappingRepository userMappingRepository;
    @Autowired
    private TenantQueryService tenantQueryService;

    @Override
    public void confirm(long tenantSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{tenantSid});
        }
        User user = (User)this.userCrudService.findBySid(tenant.getOwnerUserSid());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{tenant.getOwnerUserSid()});
        }
        user.setEnterprise(true);
        this.userCrudService.update((BaseEntity)user);
        tenant.setConfirm(TenantConfirmEnum.APPROVED.getValue());
        this.tenantCrudService.update((BaseEntity)tenant);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(Tenant tenant) {
        LOGGER.info("\u5220\u9664\u6307\u5b9a\u79df\u6237[{}]\uff0ctenant = {}", (Object)tenant.getId(), (Object)JsonUtils.writeValue((Object)((Object)tenant)));
        this.cacService.deleteByTenant(tenant.getId());
        this.omcService.deleteOrdersByTenant(tenant.getSid());
        this.userMapper.deleteEnterpriseUserByTenantSid(tenant.getSid());
        this.tenantCrudService.deleteById(tenant.getSid());
        if (tenant.isEoc()) {
            try {
                this.remoteEocService.deleteByTenant(tenant.getSid());
            }
            catch (Exception e) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                throw new BusinessException((ErrorHandler)I18nError.TENANT_DELETE_EXCEPTION, new Object[]{tenant.getSid()});
            }
        }
    }

    @Override
    public Long copy(Tenant sourceTenant, Tenant tenant) {
        Long tenantSid = SnowFlake.getInstance().newId();
        tenant.setSid(tenantSid);
        List<String> appIds = this.createTenantCore(sourceTenant, tenant);
        this.cacService.copyTenantAuth(sourceTenant.getId(), tenant.getId(), tenant.getName());
        List<CacAuth> cacAuths = this.cacService.getTenantsAndApps(Arrays.asList(tenant.getId().split(",")), appIds);
        CopyAppAuthVO copyAppAuthVO = new CopyAppAuthVO(tenant);
        copyAppAuthVO.setSourceTenantId(sourceTenant.getId());
        copyAppAuthVO.setType(0);
        copyAppAuthVO.setSourceId(CacRecordSourceEnum.CopyTestTenant.getId());
        copyAppAuthVO.setSourceCode(sourceTenant.getId());
        copyAppAuthVO.setAppIds(appIds);
        if (cacAuths.isEmpty()) {
            log.error("\u79df\u6237{}\u6388\u6743\u4fe1\u606f\u4e3a\u7a7a", (Object)tenant.getId());
        } else {
            appIds.forEach(a -> {
                AuthDataDO authDataDO = ((CacAuth)cacAuths.get(0)).getApps().stream().filter(c -> c.getAppId().equals(a)).findFirst().orElse(null);
                if (authDataDO != null) {
                    TenantApplicationVO authorizationVO = new TenantApplicationVO();
                    authorizationVO.setTenantId(tenant.getId());
                    authorizationVO.setTenantSid(tenant.getSid());
                    authorizationVO.setTenantName(tenant.getName());
                    authorizationVO.setCustomerServiceCode(tenant.getCustomerId());
                    authorizationVO.setPotentialCustomerId(tenant.getPotentialCustomerId());
                    authorizationVO.setExpiredTime(authDataDO.getExpiredDateTime());
                    authorizationVO.setEffectiveTime(authDataDO.getEffectiveDateTime());
                    authorizationVO.setId(authDataDO.getAppId());
                    authorizationVO.setName(authDataDO.getAppName());
                    copyAppAuthVO.getAuthorizations().add(authorizationVO);
                }
            });
            this.omcService.batchInitializeApps(copyAppAuthVO);
        }
        if (tenant.isEoc()) {
            this.remoteEocService.copyAllInfo(sourceTenant, tenant);
        }
        return tenantSid;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<String> createTenantCore(Tenant sourceTenant, Tenant tenant) {
        TenantCertification sourceTenantCertification;
        long sourceTenantSid = sourceTenant.getSid();
        tenant.setSid(0L);
        tenant.setSourceTenantSid(0L);
        tenant.setTestTenant(true);
        tenant.setOwnerUserSid(sourceTenant.getOwnerUserSid());
        long tenantSid = this.tenantCrudService.create((BaseEntity)tenant);
        Map<Long, User> userMap = this.createUser(sourceTenantSid, sourceTenant.getId(), tenantSid, tenant.getId());
        Map<Long, Org> orgMap = this.copyOrg(sourceTenantSid, tenantSid, userMap);
        Map<Long, Role> roleMap = this.copyRole(sourceTenantSid, tenantSid, orgMap, userMap, null, true, true);
        this.copyDevCertification(sourceTenantSid, tenantSid);
        if ("TW".equals(this.envProperties.getCountry()) && null != (sourceTenantCertification = this.tenantCertificationRepository.findByTenantSid(sourceTenantSid))) {
            TenantCertification tenantCertification = new TenantCertification();
            BeanUtils.copyProperties((Object)((Object)sourceTenantCertification), (Object)((Object)tenantCertification));
            tenantCertification.setTenantSid(tenant.getSid());
            tenantCertification.setSid(SnowFlake.getInstance().newId());
            EntityUtils.setCreateFields((BaseEntity)tenantCertification);
            this.tenantCertificationRepository.save((Object)tenantCertification);
        }
        List<String> appIds = this.copySys(sourceTenantSid, tenantSid, tenant.getId());
        this.policyCopyService.copyPolicy(sourceTenantSid, tenantSid, orgMap, roleMap, userMap);
        this.copyDataPolicy(sourceTenantSid, tenantSid, orgMap, roleMap, userMap);
        return appIds;
    }

    private void copyDevCertification(long sourceTenantSid, long tenantSid) {
        DevCertificationDO source = this.certificationRepository.findByTenantSid(sourceTenantSid);
        DevCertificationDO target = new DevCertificationDO();
        target.setSid(0L);
        target.setTenantSid(tenantSid);
        target.setSelfUploadImage(source.getSelfUploadImage());
        target.setPreTest(source.getPreTest());
        this.certificationRepository.save((Object)target);
    }

    @Override
    public void authApp(UserConditionVO userConditionVO) {
        List<UserInTenantsWithSysAuthInfo> userInTenants = this.userWholeService.getUsersByEmailOrTel(userConditionVO);
        UserInTenantsWithSysAuthInfo userInfo = userInTenants.get(0);
        Tenant tenant = (Tenant)this.tenantCrudService.findById(userConditionVO.getTenantId());
        if (null == tenant) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{userConditionVO.getTenantId()});
        }
        if (!this.userInTenantCrudService.existsByUnionKey(tenant.getSid(), userInfo.getUserSid())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_USER_NOT_EXIST, new Object[]{userConditionVO.getTenantId(), userInfo.getUserId()});
        }
        if (null == userConditionVO.getTenantAuth() || !userConditionVO.getTenantAuth().booleanValue()) {
            if (this.purchaseAuth(tenant, userConditionVO.getAppId(), userConditionVO.getStrategyCode(), false, userInfo.getUserId(), 0, null, null, null)) {
                SysVO sysVO = new SysVO();
                sysVO.setId(userConditionVO.getAppId());
                sysVO.setIdFirst(userConditionVO.getAppId());
                this.purchaseApplicationService.purchaseApplication(tenant, userInfo.getUserId(), sysVO, true);
            }
        } else {
            this.cacService.addAuthorization(this.envProperties.getCacUri(), tenant.getId(), userConditionVO.getAppId(), userInfo.getUserId());
        }
    }

    private boolean purchaseAuth(Tenant tenant, String appId, String strategyCode, Boolean updateTenantAuth, String authUserId, Integer userNumber, LocalDateTime effectiveTime, LocalDateTime expiredTime, String comeFrom) {
        GoodsAuthDO goodsAuthDO = new GoodsAuthDO(tenant);
        goodsAuthDO.setAction(0);
        goodsAuthDO.setUpdateTenantAuth(updateTenantAuth);
        goodsAuthDO.setAppId(appId);
        goodsAuthDO.setStrategyCode(strategyCode);
        goodsAuthDO.setEffectiveDateTime(effectiveTime);
        goodsAuthDO.setExpiredDateTime(expiredTime);
        goodsAuthDO.setUserNumber(userNumber);
        goodsAuthDO.setUserId(authUserId);
        goodsAuthDO.setSourceId(CacRecordSourceEnum.get(comeFrom).getId());
        goodsAuthDO.setMemo(StringUtils.isEmpty((Object)comeFrom) ? "\u7ed9\u6307\u5b9a\u7684\u4e2a\u4eba\u79df\u6237\u6dfb\u52a0\u6388\u6743" : CacRecordSourceEnum.get(comeFrom).getName());
        this.omcService.purchaseApp(tenant.getId(), Collections.singletonList(goodsAuthDO));
        return true;
    }

    @Override
    public TenantCopyCountVO copyTenantBasicData(TenantCopyVO vo) {
        Tenant sourceTenant = (Tenant)this.tenantCrudService.findBySid(vo.getSourceTenantSid());
        if (sourceTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.SOURCE_TENANT_NOT_EXIST, new Object[]{vo.getSourceTenantSid()});
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(vo.getTenantSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TARGET_TENANT_NOT_EXIST, new Object[]{vo.getTenantSid()});
        }
        AtomicInteger addCount = new AtomicInteger();
        AtomicInteger existCount = new AtomicInteger();
        this.copyBasicData(vo, addCount, existCount, sourceTenant, tenant);
        Boolean copyEoc = ObjectUtils.nullSafeEquals((Object)vo.getContentType(), (Object)3) || vo.getCopyTypes().contains(5);
        if (copyEoc.booleanValue()) {
            if (Boolean.FALSE.equals(tenant.isEoc())) {
                throw new BusinessException("\u76ee\u6807\u79df\u6237\u672a\u5f00\u542f\u4f01\u4e1a\u8fd0\u8425\uff0c\u5982\u8981\u590d\u5236EOC\u6570\u636e\u8bf7\u5148\u5f00\u542f\u79df\u6237\u7684\u4f01\u4e1a\u8fd0\u8425");
            }
            if (vo.getEocType() == 1 || vo.getEocType() == 2) {
                Map<String, Integer> cmap = this.remoteEocService.copyAndCompare(vo);
                addCount.addAndGet(cmap.get("addCount"));
                existCount.addAndGet(cmap.get("existCount"));
            }
        }
        return new TenantCopyCountVO(addCount.get(), existCount.get());
    }

    @Transactional(rollbackFor={Exception.class})
    public void copyBasicData(TenantCopyVO vo, AtomicInteger addCount, AtomicInteger existCount, Tenant sourceTenant, Tenant tenant) {
        Boolean copyUser = ObjectUtils.nullSafeEquals((Object)vo.getContentType(), (Object)1) || ObjectUtils.nullSafeEquals((Object)vo.getContentType(), (Object)2) || ObjectUtils.nullSafeEquals((Object)vo.getContentType(), (Object)3) || vo.getCopyTypes().contains(0);
        Boolean copyOrg = ObjectUtils.nullSafeEquals((Object)vo.getContentType(), (Object)2) || ObjectUtils.nullSafeEquals((Object)vo.getContentType(), (Object)3) || vo.getCopyTypes().contains(1);
        Boolean copyRole = ObjectUtils.nullSafeEquals((Object)vo.getContentType(), (Object)2) || ObjectUtils.nullSafeEquals((Object)vo.getContentType(), (Object)3) || vo.getCopyTypes().contains(2);
        Boolean copyTenantMapping = vo.getCopyTypes().contains(3);
        Boolean copyUserMapping = vo.getCopyTypes().contains(4);
        HashMap<Long, User> userMap = new HashMap();
        if (copyUser.booleanValue()) {
            userMap = this.addUser(sourceTenant.getSid(), sourceTenant.getId(), tenant.getSid(), tenant.getId(), addCount, existCount);
        }
        Map<Long, Org> orgMap = new HashMap<Long, Org>();
        if (copyOrg.booleanValue()) {
            orgMap = this.addOrg(sourceTenant.getSid(), tenant.getSid(), copyUser, userMap, addCount, existCount);
        }
        if (copyRole.booleanValue()) {
            this.addRole(sourceTenant.getSid(), tenant.getSid(), orgMap, copyUser, userMap, addCount, existCount);
        }
        if (copyTenantMapping.booleanValue()) {
            this.migrationTenantMapping(sourceTenant.getSid(), tenant.getSid());
        }
        if (copyUserMapping.booleanValue()) {
            this.copyUserMapping(sourceTenant.getSid(), tenant.getSid());
        }
    }

    private void migrationTenantMapping(Long sourceTenantSid, Long targetTenantSid) {
        List<TenantMetadataColumn> columns = this.tenantMetadataColumnRepository.findByCatalogId("corpId");
        if (CollectionUtils.isEmpty(columns)) {
            return;
        }
        List<TenantMetadata> sourceMetadataList = this.tenantMetadataRepository.findByTenantSidAndColumnSidIn(sourceTenantSid, columns.stream().map(BaseEntity::getSid).collect(Collectors.toList()));
        List<TenantMetadata> existedMetadataList = this.tenantMetadataRepository.findByTenantSidAndColumnSidIn(targetTenantSid, columns.stream().map(BaseEntity::getSid).collect(Collectors.toList()));
        sourceMetadataList.forEach(m -> {
            if (existedMetadataList.stream().anyMatch(e -> ObjectUtils.nullSafeEquals((Object)m.getColumnSid(), (Object)e.getColumnSid()))) {
                LOGGER.warn("\u76ee\u6807\u79df\u6237{}\u5df2\u7ecf\u5b58\u5728column{}\u7684\u4fe1\u606f\uff0c\u4e0d\u518d\u8fc1\u79fb", (Object)targetTenantSid, (Object)m.getColumnSid());
            } else {
                m.setTenantSid(targetTenantSid);
                EntityUtils.setModifyFields((BaseEntity)m);
                this.tenantMetadataRepository.save(m);
            }
        });
    }

    private void copyUserMapping(Long sourceTenantSid, Long targetTenantSid) {
        List sourceUserMappingList = this.userMappingRepository.findByTenantSid(sourceTenantSid);
        List existedUserMappingList = this.userMappingRepository.findByTenantSid(targetTenantSid);
        ArrayList addUserMappingList = new ArrayList();
        sourceUserMappingList.forEach(u -> {
            UserMapping existed = existedUserMappingList.stream().filter(e -> ObjectUtils.nullSafeEquals((Object)e.getUserSid(), (Object)u.getUserSid()) && ObjectUtils.nullSafeEquals((Object)e.getAppId(), (Object)u.getAppId()) && ObjectUtils.nullSafeEquals((Object)e.getAccount(), (Object)u.getAccount())).findFirst().orElse(null);
            if (null == existed) {
                UserMapping userMapping = new UserMapping();
                BeanUtils.copyProperties((Object)u, (Object)((Object)userMapping));
                userMapping.setSid(SnowFlake.getInstance().newId());
                userMapping.setTenantSid(targetTenantSid);
                EntityUtils.setCreateFields((BaseEntity)userMapping);
                addUserMappingList.add(userMapping);
            } else {
                LOGGER.warn("\u76ee\u6807\u79df\u6237{}\u4e0b\u6620\u5c04\u6570\u636e\u5df2\u7ecf\u5b58\u5728{}", (Object)targetTenantSid, (Object)JsonUtils.objToJson((Object)((Object)existed)));
            }
        });
        this.userMappingRepository.saveAll(addUserMappingList);
    }

    private Map<Long, User> addUser(Long sourceTenantSid, String sourceTenantId, Long tenantSid, String tenantId, AtomicInteger addCount, AtomicInteger existCount) {
        HashMap<Long, User> userMap = new HashMap<Long, User>();
        List<UserVO> allSourceUsers = this.userMapper.getAllVisUserInTenant(sourceTenantSid);
        List<UserVO> allUsers = this.userMapper.getAllUserInTenant(tenantSid);
        List userIds = allUsers.stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
        ArrayList realAddUsers = new ArrayList();
        ArrayList userInTenants = new ArrayList();
        ArrayList<UserMetadataVO> userMetadataVOList = new ArrayList<UserMetadataVO>();
        allSourceUsers.forEach(su -> {
            if (su.getType() == 0) {
                if (!userIds.contains(su.getId())) {
                    UserInTenant userInTenant = new UserInTenant((long)tenantSid, (UserVO)((Object)su));
                    EntityUtils.setCreateFields((BaseEntity)userInTenant);
                    userInTenants.add(userInTenant);
                    addCount.getAndIncrement();
                }
            } else {
                User user = new User();
                BeanUtils.copyProperties((Object)su, (Object)((Object)user));
                user.setId(user.getId().replace(String.format("%s$", sourceTenantId), String.format("%s$", tenantId)));
                userMap.put(su.getSid(), user);
                String userIdOfDestTenant = su.getId().replace(String.format("%s$", sourceTenantId), String.format("%s$", tenantId));
                if (!userIds.contains(userIdOfDestTenant)) {
                    user.setSid(SnowFlake.getInstance().newId());
                    EntityUtils.setCreateFields((BaseEntity)user);
                    realAddUsers.add(user);
                    UserInTenant userInTenant = new UserInTenant((long)tenantSid, (UserVO)((Object)su));
                    userInTenant.setUserSid(user.getSid());
                    EntityUtils.setCreateFields((BaseEntity)userInTenant);
                    userInTenants.add(userInTenant);
                    addCount.getAndIncrement();
                    UserMetadataVO userMetadataVO = new UserMetadataVO("basic", "dapAcceptLanguage", LanguageUtil.getDefaultLanguage(this.envProperties.getCountry()), 0L, user.getSid());
                    userMetadataVOList.add(userMetadataVO);
                } else {
                    allUsers.stream().filter(a -> a.getId().equals(userIdOfDestTenant)).findFirst().ifPresent(b -> user.setSid(b.getSid()));
                }
            }
        });
        this.userRepository.saveAll(realAddUsers);
        this.userInTenantCrudService.saveAll(userInTenants);
        this.metadataUpdateService.batchAddMetadata("basic", "dapAcceptLanguage", true, userMetadataVOList);
        existCount.set(allSourceUsers.size() - addCount.get());
        return userMap;
    }

    private Map<Long, Org> addOrg(Long sourceTenantSid, Long tenantSid, Boolean copyUser, Map<Long, User> userMap, AtomicInteger addCount, AtomicInteger existCount) {
        List<OrgCatalogCascadeVO> sourceOrgVO = this.orgCatalogQueryService.getOrgCatalogCascades(sourceTenantSid);
        OrgCatalogCascadeVO sourceCatalog = sourceOrgVO.get(0);
        OrgAspect sourceAspect = sourceCatalog.getOrgAspects().get(0);
        List<OrgType> sourceOrgTypes = sourceCatalog.getOrgTypes();
        List<OrgCatalogCascadeVO> orgCatalogs = this.orgCatalogQueryService.getOrgCatalogCascades(tenantSid);
        OrgCatalogCascadeVO catalog = orgCatalogs.get(0);
        OrgAspect aspect = catalog.getOrgAspects().get(0);
        List<OrgType> orgTypes = catalog.getOrgTypes();
        List typeIds = orgTypes.stream().map(OrgType::getId).collect(Collectors.toList());
        HashMap orgTypeMap = new HashMap();
        ArrayList languageResourceList = new ArrayList();
        List dataSids = sourceOrgTypes.stream().map(BaseEntity::getSid).collect(Collectors.toList());
        List orgTypeLanguageResources = this.languageCrudService.findByDataSids(dataSids);
        sourceOrgTypes.forEach(t -> {
            if (!typeIds.contains(t.getId())) {
                OrgType orgType = new OrgType();
                BeanUtils.copyProperties((Object)t, (Object)((Object)orgType));
                orgType.setSid(SnowFlake.getInstance().newId());
                orgType.setTenantSid(tenantSid);
                orgType.setOrgCatalogSid(catalog.getSid());
                orgTypeMap.put(t.getSid(), orgType);
                orgTypeLanguageResources.stream().filter(m -> t.getSid() == m.getDataSid()).collect(Collectors.toList()).forEach(m -> {
                    LanguageResource languageResource = new LanguageResource();
                    BeanUtils.copyProperties((Object)m, (Object)languageResource);
                    languageResource.setDataSid(orgType.getSid());
                    languageResource.setSid(0L);
                    EntityUtils.setCreateFields((BaseEntity)languageResource);
                    languageResourceList.add(languageResource);
                });
            }
        });
        this.orgTypeCrudService.saveAll(orgTypeMap.values());
        this.languageCrudService.saveAll(languageResourceList);
        List<Org> srootOrgs = this.orgRepository.findRootOrgsInTenant(sourceTenantSid);
        List<Org> rootOrgs = this.orgRepository.findRootOrgsInTenant(tenantSid);
        List rootOrgIds = rootOrgs.stream().map(BaseEntityWithIdAndTenant::getId).collect(Collectors.toList());
        ArrayList<Org> addOrgs = new ArrayList<Org>();
        ArrayList<Long> childOrgSids = new ArrayList<Long>();
        srootOrgs.forEach(o -> {
            if (!rootOrgIds.contains(o.getId())) {
                List<OrgResultVO> childOrgs = this.orgMapper.findChildOrgsById(sourceCatalog.getSid(), sourceAspect.getSid(), sourceTenantSid, o.getId());
                addOrgs.add((Org)((Object)o));
                if (!childOrgs.isEmpty()) {
                    childOrgSids.addAll(childOrgs.stream().map(OrgResultVO::getSid).collect(Collectors.toList()));
                }
            }
        });
        if (!childOrgSids.isEmpty()) {
            List<Org> childAddOrgs = this.orgRepository.findBySidIn(childOrgSids);
            addOrgs.addAll(childAddOrgs);
        }
        HashMap<Long, Org> orgMap = new HashMap<Long, Org>();
        addOrgs.forEach(o -> {
            Org org = new Org();
            BeanUtils.copyProperties((Object)o, (Object)((Object)org));
            org.setSid(SnowFlake.getInstance().newId());
            org.setTenantSid(tenantSid);
            if (orgTypeMap.keySet().contains(org.getOrgTypeSid())) {
                org.setOrgTypeSid(((OrgType)((Object)((Object)orgTypeMap.get(org.getOrgTypeSid())))).getSid());
            } else {
                OrgType type = sourceOrgTypes.stream().filter(t -> t.getSid() == org.getOrgTypeSid()).findFirst().orElse(null);
                OrgType sameType = orgTypes.stream().filter(t -> t.getId().equals(type.getId())).findFirst().orElse(null);
                org.setOrgTypeSid(sameType.getSid());
            }
            org.setOrgAspectSid(aspect.getSid());
            if (o.getParentSid() != 0L) {
                Org parentOrg = (Org)((Object)((Object)orgMap.get(o.getParentSid())));
                if (parentOrg != null) {
                    org.setParentSid(parentOrg.getSid());
                } else {
                    throw new BusinessException((ErrorHandler)I18nError.COPY_ORG_PARENT_NOT_EXIST, new Object[]{org.getId(), o.getParentSid()});
                }
            }
            EntityUtils.setCreateFields((BaseEntity)org);
            orgMap.put(o.getSid(), org);
        });
        this.orgCrudService.saveAll(orgMap.values());
        List<Org> sallOrgs = this.orgRepository.findByTenantSid(sourceTenantSid);
        addCount.addAndGet(addOrgs.size());
        existCount.addAndGet(sallOrgs.size() - addOrgs.size());
        List<Org> destOrgs = this.orgRepository.findByTenantSid(tenantSid);
        for (Org sourceOrg : sallOrgs) {
            if (orgMap.containsKey(sourceOrg.getSid())) continue;
            destOrgs.stream().filter(a -> a.getUri().equals(sourceOrg.getUri())).findFirst().ifPresent(destOrg -> orgMap.put(sourceOrg.getSid(), (Org)((Object)destOrg)));
        }
        if (ObjectUtils.nullSafeEquals((Object)Boolean.FALSE, (Object)copyUser)) {
            LOGGER.warn("\u52fe\u9009\u4e86\u7528\u6237\u7fa4\u7ec4\uff0c\u4f46\u672a\u52fe\u9009\u7528\u6237\uff0c\u7528\u6237\u7fa4\u7ec4\u4fe1\u606f\u9ed8\u8ba4\u4e0d\u4f1a\u590d\u5236");
            return orgMap;
        }
        List<QueryUserInOrgResultVO> userInOrgs = this.userInOrgMapper.findUserOrgs(sourceTenantSid);
        List<QueryUserInOrgResultVO> destUserInOrgs = this.userInOrgMapper.findUserOrgs(tenantSid);
        ArrayList userInOrgList = new ArrayList();
        userInOrgs.forEach(sourceUr -> {
            if (orgMap.containsKey(sourceUr.getOrgSid())) {
                Org destOrg = (Org)((Object)((Object)orgMap.get(sourceUr.getOrgSid())));
                if (destUserInOrgs.stream().noneMatch(aDest -> TenantServiceImpl.orgRelationExist(sourceUr, aDest))) {
                    UserInOrg userInOrg = new UserInOrg();
                    BeanUtils.copyProperties((Object)sourceUr, (Object)((Object)userInOrg));
                    userInOrg.setSid(0L);
                    EntityUtils.setCreateFields((BaseEntity)userInOrg);
                    userInOrg.setOrgSid(destOrg.getSid());
                    User user = (User)((Object)((Object)userMap.get(sourceUr.getUserSid())));
                    if (null != user) {
                        userInOrg.setUserSid(user.getSid());
                    }
                    userInOrgList.add(userInOrg);
                }
            }
        });
        this.userInOrgRepository.saveAll(userInOrgList);
        return orgMap;
    }

    private static boolean orgRelationExist(QueryUserInOrgResultVO source, QueryUserInOrgResultVO destination) {
        if (!source.getOrgLabel().equals(destination.getOrgLabel())) {
            return false;
        }
        if (!source.getUserType().equals(destination.getUserType())) {
            return false;
        }
        if (source.getUserType().equals(1)) {
            return User.getIdOfEnterpriseUser(source.getUserId()).equals(User.getIdOfEnterpriseUser(destination.getUserId()));
        }
        return destination.getUserSid() == source.getUserSid();
    }

    private Map<Long, Role> addRole(Long sourceTenantSid, Long tenantSid, Map<Long, Org> orgMap, Boolean copyUser, Map<Long, User> userMap, AtomicInteger addCount, AtomicInteger existCount) {
        List<RoleCatalog> sourceCatalog = this.roleCatalogCrudService.findByTenantSid(sourceTenantSid);
        List<RoleCatalog> catalog = this.roleCatalogCrudService.findByTenantSid(tenantSid);
        List logIds = catalog.stream().map(RoleCatalog::getId).collect(Collectors.toList());
        ArrayList roleCatalogList = new ArrayList();
        sourceCatalog.forEach(r -> {
            if (!logIds.contains(r.getId())) {
                RoleCatalog roleCatalog = new RoleCatalog();
                BeanUtils.copyProperties((Object)r, (Object)((Object)roleCatalog));
                roleCatalog.setTenantSid(tenantSid);
                roleCatalog.setSid(SnowFlake.getInstance().newId());
                EntityUtils.setCreateFields((BaseEntity)roleCatalog);
                roleCatalogList.add(roleCatalog);
            }
        });
        this.roleCatalogRepository.saveAll(roleCatalogList);
        List<RoleQueryResultVO> sourceRoles = this.roleQueryService.getRoleQueryResultVosByTenant(sourceTenantSid);
        List sourceRoleSids = sourceRoles.stream().map(RoleQueryResultVO::getSid).collect(Collectors.toList());
        List<RoleQueryResultVO> roles = this.roleQueryService.getRoleQueryResultVosByTenant(tenantSid);
        List roleIds = roles.stream().map(RoleQueryResultVO::getId).collect(Collectors.toList());
        HashMap<Long, Role> roleMap = new HashMap<Long, Role>();
        List roleLanguageResources = sourceRoleSids.isEmpty() ? new ArrayList() : this.languageCrudService.findByDataSids(sourceRoleSids);
        ArrayList languageResourceList = new ArrayList();
        if (orgMap.isEmpty() && sourceRoles.stream().anyMatch(r -> null != r.getOrg())) {
            List<Org> sourceOrgs = this.orgRepository.findByTenantSid(sourceTenantSid);
            List<Org> existedOrgs = this.orgRepository.findByTenantSid(tenantSid);
            sourceOrgs.forEach(s -> {
                Org existedOrg = existedOrgs.stream().filter(e -> ObjectUtils.nullSafeEquals((Object)s.getUri(), (Object)e.getUri())).findFirst().orElse(null);
                if (null == existedOrg) {
                    LOGGER.error("\u590d\u5236\u89d2\u8272\u65f6\uff0c\u89d2\u8272\u4e0a\u5173\u8054\u4e86\u7ec4\u7ec7\u4fe1\u606f\uff0c\u4f46\u662f\u6ca1\u6709\u52fe\u9009\u590d\u5236\u7ec4\u7ec7\uff0c\u5bfc\u81f4\u89d2\u8272\u5339\u914d\u7ec4\u7ec7\u5931\u8d25\uff0c\u672a\u5339\u914d\u5230\u7ec4\u7ec7\u4fe1\u606f{}", (Object)JsonUtils.objToJson((Object)s));
                } else {
                    orgMap.put(s.getSid(), existedOrg);
                }
            });
        }
        sourceRoles.forEach(r -> {
            if (!roleIds.contains(r.getId())) {
                Role role = new Role();
                BeanUtils.copyProperties((Object)r, (Object)((Object)role));
                role.setTenantSid(tenantSid);
                role.setSid(SnowFlake.getInstance().newId());
                TenantServiceImpl.checkOrgExist(orgMap, r, role);
                RoleCatalog roleCatalog = roleCatalogList.stream().filter(rc -> r.getCatalogId().equals(rc.getId())).findFirst().orElse(null);
                if (null != roleCatalog) {
                    role.setRoleCatalogSid(roleCatalog.getSid());
                } else {
                    RoleCatalog ncl = catalog.stream().filter(o -> r.getCatalogId().equals(o.getId())).findFirst().orElse(null);
                    role.setRoleCatalogSid(ncl.getSid());
                }
                roleMap.put(r.getSid(), role);
                addCount.getAndIncrement();
                roleLanguageResources.stream().filter(m -> r.getSid() == m.getDataSid()).collect(Collectors.toList()).forEach(m -> {
                    LanguageResource languageResource = new LanguageResource();
                    BeanUtils.copyProperties((Object)m, (Object)languageResource);
                    languageResource.setDataSid(role.getSid());
                    languageResource.setSid(0L);
                    EntityUtils.setCreateFields((BaseEntity)languageResource);
                    languageResourceList.add(languageResource);
                });
            } else {
                existCount.getAndIncrement();
            }
        });
        this.roleCrudService.saveAll(roleMap.values());
        this.languageCrudService.saveAll(languageResourceList);
        if (ObjectUtils.nullSafeEquals((Object)Boolean.FALSE, (Object)copyUser)) {
            LOGGER.warn("\u3010\u590d\u5236\u79df\u6237\u57fa\u672c\u4fe1\u606f\u3011\u52fe\u9009\u4e86\u89d2\u8272\uff0c\u4f46\u672a\u52fe\u9009\u7528\u6237\uff0c\u7528\u6237\u89d2\u8272\u4fe1\u606f\u9ed8\u8ba4\u4e0d\u4f1a\u590d\u5236");
            return roleMap;
        }
        List<QueryRoleResultVO> userInRoles = this.userInRoleMapper.findUserRoles(sourceTenantSid);
        List<QueryRoleResultVO> destUserInRoles = this.userInRoleMapper.findUserRoles(tenantSid);
        ArrayList associations = new ArrayList();
        userInRoles.forEach(ur -> {
            if (destUserInRoles.stream().noneMatch(aDest -> TenantServiceImpl.roleRelationExist(ur, aDest))) {
                Association association = new Association();
                BeanUtils.copyProperties((Object)ur, (Object)((Object)association));
                association.setSid(0L);
                association.setTenantSid(tenantSid);
                EntityUtils.setCreateFields((BaseEntity)association);
                Role role = (Role)((Object)((Object)roleMap.get(ur.getSid())));
                if (null != role) {
                    association.setRoleSid(role.getSid());
                } else {
                    RoleQueryResultVO srole = sourceRoles.stream().filter(o -> ur.getSid() == o.getSid()).findFirst().orElse(null);
                    if (null != srole) {
                        RoleQueryResultVO trole = roles.stream().filter(o -> srole.getId().equals(o.getId())).findFirst().orElse(null);
                        association.setRoleSid(trole.getSid());
                    } else {
                        LOGGER.error("\u3010\u590d\u5236\u79df\u6237\u57fa\u672c\u4fe1\u606f\u3011\u590d\u5236\u7684\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtils.objToJson((Object)ur));
                        return;
                    }
                }
                User user = (User)((Object)((Object)userMap.get(ur.getUserSid())));
                if (null != user) {
                    association.setUserSid(user.getSid());
                }
                associations.add(association);
            }
        });
        this.associationRepository.saveAll(associations);
        return roleMap;
    }

    private static boolean roleRelationExist(QueryRoleResultVO source, QueryRoleResultVO destination) {
        if (!destination.getId().equals(source.getId())) {
            return false;
        }
        if (!source.getType().equals(destination.getType())) {
            return false;
        }
        if (source.getType().equals(1)) {
            return User.getIdOfEnterpriseUser(source.getUserId()).equals(User.getIdOfEnterpriseUser(destination.getUserId()));
        }
        return destination.getUserSid().equals(source.getUserSid());
    }

    private Map<Long, User> createUser(Long sourceTenantSid, String sourceTenantId, Long tenantSid, String tenantId) {
        HashMap<Long, User> userMap = new HashMap<Long, User>();
        List<UserVO> allUsers = this.userMapper.getAllUserInTenant(sourceTenantSid);
        ArrayList<UserInTenant> userInTenants = new ArrayList<UserInTenant>(allUsers.size());
        ArrayList enterPriseUsers = new ArrayList();
        ArrayList<UserMetadataVO> userMetadataVOList = new ArrayList<UserMetadataVO>();
        allUsers.stream().filter(u -> 1 == u.getType()).collect(Collectors.toList()).forEach(u -> {
            User user = new User();
            BeanUtils.copyProperties((Object)u, (Object)((Object)user));
            String userId = user.getId().replace(String.format("%s$", sourceTenantId), String.format("%s$", tenantId));
            user.setId(userId);
            user.setSid(SnowFlake.getInstance().newId());
            user.setDisabled(true);
            user.setVisible(true);
            EntityUtils.setCreateFields((BaseEntity)user);
            enterPriseUsers.add(user);
            userMap.put(u.getSid(), user);
            UserInTenant userInTenant = new UserInTenant((long)tenantSid, (UserVO)((Object)u));
            userInTenant.setUserSid(user.getSid());
            EntityUtils.setCreateFields((BaseEntity)userInTenant);
            userInTenants.add(userInTenant);
            UserMetadataVO userMetadataVO = new UserMetadataVO("basic", "dapAcceptLanguage", LanguageUtil.getDefaultLanguage(this.envProperties.getCountry()), 0L, user.getSid());
            userMetadataVOList.add(userMetadataVO);
        });
        this.userRepository.saveAll(enterPriseUsers);
        allUsers.stream().filter(u -> 0 == u.getType()).collect(Collectors.toList()).forEach(u -> {
            UserInTenant userInTenant = new UserInTenant((long)tenantSid, (UserVO)((Object)u));
            EntityUtils.setCreateFields((BaseEntity)userInTenant);
            userInTenants.add(userInTenant);
        });
        List userSids = userInTenants.stream().map(UserInTenant::getUserSid).collect(Collectors.toList());
        if (!userSids.isEmpty() && !userSids.contains(UserUtils.getUserSid())) {
            UserInTenant createUser = new UserInTenant();
            createUser.setTenantSid(tenantSid);
            createUser.setUserSid(UserUtils.getUserSid());
            EntityUtils.setCreateFields((BaseEntity)createUser);
            userInTenants.add(createUser);
        }
        this.userInTenantCrudService.saveAll(userInTenants);
        this.metadataUpdateService.batchAddMetadata("basic", "dapAcceptLanguage", true, userMetadataVOList);
        return userMap;
    }

    private Map<Long, Org> copyOrg(Long sourceTenantSid, Long tenantSid, Map<Long, User> userMap) {
        List<OrgCatalogCascadeVO> orgCatalogs = this.orgCatalogQueryService.getOrgCatalogCascades(sourceTenantSid);
        HashMap orgCatalogMap = new HashMap();
        HashMap orgAspectMap = new HashMap();
        HashMap orgTypeMap = new HashMap();
        ArrayList languageResourceList = new ArrayList();
        orgCatalogs.forEach(o -> {
            OrgCatalog orgCatalog = new OrgCatalog();
            BeanUtils.copyProperties((Object)o, (Object)((Object)orgCatalog));
            orgCatalog.setTenantSid(tenantSid);
            orgCatalog.setSid(SnowFlake.getInstance().newId());
            orgCatalogMap.put(o.getSid(), orgCatalog);
            o.getOrgAspects().forEach(a -> {
                OrgAspect orgAspect = new OrgAspect();
                BeanUtils.copyProperties((Object)a, (Object)((Object)orgAspect));
                orgAspect.setSid(SnowFlake.getInstance().newId());
                orgAspect.setTenantSid(tenantSid);
                orgAspect.setOrgCatalogSid(orgCatalog.getSid());
                orgAspectMap.put(a.getSid(), orgAspect);
            });
            List dataSids = o.getOrgTypes().stream().map(BaseEntity::getSid).collect(Collectors.toList());
            List orgTypeLanguageResources = !dataSids.isEmpty() ? this.languageCrudService.findByDataSids(dataSids) : new ArrayList();
            o.getOrgTypes().forEach(t -> {
                OrgType orgType = new OrgType();
                BeanUtils.copyProperties((Object)t, (Object)((Object)orgType));
                orgType.setSid(SnowFlake.getInstance().newId());
                orgType.setTenantSid(tenantSid);
                orgType.setOrgCatalogSid(orgCatalog.getSid());
                if (0L != t.getParentSid()) {
                    OrgType parentOrgType = (OrgType)((Object)((Object)((Object)orgTypeMap.get(t.getParentSid()))));
                    if (null != parentOrgType) {
                        orgType.setParentSid(parentOrgType.getSid());
                    } else {
                        throw new BusinessException((ErrorHandler)I18nError.COPY_ORG_PARENT_TAG_NOT_EXIST, new Object[]{orgType.getId(), t.getParentSid()});
                    }
                }
                orgTypeMap.put(t.getSid(), orgType);
                orgTypeLanguageResources.stream().filter(m -> t.getSid() == m.getDataSid()).collect(Collectors.toList()).forEach(m -> {
                    LanguageResource languageResource = new LanguageResource();
                    BeanUtils.copyProperties((Object)m, (Object)languageResource);
                    languageResource.setDataSid(orgType.getSid());
                    languageResource.setSid(0L);
                    EntityUtils.setCreateFields((BaseEntity)languageResource);
                    languageResourceList.add(languageResource);
                });
            });
        });
        this.orgCatalogCrudService.saveAll(orgCatalogMap.values());
        this.orgAspectCrudService.saveAll(orgAspectMap.values());
        this.orgTypeCrudService.saveAll(orgTypeMap.values());
        this.languageCrudService.saveAll(languageResourceList);
        List<Org> orgs = this.orgRepository.findByTenantSid(sourceTenantSid);
        ArrayList<Object> sortOrgs = new ArrayList<Object>(orgs.size());
        List parentOrgs = orgs.stream().filter(o -> 0L == o.getParentSid()).collect(Collectors.toList());
        sortOrgs.addAll(parentOrgs);
        orgs.removeAll(sortOrgs);
        sortOrgs.addAll(orgs);
        HashMap<Long, Org> orgMap = new HashMap<Long, Org>();
        sortOrgs.forEach(o -> {
            Org org = new Org();
            BeanUtils.copyProperties((Object)o, (Object)((Object)org));
            org.setSid(SnowFlake.getInstance().newId());
            org.setTenantSid(tenantSid);
            if (0L != o.getOrgTypeSid()) {
                OrgType orgType = (OrgType)((Object)((Object)orgTypeMap.get(org.getOrgTypeSid())));
                if (null != orgType) {
                    org.setOrgTypeSid(orgType.getSid());
                } else {
                    throw new BusinessException((ErrorHandler)I18nError.COPY_ORG_TAG_NOT_EXIST, new Object[]{org.getOrgTypeSid()});
                }
            }
            if (0L != o.getOrgAspectSid()) {
                OrgAspect orgAspect = (OrgAspect)((Object)((Object)orgAspectMap.get(o.getOrgAspectSid())));
                if (null != orgAspect) {
                    org.setOrgAspectSid(orgAspect.getSid());
                } else {
                    throw new BusinessException((ErrorHandler)I18nError.COPY_ORG_ORG_TREE_NOT_EXIST, new Object[]{org.getOrgAspectSid()});
                }
            }
            if (0L != o.getParentSid()) {
                Org parentOrg = (Org)((Object)((Object)orgMap.get(o.getParentSid())));
                if (null != parentOrg) {
                    org.setParentSid(parentOrg.getSid());
                } else {
                    throw new BusinessException((ErrorHandler)I18nError.COPY_ORG_PARENT_ORG_NOT_EXIST, new Object[]{org.getId(), o.getParentSid()});
                }
            }
            orgMap.put(o.getSid(), org);
        });
        this.orgCrudService.saveAll(orgMap.values());
        List<QueryUserInOrgResultVO> userInOrgs = this.userInOrgMapper.findUserOrgs(sourceTenantSid);
        ArrayList userInOrgList = new ArrayList();
        userInOrgs.forEach(ur -> {
            UserInOrg userInOrg = new UserInOrg();
            BeanUtils.copyProperties((Object)ur, (Object)((Object)userInOrg));
            userInOrg.setSid(0L);
            EntityUtils.setCreateFields((BaseEntity)userInOrg);
            Org org = (Org)((Object)((Object)orgMap.get(ur.getOrgSid())));
            if (null == org) {
                throw new BusinessException((ErrorHandler)I18nError.COPY_ORG_PARENT_ORG_NOT_EXIST, new Object[]{ur.getUserId(), ur.getOrgLabel()});
            }
            userInOrg.setOrgSid(org.getSid());
            User user = (User)((Object)((Object)userMap.get(ur.getUserSid())));
            if (null != user) {
                userInOrg.setUserSid(user.getSid());
            }
            userInOrgList.add(userInOrg);
        });
        this.userInOrgRepository.saveAll(userInOrgList);
        return orgMap;
    }

    @Override
    public Map<Long, Role> copyRole(Long sourceTenantSid, Long tenantSid, Map<Long, Org> orgMap, Map<Long, User> userMap, List<String> roleIdFilter, boolean checkOrgExist, boolean copyUserInRole) {
        List<RoleCatalog> roleCatalogList = this.copyRoleCatalog(sourceTenantSid, tenantSid);
        List<RoleQueryResultVO> roles = this.roleQueryService.getRoleQueryResultVosByTenant(sourceTenantSid);
        List<RoleQueryResultVO> existRoles = this.roleQueryService.getRoleQueryResultVosByTenant(tenantSid);
        List roleSids = roles.stream().map(RoleQueryResultVO::getSid).collect(Collectors.toList());
        HashMap<Long, Role> roleMap = new HashMap<Long, Role>();
        List roleLanguageResources = roleSids.isEmpty() ? new ArrayList() : this.languageCrudService.findByDataSids(roleSids);
        ArrayList languageResourceList = new ArrayList();
        if (!CollectionUtils.isEmpty(roleIdFilter)) {
            roles = roles.stream().filter(a -> roleIdFilter.contains(a.getId())).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(existRoles)) {
            roles = roles.stream().filter(a -> existRoles.stream().noneMatch(b -> a.getId().equals(b.getId()))).collect(Collectors.toList());
        }
        roles.forEach(r -> {
            Role role = new Role();
            BeanUtils.copyProperties((Object)r, (Object)((Object)role));
            role.setTenantSid(tenantSid);
            role.setSid(SnowFlake.getInstance().newId());
            if (checkOrgExist) {
                TenantServiceImpl.checkOrgExist(orgMap, r, role);
            }
            if (!StringUtils.isEmpty((Object)r.getCatalogId())) {
                RoleCatalog roleCatalog = roleCatalogList.stream().filter(rc -> r.getCatalogId().equals(rc.getId())).findFirst().orElse(null);
                if (null != roleCatalog) {
                    role.setRoleCatalogSid(roleCatalog.getSid());
                } else {
                    throw new BusinessException((ErrorHandler)I18nError.COPY_ROLE_ROLE_CATEGORY_NOT_EXIST, new Object[]{r.getId(), r.getCatalogId()});
                }
            }
            roleMap.put(r.getSid(), role);
            roleLanguageResources.stream().filter(m -> r.getSid() == m.getDataSid()).collect(Collectors.toList()).forEach(m -> {
                LanguageResource languageResource = new LanguageResource();
                BeanUtils.copyProperties((Object)m, (Object)languageResource);
                languageResource.setDataSid(role.getSid());
                languageResource.setSid(0L);
                EntityUtils.setCreateFields((BaseEntity)languageResource);
                languageResourceList.add(languageResource);
            });
        });
        this.roleCrudService.saveAll(roleMap.values());
        this.languageCrudService.saveAll(languageResourceList);
        if (copyUserInRole) {
            this.copyUserInRole(sourceTenantSid, tenantSid, userMap, roleMap);
        }
        return roleMap;
    }

    private static void checkOrgExist(Map<Long, Org> orgMap, RoleQueryResultVO r, Role role) {
        if (null != r.getOrg() && r.getOrg().getSid() > 0L) {
            Org org = orgMap.get(r.getOrg().getSid());
            if (null != org) {
                role.setOrgSid(org.getSid());
                role.setUri(org.getUri() + ":" + role.getId());
            } else {
                throw new BusinessException((ErrorHandler)I18nError.COPY_ROLE_ORG_NOT_EXIST, new Object[]{r.getId(), r.getOrg().getSid()});
            }
        }
    }

    private void copyUserInRole(Long sourceTenantSid, Long tenantSid, Map<Long, User> userMap, Map<Long, Role> roleMap) {
        List<QueryRoleResultVO> userInRoles = this.userInRoleMapper.findUserRoles(sourceTenantSid);
        ArrayList<Association> associations = new ArrayList<Association>();
        userInRoles.forEach(ur -> {
            Association association = new Association();
            BeanUtils.copyProperties((Object)ur, (Object)((Object)association));
            association.setTenantSid(tenantSid);
            association.setSid(0L);
            EntityUtils.setCreateFields((BaseEntity)association);
            Role role = (Role)((Object)((Object)roleMap.get(ur.getSid())));
            if (null == role) {
                throw new BusinessException((ErrorHandler)I18nError.COPY_ROLE_USER_NOT_EXIST, new Object[]{ur.getUserSid(), ur.getId()});
            }
            association.setRoleSid(role.getSid());
            User user = (User)((Object)((Object)userMap.get(ur.getUserSid())));
            if (null != user) {
                association.setUserSid(user.getSid());
            }
            associations.add(association);
        });
        Role superAdminRole = roleMap.values().stream().filter(r -> "superadmin".equalsIgnoreCase(r.getId())).findFirst().orElse(null);
        if (null == superAdminRole) {
            throw new BusinessException((ErrorHandler)I18nError.SUPER_ADMIN_NOT_EXIST);
        }
        Association association = associations.stream().filter(u -> UserUtils.getUserSid() == u.getUserSid() && superAdminRole.getSid() == u.getRoleSid()).findFirst().orElse(null);
        if (null == association) {
            association = new Association();
            association.setTenantSid(tenantSid);
            association.setUserSid(UserUtils.getUserSid());
            association.setRoleSid(superAdminRole.getSid());
            association.setStatus(Boolean.TRUE);
            EntityUtils.setCreateFields((BaseEntity)association);
            associations.add(association);
        }
        this.associationRepository.saveAll(associations);
    }

    private List<RoleCatalog> copyRoleCatalog(Long sourceTenantSid, Long tenantSid) {
        List<RoleCatalog> roleCatalogs = this.roleCatalogCrudService.findByTenantSid(sourceTenantSid);
        List<RoleCatalog> existCatalogs = this.roleCatalogCrudService.findByTenantSid(tenantSid);
        ArrayList<RoleCatalog> roleCatalogList = new ArrayList<RoleCatalog>();
        roleCatalogs.forEach(r -> {
            RoleCatalog existedRoleCatalog = null;
            if (!CollectionUtils.isEmpty((Collection)existCatalogs)) {
                existedRoleCatalog = existCatalogs.stream().filter(a -> r.getId().equals(a.getId())).findFirst().orElse(null);
            }
            if (null == existedRoleCatalog) {
                RoleCatalog roleCatalog = new RoleCatalog();
                BeanUtils.copyProperties((Object)r, (Object)((Object)roleCatalog));
                roleCatalog.setTenantSid(tenantSid);
                roleCatalog.setSid(SnowFlake.getInstance().newId());
                EntityUtils.setCreateFields((BaseEntity)roleCatalog);
                roleCatalogList.add(roleCatalog);
            } else {
                roleCatalogList.add(existedRoleCatalog);
            }
        });
        this.roleCatalogRepository.saveAll(roleCatalogList);
        return roleCatalogList;
    }

    private List<String> copySys(Long sourceTenantSid, Long tenantSid, String tenantId) {
        List<SysQueryResultVO> sysList = this.sysMapper.findSysVOByTenantSid(sourceTenantSid);
        ArrayList sysInTenants = new ArrayList();
        sysList.forEach(s -> {
            SysInTenant sysInTenant = new SysInTenant();
            sysInTenant.setTenantSid(tenantSid);
            sysInTenant.setSysSid(s.getSid());
            sysInTenant.setSid(SnowFlake.getInstance().newId());
            EntityUtils.setCreateFields((BaseEntity)sysInTenant);
            if (!StringUtils.isEmpty((Object)s.getSecretKey())) {
                String secretKey = SecretKeyUtil.getSecretKey(tenantId, s.getId(), "virtual");
                sysInTenant.setSecretKey(secretKey);
            }
            sysInTenants.add(sysInTenant);
        });
        this.sysInTenantRepository.saveAll(sysInTenants);
        return sysList.stream().map(SysQueryResultVO::getId).collect(Collectors.toList());
    }

    private void copyDataPolicy(Long sourceTenantSid, Long tenantSid, Map<Long, Org> orgMap, Map<Long, Role> roleMap, Map<Long, User> userMap) {
        List<CopyDataPolicyCascadeVO> dataPolicyCascadeVOS = this.dataPolicyMapper.getDataPolicyCascadeInfo(sourceTenantSid);
        ArrayList dataPolicyList = new ArrayList();
        ArrayList dataStatements = new ArrayList();
        ArrayList dataPolicyOnOrgs = new ArrayList();
        ArrayList dataPolicyOnRoles = new ArrayList();
        ArrayList dataPolicyOnUsers = new ArrayList();
        dataPolicyCascadeVOS.forEach(p -> {
            DataPolicy dataPolicy = new DataPolicy();
            BeanUtils.copyProperties((Object)p, (Object)((Object)dataPolicy));
            dataPolicy.setTenantSid(tenantSid);
            dataPolicy.setSid(SnowFlake.getInstance().newId());
            dataPolicyList.add(dataPolicy);
            p.getDataStatements().forEach(s -> {
                s.setPolicySid(dataPolicy.getSid());
                s.setSid(0L);
                EntityUtils.setCreateFields((BaseEntity)s);
                dataStatements.add(s);
            });
            p.getOrgs().forEach(o -> {
                DataPolicyOnOrg policyOnOrg = new DataPolicyOnOrg();
                policyOnOrg.setPolicySid(dataPolicy.getSid());
                Org org = (Org)((Object)((Object)((Object)orgMap.get(o.getSid()))));
                if (null == org) {
                    throw new BusinessException((ErrorHandler)I18nError.COPY_DATA_POLICY_ORG_NOT_EXIST, new Object[]{o.getId()});
                }
                policyOnOrg.setOrgSid(org.getSid());
                EntityUtils.setCreateFields((BaseEntity)policyOnOrg);
                dataPolicyOnOrgs.add(policyOnOrg);
            });
            p.getRoles().forEach(r -> {
                DataPolicyOnRole policyOnRole = new DataPolicyOnRole();
                policyOnRole.setPolicySid(dataPolicy.getSid());
                Role role = (Role)((Object)((Object)((Object)roleMap.get(r.getSid()))));
                if (null == role) {
                    throw new BusinessException((ErrorHandler)I18nError.COPY_ROLE_DATA_POLICY_ROLE_NOT_EXIST, new Object[]{r.getId()});
                }
                policyOnRole.setRoleSid(role.getSid());
                EntityUtils.setCreateFields((BaseEntity)policyOnRole);
                dataPolicyOnRoles.add(policyOnRole);
            });
            p.getUsers().forEach(u -> {
                DataPolicyOnUser policyOnUser = new DataPolicyOnUser();
                policyOnUser.setUserSid(u.getSid());
                policyOnUser.setPolicySid(dataPolicy.getSid());
                User user = (User)((Object)((Object)((Object)userMap.get(u.getSid()))));
                if (null != user) {
                    policyOnUser.setUserSid(user.getSid());
                }
                EntityUtils.setCreateFields((BaseEntity)policyOnUser);
                dataPolicyOnUsers.add(policyOnUser);
            });
        });
        this.dataPolicyRepository.saveAll(dataPolicyList);
        this.dataStatementRepository.saveAll(dataStatements);
        this.dataPolicyOnOrgRepository.saveAll(dataPolicyOnOrgs);
        this.dataPolicyOnRoleRepository.saveAll(dataPolicyOnRoles);
        this.dataPolicyOnUserRepository.saveAll(dataPolicyOnUsers);
    }

    @Override
    public List<TenantAuthVO> getTenantAuthsInDate(TenantAuthDTO tenantAuthDTO) {
        ArrayList<TenantAuthVO> authResultList = new ArrayList<TenantAuthVO>();
        DeployAreaEnum azureArea = null;
        String area = "Aliyun";
        if (DeployAreaEnum.AliyunTest.toString().equals(this.envProperties.getDeployArea())) {
            azureArea = DeployAreaEnum.AzureTest;
        } else if (DeployAreaEnum.AliyunProd.toString().equalsIgnoreCase(this.envProperties.getDeployArea())) {
            azureArea = DeployAreaEnum.AzureProd;
        } else if (DeployAreaEnum.isAzure((String)this.envProperties.getDeployArea())) {
            area = "Azure";
        } else {
            azureArea = DeployAreaEnum.DevelopDev;
        }
        if (null != azureArea) {
            if (ObjectUtils.isEmpty((Object)UserUtils.getToken())) {
                throw new BusinessException((ErrorHandler)CommonErrorCode.USER_TOKEN_INVALID);
            }
            List<TenantAuthVO> tenantAuthsInDate4Azure = this.remoteIamService.getTenantAuthInfos(tenantAuthDTO, azureArea);
            if (!CollectionUtils.isEmpty(tenantAuthsInDate4Azure)) {
                authResultList.addAll(tenantAuthsInDate4Azure);
            }
        }
        List<AuthorizationVO> tenantAuthsInDate4Ali = this.cacService.getTenantAuthsInDate(tenantAuthDTO.getBeginTime(), tenantAuthDTO.getEndTime(), this.envProperties.getCacUri());
        this.addAuthResultList(authResultList, tenantAuthsInDate4Ali, area, null);
        List<Sys> sys = this.sysCrudService.findByIdIn(authResultList.stream().map(TenantAuthVO::getGoodsCode).distinct().collect(Collectors.toList()));
        for (TenantAuthVO authVO : authResultList) {
            Optional<Sys> first = sys.stream().filter(a -> a.getId().equals(authVO.getGoodsCode())).findFirst();
            if (!first.isPresent()) continue;
            authVO.setProductCode(first.get().getProductCode());
            authVO.setProductName(first.get().getProductName());
        }
        return authResultList;
    }

    public void addAuthResultList(List<TenantAuthVO> authResultList, List<AuthorizationVO> tenantAuthsInDate, String area, List<TenantVO> tenants) {
        if (CollectionUtils.isEmpty(tenants) && !CollectionUtils.isEmpty(tenantAuthsInDate)) {
            List<String> tenantIds = tenantAuthsInDate.stream().map(AuthorizationVO::getCustomerId).collect(Collectors.toList());
            tenants = this.tenantMapper.getTenantByTenantIds(tenantIds, false);
        }
        if (CollectionUtils.isEmpty(tenants)) {
            return;
        }
        Map<String, List<AuthorizationVO>> tenantAuthsInDateMap = tenantAuthsInDate.stream().collect(Collectors.groupingBy(AuthorizationVO::getCustomerId));
        tenants.forEach(o -> {
            List authorizationVOs = (List)tenantAuthsInDateMap.get(o.getId());
            if (!CollectionUtils.isEmpty((Collection)authorizationVOs)) {
                authorizationVOs.forEach(a -> {
                    TenantAuthVO tenantAuthVO = new TenantAuthVO((AuthorizationVO)a, (TenantVO)o, area);
                    authResultList.add(tenantAuthVO);
                });
            }
        });
    }

    @Override
    public List<TenantMiswsDTO> getTenantMiswsInfoList(TenantMiswsDTO tenantMiswsDTO) {
        List<TenantMiswsDTO> tenantMiswsDTOS = new ArrayList<TenantMiswsDTO>();
        TenantShippingVO tenantShippingVO = this.miswsService.getTenantInfo(tenantMiswsDTO.getUserEmail());
        if (null != tenantShippingVO) {
            if ("-1".equals(tenantShippingVO.getStatus())) {
                log.error("\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u79df\u6237\u8d44\u6599\u5931\u8d25 {}", (Object)tenantShippingVO.getMessage());
                return tenantMiswsDTOS;
            }
            if (null != tenantShippingVO.getData() && !CollectionUtils.isEmpty(tenantShippingVO.getData().getAuthorisation())) {
                tenantMiswsDTOS = tenantShippingVO.getData().getAuthorisation();
                if (!StringUtils.isEmpty((Object)tenantMiswsDTO.getCustomerId())) {
                    tenantMiswsDTOS = tenantShippingVO.getData().getAuthorisation().stream().filter(o -> tenantMiswsDTO.getCustomerId().equals(o.getCustomerId())).collect(Collectors.toList());
                }
            }
            List<String> tenantIds = tenantMiswsDTOS.stream().map(TenantMiswsDTO::getTenantId).collect(Collectors.toList());
            List<Tenant> tenants = this.tenantRepository.findInIds(tenantIds);
            tenantMiswsDTOS.stream().forEach(o -> tenants.stream().forEach(t -> {
                if (o.getTenantId().equals(t.getId())) {
                    o.setSourceTenantSid(t.getSid());
                }
            }));
        }
        return tenantMiswsDTOS;
    }

    @Override
    public void copyAuthFromSourceApp(CopyAppAuthVO copyAppAuthVO) {
        Sys sys = this.sysMapper.findById(copyAppAuthVO.getAppId());
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{copyAppAuthVO.getAppId()});
        }
        List<TenantAppVO> tenants = 1 == copyAppAuthVO.getType() ? this.sysMapper.queryTenantsByAppId(copyAppAuthVO.getSourceAppId()) : this.sysMapper.queryTenantsByCondition(copyAppAuthVO.getSourceAppId(), copyAppAuthVO.getAppId(), copyAppAuthVO.getTenantId());
        if (!tenants.isEmpty()) {
            copyAppAuthVO.setTenantIds(tenants.stream().map(TenantAppVO::getTenantId).collect(Collectors.toList()));
            SellingStrategyVO sellingStrategyVO = this.gmcService.getGoodsSellingStrategy(copyAppAuthVO.getStrategyCode());
            if (null != sellingStrategyVO) {
                TenantApplicationVO tenantApplicationVO = new TenantApplicationVO();
                tenantApplicationVO.setProductSid(sellingStrategyVO.getGoods().getId().toString());
                tenantApplicationVO.setId(copyAppAuthVO.getAppId());
                tenantApplicationVO.setName(sellingStrategyVO.getGoods().getDisplayName());
                tenantApplicationVO.setStrategyCode(sellingStrategyVO.getId().toString());
                tenantApplicationVO.setPaymentType(sellingStrategyVO.getGoods().getPaymentType());
                tenantApplicationVO.setCustomUnit(sellingStrategyVO.getGoods().getCustomUnit());
                tenantApplicationVO.setPaymentTypeName(sellingStrategyVO.getGoods().getPaymentTypeName());
                tenantApplicationVO.setEffectiveTime(copyAppAuthVO.getEffectiveDateTime());
                tenantApplicationVO.setExpiredTime(copyAppAuthVO.getExpiredDateTime());
                sellingStrategyVO.getEnabledModules().forEach(m -> {
                    AuthorizationModuleVO authorizationModuleVO = new AuthorizationModuleVO();
                    authorizationModuleVO.setId(m.getId());
                    authorizationModuleVO.setName(m.getName());
                    tenantApplicationVO.getModules().add(authorizationModuleVO);
                });
                copyAppAuthVO.getAuthorizations().add(tenantApplicationVO);
                this.cacService.copyAuthFromSourceApp(copyAppAuthVO);
            } else {
                log.warn(String.format("\u5e94\u7528%s\u7684\u9500\u552e\u65b9\u6848%s\u4e0d\u5b58\u5728", copyAppAuthVO.getAppId(), copyAppAuthVO.getStrategyCode()));
            }
        } else {
            log.warn(String.format("\u79df\u6237%s\u65e0\u9700\u590d\u5236%s\u5e94\u7528\u7684\u6388\u6743\u5230\u5e94\u7528%s", copyAppAuthVO.getTenantId(), copyAppAuthVO.getSourceAppId(), copyAppAuthVO.getAppId()));
        }
        List<TenantAppVO> existedTenants = this.sysMapper.queryTenantsByAppId(copyAppAuthVO.getAppId());
        if (!existedTenants.isEmpty()) {
            tenants.removeIf(t -> existedTenants.stream().map(TenantAppVO::getTenantId).collect(Collectors.toList()).contains(t.getTenantId()));
        }
        ArrayList sysInTenants = new ArrayList();
        tenants.forEach(t -> {
            SysInTenant sysInTenant = new SysInTenant();
            String secretKey = SecretKeyUtil.getSecretKey(t.getTenantId(), copyAppAuthVO.getAppId(), "virtual");
            sysInTenant.setSecretKey(secretKey);
            sysInTenant.setSysSid(sys.getSid());
            sysInTenant.setTenantSid(t.getTenantSid());
            sysInTenants.add(sysInTenant);
        });
        this.sysInTenantRepository.saveAll(sysInTenants);
    }

    @Override
    public void addOrDeleteAuth(CopyAppAuthVO copyAppAuthVO, Boolean inside) {
        if (StringUtils.isEmpty((Object)copyAppAuthVO.getTenantId()) && StringUtils.isEmpty((Object)copyAppAuthVO.getCustomerId())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_AND_CUSTOMER_ID_NOT_NULL);
        }
        Tenant tenant = null;
        if (com.digiwin.dap.middleware.util.StringUtils.isNotEmpty((String)copyAppAuthVO.getTenantId())) {
            tenant = (Tenant)this.tenantCrudService.findById(copyAppAuthVO.getTenantId());
        } else if (com.digiwin.dap.middleware.util.StringUtils.isNotEmpty((String)copyAppAuthVO.getCustomerId())) {
            tenant = this.tenantRepository.findBycustomerId(copyAppAuthVO.getCustomerId());
        }
        if (null == tenant) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{copyAppAuthVO.getTenantId()});
        }
        Sys sys = this.sysMapper.findById(copyAppAuthVO.getAppId());
        if (null == sys || sys.getSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{copyAppAuthVO.getAppId()});
        }
        if (0 == copyAppAuthVO.getType()) {
            log.info("1.iam\u6dfb\u52a0\u6307\u5b9a\u79df\u6237\u6388\u6743:\u79df\u6237\u4e3a:{}\uff0c\u6388\u6743\u5e94\u7528\u4fe1\u606f\u4e3a:{}", (Object)tenant.getId(), (Object)JsonUtils.writeValue((Object)copyAppAuthVO));
            this.purchaseApplicationService.purchaseApplication(tenant, "virtual", new SysVO(sys), true);
            this.initDefaultPolicy(tenant, copyAppAuthVO.getAppId());
            if (!inside.booleanValue()) {
                Assert.hasText((String)copyAppAuthVO.getStrategyCode(), (String)"\u9500\u552e\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a");
                this.purchaseAuth(tenant, copyAppAuthVO.getAppId(), copyAppAuthVO.getStrategyCode(), true, null, copyAppAuthVO.getUserNumber(), copyAppAuthVO.getEffectiveDateTime(), copyAppAuthVO.getExpiredDateTime(), copyAppAuthVO.getComeFrom());
            }
        } else {
            log.info("1.iam\u5220\u9664\u6307\u5b9a\u79df\u6237\u6388\u6743:\u79df\u6237\u4e3a:{}\uff0c\u6388\u6743\u5e94\u7528\u4fe1\u606f\u4e3a:{}", (Object)tenant.getId(), (Object)JsonUtils.writeValue((Object)copyAppAuthVO));
            AuthorizationVO authorizationVO = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(tenant.getId(), copyAppAuthVO.getAppId());
            if (authorizationVO == null) {
                log.error("\u505c\u7528\u5931\u8d25\uff0c\u79df\u6237\u4e0b{}\u65e0\u5e94\u7528{}\u6388\u6743", (Object)tenant.getId(), (Object)copyAppAuthVO.getAppId());
                return;
            }
            GoodsAuthDO goodsAuthDO = new GoodsAuthDO(tenant, authorizationVO);
            goodsAuthDO.setAction(0);
            goodsAuthDO.setUpdateTenantAuth(true);
            goodsAuthDO.setSourceCode(CacRecordSourceEnum.DirectAuthorization.getId());
            goodsAuthDO.setMemo(String.format("\u7ed9\u6307\u5b9a\u79df\u6237\u7eed\u7ea6\u6216\u505c\u7528\u5e94\u7528\uff0c\u6765\u6e90:\u3010%s\u3011", copyAppAuthVO.getComeFrom()));
            goodsAuthDO.setExpiredDateTime(LocalDateTime.now());
            this.omcService.purchaseApp(tenant.getId(), Collections.singletonList(goodsAuthDO));
        }
    }

    private void initDefaultPolicy(Tenant tenant, String appId) {
        RoleCatalog misRoleCatalog;
        Role misInDefaultTenant;
        RoleCatalog endUserRoleCatalog;
        Role endUserInDefaultTenant = this.roleCrudService.findByTenantSidAndId(3L, "endUser");
        if (null != endUserInDefaultTenant && null != (endUserRoleCatalog = this.roleCatalogCrudService.findByTenantSidAndSid(endUserInDefaultTenant.getTenantSid(), endUserInDefaultTenant.getRoleCatalogSid()))) {
            RoleInfo endUserRoleInfo = new RoleInfo(endUserInDefaultTenant, endUserRoleCatalog);
            log.info("authTenantSrobot endUserRoleInfo :{}", (Object)JsonUtils.writeValue((Object)endUserRoleInfo));
            this.importDataService.updateTenantRoles(tenant, Stream.of(endUserRoleInfo).collect(Collectors.toList()), true, appId);
        }
        if (null != (misInDefaultTenant = this.roleCrudService.findByTenantSidAndId(3L, "mis")) && null != (misRoleCatalog = this.roleCatalogCrudService.findByTenantSidAndSid(misInDefaultTenant.getTenantSid(), misInDefaultTenant.getRoleCatalogSid()))) {
            RoleInfo misUserRoleInfo = new RoleInfo(misInDefaultTenant, misRoleCatalog);
            log.info("authTenantSrobot endUserRoleInfo :{}", (Object)JsonUtils.writeValue((Object)misUserRoleInfo));
            this.importDataService.updateTenantRoles(tenant, Stream.of(misUserRoleInfo).collect(Collectors.toList()), true, appId);
        }
    }

    @Override
    public void disqualifyTenantISV(Long sid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(sid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21018);
        }
        this.tenantCrudService.update((BaseEntity)tenant);
    }

    @Override
    public Map<String, Object> checkUserAuth(String tenantId, String email, Integer type, String appId) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        boolean userExisted = false;
        boolean authExisted = false;
        if (null == tenant) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(email, email, email, type);
        if (null != user) {
            if (this.userInTenantCrudService.existsByUnionKey(tenant.getSid(), user.getSid())) {
                userExisted = true;
            }
            Sys sys = (Sys)this.sysCrudService.findById(appId);
            AuthResult appAuth = this.appAuthCheckService.getAppAuth(sys.isPlatform(), sys.getId(), tenantId, user.getId());
            authExisted = appAuth.ok();
        }
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        mapResult.put("userExisted", userExisted);
        mapResult.put("authExisted", authExisted);
        if (userExisted) {
            mapResult.put("userId", user.getId());
        }
        return mapResult;
    }

    @Override
    public List<TenantAuthQueryResultVO> getTenantAuth(TenantAuthQueryVO vo) {
        String appId = vo.getAppId();
        List<Long> tenantSid = vo.getTenantSid();
        List tenantIds = null;
        if (!CollectionUtils.isEmpty(tenantSid)) {
            List<Tenant> inputTenants = this.tenantCrudService.findBySidIn(tenantSid);
            tenantIds = inputTenants.stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
        }
        List<CacAuth> tenantsAndApps = this.cacService.getTenantsAndAppsAllowNull(tenantIds, Collections.singletonList(appId));
        List<Tenant> tenants = this.tenantRepository.findByIdIn(tenantsAndApps.stream().map(CacAuth::getTenantId).collect(Collectors.toList()));
        ArrayList<TenantAuthQueryResultVO> result = new ArrayList<TenantAuthQueryResultVO>();
        for (CacAuth cac : tenantsAndApps) {
            TenantAuthQueryResultVO aResult = new TenantAuthQueryResultVO();
            result.add(aResult);
            aResult.setTenantId(cac.getTenantId());
            Optional<Tenant> tenant = tenants.stream().filter(a -> a.getId().equals(cac.getTenantId())).findFirst();
            if (tenant.isPresent()) {
                aResult.setTenantSid(tenant.get().getSid());
                aResult.setTenantName(tenant.get().getName());
            }
            if (CollectionUtils.isEmpty(cac.getApps())) continue;
            aResult.setEffectiveTime(cac.getApps().get(0).getEffectiveDateTime());
            aResult.setExpiredTime(cac.getApps().get(0).getExpiredDateTime());
        }
        return result;
    }

    @Override
    public List<CommonVO> querySameCustomer(String tenantId) {
        return this.tenantMapper.querySameCustomer(tenantId);
    }

    @Override
    public PageSerializable<Tenant> findWechatTenant(QueryWechatTenantVO queryWechatTenantVO) {
        PageHelper.startPage((int)queryWechatTenantVO.getPageNum(), (int)queryWechatTenantVO.getPageSize(), (String)"t.sid desc");
        List<Tenant> tenantList = this.tenantMapper.findWechatTenant(queryWechatTenantVO.getTenantContent());
        return new PageSerializable(tenantList);
    }

    @Override
    public int batchAuthCacBy(TenantBatchAuthVO vo) {
        List<String> userIds = this.getUserIdToAuth(vo);
        this.checkUsage(vo, userIds);
        List<CountResultVO> countResultVOS = this.cacService.batchAddIncrementalInBatches(vo.getGoodsCode(), userIds);
        CountResultVO countResultVO = countResultVOS.get(countResultVOS.size() - 1);
        return countResultVO.getCurrentCount();
    }

    private void checkUsage(TenantBatchAuthVO vo, List<String> userIds) {
        AuthorizationResultVO cacData = this.cacService.queryAllAuthorization(vo.getTenantId(), vo.getGoodsCode());
        if (PaymentTypeEnum.isUnlimited(cacData.getPaymentType())) {
            return;
        }
        List<String> authed = this.cacService.queryAuthUser(vo.getTenantId(), vo.getGoodsCode());
        userIds.removeIf(authed::contains);
        List toAuth = userIds.stream().filter(a -> !User.isADAccount(a)).collect(Collectors.toList());
        if (PaymentTypeEnum.byUsage(cacData.getPaymentType()) && cacData.getRemainingUsage() < toAuth.size() || PaymentTypeEnum.byCount(cacData.getPaymentType()) && cacData.getUserCount() + toAuth.size() > cacData.getTotalUserCount()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_COUNTING_INADEQUATE);
        }
    }

    @Override
    public int queryAuthCacCountBy(TenantBatchAuthVO vo) {
        List<String> userIds = this.getUserIdToAuth(vo);
        List<String> authed = this.cacService.queryAuthUser(vo.getTenantId(), vo.getGoodsCode());
        userIds.removeIf(authed::contains);
        return userIds.size();
    }

    @NotNull
    private List<String> getUserIdToAuth(TenantBatchAuthVO vo) {
        List<String> userIds = new ArrayList<String>();
        if ("role".equals(vo.getAuthType())) {
            userIds = this.userInRoleQueryService.batchQueryUserInRole(vo.getTenantSid(), Collections.singletonList(vo.getSid())).stream().map(QueryRoleResultVO::getUserId).collect(Collectors.toList());
        } else if ("org".equals(vo.getAuthType())) {
            userIds = this.userInOrgMapper.findUsersByOrgSid(vo.getTenantSid(), vo.getSid()).stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
        }
        return userIds;
    }

    @Override
    public void modTenantDoubleCheck(TenantDoubleCheckVO vo) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(vo.getTenantSid());
        if (tenant != null) {
            tenant.setDoubleCheck(vo.getDoubleCheck());
            tenant.setIdentityCodeAcceptType(vo.getIdentityCodeAcceptType());
            EntityUtils.setModifyFields((BaseEntity)tenant);
            this.tenantCrudService.update((BaseEntity)tenant);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void delUserFromTenant(AuthoredUser user, long userSid) {
        User targetUser = (User)this.userCrudService.findBySid(userSid);
        this.userInTenantCrudService.deleteByUnionKey(user.getTenantSid(), targetUser.getSid());
        this.policyCascadeDeleteService.deleteUser(user.getTenantSid(), targetUser.getSid());
        this.cascadeDeleteEntityService.deleteRelation("userrelationwithtenant", Long.valueOf(targetUser.getSid()), Long.valueOf(user.getTenantSid()));
        this.serviceAuthorizationRecordService.updateRecordStop(user.getTenantSid(), targetUser.getSid(), StopTypeEnum.TENANT_STOP.getValue());
        this.authoredUserService.clear(user.getTenantSid(), targetUser.getSid());
        this.invitedUserHistoryCrudService.deleteInvitedUserHistoryByUserSid(targetUser.getSid());
        if (targetUser.getDefaultTenantSid() > 0L && targetUser.getDefaultTenantSid() == user.getTenantSid()) {
            targetUser.setDefaultTenantSid(0L);
            this.userCrudService.update((BaseEntity)targetUser);
        }
        if (1 == targetUser.getType()) {
            this.userCrudService.deleteById(targetUser.getSid());
        }
        this.remoteEocService.changeEmpStatus(user.getTenantSid(), targetUser.getId(), false, user.getToken());
        this.remoteEocService.deleteUserEmp(user.getTenantSid(), targetUser.getId());
        this.cacService.deleteUser(user.getTenantId(), targetUser.getId());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void disableUser(long tenantSid, @NotNull User user) {
        this.userInTenantCrudService.disable(tenantSid, user.getSid());
        if (user.getDefaultTenantSid() > 0L && user.getDefaultTenantSid() == tenantSid) {
            user.setDefaultTenantSid(0L);
            this.userCrudService.update((BaseEntity)user);
        }
        UserTenantSimpleVO userTenantSimpleVO = new UserTenantSimpleVO();
        userTenantSimpleVO.setTenantSid(tenantSid);
        userTenantSimpleVO.setUserId(user.getId());
        userTenantSimpleVO.setUserSid(user.getSid());
        userTenantSimpleVO.setUserName(user.getName());
        userTenantSimpleVO.setUserEmail(user.getEmail());
        this.changeLogService.batchDisableUserChangeLogs(Arrays.asList(userTenantSimpleVO));
    }

    @Override
    public UserStatusResultVO checkEmp(String userId) {
        EmpInfoVO empInfoVO = this.remoteEocService.getEmpByUserId(userId, false);
        if (null != empInfoVO) {
            UserStatusResultVO statusResultVO = new UserStatusResultVO();
            statusResultVO.setUserId(userId);
            statusResultVO.setDisabledInTenant(ObjectUtils.nullSafeEquals((Object)Boolean.FALSE, (Object)empInfoVO.getStatus()));
            statusResultVO.setName(empInfoVO.getName());
            statusResultVO.setEmail(empInfoVO.getEmail());
            statusResultVO.setTelephone(empInfoVO.getTelephone());
            return statusResultVO;
        }
        return null;
    }

    @Override
    public void updateTenantId(TenantIdDTO req) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(req.getSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{req.getSid()});
        }
        if (Objects.equals(TenantConfirmEnum.APPROVED.getValue(), tenant.getConfirm())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_HAS_BEEN_CONFIRMED, new Object[]{tenant.getId()});
        }
        TenantVO vo = new TenantVO();
        vo.setId(req.getId());
        vo.setComeFrom(tenant.getComeFrom());
        vo.setTeamId(tenant.getTeamId());
        this.tenantQueryService.checkExistsMuiltAreas(vo, null, false);
        tenant.setId(req.getId());
        this.tenantCrudService.update((BaseEntity)tenant);
    }
}

