/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenant.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantDTO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantUpdateService;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantUpdateServiceImpl
implements TenantUpdateService {
    @Autowired
    private TenantCrudService tenantCrudService;

    @Override
    @Transactional
    public void update(TenantDTO dto) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(dto.getSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{dto.getSid()});
        }
        Optional.ofNullable(dto.getAdLogin()).ifPresent(tenant::setAdLogin);
        Optional.ofNullable(dto.getSamlLogin()).ifPresent(tenant::setSamlLogin);
        Optional.ofNullable(dto.getCasLogin()).ifPresent(tenant::setCasLogin);
        Optional.ofNullable(dto.getOidcLogin()).ifPresent(tenant::setOidcLogin);
        this.tenantCrudService.update((BaseEntity)tenant);
    }
}

