/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenant.impl;

import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.domain.ComeFromEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.domain.servicer.ServicerVO;
import com.digiwin.dap.middleware.iam.domain.tenant.DevTenantCertificationVO;
import com.digiwin.dap.middleware.iam.domain.tenant.DevTenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.UpdateTenantInfoVO;
import com.digiwin.dap.middleware.iam.entity.DevCertificationDO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantCertification;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.repository.CertificationRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.authentication.TenantCertificationCrudService;
import com.digiwin.dap.middleware.iam.service.authentication.UserCertificationCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.servicer.ServicerService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.UpdateTenantService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.remote.OmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UpdateTenantServiceImpl
implements UpdateTenantService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantCertificationCrudService tenantCertificationCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserCertificationCrudService userCertificationCrudService;
    @Autowired
    private OmcService omcService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private TenantMetadataUpdateService tenantMetadataUpdateService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private CertificationRepository certificationRepository;
    @Autowired
    private ServicerService servicerService;
    @Autowired
    private UserInRoleService userInRoleService;

    @Override
    public void update(UpdateTenantInfoVO updateTenantInfoVO) {
        Assert.notNull((Object)updateTenantInfoVO, (String)"updateTenantInfoVO is null");
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(updateTenantInfoVO.getSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{updateTenantInfoVO.getSid()});
        }
        User user = (User)this.userCrudService.findBySid(tenant.getOwnerUserSid());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{tenant.getOwnerUserSid()});
        }
        if (TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue().equals(tenant.getEnterpriseType())) {
            if (!StringUtils.isEmpty((Object)updateTenantInfoVO.getEmail()) && !updateTenantInfoVO.getEmail().equals(user.getEmail())) {
                if (!StringUtils.isEmpty((Object)user.getEmail()) && !user.getEmail().equals(updateTenantInfoVO.getEmail()) && this.userRepository.existsByEmailAndType(updateTenantInfoVO.getEmail(), 0)) {
                    throw new BusinessException((ErrorHandler)I18nError.EMAIL_HAS_EXIST, new Object[]{updateTenantInfoVO.getEmail()});
                }
                tenant.setEmail(updateTenantInfoVO.getEmail());
                user.setEmail(updateTenantInfoVO.getEmail());
            }
            if (!StringUtils.isEmpty((Object)updateTenantInfoVO.getTelephone()) && !updateTenantInfoVO.getTelephone().equals(user.getTelephone())) {
                if (!StringUtils.isEmpty((Object)user.getTelephone()) && !user.getTelephone().equals(updateTenantInfoVO.getTelephone()) && this.userRepository.existsByTelephoneAndType(updateTenantInfoVO.getTelephone(), 0)) {
                    throw new BusinessException((ErrorHandler)I18nError.PHONE_HAS_EXIST, new Object[]{updateTenantInfoVO.getTelephone()});
                }
                tenant.setTelephone(updateTenantInfoVO.getTelephone());
                user.setTelephone(updateTenantInfoVO.getTelephone());
            }
            if (!StringUtils.isEmpty((Object)updateTenantInfoVO.getName())) {
                tenant.setName(updateTenantInfoVO.getName());
                if (!this.userCertificationCrudService.existsByUserSid(user.getSid())) {
                    user.setName(updateTenantInfoVO.getName());
                }
            }
            tenant.setAddress(updateTenantInfoVO.getAddress());
            user.setAddress(updateTenantInfoVO.getAddress());
        } else {
            tenant.setCustomerId(updateTenantInfoVO.getCustomerId());
            tenant.setEmail(updateTenantInfoVO.getEmail());
            tenant.setTelephone(updateTenantInfoVO.getTelephone());
            tenant.setContacts(updateTenantInfoVO.getContacts());
            tenant.setDescription(updateTenantInfoVO.getDescription());
            tenant.setStaffSize(updateTenantInfoVO.getStaffSize());
            tenant.setOpen(updateTenantInfoVO.getOpen());
            tenant.setImageUrl(updateTenantInfoVO.getImageUrl());
            tenant.setAddress(updateTenantInfoVO.getAddress());
            tenant.setExplain(updateTenantInfoVO.getExplain());
            TenantCertification tenantCertification = this.tenantCertificationCrudService.findByTenantSid(updateTenantInfoVO.getSid());
            if (tenantCertification == null || !tenantCertification.isPassed()) {
                if (!StringUtils.isEmpty((Object)updateTenantInfoVO.getName())) {
                    tenant.setName(updateTenantInfoVO.getName());
                }
            } else if (!tenant.getName().equals(updateTenantInfoVO.getName())) {
                if (!StringUtils.isEmpty((Object)tenantCertification.getAccountId())) {
                    throw new BusinessException((ErrorHandler)I18nError.COMPANY_NAME_UPDATE_FAILED, new Object[]{tenant.getId()});
                }
                tenant.setName(updateTenantInfoVO.getName());
            }
        }
        Boolean test = tenant.isTestTenant();
        if (!test.equals(updateTenantInfoVO.getTestTenant())) {
            tenant.setTestTenant(updateTenantInfoVO.getTestTenant());
            this.omcService.OrderUpdateTestTenant(tenant.getId(), updateTenantInfoVO.getTestTenant());
        }
        if (tenant.isDealer() != updateTenantInfoVO.getDealer().booleanValue()) {
            tenant.setDealer(updateTenantInfoVO.getDealer());
        }
        if (!StringUtils.isEmpty((Object)updateTenantInfoVO.getPotentialCustomerId()) && !updateTenantInfoVO.getPotentialCustomerId().equals(tenant.getPotentialCustomerId())) {
            tenant.setPotentialCustomerId(updateTenantInfoVO.getPotentialCustomerId());
        }
        if (tenant.isEoc() != updateTenantInfoVO.getEoc().booleanValue()) {
            tenant.setEoc(updateTenantInfoVO.getEoc());
            if (updateTenantInfoVO.getEoc().booleanValue()) {
                TenantInfoVO tenantInfoVO = new TenantInfoVO();
                tenantInfoVO.setSid(tenant.getSid());
                tenantInfoVO.setId(tenant.getId());
                tenantInfoVO.setName(tenant.getName());
                this.remoteEocService.initialize(tenantInfoVO);
            }
        }
        if (updateTenantInfoVO.getCorpWechat() != null) {
            tenant.setCorpWechat(updateTenantInfoVO.getCorpWechat());
        }
        if (updateTenantInfoVO.getEnableMapping() != null) {
            tenant.setEnableMapping(updateTenantInfoVO.getEnableMapping());
        }
        Optional.ofNullable(updateTenantInfoVO.getCorpDingTalk()).ifPresent(tenant::setCorpDingTalk);
        Optional.ofNullable(updateTenantInfoVO.getAdLogin()).ifPresent(tenant::setAdLogin);
        Optional.ofNullable(updateTenantInfoVO.getSamlLogin()).ifPresent(tenant::setSamlLogin);
        Optional.ofNullable(updateTenantInfoVO.getCasLogin()).ifPresent(tenant::setCasLogin);
        Optional.ofNullable(updateTenantInfoVO.getOidcLogin()).ifPresent(tenant::setOidcLogin);
        tenant.setExperience(Optional.ofNullable(updateTenantInfoVO.getExperience()).orElse(false));
        Optional.ofNullable(updateTenantInfoVO.getResAcquireMode()).ifPresent(tenant::setResAcquireMode);
        String defaultLanguage = this.tenantMetadataCrudService.getTenantMetadataValue(tenant.getSid(), "basic", "defaultLanguage");
        if (!Objects.equals(defaultLanguage, updateTenantInfoVO.getDefaultLanguage())) {
            this.tenantMetadataUpdateService.updateTenantMetadataValue(tenant.getSid(), "basic", "defaultLanguage", updateTenantInfoVO.getDefaultLanguage());
        }
        String corpId = this.tenantMetadataCrudService.getTenantMetadataValue(tenant.getSid(), "contact", "corpId");
        if (!StringUtils.isEmpty((Object)updateTenantInfoVO.getCorpId()) && !updateTenantInfoVO.getCorpId().equals(corpId)) {
            this.tenantMetadataUpdateService.updateTenantMetadataValue(tenant.getSid(), "contact", "corpId", updateTenantInfoVO.getCorpId());
            if (corpId != null) {
                this.remoteEMCService.updateCorpids(tenant.getId(), updateTenantInfoVO.getCorpId());
            }
        }
        String dingTalkCorpId = this.tenantMetadataCrudService.getTenantMetadataValue(tenant.getSid(), "corpId", ComeFromEnum.DINGDING.getId());
        if (!tenant.isCorpDingTalk() && !ObjectUtils.nullSafeEquals((Object)dingTalkCorpId, (Object)updateTenantInfoVO.getDingTalkCorpId())) {
            this.tenantMetadataUpdateService.updateTenantMetadataValue(tenant.getSid(), "corpId", ComeFromEnum.DINGDING.getId(), updateTenantInfoVO.getDingTalkCorpId());
        }
        tenant.setDoubleCheck(null == updateTenantInfoVO.getDoubleCheck() ? Boolean.FALSE : updateTenantInfoVO.getDoubleCheck());
        tenant.setIdentityCodeAcceptType(updateTenantInfoVO.getIdentityCodeAcceptType());
        tenant.setVersion(updateTenantInfoVO.getVersion());
        tenant.setTenantPurpose(updateTenantInfoVO.getTenantPurpose());
        tenant.setFoundDate(updateTenantInfoVO.getFoundDate());
        tenant.setWebsite(updateTenantInfoVO.getWebsite());
        this.tenantCrudService.update((BaseEntity)tenant);
        this.userCrudService.update((BaseEntity)user);
    }

    @Override
    public void updateTenantCreator(UpdateTenantInfoVO updateTenantInfoVO) {
        Assert.notNull((Object)updateTenantInfoVO, (String)"updateTenantInfoVO is null");
        User user = this.userRepository.findFirstByEmailAndType(updateTenantInfoVO.getEmail(), 0);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.EMAIL_NOT_CONTAIN_USER, new Object[]{updateTenantInfoVO.getEmail()});
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(updateTenantInfoVO.getSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{updateTenantInfoVO.getSid()});
        }
        long oldOwnerUserSid = tenant.getOwnerUserSid();
        if (user.getSid() != oldOwnerUserSid) {
            UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
            if (userInTenant != null && userInTenant.isDisabled()) {
                throw new BusinessException((ErrorHandler)I18nError.EMAIL_USER_IS_DISABLE, new Object[]{updateTenantInfoVO.getEmail(), user.getId()});
            }
            if (userInTenant == null) {
                UserInTenant newUserInTenant = new UserInTenant();
                newUserInTenant.setUserSid(user.getSid());
                newUserInTenant.setTenantSid(tenant.getSid());
                this.userInTenantCrudService.create(newUserInTenant);
            }
            tenant.setEmail(updateTenantInfoVO.getEmail());
            tenant.setOwnerUserSid(user.getSid());
            this.tenantCrudService.update((BaseEntity)tenant);
            this.userInRoleService.addAdminRole(tenant, user);
            this.userInTenantCrudService.disable(tenant.getSid(), oldOwnerUserSid);
            User targetUser = (User)this.userCrudService.findBySid(oldOwnerUserSid);
            if (targetUser.getDefaultTenantSid() > 0L && targetUser.getDefaultTenantSid() == tenant.getSid()) {
                targetUser.setDefaultTenantSid(0L);
                this.userCrudService.update((BaseEntity)targetUser);
            }
        } else {
            throw new BusinessException((ErrorHandler)I18nError.EMAIL_CREATOR_ERROR, new Object[]{updateTenantInfoVO.getEmail()});
        }
    }

    @Override
    @Transactional
    public Long updateDevTenantInfo(DevTenantInfoVO devTenantVO) {
        ServicerVO servicerVO;
        Assert.notNull((Object)devTenantVO, (String)"devTenantVO is null");
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(devTenantVO.getSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{devTenantVO.getSid()});
        }
        long tenantSid = tenant.getSid();
        String tenantId = tenant.getId();
        BeanUtils.mergeDifferentTypeObject((Object)devTenantVO, (Object)((Object)tenant));
        tenant.setId(tenantId);
        this.tenantCrudService.update((BaseEntity)tenant);
        DevTenantCertificationVO certificationVO = devTenantVO.getTenantCertification();
        if (certificationVO != null) {
            DevCertificationDO devCertification = this.certificationRepository.findByTenantSid(tenantSid);
            if (devCertification == null) {
                devCertification = new DevCertificationDO();
                devCertification.setTenantSid(tenantSid);
                EntityUtils.setCreateFields((BaseEntity)devCertification);
            }
            devCertification.setLegalName(devTenantVO.getLegalName());
            devCertification.setLicenseNumber(certificationVO.getLicenseNumber());
            devCertification.setLicenseNumberFrontImageUrl(certificationVO.getLicenseNumberFrontImageUrl());
            devCertification.setLicenseNumberBackImageUrl(certificationVO.getLicenseNumberBackImageUrl());
            devCertification.setLicenseNumberGroupImageUrl(certificationVO.getLicenseNumberGroupImageUrl());
            devCertification.setLicenseNumberImageUrl(certificationVO.getLicenseNumberImageUrl());
            EntityUtils.setModifyFields((BaseEntity)devCertification);
            this.certificationRepository.save((Object)devCertification);
        }
        if ((servicerVO = devTenantVO.getServicer()) != null) {
            servicerVO.setTenantSid(tenantSid);
            this.servicerService.createServicer(servicerVO);
        }
        return tenantSid;
    }
}

