/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenantmetadata.impl;

import com.digiwin.dap.middleware.entity.UnionKey;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataColumnDTO;
import com.digiwin.dap.middleware.iam.entity.TenantMetadataColumn;
import com.digiwin.dap.middleware.iam.repository.TenantMetadataColumnRepository;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataColumnCrudService;
import com.digiwin.dap.middleware.repository.BaseEntityRepository;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithUnionKeyManagerService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantMetadataColumnCrudServiceImpl
extends BaseEntityWithUnionKeyManagerService<TenantMetadataColumn>
implements TenantMetadataColumnCrudService {
    public static final String PATH_TENANT_METADATA_COLUMN_JSON = "/static/templates/tenant_metadata_column.json";
    @Autowired
    private TenantMetadataColumnRepository tenantMetadataColumnRepository;
    @Autowired
    private EnvProperties envProperties;

    protected UnionKey createUnionKey() {
        return UnionKey.create().apply(TenantMetadataColumn.class).add("catalogId").add("key");
    }

    protected BaseEntityRepository getRepository() {
        return this.tenantMetadataColumnRepository;
    }

    @Override
    public void saveDefaultAll() {
        List baseList;
        InputStream stream = this.getClass().getResourceAsStream(PATH_TENANT_METADATA_COLUMN_JSON);
        try {
            baseList = (List)JsonUtils.createObjectMapper().readValue(stream, (TypeReference)new TypeReference<List<TenantMetadataColumnDTO>>(){});
        }
        catch (IOException e) {
            throw new BusinessException("\u521d\u59cb\u79df\u6237\u5143\u6570\u636e\u8f6c\u5316\u8d44\u6599\u5931\u8d25", (Throwable)e);
        }
        ArrayList<TenantMetadataColumn> list = new ArrayList<TenantMetadataColumn>();
        for (TenantMetadataColumnDTO dto : baseList) {
            TenantMetadataColumn column = (TenantMetadataColumn)this.findByUnionKey(new Object[]{dto.getCatalogId(), dto.getKey()});
            if (column != null) continue;
            list.add(dto.fillName(this.envProperties.getLocale()).get());
        }
        if (!list.isEmpty()) {
            this.saveAll(list);
        }
    }
}

