/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenantmetadata.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.UnionKey;
import com.digiwin.dap.middleware.iam.domain.tenant.MetadataOfTenant;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantMetadataVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantMetadata;
import com.digiwin.dap.middleware.iam.entity.TenantMetadataColumn;
import com.digiwin.dap.middleware.iam.mapper.TenantMetadataMapper;
import com.digiwin.dap.middleware.iam.repository.TenantMetadataColumnRepository;
import com.digiwin.dap.middleware.iam.repository.TenantMetadataRepository;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.repository.BaseEntityRepository;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithUnionKeyManagerService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TenantMetadataCrudServiceImpl
extends BaseEntityWithUnionKeyManagerService<TenantMetadata>
implements TenantMetadataCrudService {
    private static final Logger logger = LoggerFactory.getLogger(TenantMetadataCrudServiceImpl.class);
    @Autowired
    private TenantMetadataRepository tenantMetadataRepository;
    @Autowired
    private TenantMetadataColumnRepository tenantMetadataColumnRepository;
    @Autowired
    private TenantMetadataColumnCrudService tenantMetadataColumnCrudService;
    @Autowired
    private TenantMetadataMapper tenantMetadataMapper;
    @Autowired
    private TenantCrudService tenantCrudService;

    protected UnionKey createUnionKey() {
        return UnionKey.create().apply(TenantMetadata.class).add("tenantSid").add("columnSid");
    }

    protected BaseEntityRepository getRepository() {
        return this.tenantMetadataRepository;
    }

    @Override
    public List<TenantMetadataVO> getTenantMetadata(long tenantSid) {
        ArrayList<TenantMetadataVO> result = new ArrayList<TenantMetadataVO>();
        List<TenantMetadata> tenantMetadataList = this.tenantMetadataRepository.findByTenantSid(tenantSid);
        tenantMetadataList.forEach(metadata -> {
            TenantMetadataColumn column = this.tenantMetadataColumnRepository.findById(metadata.getColumnSid()).orElse(null);
            if (column != null) {
                result.add(new TenantMetadataVO((TenantMetadata)((Object)metadata), column));
            }
        });
        return result;
    }

    @Override
    public String getTenantMetadataValue(long tenantSid, String catalogId, String key) {
        TenantMetadata tenantMetadata;
        TenantMetadataColumn columns = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{catalogId, key});
        if (columns != null && (tenantMetadata = this.tenantMetadataRepository.findByTenantSidAndColumnSid(tenantSid, columns.getSid())) != null) {
            return tenantMetadata.getValue();
        }
        return null;
    }

    @Override
    public List<MetadataOfTenant> batchGetTenantMetadataValueWithTenantId(List<String> tenantIds, String catalogId, String key) {
        List<MetadataOfTenant> tenantMetadata;
        TenantMetadataColumn columns = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{catalogId, key});
        if (columns != null && !CollectionUtils.isEmpty(tenantIds) && !CollectionUtils.isEmpty(tenantMetadata = this.tenantMetadataMapper.findByTenantIdsAndColumnSid(tenantIds, columns.getSid()))) {
            return tenantMetadata;
        }
        return new ArrayList<MetadataOfTenant>();
    }

    @Override
    public List<MetadataOfTenant> batchGetAllTenantMetadataValueWithTenantId(List<String> tenantIds) {
        if (!CollectionUtils.isEmpty(tenantIds)) {
            return this.tenantMetadataMapper.findByTenantIds(tenantIds);
        }
        return new ArrayList<MetadataOfTenant>();
    }

    @Override
    public List<TenantMetadataVO> getTenantMetadataValue(long tenantSid, String catalogId, List<String> keys) {
        List<TenantMetadataColumn> columnList = this.tenantMetadataColumnRepository.findByCatalogIdAndKeyIn(catalogId, keys);
        if (columnList.isEmpty()) {
            return Collections.emptyList();
        }
        Map<Long, TenantMetadataColumn> columnMap = columnList.stream().collect(Collectors.toMap(BaseEntity::getSid, x -> x, (k1, k2) -> k1));
        List<Long> sids = columnList.stream().map(BaseEntity::getSid).collect(Collectors.toList());
        List<TenantMetadata> metadataList = this.tenantMetadataRepository.findByTenantSidAndColumnSidIn(tenantSid, sids);
        return metadataList.stream().map(x -> new TenantMetadataVO((TenantMetadata)((Object)x), (TenantMetadataColumn)((Object)((Object)columnMap.get(x.getColumnSid()))))).collect(Collectors.toList());
    }

    @Override
    public String getTenantIdFromCorpId(String corpId, String comeFrom) {
        List<TenantMetadata> tenantMetadata;
        TenantMetadataColumn columns = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"corpId", comeFrom});
        if (columns != null && !(tenantMetadata = this.tenantMetadataRepository.findByColumnSidAndValue(columns.getSid(), corpId)).isEmpty()) {
            List tenantIds = tenantMetadata.stream().map(a -> {
                Tenant tenant = (Tenant)this.tenantCrudService.findBySid(a.getTenantSid());
                if (tenant != null) {
                    return tenant.getId();
                }
                return null;
            }).filter(Objects::nonNull).sorted((id1, id2) -> {
                boolean startsWithDing1 = id1.startsWith("ding");
                boolean startsWithDing2 = id2.startsWith("ding");
                return Boolean.compare(startsWithDing1, startsWithDing2);
            }).collect(Collectors.toList());
            logger.info("\u3010\u9489\u9489\u8001\u5ba2\u3011corpId\uff1a{},\u7ed1\u5b9a\u7684tenantId\uff1a{}", (Object)corpId, tenantIds);
            return (String)tenantIds.get(0);
        }
        return corpId;
    }
}

