/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenantmetadata.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantMetadataVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantMetadata;
import com.digiwin.dap.middleware.iam.entity.TenantMetadataColumn;
import com.digiwin.dap.middleware.iam.repository.TenantMetadataRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataUpdateService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class TenantMetadataUpdateServiceImpl
implements TenantMetadataUpdateService {
    private static final Logger logger = LoggerFactory.getLogger(TenantMetadataUpdateServiceImpl.class);
    @Autowired
    private TenantMetadataRepository tenantMetadataRepository;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private TenantMetadataColumnCrudService tenantMetadataColumnCrudService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private EnvProperties envProperties;

    @Override
    public void update(Tenant tenant, List<TenantMetadataVO> metadataVOList) {
        this.tenantMetadataRepository.deleteByTenantSid(tenant.getSid());
        this.tenantMetadataRepository.flush();
        metadataVOList.forEach(metadata -> {
            TenantMetadataColumn columns = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{metadata.getCatalogId(), metadata.getKey()});
            if (columns != null) {
                TenantMetadata newestMetadata = new TenantMetadata();
                newestMetadata.setTenantSid(tenant.getSid());
                newestMetadata.setColumnSid(columns.getSid());
                newestMetadata.setValue(metadata.getValue());
                this.tenantMetadataCrudService.create((BaseEntity)newestMetadata);
            } else {
                logger.info(String.format("TenantMetadata\u503c[%s]\u5bf9\u5e94\u7684Column[%s]\u627e\u4e0d\u5230\u65e0\u6cd5\u6dfb\u52a0\uff01", metadata.getValue(), metadata.getKey()));
            }
        });
    }

    @Override
    public void updateTenantMetadataValue(long tenantSid, String catalogId, String key, String value) {
        this.updateTenantMetadataValue(tenantSid, catalogId, key, value, false);
    }

    @Override
    public void updateTenantMetadataValue(long tenantSid, String catalogId, String key, String value, boolean deleteNull) {
        TenantMetadataColumn column = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{catalogId, key});
        if (column == null) {
            String errorMessage = String.format("TenantMetadata\u503c[%s]\u5bf9\u5e94\u7684Column[%s]\u627e\u4e0d\u5230\u65e0\u6cd5\u6dfb\u52a0\uff01", value, key);
            throw new BusinessException(errorMessage);
        }
        TenantMetadata newestMetadata = (TenantMetadata)this.tenantMetadataCrudService.findByUnionKey(new Object[]{tenantSid, column.getSid()});
        if (newestMetadata == null) {
            if (value != null) {
                newestMetadata = new TenantMetadata();
                newestMetadata.setTenantSid(tenantSid);
                newestMetadata.setColumnSid(column.getSid());
                newestMetadata.setValue(value);
                this.tenantMetadataCrudService.create((BaseEntity)newestMetadata);
            }
        } else if (value != null) {
            newestMetadata.setValue(value);
            this.tenantMetadataCrudService.update((BaseEntity)newestMetadata);
        } else if (deleteNull) {
            this.tenantMetadataCrudService.deleteById(newestMetadata.getSid());
        }
    }

    @Override
    public void deleteTenantMetadataValue(long tenantSid, String catalogId, String key) {
        TenantMetadataColumn column = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{catalogId, key});
        if (column == null) {
            String errorMessage = String.format("TenantMetadata\u5bf9\u5e94\u7684Column [catalogId=%s], [key=%s]\u627e\u4e0d\u5230\u65e0\u6cd5\u6dfb\u52a0\uff01", catalogId, key);
            throw new BusinessException(errorMessage);
        }
        this.tenantMetadataRepository.deleteByTenantSidAndColumnSid(tenantSid, column.getSid());
    }

    @Override
    @Transactional
    public void updateTenantMetadataCorpId(long tenantSid, String catalogId, String key, String value) {
        Tenant tenant = (Tenant)((Object)this.tenantRepository.findById(tenantSid).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid})));
        TenantMetadataColumn column = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{catalogId, key});
        if (column == null) {
            String errorMessage = String.format("TenantMetadata\u503c[%s]\u5bf9\u5e94\u7684Column[%s]\u627e\u4e0d\u5230\u65e0\u6cd5\u6dfb\u52a0\uff01", value, key);
            throw new BusinessException(errorMessage);
        }
        TenantMetadata newestMetadata = (TenantMetadata)this.tenantMetadataCrudService.findByUnionKey(new Object[]{tenantSid, column.getSid()});
        if (newestMetadata == null) {
            newestMetadata = new TenantMetadata();
            newestMetadata.setTenantSid(tenantSid);
            newestMetadata.setColumnSid(column.getSid());
            newestMetadata.setValue(value);
            this.tenantMetadataCrudService.create((BaseEntity)newestMetadata);
        } else {
            newestMetadata.setValue(value);
            this.tenantMetadataCrudService.update((BaseEntity)newestMetadata);
            if ("contact".equals(catalogId) && "corpId".equals(key)) {
                this.remoteEMCService.updateCorpids(tenant.getId(), value);
            }
        }
    }

    @Override
    @Transactional
    public void updateTenantMetadataCorpId4CBM(long tenantSid, String catalogId, String key, String value) {
        TenantMetadataColumn column = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{catalogId, key});
        if (column == null) {
            String errorMessage = String.format("TenantMetadata\u503c[%s]\u5bf9\u5e94\u7684Column[%s]\u627e\u4e0d\u5230\u65e0\u6cd5\u6dfb\u52a0\uff01", value, key);
            throw new BusinessException(errorMessage);
        }
        TenantMetadata newestMetadata = (TenantMetadata)this.tenantMetadataCrudService.findByUnionKey(new Object[]{tenantSid, column.getSid()});
        if (newestMetadata == null) {
            newestMetadata = new TenantMetadata();
            newestMetadata.setTenantSid(tenantSid);
            newestMetadata.setColumnSid(column.getSid());
            newestMetadata.setValue(value);
            this.tenantMetadataCrudService.create((BaseEntity)newestMetadata);
        } else {
            newestMetadata.setValue(value);
            this.tenantMetadataCrudService.update((BaseEntity)newestMetadata);
        }
    }

    @Override
    public void saveTenantDefaultLanguage(long tenantSid) {
        String language = Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry()) ? "zh_TW" : "zh_CN";
        TenantMetadataColumn column = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"basic", "defaultLanguage"});
        if (column != null) {
            TenantMetadata newestMetadata = (TenantMetadata)this.tenantMetadataCrudService.findByUnionKey(new Object[]{tenantSid, column.getSid()});
            if (newestMetadata == null) {
                newestMetadata = new TenantMetadata();
                newestMetadata.setTenantSid(tenantSid);
                newestMetadata.setColumnSid(column.getSid());
                newestMetadata.setValue(language);
                this.tenantMetadataCrudService.create((BaseEntity)newestMetadata);
            } else if (StringUtils.isEmpty((Object)newestMetadata.getValue())) {
                newestMetadata.setValue(language);
                this.tenantMetadataCrudService.update((BaseEntity)newestMetadata);
            }
        } else {
            String errorMessage = String.format("TenantMetadata\u503c[%s]\u5bf9\u5e94\u7684Column[%s]\u627e\u4e0d\u5230\u65e0\u6cd5\u6dfb\u52a0\uff01", language, "defaultLanguage");
            throw new BusinessException(errorMessage);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateTenantPasswordSpan(long tenantSid, String value) {
        TenantMetadataColumn column = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"basic", "passwordSpan"});
        if (column == null) {
            TenantMetadataColumn col = new TenantMetadataColumn();
            col.setCatalogId("basic");
            col.setKey("passwordSpan");
            col.setName("\u5bc6\u7801\u8fc7\u671f\u65f6\u95f4");
            col.setType("string");
            col.setTypeParameter("[]");
            this.tenantMetadataColumnCrudService.create(col);
            column = col;
        }
        this.saveMetadataValue(tenantSid, value, column);
    }

    private void saveMetadataValue(long tenantSid, String value, TenantMetadataColumn column) {
        TenantMetadata newestMetadata = (TenantMetadata)this.tenantMetadataCrudService.findByUnionKey(new Object[]{tenantSid, column.getSid()});
        if (newestMetadata == null) {
            newestMetadata = new TenantMetadata();
            newestMetadata.setTenantSid(tenantSid);
            newestMetadata.setColumnSid(column.getSid());
            newestMetadata.setValue(value);
            this.tenantMetadataCrudService.create((BaseEntity)newestMetadata);
        } else {
            newestMetadata.setValue(value);
            this.tenantMetadataCrudService.update((BaseEntity)newestMetadata);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateTenantAttempts(long tenantSid, String value) {
        TenantMetadataColumn column = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"basic", "passwordAttempts"});
        if (column == null) {
            TenantMetadataColumn col = new TenantMetadataColumn();
            col.setCatalogId("basic");
            col.setKey("passwordAttempts");
            col.setName("\u5bc6\u7801\u5c1d\u8bd5\u6b21\u6570");
            col.setType("string");
            col.setTypeParameter("[]");
            this.tenantMetadataColumnCrudService.create(col);
            column = col;
        }
        this.saveMetadataValue(tenantSid, value, column);
    }

    @Override
    public void updateTenantEocEntrance(long tenantSid, String value) {
        TenantMetadataColumn column = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"basic", "eocEntrance"});
        if (column == null) {
            TenantMetadataColumn col = new TenantMetadataColumn();
            col.setCatalogId("basic");
            col.setKey("eocEntrance");
            col.setName("eoc\u5165\u53e3");
            col.setType("string");
            col.setTypeParameter("[]");
            this.tenantMetadataColumnCrudService.create(col);
            column = col;
        }
        this.saveMetadataValue(tenantSid, value, column);
    }

    @Override
    public void updateTenantAutoEOC(long tenantSid, String value) {
        TenantMetadataColumn column = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"basic", "autoEOC"});
        if (column == null) {
            TenantMetadataColumn col = new TenantMetadataColumn();
            col.setCatalogId("basic");
            col.setKey("autoEOC");
            col.setName("\u9884\u8bbeeoc\u5458\u5de5");
            col.setType("string");
            col.setTypeParameter("[]");
            this.tenantMetadataColumnCrudService.create(col);
            column = col;
        }
        this.saveMetadataValue(tenantSid, value, column);
    }

    @Override
    @Transactional
    public void updateTenantMetadataValueList(long tenantSid, List<TenantMetadataVO> tenantMetadataVOList) {
        for (TenantMetadataVO vo : tenantMetadataVOList) {
            this.updateTenantMetadataValue(tenantSid, vo.getCatalogId(), vo.getKey(), vo.getValue(), true);
        }
    }
}

