/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.token.impl;

import com.digiwin.dap.middleware.auth.AuthoredDevice;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.token.LoginAuthInfo;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.service.token.AppSSOService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.Duration;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class AppSSOServiceImpl
implements AppSSOService {
    private static Logger logger = LoggerFactory.getLogger(AppSSOServiceImpl.class);
    @Autowired
    private AuthoredUserService authoredUserService;

    @Override
    public String getAuthCode(String targetAppId) {
        String redisKey = String.format("iam:login:sso:auth:code:key:%s:%s", UserUtils.getToken(), targetAppId);
        LoginAuthInfo loginAuthInfo = new LoginAuthInfo();
        loginAuthInfo.setSourceAppId(UserUtils.getSysId());
        loginAuthInfo.setTargetAppId(targetAppId);
        loginAuthInfo.setToken(UserUtils.getToken());
        String authCode = UUID.randomUUID().toString().replace("-", "");
        loginAuthInfo.setAuthCode(authCode);
        RedisUtils.set((String)redisKey, (Object)authCode, (Duration)Duration.ofHours(24L));
        String redisAuthCode = String.format("iam:login:sso:auth:code:%s", authCode);
        RedisUtils.set((String)redisAuthCode, (Object)loginAuthInfo, (Duration)Duration.ofMinutes(5L));
        return authCode;
    }

    @Override
    public IamAuthoredUser getUserTokenByAuthCode(String sourceId, String authCode, AuthoredDevice device) {
        String redisKey = String.format("iam:login:sso:auth:code:%s", authCode);
        if (!RedisUtils.hasKey((String)redisKey)) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_SSO_AUTH_CODE_NOT_EXISTED);
        }
        LoginAuthInfo loginAuthInfo = (LoginAuthInfo)RedisUtils.get((Object)redisKey, LoginAuthInfo.class);
        if (!sourceId.equalsIgnoreCase(loginAuthInfo.getSourceAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_SSO_AUTH_CODE_SOURCE_APP_NO_MATCH);
        }
        if (!UserUtils.getSysId().equalsIgnoreCase(loginAuthInfo.getTargetAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_SSO_AUTH_CODE_TARGET_APP_NO_MATCH);
        }
        if (ObjectUtils.isEmpty((Object)loginAuthInfo.getToken())) {
            logger.error("\u4e34\u65f6\u6388\u6743\u7801:{}\u6240\u793a\u7684token\u4e3a\u7a7a", (Object)authCode);
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_TOKEN_NOT_EXISTED);
        }
        RedisUtils.delete((String)redisKey);
        return this.authoredUserService.refreshUserTokenInSys(loginAuthInfo.getToken(), new Sys(UserUtils.getAuthoredSys()), device);
    }
}

