/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.token.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.token.GrantTypeInfo;
import com.digiwin.dap.middleware.iam.domain.token.OtaParameter;
import com.digiwin.dap.middleware.iam.domain.token.OtaResponseVO;
import com.digiwin.dap.middleware.iam.domain.token.OtaResultVO;
import com.digiwin.dap.middleware.iam.entity.OtaToken;
import com.digiwin.dap.middleware.iam.service.token.OtaTokenCrudService;
import com.digiwin.dap.middleware.iam.service.token.OtaTokenService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.remote.OtaCallBackService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OtaTokenServiceImpl
implements OtaTokenService {
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private OtaCallBackService otaCallBackService;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    private OtaTokenCrudService otaTokenCrudService;

    @Override
    public OtaResultVO checkOtaToken(IamAuthoredUser authoredUser, GrantTypeInfo grantTypeInfo, OtaToken otaToken) {
        OtaParameter otaParameter;
        Long userSid;
        long now = System.currentTimeMillis();
        String errorStr = "";
        int errorCode = 200;
        if (now > otaToken.getExpiresIn() || otaToken.isUsed()) {
            errorStr = "otaToken\u8fc7\u671f\u6216\u5df2\u88ab\u4f7f\u7528\uff01";
            errorCode = 500;
        }
        if (!(StringUtils.isEmpty((Object)grantTypeInfo.getVerifyUserId()) || (userSid = this.userMappingService.getUserSidByVerifyUserId(authoredUser.getTenantSid(), otaToken.getAppId(), grantTypeInfo.getVerifyUserId(), grantTypeInfo.getAccount())) != null && userSid.longValue() == authoredUser.getSid())) {
            errorStr = String.format("\u79df\u6237[%s]\u4e0b\u7684\u5e94\u7528[%s]\u6ca1\u6709\u6b64\u7528\u6237[%s]\u7684\u6620\u5c04\u5173\u7cfb,\u6216\u6620\u5c04\u7528\u6237\u4e0e\u5f53\u524d\u767b\u5f55\u4e0d\u4e00\u81f4\uff01", authoredUser.getTenantId(), otaToken.getAppId(), grantTypeInfo.getVerifyUserId());
            errorCode = 500;
        }
        if (errorCode != 200) {
            otaParameter = new OtaParameter(String.valueOf(otaToken.getSid()), errorCode, otaToken.getParameter());
            otaParameter.setErrorMsg(errorStr);
            this.otaCallBackService.callBack(otaToken.getCallBack(), otaParameter);
            throw new BusinessException((ErrorHandler)I18nError.OTA_TOKEN_PARSE_FAILED);
        }
        otaParameter = new OtaParameter(200, authoredUser, otaToken);
        OtaResponseVO response = this.otaCallBackService.callBack(otaToken.getCallBack(), otaParameter);
        return new OtaResultVO(authoredUser.getUserId(), response);
    }
}

