/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.VerificationCodeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.user.ActivateUserVO;
import com.digiwin.dap.middleware.iam.domain.user.EmailMessage;
import com.digiwin.dap.middleware.iam.domain.user.RegisterUserVO;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.user.WeChatRegisterUserVO;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.user.RegisterService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.validate.OtherValidateService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.util.FileUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class RegisterServiceImpl
implements RegisterService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private MetadataUpdateService metadataUpdateService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private OtherValidateService otherValidateService;

    @Override
    @Transactional
    public void registerByTelephoneVerifyCode(RegisterUserVO userVO) {
        String scene = "register";
        this.otherValidateService.verifyRegisterBody(userVO, true, true, false);
        if (!this.remoteEMCService.checkVerificationCode(userVO.getTelephone(), scene, userVO.getVerificationCode())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_REGISTER_ERROR_15);
        }
        long userSid = this.userCrudService.create((BaseEntity)new User(userVO, this.envProperties.getCloud()));
        userVO.setUserSid(userSid);
        UserMetadataVO userMetadataVO = new UserMetadataVO("contact", "mobilephone1", userVO.getTelephone(), 0L, userSid);
        this.metadataUpdateService.updateMetadataValue(userMetadataVO);
    }

    @Override
    @Transactional
    public void registerByEmailVerifyCode(RegisterUserVO userVO) {
        String scene = "register";
        this.otherValidateService.verifyRegisterBody(userVO, true, false, true);
        Assert.notNull((Object)userVO.getVerificationCode(), (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (!this.remoteEMCService.checkVerificationCode(userVO.getEmail(), scene, userVO.getVerificationCode())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_REGISTER_ERROR_15);
        }
        long userSid = this.userCrudService.create((BaseEntity)new User(userVO, this.envProperties.getCloud()));
        userVO.setUserSid(userSid);
        UserMetadataVO userMetadataVO = new UserMetadataVO("contact", "email", userVO.getEmail(), 0L, userSid);
        this.metadataUpdateService.updateMetadataValue(userMetadataVO);
    }

    @Override
    @Transactional
    public void registerByEmailActivationLink(RegisterUserVO userVO) {
        String scene = "activate";
        this.otherValidateService.verifyRegisterBody(userVO, false, false, true);
        User user = new User();
        user.setId(userVO.getId());
        user.setName(userVO.getName());
        user.setEmail(userVO.getEmail());
        user.setPassword(DigestUtils.sha256((String)userVO.getPassword()));
        user.setChanged(true);
        user.setPurpose("normal");
        user.setAgreeAgreement(Optional.ofNullable(user.getAgreeAgreement()).orElse(Boolean.FALSE));
        long userSid = this.userCrudService.create((BaseEntity)user);
        UserMetadataVO userMetadataVO = new UserMetadataVO("contact", "email", userVO.getEmail(), 0L, userSid);
        this.metadataUpdateService.updateMetadataValue(userMetadataVO);
        this.sendActivateEmail(userSid, userVO.getEmail(), scene);
    }

    @Override
    @Transactional
    public void registerWithoutVerifyCode(RegisterUserVO userVO) {
        boolean checkTelephone = !StringUtils.isEmpty((Object)userVO.getTelephone());
        boolean checkEmail = !StringUtils.isEmpty((Object)userVO.getEmail());
        this.otherValidateService.verifyRegisterBody(userVO, false, checkTelephone, checkEmail);
        long sid = this.userCrudService.create((BaseEntity)new User(userVO, this.envProperties.getCloud()));
        userVO.setUserSid(sid);
    }

    @Override
    public void applyActivate(String account) {
        String scene = "activate";
        User user = this.userRepository.findFirstByEmailAndType(account, 0);
        Assert.notNull((Object)((Object)user), (String)"\u8be5\u8d26\u53f7\u6ce8\u518c\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6fc0\u6d3b\uff01");
        if (user.isActivated()) {
            throw new BusinessException((ErrorHandler)I18nError.USER_HAS_ACTIVATE);
        }
        this.sendActivateEmail(user.getSid(), account, scene);
    }

    @Override
    public void activateUser(ActivateUserVO userVO) {
        String scene = "activate";
        Optional user = this.userRepository.findById(userVO.getSid());
        if (!user.isPresent()) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        if (((User)((Object)user.get())).isActivated()) {
            throw new BusinessException((ErrorHandler)I18nError.USER_HAS_ACTIVATE);
        }
        if (!this.remoteEMCService.checkVerificationCode(userVO.getAccount(), scene, userVO.getActivateCode())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_REGISTER_ERROR_15);
        }
        ((User)((Object)user.get())).setActivated(true);
        this.userCrudService.update((BaseEntity)user.get());
    }

    @Override
    @Transactional
    public void registerByWeChat(WeChatRegisterUserVO weChatRegisterUserVO) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!StringUtil.isInt(weChatRegisterUserVO.getTelephone())) {
            stringBuilder.append(String.format("user.Telephone\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a[%s]\uff01", weChatRegisterUserVO.getTelephone()));
        }
        if (this.userRepository.existsByTelephoneAndType(weChatRegisterUserVO.getTelephone(), 0)) {
            stringBuilder.append(String.format("\u8be5\u624b\u673a\u53f7\u5df2\u7ecf\u6ce8\u518c\uff1a[%s]\uff01", weChatRegisterUserVO.getTelephone()));
        }
        if (!Strings.isBlank((String)stringBuilder.toString())) {
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        if (!this.remoteEMCService.checkVerificationCode(weChatRegisterUserVO.getTelephone(), "register", weChatRegisterUserVO.getVerificationCode())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_REGISTER_ERROR_15);
        }
        User user = new User();
        String userId = this.getUserId(weChatRegisterUserVO.getTelephone());
        user.setId(userId);
        user.setName(weChatRegisterUserVO.getName());
        user.setActivated(true);
        user.setComeFrom("wechat");
        user.setWechat(weChatRegisterUserVO.getOpenId());
        user.setTelephone(weChatRegisterUserVO.getTelephone());
        user.setPassword(DigestUtils.sha256((String)"88888888"));
        user.setAgreeAgreement(Optional.ofNullable(weChatRegisterUserVO.getAgreeAgreement()).orElse(Boolean.FALSE));
        user.setPurpose("normal");
        this.userCrudService.create((BaseEntity)user);
    }

    @Override
    @Transactional
    public void registerUser(RegisterUserVO body) {
        if (VerificationCodeTypeEnum.EMAIL.getValue().equals(body.getVerificationCodeType())) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)body.getEmailHash())) {
                String email = AES.decrypt((String)body.getEmailHash(), (String)KeyConstant.WECHAT_UNION_ID);
                body.setEmail(email);
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)body.getEmail())) {
                throw new IllegalArgumentException(I18nCode.EXCEL_IMPORT_USER_EMAIL_EMPTY.getMessage());
            }
            this.otherValidateService.checkInsideEmail(body.getEmail());
            this.registerByEmailVerifyCode(body);
        } else if (VerificationCodeTypeEnum.TELEPHONE.getValue().equals(body.getVerificationCodeType())) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)body.getTelephoneHash())) {
                String telephone = AES.decrypt((String)body.getTelephoneHash(), (String)KeyConstant.WECHAT_UNION_ID);
                body.setTelephone(telephone);
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)body.getEmail()) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)body.getEmailHash())) {
                body.setEmail(AES.decrypt((String)body.getEmailHash(), (String)KeyConstant.WECHAT_UNION_ID));
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)body.getTelephone())) {
                throw new IllegalArgumentException(I18nCode.EXCEL_IMPORT_USER_TELEPHONE_EMPTY.getMessage());
            }
            this.registerByTelephoneVerifyCode(body);
        } else if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry())) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)body.getEmail())) {
                this.otherValidateService.checkInsideEmail(body.getEmail());
                this.registerByEmailVerifyCode(body);
            } else {
                this.registerByTelephoneVerifyCode(body);
            }
        } else if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)body.getTelephone())) {
            this.registerByTelephoneVerifyCode(body);
        } else {
            this.otherValidateService.checkInsideEmail(body.getEmail());
            this.registerByEmailVerifyCode(body);
        }
    }

    private String getUserId(String id) {
        String userId;
        if (this.userCrudService.existsById(id)) {
            userId = id + StrUtils.getRandomCode();
            this.getUserId(userId);
        } else {
            userId = id;
        }
        return userId;
    }

    private void sendActivateEmail(long userSid, String email, String scene) {
        String content;
        Map<String, String> result = this.remoteEMCService.getVerificationCode(email, scene);
        String link = this.envProperties.getMarketUri() + "/register/active?activateCode=" + result.get("code") + "&sid=" + userSid + "&account=" + email;
        try {
            content = FileUtil.getFile((String)"static/templates/EmailTemplate.html");
        }
        catch (IOException e) {
            throw new BusinessException((ErrorHandler)I18nError.EMAIL_TEMPLATE_READ_FAILED);
        }
        content = content.replace("digiwin_url", link);
        content = content.replace("digiwin_header", this.messageSource.getMessage("register.sendEmail.header.message", null, this.envProperties.getLocale()));
        content = content.replace("digiwin_title", this.messageSource.getMessage("register.sendEmail.title.message", null, this.envProperties.getLocale()));
        content = content.replace("digiwin_wenhao", this.messageSource.getMessage("register.sendEmail.hello.message", null, this.envProperties.getLocale()));
        content = content.replace("digiwin_content", this.messageSource.getMessage("register.sendEmail.content.message", null, this.envProperties.getLocale()));
        EmailMessage message = new EmailMessage();
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(email);
        message.setUserIds(userIds);
        message.setTitle(this.messageSource.getMessage("register.sendEmail.title.message", null, this.envProperties.getLocale()));
        message.setMsgType("text");
        message.setContent(content);
        this.remoteEMCService.sendMessage(message, 0);
    }
}

