/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.user.UpdatePasswordByAccountVO;
import com.digiwin.dap.middleware.iam.domain.user.UpdatePasswordByIdVO;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UpdatePasswordService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.DeferredExecutionService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import java.util.Arrays;
import java.util.Collections;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UpdatePasswordServiceImpl
implements UpdatePasswordService {
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private DeferredExecutionService deferredExecutionService;

    @Override
    @Transactional
    public void updatePasswordByOldPassword(UpdatePasswordByIdVO body) {
        User user = body.getSid() > 0L ? (User)this.userCrudService.findBySid(body.getSid()) : (User)this.userCrudService.findById(body.getId());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_USER_NOT_EXIST);
        }
        if (Strings.isBlank((String)body.getOldPasswordHash1())) {
            body.setOldPasswordHash1(user.getSalt() != null ? DigestUtils.md5Hex((String)(body.getOldPassword() + user.getSalt())) : DigestUtils.md5Hex((String)body.getOldPassword()));
        }
        if (!body.getOldPasswordHash().equals(user.getPassword()) && !user.getPassword().equals(body.getOldPasswordHash1())) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_INCORRECT_ERROR);
        }
        this.updatePasswordCore(user, true, body.getNewPassword());
    }

    @Override
    @Transactional
    public void updatePasswordByVerificationCode(UpdatePasswordByAccountVO userVO) {
        String scene = "changepassword";
        User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(userVO.getAccount(), userVO.getAccount(), userVO.getAccount(), null);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{userVO.getAccount()});
        }
        if (!this.remoteEMCService.checkVerificationCode(userVO.getAccount(), scene, userVO.getVerificationCode())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_VERIFICATION_CODE_ERROR);
        }
        this.updatePasswordCore(user, true, userVO.getPassword());
    }

    @Override
    @Transactional
    public void updatePasswordCore(User user, Boolean changed, String password) {
        User oldUser = new User();
        BeanUtils.copyProperties((Object)((Object)user), (Object)((Object)oldUser));
        user.setPassword(DigestUtils.sha256((String)password));
        user.setChanged(changed);
        this.userCrudService.update((BaseEntity)user);
        this.deferredExecutionService.runAfterCommit(() -> this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.USER_PASSWORD_UPDATE.getName(), (Object)oldUser, (Object)user, String.valueOf(user.getSid()), Arrays.asList("id"), Arrays.asList("password", "changed"), Collections.singletonMap("password", password)));
    }
}

