/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryPageVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserCondition;
import com.digiwin.dap.middleware.iam.domain.user.UserInOrgVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInfoForKanBanVO;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.user.UserWithTenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.ServiceAuthorizationRecord;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.ServiceAuthorizationRecordMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInOrgMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInTagMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataQueryService;
import com.digiwin.dap.middleware.iam.service.org.OrgQueryService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserBasicInfoQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserBasicInfoQueryServiceImpl
implements UserBasicInfoQueryService {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInTagMapper userInTagMapper;
    @Autowired
    private OrgQueryService orgQueryService;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    private MetadataQueryService metadataQueryService;
    @Autowired
    private UserInOrgQueryService userInOrgQueryService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private UserInOrgMapper userInOrgMapper;
    @Autowired
    private UserInRoleQueryService userInRoleQueryService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private ServiceAuthorizationRecordMapper serviceAuthorizationRecordMapper;

    @Override
    public List<UserBasicInfoVO> getUserBasicInfosByTenant(long tenantSid, String content) {
        ArrayList<UserBasicInfoVO> userBasicInfoVOs = new ArrayList<UserBasicInfoVO>();
        String searchContent = content == null ? "%%" : "%" + content + "%";
        List<User> users = this.userMapper.getUsersByTenantSidAndContent(tenantSid, searchContent);
        for (User user : users) {
            UserBasicInfoVO userBasicInfoVO = this.getUserBasicInfo(tenantSid, user);
            userBasicInfoVOs.add(userBasicInfoVO);
        }
        return userBasicInfoVOs;
    }

    @Override
    public UserBasicInfoResultVO getUserBasicInfosByTenantWithPage(long tenantSid, QueryPageVO queryPageVO) {
        UserBasicInfoResultVO resultVO = new UserBasicInfoResultVO();
        ArrayList<UserBasicInfoVO> userBasicInfoVOs = new ArrayList<UserBasicInfoVO>();
        queryPageVO.setTenantSid(tenantSid);
        List<UserWithTenantInfoVO> users = this.userMapper.getUsersByTenantSidAndContentWithPage(queryPageVO, queryPageVO.getPageNumber(), queryPageVO.getPageCount(), queryPageVO.getOrderBy());
        for (UserWithTenantInfoVO userInfo : users) {
            User user = new User();
            BeanUtils.mergeDifferentTypeObject((Object)userInfo, (Object)((Object)user));
            UserBasicInfoVO userBasicInfoVO = this.getUserBasicInfo(tenantSid, user);
            if (Boolean.TRUE.equals(userInfo.getUserType())) {
                userBasicInfoVO.setUserType(1);
            } else {
                userBasicInfoVO.setUserType(0);
            }
            userBasicInfoVO.setUserTenantCreateDate(userInfo.getJoinDate());
            userBasicInfoVOs.add(userBasicInfoVO);
        }
        resultVO.setTotalCount(PageSerializable.of(users).getTotal());
        resultVO.setUserBasicInformation(userBasicInfoVOs);
        return resultVO;
    }

    @Override
    public UserBasicInfoResultVO getDisableUserBasicInfosByTenantWithPage(long tenantSid, QueryPageVO queryPageVO) {
        UserBasicInfoResultVO resultVO = new UserBasicInfoResultVO();
        ArrayList<UserBasicInfoVO> userBasicInfoVOs = new ArrayList<UserBasicInfoVO>();
        queryPageVO.setTenantSid(tenantSid);
        List<User> users = this.userMapper.getDisableUsersByTenantSidAndContentWithPage(queryPageVO, queryPageVO.getPageNumber(), queryPageVO.getPageCount(), null);
        for (User user : users) {
            UserBasicInfoVO userBasicInfoVO = this.getUserBasicInfo(tenantSid, user);
            userBasicInfoVOs.add(userBasicInfoVO);
        }
        resultVO.setTotalCount(PageSerializable.of(users).getTotal());
        resultVO.setUserBasicInformation(userBasicInfoVOs);
        return resultVO;
    }

    @Override
    public UserBasicInfoResultVO getEnableUserBasicInfosByTenantWithPage(long tenantSid, QueryPageVO queryPageVO) {
        UserBasicInfoResultVO resultVO = new UserBasicInfoResultVO();
        ArrayList<UserBasicInfoVO> userBasicInfoVOs = new ArrayList<UserBasicInfoVO>();
        queryPageVO.setTenantSid(tenantSid);
        List<User> users = this.userMapper.getEnableUsersByTenantSidAndContentWithPage(queryPageVO, queryPageVO.getPageNumber(), queryPageVO.getPageCount(), null);
        for (User user : users) {
            UserBasicInfoVO userBasicInfoVO = this.getUserBasicInfo(tenantSid, user);
            userBasicInfoVOs.add(userBasicInfoVO);
        }
        resultVO.setTotalCount(PageSerializable.of(users).getTotal());
        resultVO.setUserBasicInformation(userBasicInfoVOs);
        return resultVO;
    }

    @Override
    public List<UserBasicInfoVO> getUserBasicInfosByUserIds(long tenantSid, List<String> userIds) {
        ArrayList<UserBasicInfoVO> userBasicInfoVOs = new ArrayList<UserBasicInfoVO>();
        for (String userId : userIds) {
            long userSid = this.userCrudService.getSidById(userId);
            if (userSid == 0L) {
                throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userId});
            }
            UserCondition userCondition = new UserCondition.Builder().sid(userSid).build();
            User user = this.userMapper.queryUserByTenantSidAndCondition(tenantSid, userCondition);
            if (user == null) {
                throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_EXISTED_ERROR, new Object[]{tenantSid, userId});
            }
            UserBasicInfoVO userBasicInfoVO = this.getUserBasicInfo(tenantSid, user);
            userBasicInfoVOs.add(userBasicInfoVO);
        }
        return userBasicInfoVOs;
    }

    @Override
    public List<UserBasicInfoVO> getUserBasicInfosByOrg(long tenantSid, List<String> orgUris) {
        ArrayList<UserBasicInfoVO> userBasicInfoVOs = new ArrayList<UserBasicInfoVO>();
        ArrayList<User> users = new ArrayList<User>();
        for (String orgUri : orgUris) {
            long orgSid = this.orgQueryService.getOrgSidByUri(tenantSid, orgUri);
            users.addAll(this.userCrudService.queryUserByOrg(tenantSid, orgSid));
        }
        for (User user : users) {
            UserBasicInfoVO userBasicInfoVO = this.getUserBasicInfo(tenantSid, user);
            userBasicInfoVOs.add(userBasicInfoVO);
        }
        return userBasicInfoVOs;
    }

    @Override
    public UserBasicInfoResultVO getUserBasicInfosByOrgWithPage(long tenantSid, List<Long> orgSids, QueryPageVO page) {
        UserBasicInfoResultVO resultVO = new UserBasicInfoResultVO();
        ArrayList<UserBasicInfoVO> userBasicInfoVOs = new ArrayList<UserBasicInfoVO>();
        List<User> users = this.userMapper.getUsersByOrgSids(orgSids, page.getContent(), page.getPageNumber().intValue(), page.getPageCount().intValue());
        PageSerializable userPage = new PageSerializable(users);
        users.forEach(user -> {
            UserBasicInfoVO userBasicInfoVO = this.getUserBasicInfo(tenantSid, (User)((Object)user));
            userBasicInfoVOs.add(userBasicInfoVO);
        });
        resultVO.setUserBasicInformation(userBasicInfoVOs);
        resultVO.setTotalCount((int)userPage.getTotal());
        return resultVO;
    }

    @Override
    public UserBasicInfoVO getUserBasicInfo(long tenantSid, User user) {
        Tenant tenant;
        UserBasicInfoVO userBasicInfoVO = new UserBasicInfoVO();
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenantSid, user.getSid());
        if (userInTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_EXISTED_ERROR, new Object[]{tenantSid, user.getId()});
        }
        List<UserMetadataVO> userMetadataVOS = this.metadataQueryService.queryUserMetadataByTenantSidAndUserSid(tenantSid, user.getSid());
        List<UserMappingQueryResultVO> identityInfo = this.userMappingService.getMappedByUser(tenantSid, user.getSid());
        List<QueryUserInOrgResultVO> orgVOS = this.userInOrgQueryService.queryUserInOrgByUser(tenantSid, user.getSid());
        List<QueryRoleResultVO> roleVOS = this.userInRoleQueryService.queryUserInRoleByUserWithLanguage(tenantSid, user.getSid());
        ServiceAuthorizationRecord record = this.serviceAuthorizationRecordMapper.selectByUserSidAndTenantSid(user.getSid(), tenantSid, Boolean.FALSE);
        if (record != null) {
            userBasicInfoVO.setServiceAuthorizationCode(record.getCode());
        }
        if ((tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid)).getOwnerUserSid() == user.getSid()) {
            user.setReadonly(true);
        }
        userBasicInfoVO.setEnabled(!userInTenant.isDisabled());
        userBasicInfoVO.setDueDate(userInTenant.getDueDate());
        userBasicInfoVO.setTenantVisible(userInTenant.isTenantVisible());
        if (userInTenant.isUserType()) {
            userBasicInfoVO.setUserType(1);
        } else {
            userBasicInfoVO.setUserType(0);
        }
        userBasicInfoVO.setUser(user);
        userBasicInfoVO.setRole(roleVOS);
        userBasicInfoVO.setUserInOrg(orgVOS);
        userBasicInfoVO.setMapping(identityInfo);
        userBasicInfoVO.setMetadata(userMetadataVOS);
        return userBasicInfoVO;
    }

    @Override
    public List<UserInfoForKanBanVO> getUserInfo(long tenantSid, long userSid) {
        ArrayList<UserInfoForKanBanVO> userInfoForKanBanVOS = new ArrayList<UserInfoForKanBanVO>();
        UserInfoForKanBanVO userInfoForKanBanVO = new UserInfoForKanBanVO();
        String tenantId = this.tenantRepository.findIdBySid(tenantSid);
        User user = (User)this.userCrudService.findBySid(userSid);
        List<Map> roleVOS = this.userInRoleMapper.queryUserInRoleSimpleInfo(tenantSid, user.getSid());
        List<UserInOrgVO> orgVOS = this.userInOrgMapper.queryUserInOrgInfo(tenantSid, user.getSid());
        userInfoForKanBanVO.setTenantId(tenantId);
        userInfoForKanBanVO.setId(user.getId());
        userInfoForKanBanVO.setName(user.getName());
        userInfoForKanBanVO.setEmail(user.getEmail());
        userInfoForKanBanVO.setMobilephone(user.getTelephone());
        userInfoForKanBanVO.setRoles(roleVOS);
        userInfoForKanBanVO.setUserInOrgs(orgVOS);
        userInfoForKanBanVOS.add(userInfoForKanBanVO);
        return userInfoForKanBanVOS;
    }

    @Override
    public List<UserInfoForKanBanVO> getUserInfoByRoleSid(long tenantSid, String roleId) {
        ArrayList<UserInfoForKanBanVO> userInfoForKanBanVOS = new ArrayList<UserInfoForKanBanVO>();
        String tenantId = this.tenantRepository.findIdBySid(tenantSid);
        Role role = this.roleCrudService.findByTenantSidAndId(tenantSid, roleId);
        List<User> users = this.userInRoleQueryService.queryUsersInRole(tenantSid, role.getSid(), 0);
        users.forEach(user -> userInfoForKanBanVOS.add(this.getUserInfoForKanBanVO((User)((Object)user), tenantSid, tenantId)));
        return userInfoForKanBanVOS;
    }

    @Override
    public List<UserInfoForKanBanVO> getUserInfoByOrgSid(long tenantSid, long orgSid) {
        ArrayList<UserInfoForKanBanVO> userInfoForKanBanVOS = new ArrayList<UserInfoForKanBanVO>();
        String tenantId = this.tenantRepository.findIdBySid(tenantSid);
        List<User> users = this.userInOrgMapper.findUsersByOrgSid(tenantSid, orgSid);
        users.forEach(user -> userInfoForKanBanVOS.add(this.getUserInfoForKanBanVO((User)((Object)user), tenantSid, tenantId)));
        return userInfoForKanBanVOS;
    }

    private UserInfoForKanBanVO getUserInfoForKanBanVO(User user, long tenantSid, String tenantId) {
        List<Map> roleVOS = this.userInRoleMapper.queryUserInRoleSimpleInfo(tenantSid, user.getSid());
        List<UserInOrgVO> orgVOS = this.userInOrgMapper.queryUserInOrgInfo(tenantSid, user.getSid());
        UserInfoForKanBanVO userInfoForKanBanVO = new UserInfoForKanBanVO();
        userInfoForKanBanVO.setTenantId(tenantId);
        userInfoForKanBanVO.setId(user.getId());
        userInfoForKanBanVO.setName(user.getName());
        userInfoForKanBanVO.setEmail(user.getEmail());
        userInfoForKanBanVO.setMobilephone(user.getTelephone());
        userInfoForKanBanVO.setRoles(roleVOS);
        userInfoForKanBanVO.setUserInOrgs(orgVOS);
        return userInfoForKanBanVO;
    }
}

