/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.CellphonePrefixEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.constant.enums.UserTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.user.ContactVO;
import com.digiwin.dap.middleware.iam.domain.user.UpdatePasswordByAccountVO;
import com.digiwin.dap.middleware.iam.domain.user.UpdateUserBasicInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoInTenantUpdateVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserUnfreezeDTO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.service.login.LoginFailureHandlingService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserApplicationService;
import com.digiwin.dap.middleware.iam.service.user.UserBasicInfoUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.obsolete.service.UserV2Service;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteLMCService;
import com.digiwin.dap.middleware.iam.support.validate.OtherValidateService;
import com.digiwin.dap.middleware.iam.util.CellPhoneUtil;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import eu.bitwalker.useragentutils.DeviceType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class UserBasicInfoUpdateServiceImpl
implements UserBasicInfoUpdateService {
    private static final Logger log = LoggerFactory.getLogger(UserBasicInfoUpdateServiceImpl.class);
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private MetadataUpdateService metadataUpdateService;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private OtherValidateService otherValidateService;
    @Autowired
    private UserV2Service userV2Service;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private LoginFailureHandlingService loginFailureHandlingService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private UserApplicationService userApplicationService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private RemoteLMCService remoteLMCService;
    @Autowired
    private UserInOrgUpdateService userInOrgUpdateService;

    @Override
    public long updateUser(UserInfo userInfo) {
        User user;
        if (userInfo.getSid() != 0L) {
            user = (User)this.userCrudService.findBySid(userInfo.getSid());
            if (!"ServiceCloud".equals(userInfo.getComeFrom()) && !user.getId().equals(userInfo.getId())) {
                throw new BusinessException((ErrorHandler)I18nError.UPDATE_USER_ID_ERROR);
            }
        } else {
            user = (User)this.userCrudService.findById(userInfo.getId());
        }
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userInfo.getId()});
        }
        this.otherValidateService.verifyUserProperties(userInfo, user, false);
        this.updateUserAndTenantInfo(userInfo, user, true);
        return user.getSid();
    }

    @Override
    public User updateServiceCloudUser(UserInfo userInfo, User user) {
        this.otherValidateService.verifyUserProperties(userInfo, user, false);
        if (!"ServiceCloud".equalsIgnoreCase(user.getComeFrom())) {
            return this.updateUserAndTenantInfo(userInfo, user, false);
        }
        return this.updateUserAndTenantInfo(userInfo, user, true);
    }

    private User updateUserAndTenantInfo(UserInfo userInfo, User user, boolean updated) {
        Tenant tenant = this.tenantCrudService.findIndividualTenant(user.getSid(), TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue());
        if (tenant != null) {
            Optional.ofNullable(userInfo.getName()).filter(StringUtils::hasText).ifPresent(tenant::setName);
            Optional.ofNullable(userInfo.getEmail()).filter(StringUtils::hasText).ifPresent(tenant::setEmail);
            Optional.ofNullable(userInfo.getAddress()).filter(StringUtils::hasText).ifPresent(tenant::setAddress);
            Optional.ofNullable(userInfo.getPhone()).filter(StringUtils::hasText).ifPresent(tenant::setPhone);
            Optional.ofNullable(userInfo.getTelephone()).filter(StringUtils::hasText).ifPresent(tenant::setTelephone);
            Optional.ofNullable(userInfo.getCellphonePrefix()).filter(StringUtils::hasText).ifPresent(tenant::setCellphonePrefix);
            this.tenantCrudService.update((BaseEntity)tenant);
        }
        User oldUser = new User();
        BeanUtil.copyProperties((Object)((Object)user), (Object)((Object)oldUser), (String[])new String[0]);
        if (updated) {
            boolean invalidateTokenCache = Boolean.TRUE.equals(user.getDoubleCheck()) && Boolean.FALSE.equals(userInfo.getDoubleCheck());
            ContactVO contactVO = new ContactVO();
            userInfo.setId(user.getId());
            userInfo.setPassword(user.getPassword());
            userInfo.setSid(user.getSid());
            userInfo.setId(user.getId());
            userInfo.setDevAgreementSigned(user.isDevAgreementSigned());
            contactVO.setOldEmail(user.getEmail());
            contactVO.setUserSid(user.getSid());
            String oldTelephone = user.getTelephone();
            contactVO.setOldTelephone(oldTelephone);
            BeanUtils.mergeDifferentTypeObject((Object)userInfo, (Object)((Object)user));
            if (StringUtils.isEmpty((Object)user.getCellphonePrefix())) {
                user.setCellphonePrefix(CellPhoneUtil.getCellPhoneDefault(this.envProperties.getCountry(), user.getTelephone()));
            }
            if (!StringUtils.isEmpty((Object)userInfo.getName())) {
                user.setName(userInfo.getName());
            }
            if (!StringUtils.isEmpty((Object)userInfo.getTelephone())) {
                user.setTelephone(userInfo.getTelephone());
            } else {
                user.setTelephone(StringUtils.hasLength((String)oldTelephone) ? oldTelephone : "");
            }
            user.setDisabled(false);
            this.userCrudService.update((BaseEntity)user);
            this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.USER_UPDATE.getName(), (Object)oldUser, (Object)user, Arrays.asList(ChangeTypeEnum.USER_UPDATE.getPrimaryKey()), Arrays.asList("name", "telephone", "disabled", "cellphonePrefix"));
            contactVO.setTelephone(userInfo.getTelephone());
            contactVO.setEmail(userInfo.getEmail());
            if (invalidateTokenCache) {
                for (DeviceType value : DeviceType.values()) {
                    RedisUtils.delete((String)LoginUser.verificationSuccessKey(user.getId(), value));
                }
            }
            this.messageService.sendChangeContactMessage(contactVO);
        } else if (Boolean.TRUE.equals(user.isDisabled())) {
            user.setDisabled(false);
            this.userCrudService.update((BaseEntity)user);
            this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.USER_UPDATE.getName(), (Object)oldUser, (Object)user, Arrays.asList(ChangeTypeEnum.USER_UPDATE.getPrimaryKey()), Arrays.asList("disabled"));
        }
        return user;
    }

    @Override
    public User create(UserInfo userInfo, Boolean enterprise) {
        return this.create(userInfo, enterprise, false);
    }

    @Override
    public User create(UserInfo userInfo, Boolean enterprise, boolean isImport) {
        if (Objects.isNull(userInfo.getType())) {
            userInfo.setType(enterprise != false ? UserTypeEnum.INTERNAL.getCode() : UserTypeEnum.NORMAL.getCode());
        }
        log.info("\u521b\u5efa\u7528\u6237{},enterprise{}", (Object)userInfo, (Object)enterprise);
        User user = new User();
        user.setType(enterprise != false ? UserTypeEnum.INTERNAL.getCode() : UserTypeEnum.NORMAL.getCode());
        this.otherValidateService.verifyUserProperties(userInfo, user, true);
        BeanUtils.mergeDifferentTypeObject((Object)userInfo, (Object)((Object)user));
        user.setName(userInfo.getName());
        user.setTelephone(userInfo.getTelephone());
        if (!Strings.isEmpty((CharSequence)userInfo.getPasswordHash())) {
            user.setPassword(userInfo.getPasswordHash());
        } else if (!Strings.isEmpty((CharSequence)userInfo.getPassword())) {
            user.setPassword(DigestUtils.sha256((String)userInfo.getPassword()));
        }
        user.setCellphonePrefix(CellPhoneUtil.getCellPhoneDefault(this.envProperties.getCountry(), userInfo.getTelephone()));
        user.setActivated(true);
        if (isImport) {
            if (user.getId().endsWith("@digiwin.com") || StringUtils.hasText((String)user.getEmail()) && user.getEmail().endsWith("@digiwin.com")) {
                user.setChanged(true);
            } else {
                user.setChanged(false);
            }
            user.setCellphonePrefix(userInfo.getCellphonePrefix());
        }
        this.userCrudService.create((BaseEntity)user);
        User newUser = new User();
        org.springframework.beans.BeanUtils.copyProperties((Object)((Object)user), (Object)((Object)newUser));
        newUser.setTelephone(userInfo.getTelephone());
        newUser.setName(userInfo.getName());
        this.changeLogService.createChangeLog(ChangeTypeEnum.USER_CREATE.getName(), (Object)newUser, ChangeTypeEnum.USER_CREATE.getPrimaryKey(), String.valueOf(user.getSid()));
        return newUser;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUserAllInfo(long tenantSid, UpdateUserBasicInfoVO userBasicInfoVO, boolean isCloud) {
        this.otherValidateService.verifyUserBasicInfoVO(tenantSid, userBasicInfoVO);
        if (!Strings.isEmpty((CharSequence)userBasicInfoVO.getPasswordHash())) {
            userBasicInfoVO.getUser().setPasswordHash(userBasicInfoVO.getPasswordHash());
        }
        long userSid = this.updateUser(userBasicInfoVO.getUser());
        boolean changeState = false;
        boolean isDisabled = false;
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenantSid, userSid);
        if (null == userInTenant) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_COMMON_ERROR, new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), Base64.encode((String)JsonUtils.writeValue((Object)userBasicInfoVO))});
        }
        this.updateUserInTenant(tenantSid, userSid, userBasicInfoVO.getUserType(), userBasicInfoVO.getDueDate(), userInTenant);
        this.metadataUpdateService.updateMetadataByTenant(tenantSid, userBasicInfoVO.getUser().getId(), userBasicInfoVO.getMetadata());
        ArrayList<String> roleIds = new ArrayList<String>();
        for (QueryRoleResultVO current : userBasicInfoVO.getRole()) {
            roleIds.add(current.getId());
        }
        this.userInRoleService.updateUserInRoleByUser(tenantSid, userSid, roleIds);
        this.userV2Service.updateUserInOrgByUser(tenantSid, userSid, "all", userBasicInfoVO.getUserInOrg());
        this.userV2Service.updateUserInTagByUser(tenantSid, userSid, userBasicInfoVO.getUserInTag());
        this.userApplicationService.batchAddApplication(UserUtils.getTenantId(), userBasicInfoVO.getUser().getId(), userBasicInfoVO.getApp());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUserSimpleInTenant(long tenantSid, UserBasicInfoInTenantUpdateVO userBasicInfoVO) {
        User user = (User)this.userCrudService.findById(userBasicInfoVO.getUser().getId());
        if (null == user) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userBasicInfoVO.getUser().getId()});
        }
        if (0 == user.getType()) {
            userBasicInfoVO.getUser().setTelephone(null);
            userBasicInfoVO.getUser().setEmail(null);
        }
        User newUser = new User();
        org.springframework.beans.BeanUtils.copyProperties((Object)((Object)user), (Object)((Object)newUser));
        BeanUtils.mergeDifferentTypeObject((Object)userBasicInfoVO.getUser(), (Object)((Object)newUser));
        this.userCrudService.update((BaseEntity)newUser);
        this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.USER_UPDATE.getName(), (Object)user, (Object)newUser, Arrays.asList("id"), Arrays.asList("name", "email", "cellphonePrefix", "telephone", "remark"));
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenantSid, user.getSid());
        if (null == userInTenant) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_COMMON_ERROR, new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), Base64.encode((String)JsonUtils.writeValue((Object)userBasicInfoVO))});
        }
        this.updateUserInTenant(tenantSid, user.getSid(), userBasicInfoVO.getUserType(), userBasicInfoVO.getDueDate(), userInTenant);
        this.userInRoleService.updateUserInRoleByUser(tenantSid, user.getSid(), userBasicInfoVO.getRoleIds());
        this.userInOrgUpdateService.updateUserInOrgByUser(tenantSid, user.getSid(), "all", userBasicInfoVO.getUserInOrgs());
        this.userApplicationService.batchAddApplication(UserUtils.getTenantId(), userBasicInfoVO.getUser().getId(), userBasicInfoVO.getApp());
    }

    private void updateUserInTenant(long tenantSid, long userSid, Boolean userType, LocalDateTime dueDate, UserInTenant userInTenant) {
        UserInTenant oldInfo = new UserInTenant();
        org.springframework.beans.BeanUtils.copyProperties((Object)((Object)userInTenant), (Object)((Object)oldInfo));
        userInTenant.setUserType(null == userType ? userInTenant.isUserType() : userType.booleanValue());
        this.userInTenantCrudService.update(userInTenant);
        if (dueDate != null) {
            userInTenant.setDueDate(dueDate);
            Boolean isDisabled = dueDate.isBefore(LocalDateTime.now());
            userInTenant.setDisabled(isDisabled);
            this.userInTenantCrudService.update(userInTenant);
            if (userInTenant.isDisabled()) {
                this.userInTenantCrudService.disable(userInTenant.getTenantSid(), userInTenant.getUserSid());
            }
        }
        this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.USER_TENANT_UPDATE.getName(), (Object)oldInfo, (Object)userInTenant, Arrays.asList("tenantSid", "userSid"), Arrays.asList("dueDate", "userType", "disabled"));
    }

    @Override
    @Transactional
    public void updateUserMobilePhone(long userSid, UpdatePasswordByAccountVO updateInfo) {
        User user = (User)this.userCrudService.findBySid(userSid);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        User existedUser = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(updateInfo.getAccount(), updateInfo.getAccount(), updateInfo.getAccount(), 0);
        if (existedUser != null) {
            throw new BusinessException((ErrorHandler)I18nError.PHONE_HAS_EXIST, new Object[]{updateInfo.getAccount()});
        }
        String cellphonePrefixNeedCode = CellphonePrefixEnum.MAINLAND.getPrefix();
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry())) {
            cellphonePrefixNeedCode = CellphonePrefixEnum.TAIWAN.getPrefix();
        }
        if ((updateInfo.getCellphonePrefix() == null || cellphonePrefixNeedCode.equals(updateInfo.getCellphonePrefix())) && !this.remoteEMCService.checkVerificationCode(updateInfo.getAccount(), "updatemobilephone", updateInfo.getVerificationCode())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_VERIFICATION_CODE_ERROR);
        }
        user.setTelephone(updateInfo.getAccount());
        if (updateInfo.getCellphonePrefix() != null) {
            user.setCellphonePrefix(updateInfo.getCellphonePrefix());
        }
        this.userCrudService.update((BaseEntity)user);
        Tenant tenant = this.tenantCrudService.findIndividualTenant(user.getSid(), TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue());
        if (tenant != null) {
            tenant.setTelephone(user.getTelephone());
            Optional.ofNullable(updateInfo.getCellphonePrefix()).filter(StringUtils::hasText).ifPresent(tenant::setCellphonePrefix);
            this.tenantCrudService.update((BaseEntity)tenant);
        }
    }

    @Override
    public void updateUserMobilePhone4CBM(long userSid, UpdatePasswordByAccountVO updateInfo) {
        User user = (User)this.userCrudService.findBySid(userSid);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        User existedUser = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(updateInfo.getAccount(), updateInfo.getAccount(), updateInfo.getAccount(), 0);
        if (existedUser != null) {
            throw new BusinessException((ErrorHandler)I18nError.PHONE_HAS_EXIST, new Object[]{updateInfo.getAccount()});
        }
        String cellphonePrefixNeedCode = CellphonePrefixEnum.MAINLAND.getPrefix();
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry())) {
            cellphonePrefixNeedCode = CellphonePrefixEnum.TAIWAN.getPrefix();
        }
        if ((updateInfo.getCellphonePrefix() == null || cellphonePrefixNeedCode.equals(updateInfo.getCellphonePrefix())) && !updateInfo.verificationCodeIsValid()) {
            throw new BusinessException((ErrorHandler)I18nError.USER_VERIFICATION_CODE_ERROR);
        }
        user.setTelephone(updateInfo.getAccount());
        if (updateInfo.getCellphonePrefix() != null) {
            user.setCellphonePrefix(updateInfo.getCellphonePrefix());
        }
        this.userCrudService.update((BaseEntity)user);
    }

    @Override
    @Transactional
    public void updateUserEmail(long userSid, UpdatePasswordByAccountVO updateInfo) {
        User user = (User)this.userCrudService.findBySid(userSid);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        String oldEmail = user.getEmail();
        if (this.remoteEMCService.checkVerificationCode(updateInfo.getAccount(), "updateEmail", updateInfo.getVerificationCode())) {
            user.setEmail(updateInfo.getAccount());
            this.userCrudService.update((BaseEntity)user);
            Tenant tenant = this.tenantCrudService.findIndividualTenant(user.getSid(), TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue());
            if (tenant != null) {
                tenant.setEmail(updateInfo.getAccount());
                this.tenantCrudService.update((BaseEntity)tenant);
            }
        } else {
            throw new BusinessException((ErrorHandler)I18nError.USER_VERIFICATION_CODE_ERROR);
        }
        ContactVO vo = new ContactVO();
        vo.setUserSid(user.getSid());
        vo.setUserId(user.getId());
        vo.setTenantSid(UserUtils.getTenantSid());
        vo.setOldEmail(oldEmail);
        vo.setEmail(updateInfo.getAccount());
        this.messageService.sendChangeContactMessage(vo);
    }

    @Override
    public void updateUserEmail4CBM(long userSid, UpdatePasswordByAccountVO updateInfo) {
        User user = (User)this.userCrudService.findBySid(userSid);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        if (!updateInfo.verificationCodeIsValid()) {
            throw new BusinessException((ErrorHandler)I18nError.USER_VERIFICATION_CODE_ERROR);
        }
        user.setEmail(updateInfo.getAccount());
        this.userCrudService.update((BaseEntity)user);
    }

    @Override
    @Transactional
    public void unfreeze(UserUnfreezeDTO dto) {
        if (!this.remoteEMCService.checkVerificationCode(dto.getId(), "unfreezelogin", dto.getVerificationCode(), dto.getType())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_VERIFICATION_CODE_ERROR);
        }
        this.loginFailureHandlingService.unfreeze(dto.getId());
    }

    @Override
    public void updateUserAgreeAgreement(long userSid, UpdatePasswordByAccountVO updateUserInfo) {
        User user = (User)this.userCrudService.findBySid(userSid);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        user.setAgreeAgreement(updateUserInfo.getAgreeAgreement());
        this.userCrudService.update((BaseEntity)user);
        this.remoteLMCService.saveAgreeAgreementChangeLog(UserUtils.getAuthoredSys(), UserUtils.getAuthoredUser(), user.getAgreeAgreement());
    }

    @Override
    public void updateDevAgreement(long userSid, UpdatePasswordByAccountVO updateUserInfo) {
        User user = (User)this.userCrudService.findBySid(userSid);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        user.setDevAgreementSigned(updateUserInfo.getDevAgreementSigned());
        this.userCrudService.update((BaseEntity)user);
    }
}

