/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.user.UserBindingWeChatVO;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.user.UserBindingWeChatService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserBindingWeChatServiceImpl
implements UserBindingWeChatService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RemoteEMCService remoteEMCService;

    @Override
    public void bindingWeChat(UserBindingWeChatVO userBindingWeChatVO) {
        if (userBindingWeChatVO == null) {
            throw new IllegalArgumentException("userBindingWeChatVO is null");
        }
        if (this.userRepository.existsByWechat(userBindingWeChatVO.getOpenId())) {
            throw new BusinessException((ErrorHandler)I18nError.OPEN_ID_HAS_EXIST_USER, new Object[]{userBindingWeChatVO.getOpenId()});
        }
        if (!this.remoteEMCService.checkVerificationCode(userBindingWeChatVO.getTelPhone(), "register", userBindingWeChatVO.getVerificationCode())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_VERIFICATION_CODE_ERROR);
        }
        User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(userBindingWeChatVO.getTelPhone(), userBindingWeChatVO.getTelPhone(), userBindingWeChatVO.getTelPhone(), 0);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.PHONE_NO_REGISTER, new Object[]{userBindingWeChatVO.getTelPhone()});
        }
        user.setWechat(userBindingWeChatVO.getOpenId());
        this.userCrudService.update((BaseEntity)user);
    }
}

