/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.user.UserCondition;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.OrgRepository;
import com.digiwin.dap.middleware.iam.repository.UserInOrgRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithIdManagerService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UserCrudServiceImpl
extends BaseEntityWithIdManagerService<User>
implements UserCrudService {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private OrgRepository orgRepository;
    @Autowired
    private UserInOrgRepository userInOrgRepository;

    protected UserRepository getRepository() {
        return this.userRepository;
    }

    @Override
    public List<User> findAllUser() {
        return this.userRepository.findAll();
    }

    @Override
    public boolean isEnterprise(long userSid) {
        User user = (User)this.findBySid(userSid);
        return user != null && user.isEnterprise();
    }

    @Override
    public boolean isConfirm(long userSid) {
        User user = (User)this.findBySid(userSid);
        return user != null && user.isConfirm();
    }

    @Override
    public List<User> queryUserByOrg(long tenantSid, long orgSid) {
        ArrayList<User> users = new ArrayList<User>();
        List<Long> userSids = this.userInOrgRepository.findUserSidsByOrgSid(orgSid);
        for (Long userSid : userSids) {
            UserCondition userCondition = new UserCondition.Builder().sid(userSid).build();
            User user = this.queryUserByTenantSidAndCondition(tenantSid, userCondition);
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    @Override
    public List<User> queryUserCascadeByOrg(long tenantSid, long orgSid) {
        List<User> userInParentOrg = this.queryUserByOrg(tenantSid, orgSid);
        ArrayList<User> users = new ArrayList<User>(userInParentOrg);
        ArrayList<Org> orgs = new ArrayList<Org>();
        this.queryChildOrg(orgs, orgSid);
        if (orgs.size() > 0) {
            for (Org org : orgs) {
                List<User> userInChildOrg = this.queryUserByOrg(tenantSid, org.getSid());
                users.addAll(userInChildOrg);
            }
        }
        return users;
    }

    private void queryChildOrg(List<Org> orgs, long orgSid) {
        List<Org> childOrgs = this.orgRepository.findByParentSid(orgSid);
        if (childOrgs.size() > 0) {
            orgs.addAll(childOrgs);
            for (Org org : childOrgs) {
                this.queryChildOrg(orgs, org.getSid());
            }
        }
    }

    @Override
    public User queryUserByIdOrEmailOrTelephoneAndType(String userId, String email, String telephone, Integer type) {
        List<User> userList = this.queryUserListByIdOrEmailOrTelephoneOrWechatAndType(userId, email, telephone, "", type);
        if (CollectionUtils.isEmpty(userList)) {
            return null;
        }
        userList.sort(Comparator.comparing(User::getType));
        return userList.get(0);
    }

    @Override
    public List<User> queryUserListByIdOrEmailOrTelephoneOrWechatAndType(String userId, String email, String telephone, String wechat, Integer type) {
        if (!(StringUtils.hasLength((String)userId) || StringUtils.hasLength((String)email) || StringUtils.hasLength((String)telephone) || StringUtils.hasLength((String)wechat))) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
        }
        return this.userMapper.queryUserListByIdOrEmailOrTelephoneOrWechatAndType(userId, email, telephone, wechat, type);
    }

    @Override
    public User queryUserByIdOrAliasIdAndComeFrom(String userId, String aliasId, String comeFrom) {
        return this.userMapper.queryUserByIdOrAliasIdAndComeFrom(userId, aliasId, comeFrom);
    }

    @Override
    public User queryUserByTenantSidAndCondition(Long tenantSid, UserCondition userCondition) {
        return this.userMapper.queryUserByTenantSidAndCondition(tenantSid, userCondition);
    }

    @Override
    public List<User> queryUserListByTenantSidAndCondition(Long tenantSid, UserCondition userCondition) {
        return this.userMapper.queryUserListByTenantSidAndCondition(tenantSid, userCondition);
    }
}

