/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middleware.entity.UnionKey;
import com.digiwin.dap.middleware.iam.domain.user.OrgInUserVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.entity.UserInOrg;
import com.digiwin.dap.middleware.iam.mapper.UserInOrgMapper;
import com.digiwin.dap.middleware.iam.repository.UserInOrgRepository;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgCrudService;
import com.digiwin.dap.middleware.repository.BaseEntityRepository;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithUnionKeyManagerService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserInOrgCrudServiceImpl
extends BaseEntityWithUnionKeyManagerService<UserInOrg>
implements UserInOrgCrudService {
    @Autowired
    private UserInOrgRepository userInOrgRepository;
    @Autowired
    private UserInOrgMapper userInOrgMapper;

    protected UnionKey createUnionKey() {
        return UnionKey.create().apply(UserInOrg.class).add("userSid").add("orgSid");
    }

    protected BaseEntityRepository getRepository() {
        return this.userInOrgRepository;
    }

    @Override
    public void deleteByUnionKey(long userSid, long orgSid) {
        this.userInOrgRepository.deleteByUserSidAndOrgSid(userSid, orgSid);
    }

    @Override
    public void deleteByUserSidAndOrgSidIn(long userSid, List<Long> orgSids) {
        this.userInOrgRepository.deleteByUserSidAndOrgSidIn(userSid, orgSids);
    }

    @Override
    public List<QueryUserInOrgResultVO> getUserInOrgByUser(long tenantSid, long userSid) {
        return this.userInOrgMapper.queryUserInOrgByUser(tenantSid, userSid);
    }

    @Override
    public List<OrgInUserVO> getOrgInUserVO(long tenantSid, long userSid) {
        List<OrgInUserVO> orgs = this.userInOrgMapper.queryOrgInUser(tenantSid, userSid);
        HashSet<OrgInUserVO> orgList = new HashSet<OrgInUserVO>(orgs);
        for (OrgInUserVO org : orgs) {
            this.getParentOrgs(org.getParentSid(), orgList);
        }
        return new ArrayList<OrgInUserVO>(orgList);
    }

    private void getParentOrgs(long parentSid, Set<OrgInUserVO> orgs) {
        OrgInUserVO parentOrg;
        if (parentSid > 0L && (parentOrg = this.userInOrgMapper.queryOrgBySid(parentSid)) != null) {
            orgs.add(parentOrg);
            this.getParentOrgs(parentOrg.getParentSid(), orgs);
        }
    }
}

