/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.org.BatchReplaceVO;
import com.digiwin.dap.middleware.iam.domain.user.BatchUserInOrgVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInOrg;
import com.digiwin.dap.middleware.iam.mapper.UserInOrgMapper;
import com.digiwin.dap.middleware.iam.repository.UserInOrgRepository;
import com.digiwin.dap.middleware.iam.repository.UserInTenantRepository;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgUpdateService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UserInOrgUpdateServiceImpl
implements UserInOrgUpdateService {
    private Logger logger = LoggerFactory.getLogger(UserInOrgUpdateServiceImpl.class);
    @Autowired
    private UserInOrgMapper userInOrgMapper;
    @Autowired
    private UserInOrgCrudService userInOrgCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private UserInTenantRepository userInTenantRepository;
    @Autowired
    private UserInOrgRepository userInOrgRepository;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private AuthValidateService authValidateService;

    @Override
    public void updateUserInOrgByUser(long tenantSid, long userSid, String updateMode, List<Long> orgSids) {
        List<QueryUserInOrgResultVO> existUserInOrgs = this.userInOrgMapper.queryUserInOrgByUser(tenantSid, userSid);
        List existOrgSids = existUserInOrgs.stream().map(QueryUserInOrgResultVO::getOrgSid).collect(Collectors.toList());
        List<Long> needRemoveOrgSids = existOrgSids.stream().filter(a -> !orgSids.contains(a)).collect(Collectors.toList());
        List newOrgSids = orgSids.stream().filter(o -> !existOrgSids.contains(o)).collect(Collectors.toList());
        List userInOrgList = newOrgSids.stream().map(orgSid -> new UserInOrg(userSid, (long)orgSid)).collect(Collectors.toList());
        if (!userInOrgList.isEmpty()) {
            this.userInOrgCrudService.saveAll(userInOrgList);
        }
        if (!"all".equals(updateMode)) {
            return;
        }
        if (!needRemoveOrgSids.isEmpty()) {
            this.userInOrgCrudService.deleteByUserSidAndOrgSidIn(userSid, needRemoveOrgSids);
        }
        this.changeLogService.saveOrgInUserChangeLogs(String.format("%s-%s", tenantSid, userSid), "", JsonUtils.objToJson(existOrgSids), JsonUtils.objToJson(orgSids));
    }

    @Override
    public void disableUserInOrgByOrg(long tenantSid, long orgSid, long userSid) {
        List<QueryUserInOrgResultVO> list = this.userInOrgMapper.queryUserInOrgByUser(tenantSid, userSid);
        for (QueryUserInOrgResultVO vo : list) {
            if (vo.getOrgSid() != orgSid) continue;
            this.userInOrgCrudService.deleteByUnionKey(userSid, orgSid);
        }
    }

    @Override
    @Transactional
    public void batchAdd(BatchUserInOrgVO body) {
        Org org = (Org)this.orgCrudService.findBySid(body.getOrgSid());
        if (org == null || UserUtils.getTenantSid() != org.getTenantSid()) {
            this.logger.error(I18nError.IAM_USER_PERMISSION_COMMON_ERROR_LOG.getMessage(new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), "POST", "/api/iam/v2/user/enterprise/password/reset", UserUtils.getToken(), UserUtils.getAppToken(), Base64.encode((String)JsonUtils.writeValue((Object)body))}));
            return;
        }
        ArrayList<UserInOrg> toAdd = new ArrayList<UserInOrg>();
        for (String userId : body.getUserIds()) {
            User user = (User)this.userCrudService.findById(userId);
            if (user == null) {
                throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userId});
            }
            if (!this.userInTenantRepository.existsByTenantSidAndUserSid(UserUtils.getTenantSid(), user.getSid())) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_COMMON_ERROR, new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), Base64.encode((String)JsonUtils.writeValue((Object)body))});
            }
            UserInOrg exist = (UserInOrg)this.userInOrgCrudService.findByUnionKey(new Object[]{user.getSid(), org.getSid()});
            if (exist != null) continue;
            UserInOrg userInOrg = new UserInOrg();
            userInOrg.setOrgSid(org.getSid());
            userInOrg.setUserSid(user.getSid());
            toAdd.add(userInOrg);
        }
        this.userInOrgCrudService.saveAll(toAdd);
    }

    @Override
    @Transactional
    public void batchDel(BatchUserInOrgVO body) {
        if (!CollectionUtils.isEmpty(body.getSids())) {
            List<QueryUserInOrgResultVO> resultVOS = this.userInOrgMapper.batchQueryOrgInTenant(0L, body.getSids());
            if (CollectionUtils.isEmpty(resultVOS)) {
                return;
            }
            ArrayList errorSids = new ArrayList();
            body.getSids().forEach(s -> {
                Optional<QueryUserInOrgResultVO> matchResult = resultVOS.stream().filter(p -> p.getSid() == s.longValue()).findFirst();
                if (matchResult.isPresent() && UserUtils.getTenantSid() != matchResult.get().getTenantSid()) {
                    errorSids.add(s);
                }
            });
            if (!CollectionUtils.isEmpty(errorSids) && !this.authValidateService.checkAccessPermission("Sys", AppAuthContextHolder.getContext().getRequestInfo().getMethod(), AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
            }
            this.userInOrgRepository.deleteAllByIdInBatch(body.getSids());
        }
    }

    @Override
    @Transactional
    public void batchReplaceOrg(BatchReplaceVO vo) {
        List<UserInOrg> userInOrgs = this.userInOrgRepository.findByUserSidInAndOrgSid(vo.getUserSids(), vo.getOldSid());
        List toAdd = userInOrgs.stream().map(a -> {
            UserInOrg newUserInOrgs = new UserInOrg();
            newUserInOrgs.setOrgSid(vo.getNewSid());
            newUserInOrgs.setUserSid(a.getUserSid());
            return newUserInOrgs;
        }).collect(Collectors.toList());
        this.userInOrgRepository.deleteAll(userInOrgs);
        this.userInOrgRepository.flush();
        List<Long> exist = this.userInOrgRepository.findUserSidsByOrgSid(vo.getNewSid());
        toAdd.removeIf(a -> exist.contains(a.getUserSid()));
        this.userInOrgCrudService.saveAll(toAdd);
    }
}

