/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.roleuser.RoleUserListVO;
import com.digiwin.dap.middleware.iam.domain.roleuser.UserRoleListVO;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.repository.AssociationRepository;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithPartitionManagerService;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserInRoleCrudServiceImpl
extends BaseEntityWithPartitionManagerService<Association>
implements UserInRoleCrudService {
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private AssociationRepository associationRepository;

    protected AssociationRepository getRepository() {
        return this.associationRepository;
    }

    @Override
    public Association findByUnionKey(long tenantSid, long userSid, long roleSid) {
        return this.associationRepository.findByTenantSidAndUserSidAndRoleSid(tenantSid, userSid, roleSid);
    }

    @Override
    public boolean existsByUnionKey(long tenantSid, long userSid, long roleSid) {
        Association association = this.associationRepository.findByTenantSidAndUserSidAndRoleSid(tenantSid, userSid, roleSid);
        return association != null;
    }

    @Override
    public void deleteByUnionKey(long tenantSid, long userSid, long roleSid) {
        this.associationRepository.removeByTenantSidAndUserSidAndRoleSid(tenantSid, userSid, roleSid);
    }

    @Override
    @Transactional
    public void deleteByUnionKeyRoleSids(Long tenantSid, Long userSid, Collection<Long> roleSids) {
        this.associationRepository.removeByTenantSidAndUserSidAndRoleSidIn(tenantSid, userSid, roleSids);
    }

    @Override
    @Transactional
    public void updateStatus(long tenantSid, boolean status, List<Long> sids) {
        this.userInRoleMapper.updateStatus(tenantSid, status, sids);
    }

    @Override
    public List<QueryRoleResultVO> getUserInRoleByUser(long tenantSid, long userSid) {
        return this.userInRoleMapper.queryUserInRoleByUser(tenantSid, userSid);
    }

    @Override
    public List<RoleUserListVO> findUserByRoleSid(long tenantSid, long roleSid) {
        return this.userInRoleMapper.findUserByRoleSid(tenantSid, roleSid);
    }

    @Override
    public List<UserRoleListVO> findRoleByUserSid(long tenantSid, long userSid, boolean onlyValid) {
        return this.userInRoleMapper.findRoleByUserSid(tenantSid, userSid, true);
    }
}

