/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInRoleInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInfoVO;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleQueryService;
import com.digiwin.dap.middleware.language.service.LanguageService;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserInRoleQueryServiceImpl
implements UserInRoleQueryService {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private LanguageService languageService;

    @Override
    public List<QueryRoleResultVO> queryUserInRoleByUser(long tenantSid, long userSid) {
        return this.userInRoleMapper.queryUserInRoleByUser(tenantSid, userSid);
    }

    @Override
    public QueryRoleResultVO queryUserInRoleByUserAndRole(long tenantSid, long userSid, String roleId) {
        return this.userInRoleMapper.queryUserInRoleByUserAndRole(tenantSid, userSid, roleId);
    }

    @Override
    public QueryRoleResultVO queryUserInRoleByRoleSid(Long tenantSid, long roleSid) {
        return this.userInRoleMapper.queryUserInRoleByRoleSid(tenantSid, roleSid);
    }

    @Override
    public List<User> queryUsersInRole(long tenantSid, long roleSid, Integer status) {
        return this.userInRoleMapper.queryUserInRoleInTenant(tenantSid, roleSid, status);
    }

    @Override
    public List<UserInfoVO> queryUserListInRole(long roleSid, long tenantSid, UserInRoleInfoVO dto, Integer pageNum, Integer pageSize, String orderBy) {
        List<UserInfoVO> userInfoList = this.userInRoleMapper.queryUserListInRole(tenantSid, roleSid, dto, pageNum, pageSize, orderBy);
        if (!userInfoList.isEmpty()) {
            userInfoList.forEach(user -> {
                List<QueryRoleResultVO> roles = this.userInRoleMapper.queryUserInRoleByUser(tenantSid, user.getSid());
                user.setRoles(roles);
            });
        }
        return userInfoList;
    }

    @Override
    public List<UserInfoVO> queryUserListInRoleUserName(long roleSid, long tenantSid, String userName) {
        List<UserInfoVO> users = this.userInRoleMapper.queryUserInRoleUserName(tenantSid, roleSid, userName);
        if (!users.isEmpty()) {
            users.forEach(user -> {
                List<QueryRoleResultVO> roles = this.userInRoleMapper.queryUserInRoleByUser(tenantSid, user.getSid());
                user.setRoles(roles);
            });
        }
        return users;
    }

    @Override
    public List<User> queryUserNotInRole(long tenantSid, long roleSid, Integer status) {
        List<User> allUsers = this.userMapper.getUsersByTenantSid(tenantSid);
        List<User> removeUsers = this.userInRoleMapper.queryUserInRoleInTenant(tenantSid, roleSid, status);
        ArrayList<Long> userSidList = new ArrayList<Long>();
        if (removeUsers.size() > 0) {
            for (User user : removeUsers) {
                userSidList.add(user.getSid());
            }
            allUsers.removeIf(u -> userSidList.contains(u.getSid()));
        }
        return allUsers;
    }

    @Override
    public PageSerializable<User> queryUserNotInRolePage(long tenantSid, long roleSid, UserInRoleInfoVO body) {
        PageMethod.startPage((int)body.getPageNum(), (int)body.getPageSize());
        return new PageSerializable(this.userInRoleMapper.queryUserNotInRoleInTenantPage(tenantSid, roleSid, body));
    }

    @Override
    public List<QueryRoleResultVO> batchQueryUserInRole(long tenantSid, List<Long> roleSids) {
        return this.userInRoleMapper.batchQueryUserInRole(tenantSid, roleSids);
    }

    @Override
    public List<QueryRoleResultVO> queryUserAdministratorRoles(long tenantSid, long userSid) {
        List<QueryRoleResultVO> allRoles = this.queryUserInRoleByUser(tenantSid, userSid);
        ArrayList<QueryRoleResultVO> userAdministratorRoles = new ArrayList<QueryRoleResultVO>();
        for (QueryRoleResultVO resultVO : allRoles) {
            if (!"administrators".equals(resultVO.getCatalogId())) continue;
            userAdministratorRoles.add(resultVO);
        }
        return userAdministratorRoles;
    }

    @Override
    public List<QueryRoleResultVO> queryUserInRoleByUserWithLanguage(long tenantSid, long userSid) {
        List<QueryRoleResultVO> roleVOS = this.userInRoleMapper.queryUserInRoleByUser(tenantSid, userSid);
        return this.languageService.parse(roleVOS, Collections.singletonMap("name", "roleName"), QueryRoleResultVO.class, Role.class);
    }
}

