/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.UpdateModeEnum;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.GeneralParametersVO;
import com.digiwin.dap.middleware.iam.domain.user.RoleInUserInfoVO;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.RoleCatalog;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.repository.AssociationRepository;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.support.DeferredExecutionService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserInRoleServiceImpl
implements UserInRoleService {
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private AssociationRepository associationRepository;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private RoleCatalogCrudService roleCatalogCrudService;
    @Autowired
    private UserInRoleQueryService userInRoleQueryService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private DeferredExecutionService deferredExecutionService;

    @Override
    public void updateUserInRoleByUser(Long tenantSid, Long userSid, List<String> roleIds) {
        List<QueryRoleResultVO> roleDBList = this.userInRoleMapper.queryUserInRoleByUser(tenantSid, userSid);
        List oldRoleIds = roleDBList.stream().map(QueryRoleResultVO::getId).collect(Collectors.toList());
        HashMap<String, QueryRoleResultVO> roleDBMap = new HashMap<String, QueryRoleResultVO>();
        ArrayList<String> existRoleIds = new ArrayList<String>();
        ArrayList<String> newRoleIds = new ArrayList<String>();
        for (QueryRoleResultVO queryRoleResultVO : roleDBList) {
            roleDBMap.put(queryRoleResultVO.getId(), queryRoleResultVO);
            existRoleIds.add(queryRoleResultVO.getId());
        }
        HashMap<String, String> catalogMulti = new HashMap<String, String>();
        for (String roleId : roleIds) {
            newRoleIds.add(roleId);
            Role role = this.roleCrudService.findByTenantSidAndId(tenantSid, roleId);
            if (role == null) continue;
            RoleCatalog catalog = this.roleCatalogCrudService.findByTenantSidAndSid(tenantSid, role.getRoleCatalogSid());
            if (!catalog.isMultiSelect()) {
                if (catalogMulti.containsKey(catalog.getId())) {
                    throw new BusinessException((ErrorHandler)I18nError.ROLE_CATALOG_NO_MULTIPLE_CHOICE, new Object[]{catalog.getId(), roleId});
                }
                catalogMulti.put(catalog.getId(), roleId);
            }
            if (roleDBMap.containsKey(roleId)) continue;
            Association association = new Association();
            association.setTenantSid(tenantSid);
            association.setRoleSid(role.getSid());
            association.setUserSid(userSid);
            association.setStatus(Boolean.TRUE);
            this.userInRoleCrudService.create((BaseEntity)association);
            this.userInRoleQueryService.queryUserInRoleByUserAndRole(tenantSid, userSid, roleId);
        }
        AuthoredSys authoredSys = AppAuthContextHolder.getContext().getAuthoredSys();
        ArrayList needRemove = new ArrayList(existRoleIds);
        needRemove.removeAll(newRoleIds);
        for (String removeId : needRemove) {
            QueryRoleResultVO resultVO = (QueryRoleResultVO)roleDBMap.get(removeId);
            RoleCatalog catalog = this.roleCatalogCrudService.findByTenantSidAndId(tenantSid, resultVO.getCatalogId());
            if (catalog.isReadonly() && catalog.getCanupdateProvider() != null && catalog.getCanupdateProvider().contains(authoredSys.getId())) {
                throw new BusinessException((ErrorHandler)I18nError.SYS_NO_DELETE_ROLE, new Object[]{resultVO.getId()});
            }
            this.userInRoleCrudService.deleteByUnionKey(tenantSid, userSid, resultVO.getSid());
        }
        Optional.of(this.userCrudService.findBySid(userSid)).ifPresent(user -> this.changeLogService.saveAssociationChangeLogs(new User(user.getId(), user.getName()), new User(UserUtils.getUserId(), UserUtils.getUserName()), JsonUtils.writeValue((Object)oldRoleIds), JsonUtils.writeValue((Object)roleIds)));
    }

    @Override
    public void updateByUserRoles(Long tenantSid, Long userSid, List<GeneralParametersVO> roles, UpdateModeEnum updateModeEnum) {
        List roleSids = roles.stream().map(GeneralParametersVO::getSid).collect(Collectors.toList());
        List roleIds = roles.stream().map(x -> x.getId()).collect(Collectors.toList());
        List<QueryRoleResultVO> roleDBList = this.userInRoleMapper.queryUserInRoleByUser(tenantSid, userSid);
        Map<Long, QueryRoleResultVO> roleSidMap = roleDBList.stream().collect(Collectors.toMap(QueryRoleResultVO::getSid, x -> x, (k1, k2) -> k1));
        List oldRoleIds = roleDBList.stream().map(QueryRoleResultVO::getId).collect(Collectors.toList());
        List newRoleSids = roleSids.stream().filter(x -> !roleSidMap.containsKey(x)).collect(Collectors.toList());
        ArrayList<Association> newList = new ArrayList<Association>();
        for (Long newRoleSid : newRoleSids) {
            Association association = new Association();
            association.setTenantSid(tenantSid);
            association.setRoleSid(newRoleSid);
            association.setUserSid(userSid);
            association.setStatus(Boolean.TRUE);
            newList.add(association);
        }
        if (!newList.isEmpty()) {
            this.userInRoleCrudService.saveAll(newList);
        }
        Map<Long, QueryRoleResultVO> deleteRoles = roleSidMap.keySet().stream().filter(x -> !roleSids.contains(x)).collect(Collectors.toMap(x -> x, roleSidMap::get, (k1, k2) -> k1));
        if (UpdateModeEnum.all.equals((Object)updateModeEnum) && !deleteRoles.isEmpty()) {
            this.userInRoleCrudService.deleteByUnionKeyRoleSids(tenantSid, userSid, deleteRoles.keySet());
        }
        AuthoredUser authoredUser = UserUtils.getAuthoredUser();
        this.deferredExecutionService.runAfterCommit(() -> Optional.of(this.userCrudService.findBySid(userSid)).ifPresent(user -> this.changeLogService.saveAssociationChangeLogs(new User(user.getId(), user.getName()), new User(authoredUser.getUserId(), authoredUser.getUserName()), JsonUtils.writeValue((Object)oldRoleIds), JsonUtils.writeValue((Object)roleIds))));
    }

    @Override
    public void updateRoleByUserWithAction(Long tenantSid, Long userSid, RoleInUserInfoVO roleInUserInfoVO) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        User user = (User)this.userCrudService.findBySid(userSid);
        List<QueryRoleResultVO> roleDBList = this.userInRoleMapper.queryUserInRoleByUser(tenantSid, userSid);
        List<String> roleIds = roleInUserInfoVO.getRoleIds();
        if ("delete".equalsIgnoreCase(roleInUserInfoVO.getAction())) {
            AuthoredSys authoredSys = AppAuthContextHolder.getContext().getAuthoredSys();
            block0: for (String roleId : roleIds) {
                for (QueryRoleResultVO roleDB2 : roleDBList) {
                    RoleCatalog catalog;
                    if (!roleDB2.getId().equals(roleId)) continue;
                    if (authoredSys != null && (catalog = this.roleCatalogCrudService.findByTenantSidAndId(tenantSid, roleDB2.getCatalogId())).isReadonly() && catalog.getCanupdateProvider() != null && catalog.getCanupdateProvider().contains(authoredSys.getId())) {
                        throw new BusinessException((ErrorHandler)I18nError.SYS_NO_DELETE_ROLE, new Object[]{authoredSys.getId(), roleDB2.getId()});
                    }
                    this.userInRoleCrudService.deleteByUnionKey(tenantSid, userSid, roleDB2.getSid());
                    this.changeLogService.saveDeleteAssociationChangeLogs(roleDB2, tenant, user, roleDBList);
                    continue block0;
                }
            }
        } else {
            for (String roleId : roleIds) {
                Role role = this.roleCrudService.findByTenantSidAndId(tenantSid, roleId);
                if (role == null || !roleDBList.stream().noneMatch(roleDB -> roleDB.getId().equals(role.getId()))) continue;
                Association association = new Association();
                association.setTenantSid(tenantSid);
                association.setRoleSid(role.getSid());
                association.setUserSid(userSid);
                association.setStatus(Boolean.TRUE);
                this.userInRoleCrudService.create((BaseEntity)association);
                RoleCatalog roleCatalog = this.roleCatalogCrudService.findByTenantSidAndSid(tenantSid, role.getRoleCatalogSid());
                String roleCatalogId = roleCatalog == null ? "" : roleCatalog.getId();
                this.changeLogService.saveNewAssociationChangeLogs(role, roleCatalogId, tenant, user, roleDBList);
                QueryRoleResultVO queryRoleResultVO = new QueryRoleResultVO();
                queryRoleResultVO.setId(role.getId());
                queryRoleResultVO.setName(role.getName());
                queryRoleResultVO.setSid(association.getSid());
                queryRoleResultVO.setCatalogId(roleCatalogId);
                roleDBList.add(queryRoleResultVO);
            }
        }
    }

    @Override
    public void updateUserInRole(Long tenantSid, Long roleSid, List<User> users) {
        List<User> userInDBList = this.userInRoleQueryService.queryUsersInRole(tenantSid, roleSid, 0);
        ArrayList<Long> existRoleSids = new ArrayList<Long>();
        ArrayList<Long> newRoleSids = new ArrayList<Long>();
        for (User user : userInDBList) {
            existRoleSids.add(user.getSid());
        }
        for (User user : users) {
            newRoleSids.add(user.getSid());
        }
        ArrayList needInsert = new ArrayList(newRoleSids);
        ArrayList needRemove = new ArrayList(existRoleSids);
        needInsert.removeAll(existRoleSids);
        needRemove.removeAll(newRoleSids);
        for (Long removeSid : needRemove) {
            this.userInRoleCrudService.deleteByUnionKey(tenantSid, removeSid, roleSid);
        }
        for (Long insertSid : needInsert) {
            Association association = new Association();
            association.setTenantSid(tenantSid);
            association.setUserSid(insertSid);
            association.setRoleSid(roleSid);
            association.setStatus(Boolean.TRUE);
            this.userInRoleCrudService.create((BaseEntity)association);
        }
    }

    @Override
    public void deleteRoleInUser(Long tenantSid, Long userSid) {
        this.associationRepository.deleteAllByTenantSidAndUserSid(tenantSid, userSid);
    }

    @Override
    public void deleteUserInRole(Long roleSid, Long tenantSid, String sysId) {
        QueryRoleResultVO resultVO = this.userInRoleQueryService.queryUserInRoleByRoleSid(tenantSid, roleSid);
        RoleCatalog roleCatalog = this.roleCatalogCrudService.findByTenantSidAndId(resultVO.getTenantSid(), resultVO.getCatalogId());
        if (roleCatalog.isReadonly() && !roleCatalog.getCanupdateProvider().contains(sysId)) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NO_DELETE_ROLE, new Object[]{sysId, resultVO.getId()});
        }
        this.associationRepository.deleteAllByTenantSidAndRoleSid(roleCatalog.getTenantSid(), roleSid);
    }

    @Override
    public void deleteUsersInRole(Long roleSid, List<Long> userSids, long tenantSid) {
        if (!userSids.isEmpty()) {
            this.userInRoleMapper.deleteRoleUsers(tenantSid, roleSid, userSids);
        }
    }

    @Override
    public void addUsersInRole(Long roleSid, List<Long> userSids, long tenantSid) {
        userSids.forEach(userSid -> {
            Association association = new Association();
            association.setTenantSid(tenantSid);
            association.setRoleSid(roleSid);
            association.setUserSid((long)userSid);
            association.setStatus(Boolean.TRUE);
            this.associationRepository.save((Object)association);
        });
    }

    @Override
    public boolean checkSuperAdmin(Long tenantSid, Long userSid) {
        List<QueryRoleResultVO> userAdministratorRoles = this.userInRoleQueryService.queryUserAdministratorRoles(tenantSid, userSid);
        return userAdministratorRoles.size() > 0;
    }

    @Override
    public void addAdminRole(Tenant tenant, User user) {
        Role role = this.roleCrudService.findByTenantSidAndId(tenant.getSid(), "superadmin");
        if (role == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NO_SUPER_ADMIN, new Object[]{tenant.getId()});
        }
        Association oldAssociation = this.userInRoleCrudService.findByUnionKey(tenant.getSid(), user.getSid(), role.getSid());
        if (oldAssociation == null) {
            Association association = new Association();
            association.setTenantSid(tenant.getSid());
            association.setRoleSid(role.getSid());
            association.setUserSid(user.getSid());
            association.setStatus(Boolean.TRUE);
            this.userInRoleCrudService.create((BaseEntity)association);
        }
    }
}

