/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.repository.UserInTenantRepository;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.repository.BaseEntityRepository;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserInTenantCrudServiceImpl
extends BaseEntityManagerService<UserInTenant>
implements UserInTenantCrudService {
    @Autowired
    private UserInTenantRepository userInTenantRepository;

    protected BaseEntityRepository getRepository() {
        return this.userInTenantRepository;
    }

    @Override
    public UserInTenant findByUnionKey(long tenantSid, long userSid) {
        return this.userInTenantRepository.findByTenantSidAndUserSid(tenantSid, userSid);
    }

    @Override
    public void deleteByUnionKey(long tenantSid, long userSid) {
        UserInTenant userInTenant = this.userInTenantRepository.findByTenantSidAndUserSid(tenantSid, userSid);
        if (userInTenant != null) {
            this.userInTenantRepository.deleteById(userInTenant.getSid());
        }
    }

    @Override
    public boolean existsByUnionKey(long tenantSid, long userSid) {
        return this.userInTenantRepository.existsByTenantSidAndUserSid(tenantSid, userSid);
    }

    @Override
    public void enable(long tenantSid, long userSid) {
        UserInTenant userInTenant = this.userInTenantRepository.findByTenantSidAndUserSid(tenantSid, userSid);
        if (userInTenant != null) {
            userInTenant.setDisabled(false);
            this.userInTenantRepository.save((Object)userInTenant);
        }
    }

    @Override
    public void disable(long tenantSid, long userSid) {
        UserInTenant userInTenant = this.userInTenantRepository.findByTenantSidAndUserSid(tenantSid, userSid);
        if (userInTenant != null) {
            userInTenant.setDisabled(true);
            this.userInTenantRepository.save((Object)userInTenant);
        }
    }

    @Override
    public void batchDisable(long tenantSid, List<Long> userSid) {
        List<UserInTenant> userInTenant = this.userInTenantRepository.findByTenantSidAndUserSidIn(tenantSid, userSid);
        if (!userInTenant.isEmpty()) {
            userInTenant.forEach(a -> a.setDisabled(true));
            this.saveAll(userInTenant);
        }
    }

    @Override
    public List<UserInTenant> queryUserJoinedTenant(long userSid) {
        return this.userInTenantRepository.findByUserSid(userSid);
    }

    @Override
    public void createUserInTenant(long tenantSid, long userSid, boolean userType) {
        UserInTenant userInTenant = this.findByUnionKey(tenantSid, userSid);
        if (userInTenant == null) {
            userInTenant = new UserInTenant();
            userInTenant.setTenantSid(tenantSid);
            userInTenant.setUserSid(userSid);
            userInTenant.setUserType(userType);
            this.create(userInTenant);
        }
    }

    @Override
    public void changeTenantVisibility(long tenantSid, long userSid, boolean tenantVisible) {
        UserInTenant userInTenant = this.findByUnionKey(tenantSid, userSid);
        if (userInTenant != null) {
            userInTenant.setTenantVisible(tenantVisible);
            this.update(userInTenant);
        }
    }
}

