/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.constant.enums.UpdateModeEnum;
import com.digiwin.dap.middleware.iam.constant.enums.UserTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.enumeration.ActionEnum;
import com.digiwin.dap.middleware.iam.domain.enumeration.StopTypeEnum;
import com.digiwin.dap.middleware.iam.domain.metadata.MetadaVO;
import com.digiwin.dap.middleware.iam.domain.tenant.GeneralParametersVO;
import com.digiwin.dap.middleware.iam.domain.tenant.InvitedUserVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuthDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCorpConfigDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.InvitedUserHistory;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.repository.UserInTenantRepository;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.service.authorization.record.ServiceAuthorizationRecordService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.AutoEOCService;
import com.digiwin.dap.middleware.iam.service.tenant.InvitedUserHistoryCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantOperationService;
import com.digiwin.dap.middleware.iam.support.clean.PolicyCascadeDeleteService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.WeComUserVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.EmpUserVO;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.iam.util.UserIdUtil;
import com.digiwin.dap.middleware.service.CascadeDeleteEntityService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UserInTenantOperationServiceImpl
implements UserInTenantOperationService {
    private static final Logger logger = LoggerFactory.getLogger(UserInTenantOperationServiceImpl.class);
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private CacService cacService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private SysInTenantCrudService sysInTenantCrudService;
    @Autowired
    private CascadeDeleteEntityService cascadeDeleteEntityService;
    @Autowired
    private UserInTenantRepository userInTenantRepository;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private UserInOrgUpdateService userInOrgUpdateService;
    @Autowired
    private InvitedUserHistoryCrudService invitedUserHistoryCrudService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private RemoteEMCService remoteEmcService;
    @Autowired
    private MetadataUpdateService metadataUpdateService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private PolicyCascadeDeleteService policyCascadeDeleteService;
    @Autowired
    private ServiceAuthorizationRecordService serviceAuthorizationRecordService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private SysNoticeService sysNoticeService;
    @Autowired
    private AutoEOCService autoEOCService;

    @Override
    public void applyJoinTenant(long userSid, Tenant tenant, String content, String dueDate) {
        User user = (User)this.userCrudService.findBySid(userSid);
        Assert.notNull((Object)((Object)user), (String)String.format("\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237[%s]\uff01", user.getSid()));
        if (!user.isActivated()) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_NOT_ACTIVE, new Object[]{user.getId()});
        }
        List<UserInTenant> alreadyJoinedList = this.userInTenantRepository.findByUserSid(userSid);
        ArrayList<Long> joinTenantSids = new ArrayList<Long>();
        for (UserInTenant userInTenant : alreadyJoinedList) {
            joinTenantSids.add(userInTenant.getTenantSid());
        }
        if (!joinTenantSids.contains(tenant.getSid())) {
            List<InvitedUserHistory> invitedUserHistoryList;
            InvitedUserHistory invitedUserHistory = new InvitedUserHistory().generateHistoryUserApplyTenant(tenant.getSid(), user.getSid(), content);
            if (!StringUtils.isEmpty((Object)dueDate)) {
                try {
                    invitedUserHistory.setDueDate(LocalDateTimeUtil.parse((CharSequence)dueDate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
                catch (Exception ex) {
                    throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
                }
            }
            if ((invitedUserHistoryList = this.invitedUserHistoryCrudService.findApplyTenantHistories(tenant.getSid(), userSid, null, null)).size() > 0) {
                InvitedUserHistory history = invitedUserHistoryList.get(0);
                if (IamConstants.AcceptedStatus.ApplyWaitAgree.toString().equals(history.getAcceptedStatus())) {
                    history.setRequestDate(LocalDateTime.now());
                    history.setDueDate(invitedUserHistory.getDueDate());
                    this.invitedUserHistoryCrudService.update(history);
                } else {
                    this.invitedUserHistoryCrudService.create(invitedUserHistory);
                }
            } else {
                this.invitedUserHistoryCrudService.create(invitedUserHistory);
            }
        }
    }

    @Override
    public List<GeneralParametersVO> agreeTenantInvited(long userSid, long invitedHistorySid) {
        List appList;
        List orgList;
        List roleList;
        InvitedUserHistory history = (InvitedUserHistory)this.invitedUserHistoryCrudService.findBySid(invitedHistorySid);
        if (history == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21023);
        }
        User user = (User)this.userCrudService.findBySid(userSid);
        Assert.notNull((Object)((Object)user), (String)String.format("\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237[%s]\uff01", user.getId()));
        if (history.getUserSid() != userSid && Strings.isEmpty((CharSequence)history.getUserEmail()) && Strings.isEmpty((CharSequence)history.getUserTel())) {
            throw new BusinessException((ErrorHandler)I18nError.NO_PERMISSION_OPERATE_USER_INFO);
        }
        if (history.getUserSid() != userSid && !StringUtil.equalsIgnoreCase(history.getUserEmail(), user.getEmail()) && !StringUtil.equalsIgnoreCase(history.getUserTel(), user.getTelephone())) {
            throw new BusinessException((ErrorHandler)I18nError.NO_PERMISSION_OPERATE_USER_INFO);
        }
        if (history.getType().booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NO_AGREE);
        }
        if (!history.getAcceptedStatus().equals(IamConstants.AcceptedStatus.InvitedWaitAgree.name())) {
            throw new BusinessException((ErrorHandler)I18nError.AGREE_OR_REJECT);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(history.getTenantSid());
        Assert.notNull((Object)((Object)tenant), (String)String.format("\u8be5\u4f01\u4e1a[%s]\u4e0d\u5b58\u5728\uff01", history.getTenantSid()));
        history.setConfirmDate(LocalDateTime.now());
        history.setAcceptedstatus(IamConstants.AcceptedStatus.Agree.toString());
        this.invitedUserHistoryCrudService.update(history);
        if (!this.userInTenantCrudService.existsByUnionKey(tenant.getSid(), user.getSid())) {
            UserInTenant userInTenant = new UserInTenant(user.getSid(), tenant.getSid());
            if (history.getDueDate() != null) {
                userInTenant.setDueDate(history.getDueDate());
            }
            if (history.getUserType() != null) {
                userInTenant.setUserType(history.getUserType());
            }
            this.userInTenantCrudService.create(userInTenant);
        }
        try {
            roleList = (List)objectMapper.readValue(history.getRole(), (TypeReference)new TypeReference<List<GeneralParametersVO>>(){});
            orgList = (List)objectMapper.readValue(history.getOrg(), (TypeReference)new TypeReference<List<GeneralParametersVO>>(){});
            appList = (List)objectMapper.readValue(history.getApp(), (TypeReference)new TypeReference<List<GeneralParametersVO>>(){});
        }
        catch (IOException e) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        this.autoEOCService.userJoinTenant(history.getEmpId(), user, tenant.getSid(), Optional.ofNullable(history.getUserType()).orElse(false), false);
        List<GeneralParametersVO> result = this.initializeUserData(tenant, user, (List<GeneralParametersVO>)roleList, (List<GeneralParametersVO>)orgList, appList, history.getWechat(), history.getEmpId(), history.getUserType());
        return result;
    }

    @Override
    public void refuseTenantInvitation(long userSid, long invitedHistorySid) {
        InvitedUserHistory history = (InvitedUserHistory)this.invitedUserHistoryCrudService.findBySid(invitedHistorySid);
        Assert.notNull((Object)((Object)history), (String)"\u5f53\u524d\u9080\u8bf7\u5df2\u88ab\u53d6\u6d88\uff0c\u60a8\u53ef\u81ea\u884c\u7533\u8bf7\u52a0\u5165!");
        User user = (User)this.userCrudService.findBySid(userSid);
        Assert.notNull((Object)((Object)user), (String)String.format("\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237[%s]\uff01", user.getId()));
        if (history.getUserSid() != userSid && Strings.isEmpty((CharSequence)history.getUserEmail()) && Strings.isEmpty((CharSequence)history.getUserTel())) {
            throw new BusinessException((ErrorHandler)I18nError.NO_PERMISSION_OPERATE_USER_INFO);
        }
        if (history.getUserSid() != userSid && !StringUtil.equals(history.getUserEmail(), user.getEmail()) && !StringUtil.equals(history.getUserTel(), user.getTelephone())) {
            throw new BusinessException((ErrorHandler)I18nError.NO_PERMISSION_OPERATE_USER_INFO);
        }
        if (history.getType().booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NO_AGREE);
        }
        if (!history.getAcceptedStatus().equals(IamConstants.AcceptedStatus.InvitedWaitAgree.name())) {
            throw new BusinessException((ErrorHandler)I18nError.AGREE_OR_REJECT);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(history.getTenantSid());
        Assert.notNull((Object)((Object)tenant), (String)String.format("\u8be5\u4f01\u4e1a[%s]\u4e0d\u5b58\u5728\uff01", history.getTenantSid()));
        history.setConfirmDate(LocalDateTime.now());
        history.setAcceptedstatus(IamConstants.AcceptedStatus.Refuse.toString());
        this.invitedUserHistoryCrudService.update(history);
    }

    @Override
    @Transactional
    public void exitTenant(Long tenantSid, User user) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant.getOwnerUserSid() == user.getSid() && !TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue().equals(tenant.getEnterpriseType())) {
            throw new BusinessException(String.format("\u7528\u6237[%s]\u662f\u4f01\u4e1a\u7684\u521b\u5efa\u8005\uff0c\u65e0\u6cd5\u9000\u51fa\uff01", user.getId()));
        }
        Assert.notNull((Object)((Object)tenant), (String)"\u8be5\u79df\u6237\u4e0d\u5b58\u5728\uff01");
        if (tenantSid.longValue() == user.getDefaultTenantSid()) {
            user.setDefaultTenantSid(0L);
            this.userCrudService.update((BaseEntity)user);
        }
        this.userInTenantCrudService.deleteByUnionKey(tenantSid, user.getSid());
        this.cascadeDeleteEntityService.deleteRelation("userrelationwithtenant", Long.valueOf(user.getSid()), tenantSid);
        if (Objects.equals(UserTypeEnum.INTERNAL.getCode(), user.getType())) {
            this.userCrudService.deleteById(user.getSid());
        }
        this.remoteEocService.deleteUserEmp(tenantSid, user.getId());
        this.cacService.deleteUser(tenant.getId(), user.getId());
        this.remoteEmcService.doAfterUserExitTenant(tenantSid, user.getSid());
    }

    @Override
    public List<GeneralParametersVO> initializeUserData(Tenant tenant, User user, InvitedUserVO userVO) {
        return this.initializeUserData(tenant, user, userVO.getRole(), userVO.getOrg(), userVO.getApp(), null, userVO.getUserType());
    }

    @Override
    public List<GeneralParametersVO> initializeUserData(Tenant tenant, User user, List<GeneralParametersVO> roleList, List<GeneralParametersVO> orgList, List<GeneralParametersVO> appList, String wechat, Boolean tenantUserType) {
        ArrayList<Long> orgSids = new ArrayList<Long>();
        ArrayList<String> roleIds = new ArrayList<String>();
        ArrayList<GeneralParametersVO> authorizationFailureApps = new ArrayList<GeneralParametersVO>();
        if (!CollectionUtils.isEmpty(roleList)) {
            roleList.forEach(role -> {
                if (this.roleCrudService.existsByTenantSidAndSid(tenant.getSid(), role.getSid())) {
                    roleIds.add(role.getId());
                }
            });
            this.userInRoleService.updateUserInRoleByUser(tenant.getSid(), user.getSid(), roleIds);
        }
        if (!CollectionUtils.isEmpty(orgList)) {
            orgList.forEach(org -> {
                if (this.orgCrudService.exists(org.getSid())) {
                    orgSids.add(org.getSid());
                }
            });
            this.userInOrgUpdateService.updateUserInOrgByUser(tenant.getSid(), user.getSid(), "onlyAppend", orgSids);
        }
        if (!CollectionUtils.isEmpty(appList)) {
            appList.forEach(app -> {
                Sys sys = (Sys)this.sysCrudService.findById(app.getId());
                if (sys != null && !sys.isInside() && this.sysInTenantCrudService.existsByUnionKey(tenant.getSid(), sys.getSid())) {
                    if (user.getId().toLowerCase().contains("@digiwin.com")) {
                        this.cacService.addAuthorization(this.envProperties.getCacUri(), tenant.getId(), app.getId(), user.getId());
                    } else {
                        AuthorizationResultVO result = this.cacService.queryAllAuthorization(tenant.getId(), app.getId());
                        if (result != null && (result.getTotalUserCount() < 0 || result.getTotalUserCount() > result.getUserCount())) {
                            this.cacService.addAuthorization(this.envProperties.getCacUri(), tenant.getId(), app.getId(), user.getId());
                        } else {
                            app.setMessage(String.format(I18nCode.SYS_AUTHORIZATION_MAX_USER_ERROR.getMessage(), app.getId()));
                            app.setCode(0);
                            authorizationFailureApps.add((GeneralParametersVO)app);
                        }
                    }
                } else {
                    app.setMessage(String.format("\u5e94\u7528[%s]\u4fe1\u606f\u9519\u8bef\uff01", app.getId()));
                    app.setCode(1);
                    authorizationFailureApps.add((GeneralParametersVO)app);
                }
            });
        }
        this.updateWechat(tenant, user, wechat, UserUtils.getToken());
        if (ObjectUtil.equal((Object)Boolean.TRUE, (Object)tenantUserType)) {
            this.sysNoticeOutSideUser(tenant, user, appList);
        }
        return authorizationFailureApps;
    }

    @Override
    public void updateWechat(Tenant tenant, User user, String wechat, String userToken) {
        if (!StringUtils.hasText((String)wechat)) {
            return;
        }
        try {
            WeComUserVO weComUserVO;
            TenantCorpConfigDTO corpIdAndAppConfig = this.tenantQueryService.getTenantCorpIdAndAppConfig(tenant.getSid());
            if (Boolean.TRUE.equals(corpIdAndAppConfig.getAppConfig()) && tenant.isCorpWechat() && Objects.nonNull(weComUserVO = this.remoteEmcService.checkWechatExistReturnOpenUserId(null, tenant.getId(), wechat, user.getId(), userToken))) {
                this.metadataUpdateService.updateMetadata(new MetadaVO(user.getId(), tenant.getId(), wechat));
                if (StringUtils.hasText((String)weComUserVO.getOpen_userid())) {
                    UserMetadataVO openWeComMetadata = new UserMetadataVO();
                    openWeComMetadata.setCatalogId("contact");
                    openWeComMetadata.setKey("open_wecom");
                    openWeComMetadata.setValue(weComUserVO.getOpen_userid());
                    openWeComMetadata.setTenantSid(tenant.getSid());
                    openWeComMetadata.setUserSid(user.getSid());
                    this.metadataUpdateService.updateMetadataValue(openWeComMetadata);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u3010\u521d\u59cb\u5316\u7528\u6237\u6570\u636e\u5931\u8d25\u3011 \u6210\u5458\u5fae\u4fe1\u8d26\u53f7\u5931\u8d25\uff1auserId={}, tenantId={}, wechat={}", new Object[]{user.getId(), tenant.getId(), wechat, e});
        }
    }

    @Override
    public List<GeneralParametersVO> initializeUserData(Tenant tenant, User user, List<GeneralParametersVO> roleList, List<GeneralParametersVO> orgList, List<GeneralParametersVO> appList, String wechat, String empId, Boolean tenantUserType) {
        if (tenant.isEoc() && !StringUtils.isEmpty((Object)empId)) {
            EmpUserVO empUserVO = new EmpUserVO();
            empUserVO.setTenantSid(tenant.getSid());
            empUserVO.setEmpId(empId);
            empUserVO.setUserId(user.getId());
            empUserVO.setUserName(user.getName());
            this.remoteEocService.bindingUser(empUserVO);
        }
        return this.initializeUserData(tenant, user, roleList, orgList, appList, wechat, tenantUserType);
    }

    @Override
    public List<GeneralParametersVO> initializeUserData(Tenant tenant, User user, List<GeneralParametersVO> roleList, List<GeneralParametersVO> orgList, Map<String, AuthorizationResultVO> authorizationResultMap, List<GeneralParametersVO> appList, Boolean tenantUserType, UpdateModeEnum updateModeEnum) {
        if (roleList != null) {
            this.userInRoleService.updateByUserRoles(tenant.getSid(), user.getSid(), roleList, updateModeEnum);
        }
        if (orgList != null) {
            List<Long> orgSids = orgList.stream().map(GeneralParametersVO::getSid).collect(Collectors.toList());
            this.userInOrgUpdateService.updateUserInOrgByUser(tenant.getSid(), user.getSid(), updateModeEnum.getType(), orgSids);
        }
        ArrayList<GeneralParametersVO> authorizationFailureApps = new ArrayList<GeneralParametersVO>();
        if (appList != null) {
            this.userAuthAppList(tenant, user, appList, authorizationResultMap, authorizationFailureApps, updateModeEnum);
        }
        if (ObjectUtil.equal((Object)Boolean.TRUE, (Object)tenantUserType) && !CollectionUtils.isEmpty(appList)) {
            this.sysNoticeOutSideUser(tenant, user, appList);
        }
        return authorizationFailureApps;
    }

    private void userAuthAppList(Tenant tenant, User user, List<GeneralParametersVO> appList, Map<String, AuthorizationResultVO> authorizationResultMap, List<GeneralParametersVO> authorizationFailureApps, UpdateModeEnum updateModeEnum) {
        List<String> oldAuthAppIdList = this.cacService.queryGoodsCodeByCurrentAndUserId(user.getId(), UserUtils.getToken());
        for (GeneralParametersVO app : appList) {
            AuthorizationResultVO result;
            if (oldAuthAppIdList.contains(app.getId())) continue;
            if (UserIdUtil.isDigiwin(user.getId())) {
                this.cacService.addAuthorization(this.envProperties.getCacUri(), tenant.getId(), app.getId(), user.getId());
                continue;
            }
            if (authorizationResultMap.containsKey(app.getId())) {
                result = authorizationResultMap.get(app.getId());
            } else {
                result = this.cacService.queryAllAuthorization(tenant.getId(), app.getId());
                authorizationResultMap.put(app.getId(), result);
            }
            if (result != null) {
                if (result.getTotalUserCount() < 0 || result.getTotalUserCount() > result.getUserCount()) {
                    this.cacService.addAuthorization(this.envProperties.getCacUri(), tenant.getId(), app.getId(), user.getId());
                    result.setUserCount(result.getUserCount() + 1);
                    continue;
                }
                app.setMessage(String.format(I18nCode.SYS_AUTHORIZATION_MAX_USER_ERROR.getMessage(), app.getId()));
                app.setCode(0);
                authorizationFailureApps.add(app);
                continue;
            }
            app.setMessage(I18nError.TENANT_NO_AUTHORIZATION_INFO.getErrorMessage(new Object[]{tenant.getId(), app.getId()}));
            app.setCode(0);
            authorizationFailureApps.add(app);
        }
        if (updateModeEnum == UpdateModeEnum.all) {
            List newAuthAppIdList = appList.stream().map(GeneralParametersVO::getId).collect(Collectors.toList());
            List<String> needDeleteAppIdList = oldAuthAppIdList.stream().filter(x -> !newAuthAppIdList.contains(x)).collect(Collectors.toList());
            if (!needDeleteAppIdList.isEmpty()) {
                this.cacService.batchUpdateAuthorization(tenant.getId(), user.getId(), Collections.emptyList(), needDeleteAppIdList);
            }
        }
    }

    private void sysNoticeOutSideUser(Tenant tenant, User user, List<GeneralParametersVO> appList) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("tenantId", tenant.getId());
        data.put("userId", user.getId());
        data.put("telephone", user.getTelephone());
        data.put("email", user.getEmail());
        data.put("appIds", appList.stream().map(GeneralParametersVO::getId).collect(Collectors.toList()));
        this.sysNoticeService.userJoined(data, UserUtils.getToken());
    }

    @Override
    public TenantVO bindingCurrentUserWithTenant(String customerId, Long userSid) {
        Association association;
        List<TenantVO> tenantVOS = this.tenantMapper.findTenantByCustomerId(customerId, "ServiceCloud");
        if (tenantVOS.isEmpty()) {
            tenantVOS = this.tenantMapper.findTenantByCustomerId(customerId, null);
        }
        if (tenantVOS.isEmpty()) {
            throw new BusinessException(String.format("\u5ba2\u670d\u4ee3\u53f7\u4e3a%s\u7684\u79df\u6237\u4e0d\u5b58\u5728", customerId));
        }
        TenantVO joinTenant = tenantVOS.get(0);
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(joinTenant.getSid(), userSid);
        if (userInTenant == null) {
            userInTenant = new UserInTenant();
            userInTenant.setTenantSid(joinTenant.getSid());
            userInTenant.setUserSid(userSid);
            this.userInTenantCrudService.create(userInTenant);
        }
        if ((association = this.userInRoleCrudService.findByUnionKey(joinTenant.getSid(), userSid, joinTenant.getSuperAdminSid())) == null) {
            association = new Association();
            association.setTenantSid(joinTenant.getSid());
            association.setRoleSid(joinTenant.getSuperAdminSid());
            association.setUserSid(userSid);
            association.setStatus(Boolean.TRUE);
            this.userInRoleCrudService.create((BaseEntity)association);
        }
        return joinTenant;
    }

    @Override
    public I18nError operateUserInTenant(TenantAuthDTO tenantAuthDTO, Tenant tenant, User user) {
        if (ActionEnum.ADD.getValue().equals(tenantAuthDTO.getAction())) {
            Map map = this.cacService.addUserAuthorization(this.envProperties.getCacUri(), tenant.getId(), tenantAuthDTO.getGoodsCode(), user.getId());
            if (map != null && !((Boolean)map.get("isSuccess")).booleanValue()) {
                if (0 == (Integer)map.get("totalCount") && 0 == (Integer)map.get("currentCount")) {
                    return I18nError.ERROR_21007;
                }
                return I18nError.USER_COUNTING_FULL;
            }
            this.userJoinTenant(tenant, user);
        } else if (ActionEnum.DEL.getValue().equals(tenantAuthDTO.getAction())) {
            UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
            if (userInTenant != null) {
                this.userInTenantCrudService.deleteById(userInTenant.getSid());
            }
            this.policyCascadeDeleteService.deleteUser(tenant.getSid(), user.getSid());
            this.cascadeDeleteEntityService.deleteRelation("userrelationwithtenant", Long.valueOf(user.getSid()), Long.valueOf(tenant.getSid()));
            this.serviceAuthorizationRecordService.updateRecordStop(tenant.getSid(), user.getSid(), StopTypeEnum.TENANT_STOP.getValue());
            this.remoteEocService.deleteUserEmp(tenant.getSid(), user.getId());
            this.cacService.deleteUser(tenant.getId(), user.getId());
            this.changeLogService.saveRemoveUserChangeLogs(user);
        }
        return null;
    }

    public void userJoinTenant(Tenant tenant, User user) {
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
        if (userInTenant == null) {
            userInTenant = new UserInTenant();
            userInTenant.setTenantSid(tenant.getSid());
            userInTenant.setUserSid(user.getSid());
            this.userInTenantCrudService.create(userInTenant);
        }
        long adminRoleSid = this.roleCrudService.getSidByTenantAndId(tenant.getSid(), "superadmin");
        Association association = this.userInRoleCrudService.findByUnionKey(tenant.getSid(), user.getSid(), adminRoleSid);
        if (association == null) {
            association = new Association();
            association.setTenantSid(tenant.getSid());
            association.setRoleSid(adminRoleSid);
            association.setUserSid(user.getSid());
            association.setStatus(Boolean.TRUE);
            this.userInRoleCrudService.create((BaseEntity)association);
        }
    }
}

