/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import cn.hutool.core.util.ReflectUtil;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.domain.form.IntellyRelationPageVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyRelationResultVO;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.UserInTenantSimpleDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.UserInTenantVO;
import com.digiwin.dap.middleware.iam.domain.user.TenantRelationWithUserWithStatusVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserConditionVO;
import com.digiwin.dap.middleware.iam.entity.Action;
import com.digiwin.dap.middleware.iam.entity.InvitedUserHistory;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantMetadata;
import com.digiwin.dap.middleware.iam.entity.TenantMetadataColumn;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.IntellyMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMetadataMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInTenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.InvitedUserHistoryRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.repository.UserInTenantRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCalcService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserBasicInfoQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantQueryService;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserInTenantQueryServiceImpl
implements UserInTenantQueryService {
    @Autowired
    private PolicyCalcService policyCalcService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private UserInTenantRepository userInTenantRepository;
    @Autowired
    private InvitedUserHistoryRepository invitedUserHistoryRepository;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private TenantMetadataMapper tenantMetadataMapper;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private TenantMetadataColumnCrudService tenantMetadataColumnCrudService;
    @Autowired
    private UserBasicInfoQueryService userBasicInfoQueryService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private IntellyMapper intellyMapper;
    @Autowired
    private UserInTenantMapper userInTenantMapper;

    @Override
    public List<TenantRelationWithUserWithStatusVO> queryUserRelatedTenant(String type, User user, Boolean excludeSensitiveData) {
        ArrayList<TenantRelationWithUserWithStatusVO> results = new ArrayList<TenantRelationWithUserWithStatusVO>();
        switch (type.toLowerCase()) {
            case "all": {
                List<TenantRelationWithUserWithStatusVO> joinList = this.queryUserJoinedTenant(user.getSid(), excludeSensitiveData);
                HashMap<Long, TenantRelationWithUserWithStatusVO> joinMap = new HashMap<Long, TenantRelationWithUserWithStatusVO>();
                for (TenantRelationWithUserWithStatusVO tenantRelationWithUserWithStatusVO : joinList) {
                    joinMap.put(tenantRelationWithUserWithStatusVO.getSid(), tenantRelationWithUserWithStatusVO);
                }
                results.addAll(joinList);
                List<TenantRelationWithUserWithStatusVO> invitedList = this.queryUserInvitedByTenant(user.getType(), user.getSid(), user.getEmail(), user.getTelephone(), excludeSensitiveData);
                for (TenantRelationWithUserWithStatusVO item : invitedList) {
                    if (!IamConstants.AcceptedStatus.InvitedWaitAgree.toString().equals(item.getStatus()) || item.getApplyOrInvited() == null || joinMap.containsKey(item.getSid())) continue;
                    results.add(item);
                }
                List<TenantRelationWithUserWithStatusVO> list = this.queryUserApplyTenant(user.getSid(), excludeSensitiveData);
                for (TenantRelationWithUserWithStatusVO item : list) {
                    if (!IamConstants.AcceptedStatus.ApplyWaitAgree.toString().equals(item.getStatus()) || item.getApplyOrInvited() == null || joinMap.containsKey(item.getSid())) continue;
                    results.add(item);
                }
                break;
            }
            case "joined": {
                results.addAll(this.queryUserJoinedTenant(user.getSid(), excludeSensitiveData));
                break;
            }
            case "apply": {
                results.addAll(this.queryUserApplyTenant(user.getSid(), excludeSensitiveData));
                break;
            }
            case "invited": {
                results.addAll(this.queryUserInvitedByTenant(user.getType(), user.getSid(), user.getEmail(), user.getTelephone(), excludeSensitiveData));
                break;
            }
            case "audit": {
                results.addAll(this.queryUserAuditTenant(user.getSid(), excludeSensitiveData));
                break;
            }
        }
        return results;
    }

    private List<TenantRelationWithUserWithStatusVO> queryUserAuditTenant(Long userSid, Boolean excludeSensitiveData) {
        List<UserInTenant> userInTenants = this.userInTenantRepository.findByUserSid(userSid);
        ArrayList<TenantRelationWithUserWithStatusVO> results = new ArrayList<TenantRelationWithUserWithStatusVO>();
        for (UserInTenant userInTenant : userInTenants) {
            Tenant tenant;
            Optional optionalTenant = this.tenantRepository.findById(userInTenant.getTenantSid());
            if (!optionalTenant.isPresent() || (tenant = (Tenant)((Object)optionalTenant.get())).getOwnerUserSid() != userSid.longValue() || tenant.getConfirm() == 1) continue;
            TenantRelationWithUserWithStatusVO result = new TenantRelationWithUserWithStatusVO(tenant, IamConstants.AcceptedStatus.Create.toString(), userInTenant.getCreateDate(), excludeSensitiveData);
            result.setUserNumber(this.userInTenantRepository.countByTenantSidAndVisible(tenant.getSid(), true));
            results.add(result);
        }
        this.getTenantDefaultLanguage(results);
        this.getTenantCorpId(results);
        return results;
    }

    @Override
    public List<TenantRelationWithUserWithStatusVO> queryUserJoinedTenant(Long userSid, Boolean excludeSensitiveData) {
        List<TenantRelationWithUserWithStatusVO> tenants = excludeSensitiveData == false ? this.tenantMapper.getTenantWithUserByJoinedUserSid(userSid) : this.tenantMapper.getTenantExcludeSensitiveWithUserByJoinedUserSid(userSid);
        User user = this.userMapper.findBySid(userSid);
        Long defaultTenantSid = Objects.nonNull((Object)user) ? Long.valueOf(user.getDefaultTenantSid()) : null;
        for (TenantRelationWithUserWithStatusVO tenant : tenants) {
            if (Objects.equals(tenant.getOwnerUserSid(), userSid)) {
                tenant.setStatus(IamConstants.AcceptedStatus.Create.toString());
            } else {
                tenant.setStatus(IamConstants.AcceptedStatus.Joined.toString());
            }
            if (defaultTenantSid == null || !defaultTenantSid.equals(tenant.getSid())) continue;
            tenant.setWasDefault(true);
        }
        this.getTenantDefaultLanguage(tenants);
        this.getTenantCorpId(tenants);
        this.getTenantPasswordSpan(tenants);
        this.getTenantPasswordAttempts(tenants);
        this.populateMeta(tenants, "basic", "eocEntrance", "eocEntrance");
        this.populateMeta(tenants, "basic", "autoEOC", "autoEOC");
        return tenants;
    }

    private void populateMeta(List<TenantRelationWithUserWithStatusVO> results, String metaType, String metaKey, String fieldName) {
        List<Long> tenantSids = results.stream().map(TenantVO::getSid).collect(Collectors.toList());
        TenantMetadataColumn columns = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{metaType, metaKey});
        if (columns != null && !tenantSids.isEmpty()) {
            List<TenantMetadata> tenantMetadatas = this.tenantMetadataMapper.findMetadatasByTenantSidsAndColumnSid(tenantSids, columns.getSid());
            tenantMetadatas.forEach(meta -> results.stream().filter(tenant -> tenant.getSid().equals(meta.getTenantSid())).findFirst().ifPresent(aTenant -> ReflectUtil.setFieldValue((Object)aTenant, (String)fieldName, (Object)meta.getValue())));
        }
    }

    @Override
    public List<TenantRelationWithUserWithStatusVO> queryUserJoinedTenantBasicInfo(Long userSid) {
        List<TenantRelationWithUserWithStatusVO> tenants = this.tenantMapper.getTenantBasicInfoWithUserByJoinedUserSid(userSid);
        this.getTenantDefaultLanguage(tenants);
        tenants.forEach(t -> {
            if (Objects.equals(t.getSid(), t.getUserDefaultTenantSid())) {
                t.setWasDefault(true);
            }
            if (Objects.equals(t.getOwnerUserSid(), userSid)) {
                t.setStatus(IamConstants.AcceptedStatus.Create.toString());
            } else {
                t.setStatus(IamConstants.AcceptedStatus.Joined.toString());
            }
        });
        tenants.removeIf(a -> Boolean.FALSE.equals(a.getTenantVisible()));
        return tenants;
    }

    private List<TenantRelationWithUserWithStatusVO> queryUserInvitedByTenant(Integer type, Long userSid, String email, String telephone, Boolean excludeSensitiveData) {
        ArrayList<TenantRelationWithUserWithStatusVO> results = new ArrayList<TenantRelationWithUserWithStatusVO>();
        if (0 == type) {
            this.invitedUserHistoryRepository.findTenantInvitedUser(userSid, email, telephone).forEach(invitedUserHistory -> this.tenantRepository.findById(invitedUserHistory.getTenantSid()).ifPresent(tenant -> results.add(new TenantRelationWithUserWithStatusVO((InvitedUserHistory)((Object)invitedUserHistory), (Tenant)((Object)((Object)tenant)), excludeSensitiveData))));
            this.getTenantDefaultLanguage(results);
            this.getTenantCorpId(results);
        }
        return results;
    }

    private List<TenantRelationWithUserWithStatusVO> queryUserApplyTenant(Long userSid, Boolean excludeSensitiveData) {
        List<InvitedUserHistory> invitedUserHistoryList = this.invitedUserHistoryRepository.findTenantApplyUser(userSid);
        ArrayList<TenantRelationWithUserWithStatusVO> results = new ArrayList<TenantRelationWithUserWithStatusVO>();
        for (InvitedUserHistory invitedUserHistory : invitedUserHistoryList) {
            Optional optionalTenant = this.tenantRepository.findById(invitedUserHistory.getTenantSid());
            optionalTenant.ifPresent(tenant -> results.add(new TenantRelationWithUserWithStatusVO(invitedUserHistory, (Tenant)((Object)tenant), excludeSensitiveData)));
        }
        this.getTenantDefaultLanguage(results);
        this.getTenantCorpId(results);
        return results;
    }

    @Override
    public List<TenantRelationWithUserWithStatusVO> queryUserHasPermissionTenant(long userSid) {
        Action action = this.actionCrudService.findByUri("drn:iam:app:DigiwinCloud:djc-cloud-management:djc-mang-order");
        List<TenantRelationWithUserWithStatusVO> tenants = this.queryUserJoinedTenant(userSid, false);
        long sysSid = this.sysCrudService.getSidById("DigiwinCloud");
        ArrayList<TenantRelationWithUserWithStatusVO> results = new ArrayList<TenantRelationWithUserWithStatusVO>();
        tenants.forEach(tenant -> {
            if (tenant.getConfirm() == 1) {
                if (this.userInRoleService.checkSuperAdmin(tenant.getSid(), userSid)) {
                    results.add((TenantRelationWithUserWithStatusVO)tenant);
                } else {
                    List<Long> actionSids = this.policyCalcService.getPolicyAction(tenant.getSid(), "user", userSid, sysSid);
                    if (actionSids.stream().anyMatch(actionSid -> actionSid.longValue() == action.getSid())) {
                        results.add((TenantRelationWithUserWithStatusVO)tenant);
                    }
                }
            }
        });
        results.removeIf(a -> Boolean.FALSE.equals(a.getTenantVisible()));
        this.getTenantDefaultLanguage(results);
        this.getTenantCorpId(results);
        this.getTenantForms(results);
        return results;
    }

    private void getTenantForms(List<TenantRelationWithUserWithStatusVO> results) {
        List<String> tenantIds = results.stream().map(TenantVO::getId).collect(Collectors.toList());
        IntellyRelationPageVO param = new IntellyRelationPageVO();
        param.setPageSize(99999);
        param.setTenantIds(tenantIds);
        List<IntellyRelationResultVO> relationResults = this.intellyMapper.queryIntellyTenantPage(param);
        if (CollectionUtils.isEmpty(relationResults)) {
            return;
        }
        Map<String, List<IntellyRelationResultVO>> intellyRelMap = relationResults.stream().collect(Collectors.groupingBy(IntellyRelationResultVO::getId));
        results.forEach(tenant -> tenant.setIntellyRelations((List)intellyRelMap.get(tenant.getId())));
    }

    private void getTenantDefaultLanguage(List<TenantRelationWithUserWithStatusVO> results) {
        List<Long> tenantSids = results.stream().map(TenantVO::getSid).collect(Collectors.toList());
        TenantMetadataColumn columns = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"basic", "defaultLanguage"});
        if (columns != null && tenantSids.size() > 0) {
            List<TenantMetadata> tenantMetadatas = this.tenantMetadataMapper.findMetadatasByTenantSidsAndColumnSid(tenantSids, columns.getSid());
            results.forEach(tenant -> tenantMetadatas.forEach(tenantMetadata -> {
                if (tenant.getSid().equals(tenantMetadata.getTenantSid())) {
                    tenant.setDefaultLanguage(tenantMetadata.getValue());
                }
            }));
        }
    }

    private void getTenantCorpId(List<TenantRelationWithUserWithStatusVO> results) {
        List<Long> tenantSids = results.stream().map(TenantVO::getSid).collect(Collectors.toList());
        TenantMetadataColumn columns = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"contact", "corpId"});
        if (columns != null && tenantSids.size() > 0) {
            List<TenantMetadata> tenantMetadatas = this.tenantMetadataMapper.findMetadatasByTenantSidsAndColumnSid(tenantSids, columns.getSid());
            results.forEach(tenant -> tenantMetadatas.forEach(tenantMetadata -> {
                if (tenant.getSid().equals(tenantMetadata.getTenantSid())) {
                    tenant.setCorpId(tenantMetadata.getValue());
                }
            }));
        }
    }

    private void getTenantPasswordSpan(List<TenantRelationWithUserWithStatusVO> results) {
        List<Long> tenantSids = results.stream().map(TenantVO::getSid).collect(Collectors.toList());
        TenantMetadataColumn columns = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"basic", "passwordSpan"});
        if (columns != null && tenantSids.size() > 0) {
            List<TenantMetadata> tenantMetadatas = this.tenantMetadataMapper.findMetadatasByTenantSidsAndColumnSid(tenantSids, columns.getSid());
            results.forEach(tenant -> tenantMetadatas.forEach(tenantMetadata -> {
                if (tenant.getSid().equals(tenantMetadata.getTenantSid())) {
                    tenant.setPasswordSpan(tenantMetadata.getValue());
                }
            }));
        }
    }

    private void getTenantPasswordAttempts(List<TenantRelationWithUserWithStatusVO> results) {
        List<Long> tenantSids = results.stream().map(TenantVO::getSid).collect(Collectors.toList());
        TenantMetadataColumn columns = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"basic", "passwordAttempts"});
        if (columns != null && !tenantSids.isEmpty()) {
            List<TenantMetadata> tenantMetadatas = this.tenantMetadataMapper.findMetadatasByTenantSidsAndColumnSid(tenantSids, columns.getSid());
            results.forEach(tenant -> tenantMetadatas.forEach(tenantMetadata -> {
                if (tenant.getSid().equals(tenantMetadata.getTenantSid())) {
                    tenant.setPasswordAttempts(tenantMetadata.getValue());
                }
            }));
        }
    }

    @Override
    public PageSerializable<UserBasicInfoVO> getUserInfoByTenantWithPage(long tenantSid, UserConditionVO userConditionVO, int pageNum, int pageSize) {
        ArrayList<UserBasicInfoVO> userBasicInfoVOs = new ArrayList<UserBasicInfoVO>();
        List<User> users = this.userMapper.getUsersByTenantWithPage(tenantSid, userConditionVO, pageNum, pageSize);
        PageSerializable pageSerializable = new PageSerializable(users);
        for (User user : users) {
            UserBasicInfoVO userBasicInfoVO = this.userBasicInfoQueryService.getUserBasicInfo(tenantSid, user);
            UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenantSid, user.getSid());
            userBasicInfoVO.setEnabled(!userInTenant.isDisabled());
            userBasicInfoVO.setUserTenantModifyDate(userInTenant.getModifyDate());
            if (userInTenant.isUserType()) {
                userBasicInfoVO.setUserType(1);
            } else {
                userBasicInfoVO.setUserType(0);
            }
            userBasicInfoVOs.add(userBasicInfoVO);
        }
        PageSerializable lists = new PageSerializable();
        lists.setTotal(pageSerializable.getTotal());
        lists.setList(userBasicInfoVOs);
        return lists;
    }

    @Override
    public PageSerializable<UserBasicInfoVO> getUserInfoByTenantWithPageSimple(long tenantSid, UserConditionVO userConditionVO, int pageNum, int pageSize) {
        ArrayList<UserBasicInfoVO> result = new ArrayList<UserBasicInfoVO>();
        List<User> users = this.userMapper.getUsersByTenantWithPage(tenantSid, userConditionVO, pageNum, pageSize);
        List<QueryRoleResultVO> roles = this.userMapper.getUserRolesByTenantSidAndUserSids(tenantSid, users.stream().map(BaseEntity::getSid).collect(Collectors.toList()));
        Map<Long, List<QueryRoleResultVO>> roleMap = roles.stream().collect(Collectors.groupingBy(QueryRoleResultVO::getUserSid));
        for (User user : users) {
            UserBasicInfoVO aResult = new UserBasicInfoVO();
            result.add(aResult);
            aResult.setUser(user);
            Optional.ofNullable(roleMap.get(user.getSid())).ifPresent(aResult::setRole);
        }
        PageSerializable resultPage = new PageSerializable(result);
        resultPage.setTotal(new PageSerializable(users).getTotal());
        return resultPage;
    }

    @Override
    public TenantRelationWithUserWithStatusVO getOauthIsvTenantInfo(long userSid, String userId, String userName) {
        if (Arrays.asList("virtual".toUpperCase(), "integration".toUpperCase()).contains(userId.toUpperCase())) {
            return null;
        }
        List<TenantRelationWithUserWithStatusVO> tenantLists = this.tenantMapper.getTenantBasicInfoWithUserByJoinedUserSid(userSid);
        if (CollectionUtils.isEmpty(tenantLists)) {
            return null;
        }
        TenantRelationWithUserWithStatusVO tenant = tenantLists.stream().filter(t -> t.getIsv() != false && t.getTestTenant() == false).findFirst().orElse(null);
        if (tenant == null) {
            tenant = tenantLists.stream().filter(t -> t.getId().startsWith("ISV") && t.getTestTenant() == false).findFirst().orElse(null);
        }
        if (tenant == null) {
            tenant = tenantLists.stream().filter(t -> t.getSid().equals(t.getUserDefaultTenantSid()) && t.getTestTenant() == false).findFirst().orElse(null);
        }
        if (tenant == null) {
            tenant = tenantLists.stream().filter(t -> t.getTestTenant() == false).findFirst().orElse(null);
        }
        if (tenant == null) {
            tenant = tenantLists.stream().filter(t -> TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue().equals(t.getEnterpriseType())).findFirst().orElse(null);
        }
        if (tenant == null) {
            tenant = new TenantRelationWithUserWithStatusVO();
            tenant.setId("pro-" + userId);
            tenant.setName(userName);
        }
        return tenant;
    }

    @Override
    public List<UserInTenantVO> listUserInTenant(UserInTenantSimpleDTO dto) {
        return this.userInTenantMapper.listUserInTenant(dto);
    }
}

