/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredDevice;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.service.user.UserQueryForWeChatService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UserQueryForWeChatServiceImpl
implements UserQueryForWeChatService {
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private AuthoredUserService authoredUserService;

    @Override
    public IamAuthoredUser getIamAuthoredUser(String openId, AuthoredDevice device) {
        if (StringUtils.isEmpty((Object)openId)) {
            throw new IllegalArgumentException("openId is null");
        }
        Tenant tenant = null;
        List<Tenant> tenants = null;
        User user = this.userRepository.findByWechat(openId);
        if (user == null) {
            throw new BusinessException("\u6839\u636eopenid\u67e5\u8be2\u4e0d\u5230\u7528\u6237");
        }
        AuthoredSys sys = AppAuthContextHolder.getContext().getAuthoredSys();
        Sys loginSys = null;
        if (sys != null) {
            tenants = this.tenantMapper.getTenantsByUserSidAndSysSid(user.getSid(), sys.getSid());
            loginSys = new Sys(sys);
        }
        if (tenants == null || tenants.size() == 0) {
            tenants = this.tenantMapper.getTenantsByJoinedUserSid(user.getSid());
        }
        if (tenants.size() > 0) {
            List defaultTenants;
            tenant = user.getDefaultTenantSid() > 0L ? ((defaultTenants = tenants.stream().filter(data -> data.getSid() == user.getDefaultTenantSid()).collect(Collectors.toList())).size() > 0 ? (Tenant)((Object)defaultTenants.get(0)) : tenants.get(0)) : tenants.get(0);
        }
        LoginUser loginUser = new LoginUser();
        loginUser.setDevice(device);
        loginUser.setUser(user);
        loginUser.setTenant(tenant);
        loginUser.setApp(loginSys);
        return this.authoredUserService.generate(loginUser, true, false);
    }
}

