/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.BaseVO;
import com.digiwin.dap.middleware.iam.domain.dev.EnterpriseUserVO;
import com.digiwin.dap.middleware.iam.domain.excel.UserWechatExcelVO;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.role.RoleInfo;
import com.digiwin.dap.middleware.iam.domain.tenant.AddUsersToTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAppDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantRelevantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantSimpleVO;
import com.digiwin.dap.middleware.iam.domain.tenant.UserInTenantDTO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.TenantWithSysAuthInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserAndTenantSimpleInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserConditionVO;
import com.digiwin.dap.middleware.iam.domain.user.UserContacts;
import com.digiwin.dap.middleware.iam.domain.user.UserDataVO;
import com.digiwin.dap.middleware.iam.domain.user.UserExcludeSensitiveInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInRoleInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.user.UserQueryPageVO;
import com.digiwin.dap.middleware.iam.domain.user.UserQueryRspVO;
import com.digiwin.dap.middleware.iam.domain.user.UserRolesVO;
import com.digiwin.dap.middleware.iam.domain.user.UserSimpleVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysOnPlatform;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.MetadataMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInOrgMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInTenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.SysOnPlatformRepository;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserQueryService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.MultiLanguageQueryVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplication;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplicationDTO;
import com.digiwin.dap.middleware.iam.support.remote.domain.cac.AppAuthUserVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.cac.AppInfo;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.GoodsAlias;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UserQueryServiceImpl
implements UserQueryService {
    @Autowired
    private CacService cacService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserQueryService userQueryService;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private UserInOrgMapper userInOrgMapper;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private MetadataQueryService metadataQueryService;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private MetadataMapper metadataMapper;
    @Autowired
    private UserInTenantMapper userInTenantMapper;
    @Autowired
    private SysOnPlatformRepository sysOnPlatformRepository;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private SysRepository sysRepository;

    @Override
    public String getUserSalt(String userId) {
        User user = (User)this.userCrudService.findById(userId);
        String serviceCloud = "ServiceCloud";
        if (user != null && user.getComeFrom() != null && "ServiceCloud".equals(user.getComeFrom())) {
            return user.getSalt();
        }
        return "";
    }

    @Override
    public List<BaseVO> getUserApplication(TenantApplicationDTO dto) {
        List<AuthorizationResultVO> authorizations = this.cacService.getAuthorizations(dto.getTenantId(), dto.getUserId());
        List<String> goodsCodes = authorizations.stream().map(AuthorizationResultVO::getCode).collect(Collectors.toList());
        List<Sys> sysList = this.sysRepository.findByIdIn(goodsCodes);
        List<MultiLanguageQueryVO> goodsLanguages = this.gmcService.getGoodsMultiLanguageVos(goodsCodes);
        Map<String, String> goodsNameMap = goodsLanguages.stream().filter(g -> g.getContents() != null).flatMap(g -> g.getContents().stream().filter(c -> "goodsName".equals(c.getFieldName()) && c.getContent() != null).map(c -> new AbstractMap.SimpleEntry<String, String>(g.getId(), c.getContent()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        return sysList.stream().map(sys -> {
            BaseVO baseVO = new BaseVO();
            baseVO.setSid(sys.getSid());
            baseVO.setId(sys.getId());
            baseVO.setName(goodsNameMap.getOrDefault(sys.getId(), sys.getName()));
            return baseVO;
        }).collect(Collectors.toList());
    }

    @Override
    public List<TenantApplication> getTenantApplicationByUser(TenantApplicationDTO dto) {
        Assert.hasText((String)dto.getUserId(), (String)"userId is null");
        boolean exists = this.userCrudService.existsById(dto.getUserId());
        if (!exists) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{dto.getUserId()});
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findById(dto.getTenantId());
        List<AuthorizationResultVO> authorizations = this.cacService.getAuthorizations(dto.getTenantId(), dto.getUserId());
        List<String> goodsCodes = authorizations.stream().map(AuthorizationResultVO::getCode).collect(Collectors.toList());
        List<SysOnPlatform> sysOnPlatforms = this.sysOnPlatformRepository.getBySysIdIn(goodsCodes);
        List<AuthorizationResultVO> allAuthorization = this.cacService.queryAllAuthorization(dto.getTenantId());
        allAuthorization.removeIf(auth -> sysOnPlatforms.stream().noneMatch(platform -> auth.getCode().equals(platform.getPlatformSysId())) || authorizations.stream().anyMatch(before -> before.getCode().equals(auth.getCode())));
        authorizations.addAll(allAuthorization);
        goodsCodes.addAll(allAuthorization.stream().map(AuthorizationResultVO::getCode).collect(Collectors.toList()));
        List<MultiLanguageQueryVO> multiLanguageResources = this.gmcService.getGoodsMultiLanguageVos(goodsCodes);
        List<Sys> sysList = this.sysRepository.findByIdIn(goodsCodes);
        Map<String, Sys> sysMap = sysList.stream().collect(Collectors.toMap(BaseEntityWithId::getId, a -> a));
        List<TenantApplication> tenantApplications = new ArrayList<TenantApplication>();
        for (AuthorizationResultVO o2 : authorizations) {
            multiLanguageResources.forEach(multiLanguageVO -> {
                if (o2.getCode().equals(multiLanguageVO.getId())) {
                    Optional<GoodsAlias> goodsAlias;
                    if (!CollectionUtils.isEmpty(multiLanguageVO.getContents())) {
                        multiLanguageVO.getContents().forEach(con -> {
                            if (con.getFieldName().equals("goodsName")) {
                                o2.setDisplayName(con.getContent());
                            }
                        });
                    }
                    if (!StringUtils.isEmpty((Object)o2.getGoodsAliasId()) && null != multiLanguageVO.getGoodsAliases() && (goodsAlias = multiLanguageVO.getGoodsAliases().stream().filter(a -> a.getGoodsAliasId().equals(o2.getGoodsAliasId())).findFirst()).isPresent()) {
                        o2.setGoodsAliasName(goodsAlias.get().getGoodsAliasName());
                    }
                    o2.setGoodsCategoryList(multiLanguageVO.getGoodsCategoryList());
                    o2.setLogoImage(multiLanguageVO.getLogoImage());
                    o2.setDescription(multiLanguageVO.getDescription());
                    o2.setCloudwebsite(multiLanguageVO.getCloudwebsite());
                    o2.setCloudwebsiteHw(multiLanguageVO.getCloudwebsiteHw());
                    o2.setPlatformCodes(multiLanguageVO.getPlatformCodes());
                    o2.setShowConsole(multiLanguageVO.getShowConsole());
                }
            });
            TenantApplication tenantApplication = new TenantApplication(tenant, o2, (Boolean)false);
            Sys sys = sysMap.getOrDefault(o2.getCode(), new Sys());
            tenantApplication.setSid(sys.getSid());
            tenantApplications.add(tenantApplication);
        }
        if (!StringUtils.isEmpty((Object)dto.getExcludePlatformCode())) {
            tenantApplications = tenantApplications.stream().filter(x -> !Optional.ofNullable(x.getPlatformCodes()).orElse(Collections.emptyList()).contains(dto.getExcludePlatformCode())).collect(Collectors.toList());
        }
        if (dto.getShowConsole() != null) {
            tenantApplications = tenantApplications.stream().filter(o -> dto.getShowConsole().equals(o.getShowConsole())).collect(Collectors.toList());
        }
        return tenantApplications;
    }

    @Override
    public List<UserInfoVO> getTenantUsers() {
        List<UserInfoVO> users = this.userMapper.getAllUsers();
        List<QueryRoleResultVO> roles = this.userInRoleMapper.findAllUserRoles();
        Map<String, List<QueryRoleResultVO>> roleMap = roles.stream().collect(Collectors.groupingBy(o -> o.getTenantSid() + "-" + o.getUserSid()));
        List<QueryUserInOrgResultVO> orgs = this.userInOrgMapper.findAllUserOrgs();
        Map<String, List<QueryUserInOrgResultVO>> orgMap = orgs.stream().collect(Collectors.groupingBy(o -> o.getTenantSid() + "-" + o.getUserSid()));
        users.forEach(o -> {
            if (roleMap.containsKey(o.getTenantSid() + "-" + o.getSid())) {
                o.setRoles((List)roleMap.get(o.getTenantSid() + "-" + o.getSid()));
            }
            if (orgMap.containsKey(o.getTenantSid() + "-" + o.getSid())) {
                o.setUserInOrgs((List)orgMap.get(o.getTenantSid() + "-" + o.getSid()));
            }
        });
        return users;
    }

    @Override
    public List<UserInfoVO> getTenantUsers(long tenantSid) {
        List<UserInfoVO> users = this.userMapper.getAllUsers(tenantSid);
        List<QueryRoleResultVO> roles = this.userInRoleMapper.findUserRoles(tenantSid);
        Map<Long, List<QueryRoleResultVO>> roleMap = roles.stream().collect(Collectors.groupingBy(QueryRoleResultVO::getUserSid));
        List<QueryUserInOrgResultVO> orgs = this.userInOrgMapper.findUserOrgs(tenantSid);
        Map<Long, List<QueryUserInOrgResultVO>> orgMap = orgs.stream().collect(Collectors.groupingBy(QueryUserInOrgResultVO::getUserSid));
        users.forEach(o -> {
            if (roleMap.containsKey(o.getSid())) {
                o.setRoles((List)roleMap.get(o.getSid()));
            }
            if (orgMap.containsKey(o.getSid())) {
                o.setUserInOrgs((List)orgMap.get(o.getSid()));
            }
        });
        return users;
    }

    @Override
    public List<UserWechatExcelVO> getTenantUsersWechatExcelVO(long tenantSid) {
        ArrayList<UserWechatExcelVO> list = new ArrayList<UserWechatExcelVO>();
        List<User> users = this.userMapper.getUsersByTenantSid(tenantSid);
        for (User user : users) {
            List<UserMetadataVO> metadataVOS = this.metadataQueryService.queryUserMetadataByTenantSidAndUserSid(tenantSid, user.getSid());
            String wechat = metadataVOS.stream().filter(x -> "wechat".equals(x.getKey())).findFirst().map(UserMetadataVO::getValue).orElse(null);
            list.add(new UserWechatExcelVO(user.getId(), user.getName(), wechat));
        }
        return list;
    }

    @Override
    public List<UserSimpleVO> getUserSimpleByTenant(long tenantSid) {
        return this.userMapper.findUserSimpleVoByTenantSid(tenantSid);
    }

    @Override
    public UserAndTenantSimpleInfo getUserAndTenantSimpleInfo(long userSid, long tenantSid) {
        UserAndTenantSimpleInfo userAndTenantSimpleInfo = new UserAndTenantSimpleInfo();
        if (this.userInTenantCrudService.existsByUnionKey(tenantSid, userSid)) {
            User user = (User)this.userCrudService.findBySid(userSid);
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
            if (user != null && tenant != null) {
                userAndTenantSimpleInfo.setUserId(user.getId());
                userAndTenantSimpleInfo.setUserName(user.getName());
                userAndTenantSimpleInfo.setTenantId(tenant.getId());
                userAndTenantSimpleInfo.setTenantName(tenant.getName());
            }
        }
        return userAndTenantSimpleInfo;
    }

    @Override
    @Transactional
    public List<UserSimpleVO> getUserSimpleVOSByEmpSimple(UserSimpleVO userSimpleCondition, int pageNum, int pageSize, String orderBy, long tenantSid) {
        List<UserSimpleVO> userSimpleVOS = this.userMapper.findUserSimpleVOSByUserSimple(userSimpleCondition, pageNum, pageSize, orderBy, tenantSid);
        return userSimpleVOS;
    }

    @Override
    public UserContacts getUserContacts(String id, Integer type) {
        UserContacts userContacts = Integer.valueOf(0).equals(type) ? this.userQueryService.getUserContactsById(id) : this.userMapper.getUserContacts(id);
        if (userContacts != null) {
            if (!StringUtils.isEmpty((Object)userContacts.getTelephone())) {
                userContacts.setTelephone(userContacts.getTelephone().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2"));
            }
            return userContacts;
        }
        throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_USER_NOT_EXIST, new Object[]{id});
    }

    @Override
    public PageSerializable<EnterpriseUserVO> getEnterpriseUsers(Integer pageNum, Integer pageSize, String orderBy, UserConditionVO userConditionVO, Long tenantSid) {
        List<EnterpriseUserVO> users = this.userMapper.getEnterpriseUsers(pageNum, pageSize, orderBy, tenantSid, userConditionVO);
        if (!users.isEmpty()) {
            users.forEach(user -> {
                List<RoleInfo> roles = this.userInRoleMapper.queryRolesByUser(tenantSid, user.getSid());
                user.setRoles(roles);
            });
        }
        return new PageSerializable(users);
    }

    @Override
    public List<UserRolesVO> getUserWithRoles(String content, String tenantId) {
        long tenantSid = this.tenantCrudService.getSidById(tenantId);
        return this.userMapper.getUsersByIdOrEmailOrTelOrWechatAndTenantId(content, content, content, content, tenantSid);
    }

    @Override
    public List<UserDataVO> getUserDetailWithRolesInTenant(List<AddUsersToTenantVO> usersWithTenants) {
        ArrayList<String> userIds = new ArrayList<String>();
        usersWithTenants.forEach(u -> userIds.addAll(u.getUserIds()));
        List<String> tenantIds = usersWithTenants.stream().map(AddUsersToTenantVO::getTenantId).collect(Collectors.toList());
        ArrayList<UserDataVO> userDataVOS = new ArrayList<UserDataVO>();
        if (!tenantIds.isEmpty()) {
            List<TenantSimpleVO> tenantSimpleVOS = this.tenantMapper.getTenantSidsByTenantIds(tenantIds);
            if (!CollectionUtils.isEmpty(userIds)) {
                List<UserDataVO> userAllDataVOS = this.userMapper.getUserInTenantByIds(userIds, tenantIds);
                tenantSimpleVOS.forEach(t -> {
                    List<UserDataVO> filterTenants = userAllDataVOS.stream().filter(u -> u.getTenantId().equals(t.getTenantId())).collect(Collectors.toList());
                    if (filterTenants.isEmpty()) {
                        UserDataVO userDataVO = new UserDataVO();
                        userDataVO.setTenantSid(t.getTenantSid());
                        userDataVO.setTenantId(t.getTenantId());
                        userDataVO.setTestTenant(t.getTestTenant());
                        userDataVOS.add(userDataVO);
                    } else {
                        ArrayList currentUserIds = new ArrayList();
                        usersWithTenants.stream().filter(s -> s.getTenantId().equals(t.getTenantId())).collect(Collectors.toList()).forEach(r -> currentUserIds.addAll(r.getUserIds()));
                        filterTenants.forEach(data -> {
                            if (currentUserIds.isEmpty()) {
                                UserDataVO userDataVO = new UserDataVO();
                                userDataVO.setTenantSid(t.getTenantSid());
                                userDataVO.setTenantId(t.getTenantId());
                                userDataVO.setTestTenant(t.getTestTenant());
                                userDataVOS.add(userDataVO);
                                return;
                            }
                            if (currentUserIds.contains(data.getUserId())) {
                                String roleName = data.getRoles().stream().collect(Collectors.joining(";"));
                                data.setRoleName(roleName);
                                userDataVOS.add((UserDataVO)data);
                            }
                        });
                    }
                });
            } else {
                tenantSimpleVOS.forEach(t -> {
                    UserDataVO userDataVO = new UserDataVO();
                    userDataVO.setTenantSid(t.getTenantSid());
                    userDataVO.setTenantId(t.getTenantId());
                    userDataVO.setTestTenant(t.getTestTenant());
                    userDataVOS.add(userDataVO);
                });
            }
        }
        return userDataVOS;
    }

    @Override
    public UserContacts getUserContactsById(String id) {
        return this.userMapper.getUserContactsByIdOrEmailOrTel(id, id, id);
    }

    @Override
    public UserExcludeSensitiveInfoVO getUserByIdOrEmailOrTelOrWechat(String content) {
        return this.userMapper.getUserByIdOrEmailOrTelOrWechat(content, content, content, content);
    }

    @Override
    public List<UserInfoVO> queryUserInfosInRole(UserInRoleInfoVO body) {
        List<Long> tenantSids = this.tenantRepository.findInIds(body.getTenantIds()).stream().map(BaseEntity::getSid).collect(Collectors.toList());
        List<UserInfoVO> users = this.userInRoleMapper.queryUsersByRole(tenantSids, body.getRoleId(), body);
        List<String> userIds = users.stream().map(UserInfoVO::getId).collect(Collectors.toList());
        if (!userIds.isEmpty()) {
            List<UserMetadataVO> metadataVOS = this.metadataMapper.findByTenantSidAndColumnInUserIds(body.getTenantIds(), "basic", "dapAcceptLanguage", userIds);
            users.forEach(u -> {
                UserMetadataVO currentMetadataVO = metadataVOS.stream().filter(m -> u.getId().equals(m.getUserId()) && u.getTenantId().equals(m.getTenantId())).findFirst().orElse(null);
                if (currentMetadataVO == null) {
                    currentMetadataVO = metadataVOS.stream().filter(m -> u.getId().equals(m.getUserId()) && m.getTenantSid() == 0L).findFirst().orElse(null);
                }
                if (currentMetadataVO != null) {
                    u.setLanguage(currentMetadataVO.getValue());
                    return;
                }
            });
        }
        return users;
    }

    @Override
    public List<TenantRelevantInfoVO> getUserJoinedTenants(String account) {
        User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(account, account, account, 0);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{account});
        }
        return this.userInTenantMapper.findAllTenantByUser(user.getSid());
    }

    @Override
    public List<UserSimpleVO> queryUserList(long tenantSid, UserInTenantDTO dto, int pageNum, int pageSize, String orderBy) {
        return this.userMapper.getUserInfoList(tenantSid, dto, pageNum, pageSize, orderBy);
    }

    @Override
    public List<UserSimpleVO> queryUserList(long tenantSid, UserInTenantDTO dto) {
        return this.userMapper.getUserInfoList(tenantSid, dto);
    }

    @Override
    public PageSerializable<UserSimpleVO> queryAuthorizedUserList(UserInTenantDTO dto, int pageNum, int pageSize, String orderBy) {
        List<String> userIds = this.cacService.getAuthorizedUserIds(UserUtils.getTenantId(), dto.getAppId());
        if (CollectionUtils.isEmpty(userIds)) {
            return new PageSerializable();
        }
        dto.setUserIds(userIds);
        return PageSerializable.of(this.userQueryService.queryUserList(UserUtils.getTenantSid(), dto, pageNum, pageSize, orderBy));
    }

    @Override
    public List<UserSimpleVO> queryAuthorizedUserList(UserInTenantDTO dto) {
        List<String> userIds = this.cacService.getAuthorizedUserIds(UserUtils.getTenantId(), dto.getAppId());
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyList();
        }
        dto.setUserIds(userIds);
        return this.userQueryService.queryUserList(UserUtils.getTenantSid(), dto);
    }

    @Override
    public PageSerializable<UserQueryRspVO> getUserInfoPage(UserQueryPageVO vo) {
        PageMethod.startPage((int)vo.getPageNum(), (int)vo.getPageSize(), (String)vo.getOrderBy());
        return new PageSerializable(this.userMapper.getUserInfoPage(vo));
    }

    @Override
    public PageSerializable<UserSimpleVO> getAuthUsers(TenantAppDTO tenantAppDTO) {
        ArrayList<String> userIds = new ArrayList<String>();
        List<String> tenantIds = tenantAppDTO.getTenantIds();
        String appId = tenantAppDTO.getAppId();
        if (null != tenantAppDTO.getUserSid() && 0L < tenantAppDTO.getUserSid()) {
            User user = (User)this.userCrudService.findBySid(tenantAppDTO.getUserSid());
            if (null != user) {
                tenantAppDTO.setUserId(user.getId());
            } else {
                return new PageSerializable();
            }
        }
        if (StringUtils.hasText((String)tenantAppDTO.getUserId())) {
            List<TenantWithSysAuthInfo> cacTenantResult = this.cacService.checkUserInTenantAuth(appId, tenantAppDTO.getUserId(), tenantIds);
            if (CollectionUtils.isEmpty(cacTenantResult)) {
                return new PageSerializable();
            }
            userIds.add(tenantAppDTO.getUserId());
        } else {
            List<AppAuthUserVO> authUsers = this.cacService.getAppAuthUsers4Tenant(Collections.singletonList(appId), tenantIds);
            authUsers.forEach(a -> {
                AppInfo appInfo = a.getApps().stream().filter(p -> appId.equals(p.getAppId())).findFirst().orElse(null);
                if (null != appInfo && appInfo.getUserIds().size() > 0) {
                    userIds.addAll(appInfo.getUserIds());
                }
            });
        }
        if (userIds.isEmpty()) {
            return new PageSerializable();
        }
        List<UserSimpleVO> userSimpleVOS = this.userMapper.getUserSimples(userIds.stream().distinct().collect(Collectors.toList()), tenantAppDTO, tenantAppDTO.getPageSize(), tenantAppDTO.getPageNum());
        return new PageSerializable(userSimpleVOS);
    }
}

