/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.constant.enums.BooleanStrEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.constant.enums.UserTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ReassignAdminVO;
import com.digiwin.dap.middleware.iam.domain.tenant.UserInTenantSimpleDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.UserInTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataLdapVO;
import com.digiwin.dap.middleware.iam.domain.user.CheckPasswordVO;
import com.digiwin.dap.middleware.iam.domain.user.EMCEmailContactDTO;
import com.digiwin.dap.middleware.iam.domain.user.InternalUserUnfreezeVO;
import com.digiwin.dap.middleware.iam.domain.user.ModUserVO;
import com.digiwin.dap.middleware.iam.domain.user.RegisterTempUserVO;
import com.digiwin.dap.middleware.iam.domain.user.RegisterUserWithTenantVO;
import com.digiwin.dap.middleware.iam.domain.user.UpdatePasswordByIdVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserDataVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.user.UserTypeVO;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.InvitedUserHistory;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserDeregisterRecord;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.UserInTenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.repository.UserDeregisterRecordRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.login.LoginFailureHandlingService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.InvitedUserHistoryCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRelationWithUserService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantOperationService;
import com.digiwin.dap.middleware.iam.service.user.UserService;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.iam.support.clean.PolicyCascadeDeleteService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.obsolete.service.UserV2Service;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.LdapService;
import com.digiwin.dap.middleware.iam.support.remote.OmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.EmpInfoVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.ad.AdOu;
import com.digiwin.dap.middleware.iam.support.remote.domain.ad.AdTenantInfoDTO;
import com.digiwin.dap.middleware.iam.support.remote.domain.ad.AdUser;
import com.digiwin.dap.middleware.iam.support.remote.domain.omc.OrderListResult;
import com.digiwin.dap.middleware.iam.support.validate.OtherValidateService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.iam.util.vlidator.PasswordValidator;
import com.digiwin.dap.middleware.util.I18nUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private InvitedUserHistoryCrudService invitedUserHistoryCrudService;
    @Autowired
    private UserV2Service userV2Service;
    @Autowired
    private OtherValidateService otherValidateService;
    @Autowired
    private UserInTenantOperationService userInTenantOperationService;
    @Autowired
    private MetadataUpdateService metadataUpdateService;
    @Autowired
    private CacService cacService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private LoginFailureHandlingService loginFailureHandlingService;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private PasswordEncoder iamPasswordEncoder;
    @Autowired
    private TenantRelationWithUserService tenantRelationWithUserService;
    @Autowired
    @Qualifier(value="internalIdentityService")
    private IdentityService internalIdentityService;
    @Autowired
    private ThreadPoolTaskExecutor dapTaskExecutor;
    @Autowired
    private PolicyCascadeDeleteService policyCascadeDeleteService;
    @Autowired
    private UserDeregisterRecordRepository userDeregisterRecordRepository;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private CommonCacheService commonCacheService;
    @Autowired
    private UserInTenantMapper userInTenantMapper;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private OmcService omcService;

    @Override
    public void disableUser(long tenantSid, long userSid) {
        this.otherValidateService.checkParam(tenantSid, userSid);
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenantSid, userSid);
        if (userInTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_IN_TENANT, new Object[]{userSid, tenantSid});
        }
        if (!userInTenant.isDisabled()) {
            UserInTenant oldUserInTenant = new UserInTenant();
            BeanUtils.copyProperties((Object)((Object)userInTenant), (Object)((Object)oldUserInTenant));
            userInTenant.setDisabled(true);
            this.userInTenantCrudService.update(userInTenant);
            this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.USER_DISABLE_UPDATE.getName(), (Object)oldUserInTenant, (Object)userInTenant, String.valueOf(oldUserInTenant.getUserSid()), Arrays.asList("sid"), Arrays.asList("disabled"));
        }
    }

    @Override
    public void enableUser(long tenantSid, long userSid) {
        this.otherValidateService.checkParam(tenantSid, userSid);
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenantSid, userSid);
        if (userInTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_IN_TENANT, new Object[]{userSid, tenantSid});
        }
        if (userInTenant.isDisabled()) {
            UserInTenant oldUserInTenant = new UserInTenant();
            BeanUtils.copyProperties((Object)((Object)userInTenant), (Object)((Object)oldUserInTenant));
            userInTenant.setDisabled(false);
            this.userInTenantCrudService.update(userInTenant);
            this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.USER_ENABLE_UPDATE.getName(), (Object)oldUserInTenant, (Object)userInTenant, String.valueOf(userInTenant.getUserSid()), Arrays.asList("sid"), Arrays.asList("disabled"));
        }
    }

    @Override
    public void updateUserInAdmin(long tenantSid, long userSid) {
        this.otherValidateService.checkParam(tenantSid, userSid);
        Role role = this.roleCrudService.findByTenantSidAndId(tenantSid, "superadmin");
        if (role == null) {
            throw new BusinessException("\u6ca1\u6709\u7ba1\u7406\u5458\u89d2\u8272");
        }
        Association association = new Association();
        association.setTenantSid(tenantSid);
        association.setRoleSid(role.getSid());
        association.setUserSid(userSid);
        association.setStatus(Boolean.TRUE);
        Association associationTemp = this.userInRoleCrudService.findByUnionKey(tenantSid, userSid, role.getSid());
        if (associationTemp == null) {
            this.userInRoleCrudService.create((BaseEntity)association);
        }
    }

    @Override
    public void updateUserCancelAdmin(long tenantSid, long userSid) {
        this.otherValidateService.checkParam(tenantSid, userSid);
        Role adminRole = this.roleCrudService.findByTenantSidAndId(tenantSid, "superadmin");
        if (adminRole == null) {
            throw new BusinessException("\u6ca1\u6709\u7ba1\u7406\u5458\u89d2\u8272");
        }
        Association associationTemp = this.userInRoleCrudService.findByUnionKey(tenantSid, userSid, adminRole.getSid());
        if (associationTemp != null) {
            this.userInRoleCrudService.deleteByUnionKey(tenantSid, userSid, adminRole.getSid());
        }
    }

    @Override
    public void activateUser(long tenantSid, long userSid) {
        this.otherValidateService.checkParam(tenantSid, userSid);
        User user = (User)this.userCrudService.findBySid(userSid);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        if (!user.isActivated()) {
            user.setActivated(true);
            this.userCrudService.update((BaseEntity)user);
        }
    }

    @Override
    public void updateBasicInfo(long tenantSid, long userSid, UserBasicInfoVO updateBasicInfoVO) {
        this.otherValidateService.checkParam(tenantSid, userSid);
        if (updateBasicInfoVO == null) {
            throw new IllegalArgumentException("bossUpdateBasicInfoVO is null");
        }
        User user = (User)this.userCrudService.findBySid(userSid);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        ArrayList<String> roleIds = new ArrayList<String>();
        for (QueryRoleResultVO current : updateBasicInfoVO.getRole()) {
            roleIds.add(current.getId());
        }
        this.userInRoleService.updateUserInRoleByUser(tenantSid, userSid, roleIds);
        this.userV2Service.updateUserInOrgByUser(tenantSid, userSid, "all", updateBasicInfoVO.getUserInOrg());
    }

    @Override
    public void agreeTenantInvited(long userSid, long invitedHistorySid) {
        InvitedUserHistory history = (InvitedUserHistory)this.invitedUserHistoryCrudService.findBySid(invitedHistorySid);
        if (null == history) {
            throw new BusinessException(String.format("\u9080\u8bf7\u8bb0\u5f55\u3010%s\u3011\u4e0d\u5b58\u5728", invitedHistorySid));
        }
        User user = (User)this.userCrudService.findBySid(userSid);
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(history.getTenantSid());
        this.otherValidateService.checkInvitedParam(history, userSid, user, tenant);
        history.setConfirmDate(LocalDateTime.now());
        history.setAcceptedstatus(IamConstants.AcceptedStatus.Agree.toString());
        this.invitedUserHistoryCrudService.update(history);
        this.userInTenantCrudService.createUserInTenant(tenant.getSid(), user.getSid(), false);
    }

    @Override
    public void updateUserType(UserTypeVO vo, AuthoredUser authoredUser) {
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(vo.getTenantSid(), vo.getUserSid());
        if (userInTenant == null) {
            throw new BusinessException("\u7528\u6237" + vo.getUserSid() + "\u4e0d\u5728\u79df\u6237" + vo.getTenantSid() + "\u4e2d");
        }
        if (vo.getUserType() == 0) {
            userInTenant.setUserType(false);
        } else {
            userInTenant.setUserType(true);
        }
        userInTenant.setDisabled(vo.getDisable());
        this.userInTenantCrudService.update(userInTenant);
        User user = (User)this.userCrudService.findBySid(userInTenant.getUserSid());
        this.remoteEocService.changeEmpStatus(userInTenant.getTenantSid(), user.getId(), vo.getDisable() == false, authoredUser.getToken());
    }

    @Override
    @Transactional
    public Long addUser(long tenantSid, RegisterUserWithTenantVO registerUserWithTenantVO) {
        if (ObjectUtils.isEmpty((Object)registerUserWithTenantVO.getEmail()) && ObjectUtils.isEmpty((Object)registerUserWithTenantVO.getTelephone())) {
            throw new BusinessException(I18nCode.EXCEL_IMPORT_USER_ERROR_EMPTY_TELEPHONE_EMAIL.getMessage());
        }
        if (StringUtils.hasText((String)registerUserWithTenantVO.getPasswordHash())) {
            try {
                String password = AES.decrypt((String)registerUserWithTenantVO.getPasswordHash(), (String)KeyConstant.WECHAT_UNION_ID);
                if (PasswordValidator.validatePassword(password)) {
                    throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_FORMAT_ERROR);
                }
                registerUserWithTenantVO.setPassword(password);
            }
            catch (Exception e) {
                logger.error("\u5bc6\u7801\u89e3\u5bc6\u5f02\u5e38: {}", (Object)e.getMessage());
            }
        }
        boolean checkEmail = StringUtils.hasLength((String)registerUserWithTenantVO.getEmail());
        boolean checkTelephone = StringUtils.hasLength((String)registerUserWithTenantVO.getTelephone());
        this.otherValidateService.verifyRegisterBody(registerUserWithTenantVO, false, checkTelephone, checkEmail);
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        User user = new User(registerUserWithTenantVO, this.envProperties.getCloud());
        long userSid = this.userCrudService.create((BaseEntity)user);
        UserInTenant userInTenant = new UserInTenant();
        userInTenant.setUserSid(userSid);
        userInTenant.setUserType(registerUserWithTenantVO.getType());
        userInTenant.setTenantSid(tenantSid);
        this.userInTenantCrudService.create(userInTenant);
        if (!StringUtils.isEmpty((Object)registerUserWithTenantVO.getTelephone())) {
            UserMetadataVO userMetadataVO = new UserMetadataVO("contact", "mobilephone1", registerUserWithTenantVO.getTelephone(), 0L, userSid);
            this.metadataUpdateService.updateMetadataValue(userMetadataVO);
        }
        this.userInTenantOperationService.initializeUserData(tenant, user, registerUserWithTenantVO.getRole(), registerUserWithTenantVO.getOrg(), registerUserWithTenantVO.getApp(), "", "", registerUserWithTenantVO.getType());
        return userSid;
    }

    @Override
    public void addUserInTenantWithAuth(Tenant tenant, String userId, RegisterTempUserVO input) {
        Association exist;
        long roleSid;
        String appId = input.getAppId();
        List<String> appIds = input.getAppIds();
        String roleId = input.getRoleId();
        User user = (User)this.userCrudService.findById(userId);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userId});
        }
        this.userInTenantCrudService.createUserInTenant(tenant.getSid(), user.getSid(), false);
        if (!StringUtils.isEmpty((Object)appId)) {
            this.cacService.addAuthorization(this.envProperties.getCacUri(), tenant.getId(), appId, user.getId());
        }
        if (!CollectionUtils.isEmpty(appIds)) {
            this.cacService.batchUpdateAuthorization(tenant.getId(), userId, appIds, new ArrayList<String>());
        }
        if (StringUtils.hasLength((String)roleId) && (roleSid = this.roleCrudService.getSidByTenantAndId(tenant.getSid(), roleId)) > 0L && (exist = this.userInRoleCrudService.findByUnionKey(tenant.getSid(), user.getSid(), roleSid)) == null) {
            this.userInRoleService.addUsersInRole(roleSid, Collections.singletonList(user.getSid()), tenant.getSid());
        }
    }

    @Override
    public void reassignAdmin(ReassignAdminVO reassignAdminVO) {
        long tenantSid = UserUtils.getTenantSid();
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        Role role = this.roleCrudService.findByTenantSidAndId(tenantSid, "superadmin");
        if (role == null) {
            throw new BusinessException("\u6ca1\u6709\u7ba1\u7406\u5458\u89d2\u8272");
        }
        List<UserDataVO> users = this.userMapper.getUserInTenantByIds(reassignAdminVO.getUserIds(), Collections.singletonList(tenant.getId()));
        if (users.isEmpty()) {
            throw new BusinessException(String.format("\u7528\u6237%s\u4e0d\u5b58\u5728\u6216\u4e0d\u5728\u79df\u6237[%s]\u4e0b,\u4e0d\u80fd\u79fb\u8f6c", Strings.join(reassignAdminVO.getUserIds(), (char)','), tenant.getId()));
        }
        ArrayList<Association> associations = new ArrayList<Association>();
        for (UserDataVO user : users) {
            Association association = new Association();
            association.setTenantSid(tenantSid);
            association.setRoleSid(role.getSid());
            association.setUserSid(user.getUserSid());
            association.setStatus(Boolean.TRUE);
            Association associationTemp = this.userInRoleCrudService.findByUnionKey(tenantSid, user.getUserSid(), role.getSid());
            if (associationTemp != null) continue;
            associations.add(association);
        }
        this.userInRoleCrudService.insertAll(associations);
        User ownerUser = (User)this.userCrudService.findBySid(tenant.getOwnerUserSid());
        if (ownerUser == null) {
            log.error(String.format("\u79df\u6237%s\u7684\u521b\u5efa\u8005[%s]\u4e0d\u5b58\u5728", tenant.getId(), tenant.getOwnerUserSid()));
            tenant.setOwnerUserSid(users.get(0).getUserSid());
            this.tenantCrudService.update((BaseEntity)tenant);
        } else if (ownerUser.getSid() == UserUtils.getUserSid()) {
            this.userInRoleCrudService.deleteByUnionKey(tenantSid, ownerUser.getSid(), role.getSid());
            tenant.setOwnerUserSid(users.get(0).getUserSid());
            this.tenantCrudService.update((BaseEntity)tenant);
            if (!StringUtils.isEmpty((Object)reassignAdminVO.getRoleId())) {
                role = this.roleCrudService.findByTenantSidAndId(tenantSid, reassignAdminVO.getRoleId());
                if (role == null) {
                    throw new BusinessException(String.format("\u6ca1\u6709\u89d2\u8272%s", reassignAdminVO.getRoleId()));
                }
                Association association = new Association();
                association.setTenantSid(tenantSid);
                association.setRoleSid(role.getSid());
                association.setUserSid(ownerUser.getSid());
                association.setStatus(Boolean.TRUE);
                Association associationTemp = this.userInRoleCrudService.findByUnionKey(tenantSid, ownerUser.getSid(), role.getSid());
                if (associationTemp != null) {
                    return;
                }
                this.userInRoleCrudService.create((BaseEntity)association);
            }
        } else {
            log.error(String.format("\u5f53\u524d\u7528\u6237%s\u975e\u79df\u6237%\u7684\u521b\u5efa\u8005[%s],\u6ca1\u6709\u6743\u9650\u79fb\u8f6c", UserUtils.getUserId(), tenant.getId(), ownerUser.getId()));
        }
    }

    @Override
    public void renewPassword() {
        User user = (User)this.userCrudService.findBySid(UserUtils.getUserSid());
        if (user != null) {
            user.setChanged(true);
            this.userCrudService.update((BaseEntity)user);
        }
    }

    @Override
    public CheckPasswordVO checkPasswordChange() {
        CheckPasswordVO result = new CheckPasswordVO();
        boolean requireChange = false;
        String message = "";
        String type = "";
        if (User.isADAccount(UserUtils.getUserId())) {
            return result;
        }
        User user = (User)this.userCrudService.findBySid(UserUtils.getUserSid());
        int lifeSpan = this.fetchPasswordLifeSpan();
        if (!user.isChanged()) {
            requireChange = true;
            type = "default";
            message = I18nCode.USER_PW_DEFAULT.getMessage();
        } else if (user.getPwDate().plusMonths(lifeSpan).isBefore(LocalDateTime.now())) {
            requireChange = true;
            type = "overdue";
            message = I18nUtils.getMessage((String)I18nCode.USER_PW_OVERDUE.getCode(), (Object[])new Object[]{lifeSpan});
        }
        if (requireChange) {
            result.setChangeRequired(true);
            result.setPwChangeNotification(message);
            result.setPwChangeType(type);
        }
        return result;
    }

    @Override
    public UserInfo getCurrentInfo(AuthoredUser authoredUser, boolean withEmp) {
        User user = (User)this.userCrudService.findBySid(authoredUser.getSid());
        if (null == user) {
            user = (User)this.userCrudService.findById(authoredUser.getUserId());
        }
        if (null == user) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{authoredUser.getUserId()});
        }
        EmpInfoVO empInfoVO = null;
        if (withEmp) {
            if (0L == authoredUser.getTenantSid()) {
                throw new BusinessException("");
            }
            empInfoVO = this.remoteEocService.getEmpByTenantAndUserId(authoredUser.getTenantSid(), authoredUser.getUserId());
        }
        UserInfo userInfo = new UserInfo(user, empInfoVO);
        return userInfo;
    }

    public int fetchPasswordLifeSpan() {
        int span = this.fetchPasswordLifeSpanByTenant();
        if (span > 0) {
            return span;
        }
        return this.fetchPasswordByOMConfig();
    }

    private int fetchPasswordLifeSpanByTenant() {
        String span = this.tenantMetadataCrudService.getTenantMetadataValue(UserUtils.getTenantSid(), "basic", "passwordSpan");
        int result = 0;
        if (!StringUtils.isEmpty((Object)span)) {
            try {
                result = Integer.parseInt(span);
            }
            catch (Exception e) {
                log.error("parse password span error", (Throwable)e);
            }
        }
        return result;
    }

    private int fetchPasswordByOMConfig() {
        int month = 6;
        try {
            DictDataDTO dictDataDTO = new DictDataDTO();
            dictDataDTO.setDictId("pw_life");
            dictDataDTO.setDictKey("pw_life");
            List dictData = this.dictDataService.selectDictDataList(dictDataDTO);
            if (CollectionUtils.isEmpty((Collection)dictData)) {
                return month;
            }
            month = Integer.parseInt(((DictData)dictData.get(0)).getDictValue());
        }
        catch (Exception e) {
            log.error("fail to get password life span");
        }
        return month;
    }

    @Override
    public List<EMCEmailContactDTO> queryEmailBySids(List<Long> userSids) {
        if (CollectionUtils.isEmpty(userSids)) {
            return new ArrayList<EMCEmailContactDTO>();
        }
        return this.userMapper.queryEmailBySids(userSids);
    }

    @Override
    public List<EMCEmailContactDTO> queryEmailByIds(List<String> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return new ArrayList<EMCEmailContactDTO>();
        }
        return this.userMapper.queryEmailByIds(userIds);
    }

    @Override
    public void updatePasswordForce(UpdatePasswordByIdVO body) {
        User user = body.getSid() != 0L ? (User)this.userCrudService.findBySid(body.getSid()) : (User)this.userCrudService.findById(body.getId());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        String newPasswordHash = DigestUtils.sha256((String)body.getNewPassword());
        this.updateInternalUserPassword(user.getSid(), newPasswordHash);
        user.setPassword(newPasswordHash);
        user.setChanged(false);
        this.userCrudService.update((BaseEntity)user);
    }

    private void updateInternalUserPassword(long userSid, String passwordHash) {
        List<Tenant> tenants = this.tenantCrudService.queryTenantByOwnerUserSid(userSid);
        for (Tenant tenant : tenants) {
            User superadminUser;
            User integrationUser = (User)this.userCrudService.findById(tenant.getId() + "@integration");
            if (integrationUser != null) {
                integrationUser.setPassword(passwordHash);
                integrationUser.setChanged(true);
                this.userCrudService.update((BaseEntity)integrationUser);
            }
            if ((superadminUser = (User)this.userCrudService.findById(tenant.getId() + "@superadmin")) == null) continue;
            superadminUser.setPassword(passwordHash);
            superadminUser.setChanged(true);
            this.userCrudService.update((BaseEntity)superadminUser);
        }
    }

    @Override
    public void unfreezeInternal(InternalUserUnfreezeVO dto) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(UserUtils.getTenantSid());
        if (tenant == null || !ObjectUtils.nullSafeEquals((Object)tenant.getId(), (Object)User.getTenantIdOfEnterpriseUser(dto.getId()))) {
            throw new BusinessException((ErrorHandler)I18nError.APP_PERMISSION_ERROR);
        }
        this.loginFailureHandlingService.unfreeze(dto.getId());
    }

    @Override
    public void updateInviteHistory(Long userSid, Long inviteSid) {
        Optional.ofNullable(inviteSid).ifPresent(a -> {
            InvitedUserHistory history = (InvitedUserHistory)this.invitedUserHistoryCrudService.findBySid((long)a);
            if (history != null && history.getUserSid() == -1L && Boolean.FALSE.equals(history.getUsed())) {
                history.setUserSid(userSid);
                history.setUsed(true);
                history.setMode("userId");
                this.invitedUserHistoryCrudService.update(history);
            }
        });
    }

    @Override
    public void syncAdObject(Tenant tenant, TenantMetadataLdapVO vo, AuthoredUser authoredUser, boolean syncOu) {
        boolean isEmpty;
        boolean bl = isEmpty = ObjectUtils.isEmpty((Object)vo.getUrl()) || ObjectUtils.isEmpty((Object)vo.getAdminAccount()) || ObjectUtils.isEmpty((Object)vo.getAdminPassword()) || ObjectUtils.isEmpty((Object)vo.getBaseDn()) || ObjectUtils.isEmpty((Object)vo.getUserLoginAttr());
        if (isEmpty) {
            logger.info("\u79df\u6237{}\u7684AD\u57df\u53c2\u6570\u8865\u5168\uff0c\u9000\u51fa {} <<<---", (Object)tenant.getId(), (Object)vo);
            return;
        }
        authoredUser = this.getAuthoredUser(tenant, authoredUser);
        this.syncAdUser(tenant, vo, authoredUser, true, syncOu);
        if (!syncOu) {
            return;
        }
        List<AdOu> adOus = this.ldapService.listAdOu(vo.getUrl(), vo.getAdminAccount(), AES.decrypt((String)vo.getAdminPassword(), (String)KeyConstant.WECHAT_UNION_ID), BooleanStrEnum.TRUE.getValue().equals(vo.getSslEnabled()), vo.getBaseDn(), vo);
        logger.info("\u540c\u6b65\u79df\u6237{}\u7684AD\u7ec4\u7ec7\uff0csize={}", (Object)tenant.getId(), (Object)adOus.size());
        if (!adOus.isEmpty()) {
            String companyId = StringUtil.getAdCompanyId(null, adOus.get(0));
            this.remoteEocService.syncAdOu(new AdTenantInfoDTO(companyId, null, adOus), authoredUser.getToken());
        }
        AuthoredUser finalAuthoredUser = authoredUser;
        this.dapTaskExecutor.execute(() -> this.syncAdUser(tenant, vo, finalAuthoredUser, false, true));
    }

    public void syncAdUser(Tenant tenant, TenantMetadataLdapVO vo, AuthoredUser authoredUser, boolean syncUser, boolean syncOu) {
        if (!syncUser) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        String adminPassword = AES.decrypt((String)vo.getAdminPassword(), (String)KeyConstant.WECHAT_UNION_ID);
        boolean ssl = BooleanStrEnum.TRUE.getValue().equals(vo.getSslEnabled());
        DirContext ctx = this.ldapService.connect(vo.getUrl(), vo.getAdminAccount(), adminPassword, ssl);
        ArrayList<byte[]> cookieList = new ArrayList<byte[]>(1);
        cookieList.add(null);
        int total = 0;
        int pageSize = 500;
        String companyId = null;
        try {
            do {
                List<AdUser> adUsers = this.ldapService.listAdUserPage((LdapContext)ctx, vo.getBaseDn(), vo, pageSize, cookieList);
                total += adUsers.size();
                if (adUsers.isEmpty()) continue;
                if (syncUser) {
                    logger.info("\u540c\u6b65\u79df\u6237{}\u7684AD\u7528\u6237\uff0cpageSize={}\uff0csize={}", new Object[]{tenant.getId(), pageSize, adUsers.size()});
                    for (AdUser adUser : adUsers) {
                        this.syncAdUser(tenant, authoredUser, adUser);
                    }
                }
                if (!syncOu) continue;
                companyId = StringUtil.getAdCompanyId(companyId, adUsers.get(0));
                logger.info("\u540c\u6b65\u79df\u6237{}\u7684AD\u7528\u6237 -> EOC\u5458\u5de5\uff0cpageSize={}\uff0csize={}", new Object[]{tenant.getId(), pageSize, adUsers.size()});
                this.remoteEocService.syncAdUser(new AdTenantInfoDTO(companyId, adUsers, null), authoredUser.getToken());
            } while (cookieList.get(0) != null);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException namingException) {}
        }
        logger.info("\u540c\u6b65\u79df\u6237{}\u7684AD\u7528\u6237\uff0c\u603b\u91cftotal={}", (Object)tenant.getId(), (Object)total);
    }

    private void syncAdUser(Tenant tenant, AuthoredUser authoredUser, AdUser adUser) {
        boolean disabled = false;
        String userId = String.format("%s$%s", tenant.getId(), adUser.getId());
        User user = (User)this.userCrudService.findById(userId);
        if (user == null) {
            if (Boolean.TRUE.equals(adUser.getDisabled())) {
                logger.info("AD\u7528\u6237[{}]\u72b6\u6001{}\u505c\u7528\uff0c\u8df3\u8fc7\u521b\u5efa...", (Object)adUser.getId(), (Object)adUser.getUserAccountControl());
                return;
            }
            user = this.createUser(adUser, userId, tenant);
        } else {
            disabled = this.updateUser(tenant, authoredUser, adUser, user, disabled);
        }
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
        if (userInTenant == null) {
            userInTenant = new UserInTenant();
            userInTenant.setUserSid(user.getSid());
            userInTenant.setTenantSid(tenant.getSid());
            userInTenant.setDisabled(disabled);
            this.userInTenantCrudService.create(userInTenant);
            logger.info("AD\u57df\u7528\u6237[{}]\u52a0\u5165\u79df\u6237\u6210\u529f...", (Object)userId);
        }
    }

    private boolean updateUser(Tenant tenant, AuthoredUser authoredUser, AdUser adUser, User user, boolean disabled) {
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
        if (Boolean.TRUE.equals(adUser.getDisabled())) {
            if (userInTenant == null) {
                disabled = true;
            } else if (!userInTenant.isDisabled()) {
                this.tenantRelationWithUserService.disableTenantUser(user, authoredUser);
                logger.info("AD\u57df\u7528\u6237[{}]\u7981\u7528\u6210\u529f...", (Object)user.getId());
            }
        } else {
            this.updateUser(adUser, user);
            if (userInTenant != null && userInTenant.isDisabled()) {
                this.tenantRelationWithUserService.enableTenantUser(user, authoredUser);
                logger.info("AD\u57df\u7528\u6237[{}]\u542f\u7528\u6210\u529f...", (Object)user.getId());
            }
        }
        return disabled;
    }

    private void updateUser(AdUser adUser, User user) {
        String telephone;
        boolean update = false;
        String name = adUser.getName();
        String string = telephone = adUser.getTelephoneNumber() != null ? adUser.getTelephoneNumber() : null;
        if (!Objects.equals(user.getName(), name)) {
            user.setName(name);
            update = true;
        }
        if (!Objects.equals(user.getNickname(), adUser.getDisplayName())) {
            user.setNickname(adUser.getDisplayName());
            update = true;
        }
        if (!Objects.equals(user.getTelephone(), telephone)) {
            user.setTelephone(telephone);
            update = true;
        }
        if (!Objects.equals(user.getEmail(), adUser.getMail())) {
            user.setEmail(adUser.getMail());
        }
        if (!IdentityType.ad.name().equals(user.getComeFrom())) {
            user.setComeFrom(IdentityType.ad.name());
            update = true;
        }
        if (update) {
            this.userCrudService.update((BaseEntity)user);
            logger.info("AD\u57df\u7528\u6237\u66f4\u65b0\u6210\u529f{}", (Object)adUser);
        }
    }

    @NotNull
    private User createUser(AdUser adUser, String userId, Tenant tenant) {
        User user = new User();
        user.setName(adUser.getName());
        user.setNickname(adUser.getDisplayName());
        user.setTelephone(adUser.getTelephoneNumber() != null ? adUser.getTelephoneNumber() : null);
        user.setPhone(adUser.getMobile());
        user.setEmail(adUser.getMail());
        user.setId(userId);
        user.setPassword(this.iamPasswordEncoder.encode((CharSequence)(tenant.getId() + "88888888")));
        user.setActivated(true);
        user.setChanged(true);
        user.setComeFrom(IdentityType.ad.name());
        user.setType(UserTypeEnum.INTERNAL.ordinal());
        user.setEnterprise(true);
        this.userCrudService.create((BaseEntity)user);
        logger.info("AD\u57df\u7528\u6237\u521b\u5efa\u6210\u529f{}", (Object)adUser);
        return user;
    }

    private AuthoredUser getAuthoredUser(Tenant tenant, AuthoredUser authoredUser) {
        if (authoredUser != null) {
            return authoredUser;
        }
        LoginUser loginUser = new LoginUser();
        loginUser.setTenantId(tenant.getId());
        loginUser.setUserId("integration");
        loginUser.setPasswordHash(this.envProperties.getIntegrationPasswordHash());
        loginUser.setIdentityType(IdentityType.internal);
        return this.internalIdentityService.login(loginUser);
    }

    @Override
    public void modUser(ModUserVO vo) {
        User user = (User)this.userCrudService.findBySid(vo.getUserSid());
        Optional.ofNullable(user).ifPresent(a -> {
            if (vo.getDoubleCheck() != null) {
                a.setDoubleCheck(vo.getDoubleCheck());
            }
            if (vo.getIdentityCodeAcceptType() != null) {
                a.setIdentityCodeAcceptType(vo.getIdentityCodeAcceptType());
            }
            if (StringUtils.hasLength((String)vo.getUserName())) {
                a.setName(vo.getUserName());
            }
            if (StringUtils.hasText((String)vo.getUserPurpose())) {
                a.setPurpose(vo.getUserPurpose());
            }
            this.userCrudService.update((BaseEntity)user);
        });
    }

    @Override
    @Transactional
    public void deleteUser(String userId, String operatorId, String remark) {
        Tenant tenant;
        User user = (User)this.userRepository.findById(userId);
        if (Objects.isNull((Object)user)) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userId});
        }
        UserDeregisterRecord userDeregisterRecord = new UserDeregisterRecord();
        userDeregisterRecord.setUserSid(user.getSid());
        userDeregisterRecord.setUserId(userId);
        userDeregisterRecord.setUserData(JsonUtils.objToJson((Object)((Object)user)));
        userDeregisterRecord.setRemark(remark);
        userDeregisterRecord.setOperatorId(operatorId);
        userDeregisterRecord.setOperateDate(LocalDateTime.now());
        List<UserInTenantVO> tenants = this.userInTenantMapper.listUserInTenant(new UserInTenantSimpleDTO(user.getSid(), null));
        List invisibleTenantList = tenants.stream().filter(vo -> Boolean.FALSE.equals(vo.getTenantVisible())).collect(Collectors.toList());
        tenants.removeAll(invisibleTenantList);
        List tenantList = tenants.stream().filter(vo -> Boolean.FALSE.equals(vo.getDisabled()) && !TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue().equals(vo.getEnterpriseType()) && !Boolean.FALSE.equals(vo.getTenantVisible())).collect(Collectors.toList());
        if (!tenantList.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_TENANT_EXISTED, new Object[]{userId, tenantList.stream().map(UserInTenantVO::getTenantId).collect(Collectors.joining(","))});
        }
        List tenantList1 = tenants.stream().filter(vo -> Boolean.TRUE.equals(vo.getDisabled()) && !TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue().equals(vo.getEnterpriseType())).collect(Collectors.toList());
        if (!tenantList1.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_TENANT_DISABLED_EXISTED, new Object[]{userId, tenantList1.stream().map(UserInTenantVO::getTenantId).collect(Collectors.joining(","))});
        }
        List tenantList2 = tenants.stream().filter(vo -> TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue().equals(vo.getEnterpriseType())).collect(Collectors.toList());
        if (this.envProperties.isCloud()) {
            for (UserInTenantVO userInTenantVO : tenantList2) {
                OrderListResult orderListResult = this.omcService.getOrdersByTenantId(userInTenantVO.getTenantId());
                if (orderListResult.getTotal() <= 0L) continue;
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_TENANT_ORDER_UNPAID_EXISTED, new Object[]{userId, userInTenantVO.getTenantId()});
            }
        }
        if (!tenantList2.isEmpty()) {
            String tenantIdList = tenantList2.stream().map(UserInTenantVO::getTenantId).collect(Collectors.joining(","));
            logger.warn("\u7528\u6237[{}]\u5b58\u5728\u4e2a\u4eba\u79df\u6237[{}]\uff0c\u8fdb\u884c\u9000\u51fa\u3001\u5220\u9664...", (Object)userId, (Object)tenantIdList);
        }
        for (UserInTenantVO vo2 : invisibleTenantList) {
            tenant = (Tenant)this.tenantRepository.findById(vo2.getTenantId());
            this.userInTenantOperationService.exitTenant(tenant.getSid(), user);
        }
        for (UserInTenantVO vo2 : tenantList2) {
            tenant = (Tenant)this.tenantRepository.findById(vo2.getTenantId());
            this.userInTenantOperationService.exitTenant(tenant.getSid(), user);
            this.tenantService.delete(tenant);
        }
        this.commonCacheService.deleteUserCacheBySid(user.getSid());
        this.userCrudService.deleteById(user.getSid());
        this.invitedUserHistoryCrudService.deleteInvitedUserHistoryByUserSid(user.getSid());
        this.policyCascadeDeleteService.deleteUser(user.getSid());
        this.cacService.batchDeleteUserAuthorization(userId);
        this.userDeregisterRecordRepository.save((Object)userDeregisterRecord);
    }

    @Override
    @Transactional
    public void createAd(String userId, String userName) {
        boolean isAd = userId.toLowerCase().endsWith("@digiwin.com");
        if (!isAd) {
            return;
        }
        User exist = (User)this.userCrudService.findById(userId);
        if (exist != null) {
            return;
        }
        User user = new User();
        user.setId(userId);
        user.setName(userName);
        user.setEmail(userId);
        user.setPassword(DigestUtils.sha256((String)"default"));
        user.setActivated(true);
        user.setComeFrom("digiwin-ad");
        user.setType(UserTypeEnum.NORMAL.getCode());
        user.setChanged(true);
        user.setAgreeAgreement(true);
        this.userCrudService.create((BaseEntity)user);
        Tenant tenant = (Tenant)this.tenantCrudService.findById("99990000");
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
        if (userInTenant == null) {
            this.userInTenantCrudService.create(new UserInTenant(user.getSid(), tenant.getSid()));
        }
    }
}

