/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.user.impl;

import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryAuthUserPageVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.TenantWithSysAuthInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserConditionVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInTenantsWithSysAuthInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.UserWholeMapper;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserWholeService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.domain.cac.AuthedUserInfoVO;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UserWholeServiceImpl
implements UserWholeService {
    @Autowired
    private UserWholeMapper userWholeMapper;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private CacService cacService;

    @Override
    public List<UserBasicInfoVO> getUsersWhole(long tenantSid, List<String> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyList();
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        List<User> users = this.userWholeMapper.findUsersExcludeSensitveDate(tenantSid, userIds);
        ArrayList<UserBasicInfoVO> userBasics = new ArrayList<UserBasicInfoVO>();
        if (users.isEmpty()) {
            userIds.forEach(userId -> {
                UserBasicInfoVO userBasic = new UserBasicInfoVO();
                User user = new User();
                user.setId((String)userId);
                userBasic.setUser(user);
                userBasic.setEffective(false);
                userBasics.add(userBasic);
            });
        } else {
            List<Long> userSids = users.stream().map(BaseEntity::getSid).collect(Collectors.toList());
            List<QueryRoleResultVO> userRoles = this.userWholeMapper.findUsersRole(tenantSid, userSids);
            List<QueryUserInOrgResultVO> userOrgs = this.userWholeMapper.findUsersOrg(tenantSid, userSids);
            List<UserMetadataVO> userMetadatas = this.userWholeMapper.findUsersMetadata(tenantSid, userSids);
            List<UserMappingQueryResultVO> userMappings = this.userWholeMapper.findUsersMapping(tenantSid, userSids);
            List<UserInTenant> userInTenants = this.userWholeMapper.findUsersInTenant(tenantSid, userSids);
            Map<String, User> userMap = users.stream().collect(Collectors.toMap(BaseEntityWithId::getId, Function.identity(), BinaryOperator.maxBy(Comparator.comparingLong(BaseEntity::getSid))));
            Map<Long, List<QueryRoleResultVO>> roles = userRoles.stream().collect(Collectors.groupingBy(QueryRoleResultVO::getUserSid));
            Map<Long, List<QueryUserInOrgResultVO>> orgs = userOrgs.stream().collect(Collectors.groupingBy(QueryUserInOrgResultVO::getUserSid));
            Map<Long, List<UserMetadataVO>> metadatas = userMetadatas.stream().collect(Collectors.groupingBy(UserMetadataVO::getUserSid));
            Map<Long, List<UserMappingQueryResultVO>> mappings = userMappings.stream().collect(Collectors.groupingBy(UserMappingQueryResultVO::getUserSid));
            Map<Long, Boolean> tenants = userInTenants.stream().collect(Collectors.toMap(UserInTenant::getUserSid, BaseEntity::isDisabled));
            userIds.forEach(userId -> {
                UserBasicInfoVO userBasic = new UserBasicInfoVO();
                if (userMap.containsKey(userId)) {
                    User user = (User)((Object)((Object)userMap.get(userId)));
                    if (tenant.getOwnerUserSid() == user.getSid()) {
                        user.setReadonly(true);
                    }
                    userBasic.setEffective(true);
                    userBasic.setEnabled(tenants.getOrDefault(user.getSid(), false) == false);
                    userBasic.setUser(user);
                    userBasic.setRole(roles.getOrDefault(user.getSid(), Collections.emptyList()));
                    userBasic.setUserInOrg(orgs.getOrDefault(user.getSid(), Collections.emptyList()));
                    userBasic.setMetadata(metadatas.getOrDefault(user.getSid(), Collections.emptyList()));
                    userBasic.setMapping(mappings.getOrDefault(user.getSid(), Collections.emptyList()));
                    userBasic.setUserInTag(Collections.emptyList());
                    userBasic.setDefaultOrg(Collections.emptyList());
                } else {
                    User user = new User();
                    user.setId((String)userId);
                    userBasic.setUser(user);
                    userBasic.setEffective(false);
                }
                userBasics.add(userBasic);
            });
        }
        return userBasics;
    }

    @Override
    public UserInTenantsWithSysAuthInfo getTenants(UserConditionVO userConditionVO) {
        List<UserInTenantsWithSysAuthInfo> userInTenants = this.getUsersByEmailOrTel(userConditionVO);
        UserInTenantsWithSysAuthInfo userInTenantsWithSysAuthInfo = userInTenants.get(0);
        List<TenantWithSysAuthInfo> tenants = this.userWholeMapper.getTenantsByUserSid(userConditionVO, userInTenantsWithSysAuthInfo.getUserSid());
        if (!StringUtils.isEmpty((Object)userConditionVO.getAppId()) && !tenants.isEmpty()) {
            List<String> tenantIds = tenants.stream().map(TenantWithSysAuthInfo::getId).collect(Collectors.toList());
            List<TenantWithSysAuthInfo> cacTenantResult = this.cacService.checkUserInTenantAuth(userConditionVO.getAppId(), userInTenantsWithSysAuthInfo.getUserId(), tenantIds);
            cacTenantResult.forEach(t -> {
                TenantWithSysAuthInfo tenantWithSysAuthInfo = tenants.stream().filter(tenant -> t.getId().equals(tenant.getId())).findFirst().orElse(null);
                if (null != tenantWithSysAuthInfo) {
                    t.setName(tenantWithSysAuthInfo.getName());
                    t.setType(tenantWithSysAuthInfo.getType());
                }
            });
            userInTenantsWithSysAuthInfo.setTenants(cacTenantResult);
        }
        return userInTenantsWithSysAuthInfo;
    }

    @Override
    public List<UserInTenantsWithSysAuthInfo> getUsersByEmailOrTel(UserConditionVO conditionVO) {
        if (!StringUtils.isEmpty((Object)conditionVO.getTelephone())) {
            conditionVO.setAesTelephone(conditionVO.getTelephone());
        }
        conditionVO.setType(Optional.ofNullable(conditionVO.getType()).orElse(0));
        List<UserInTenantsWithSysAuthInfo> userInTenants = this.userWholeMapper.getTenants(conditionVO);
        if (userInTenants.isEmpty()) {
            throw new BusinessException(String.format("\u7528\u6237\u6570\u636e\u5f02\u5e38\uff0c\u90ae\u7bb1%s\u6216\u624b\u673a\u53f7%s\u6240\u5c5e\u7528\u6237\u4e0d\u5b58\u5728", conditionVO.getEmail(), conditionVO.getTelephone()));
        }
        if (userInTenants.size() > 1) {
            throw new BusinessException(String.format("\u7528\u6237\u6570\u636e\u5f02\u5e38\uff0c\u5b58\u5728\u591a\u7b14\u90ae\u7bb1%s\u6216\u624b\u673a\u53f7%s\u76f8\u540c\u7684\u7528\u6237", conditionVO.getEmail(), conditionVO.getTelephone()));
        }
        return userInTenants;
    }

    @Override
    public PageSerializable<UserBasicInfoVO> getAuthUsers(long tenantSid, List<AuthedUserInfoVO> cacUsers, QueryAuthUserPageVO body) {
        if (CollectionUtils.isEmpty(cacUsers)) {
            return new PageSerializable(new ArrayList());
        }
        Map<String, AuthedUserInfoVO> cacUserMap = cacUsers.stream().collect(Collectors.toMap(AuthedUserInfoVO::getUserId, Function.identity(), (k1, k2) -> k1));
        PageMethod.startPage((int)body.getPageNum(), (int)body.getPageSize(), (String)body.getOrderBy());
        List<UserBasicInfoVO> users = this.userWholeMapper.findAuthedUsers(tenantSid, new ArrayList<String>(cacUserMap.keySet()), body);
        if (CollectionUtils.isEmpty(users)) {
            return new PageSerializable((List)Lists.newArrayList());
        }
        UserWholeServiceImpl.populateCacInfo(users, cacUserMap);
        this.populateEffective(tenantSid, users);
        this.populateRoleAndOrg(tenantSid, users);
        return new PageSerializable(users);
    }

    private static void populateCacInfo(List<UserBasicInfoVO> users, Map<String, AuthedUserInfoVO> cacUserMap) {
        for (UserBasicInfoVO user : users) {
            AuthedUserInfoVO cacUserInfo = cacUserMap.getOrDefault(user.getUser().getId(), new AuthedUserInfoVO());
            user.setCacAuthDate(cacUserInfo.getCreateDate());
        }
    }

    private void populateEffective(long tenantSid, List<UserBasicInfoVO> users) {
        List<User> inTenant = this.userWholeMapper.findUsersExcludeSensitveDate(tenantSid, users.stream().map(UserBasicInfoVO::getUser).map(BaseEntityWithId::getId).collect(Collectors.toList()));
        Set existIds = inTenant.stream().map(BaseEntityWithId::getId).collect(Collectors.toSet());
        for (UserBasicInfoVO user : users) {
            user.setEffective(existIds.contains(user.getUser().getId()));
        }
    }

    private void populateRoleAndOrg(long tenantSid, List<UserBasicInfoVO> users) {
        List<Long> userSids = users.stream().map(UserBasicInfoVO::getUser).map(BaseEntity::getSid).collect(Collectors.toList());
        List<QueryRoleResultVO> userRoles = this.userWholeMapper.findUsersRole(tenantSid, userSids);
        List<QueryUserInOrgResultVO> userOrgs = this.userWholeMapper.findUsersOrg(tenantSid, userSids);
        Map<Long, List<QueryRoleResultVO>> roles = userRoles.stream().collect(Collectors.groupingBy(QueryRoleResultVO::getUserSid));
        Map<Long, List<QueryUserInOrgResultVO>> orgs = userOrgs.stream().collect(Collectors.groupingBy(QueryUserInOrgResultVO::getUserSid));
        for (UserBasicInfoVO user : users) {
            long sid = user.getUser().getSid();
            user.setRole(roles.getOrDefault(sid, Collections.emptyList()));
            user.setUserInOrg(orgs.getOrDefault(sid, Collections.emptyList()));
        }
    }

    @Override
    public PageSerializable<UserBasicInfoVO> getUsersWithAuth(long tenantSid, QueryAuthUserPageVO body) {
        PageMethod.startPage((int)body.getPageNum(), (int)body.getPageSize(), (String)body.getOrderBy());
        List<UserBasicInfoVO> users = this.userWholeMapper.findUsers4Auth(tenantSid, body);
        if (CollectionUtils.isEmpty(users)) {
            return new PageSerializable((List)Lists.newArrayList());
        }
        this.populateRoleAndOrg(tenantSid, users);
        this.populateAuth(users, body.getAppId(), tenantSid);
        return new PageSerializable(users);
    }

    private void populateAuth(List<UserBasicInfoVO> users, String appId, long tenantSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        List<String> authedUsers = this.cacService.queryUserHasAuth(appId, tenant.getId(), users.stream().map(UserBasicInfoVO::getUser).map(BaseEntityWithId::getId).collect(Collectors.toList()));
        for (UserBasicInfoVO user : users) {
            String userId = user.getUser().getId();
            if (!authedUsers.contains(userId)) continue;
            user.setAuthed(true);
        }
    }
}

