/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.usermapping.impl;

import com.digiwin.dap.middleware.domain.ComeFromEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.BatchMappingQueryRequest;
import com.digiwin.dap.middleware.iam.domain.usermapping.BatchMappingQueryResponse;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingVO;
import com.digiwin.dap.middleware.iam.entity.MetadataColumn;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.entity.UserMapping;
import com.digiwin.dap.middleware.iam.mapper.UserMappingMapper;
import com.digiwin.dap.middleware.iam.repository.UserMappingRepository;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataCrudService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.EmpInfoVO;
import com.digiwin.dap.middleware.util.UserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class UserMappingServiceImpl
implements UserMappingService {
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserMappingCrudService userMappingCrudService;
    @Autowired
    private UserMappingRepository userMappingRepository;
    @Autowired
    private UserMappingMapper userMappingMapper;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private MetadataUpdateService metadataUpdateService;
    @Autowired
    private MetadataCrudService metadataCrudService;
    @Autowired
    private MetadataColumnCrudService metadataColumnCrudService;
    @Autowired
    private ChangeLogService changeLogService;

    @Override
    public void map(long tenantSid, UserMappingVO userMappingVO, boolean force, boolean frontend) {
        UserInTenant userInTenant;
        Assert.hasText((String)userMappingVO.getUserId(), (String)"userId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)userMappingVO.getVerifyUserId(), (String)"verifyUserId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)userMappingVO.getIdentityId(), (String)"identityId\u4e0d\u80fd\u4e3a\u7a7a");
        long userSid = this.userCrudService.getSidById(userMappingVO.getUserId());
        if (userSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_USER_NOT_EXIST, new Object[]{userMappingVO.getUserId()});
        }
        if (tenantSid > 0L && (userInTenant = this.userInTenantCrudService.findByUnionKey(tenantSid, userSid)) == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_EXISTED_ERROR, new Object[]{UserUtils.getTenantId(), userMappingVO.getUserId()});
        }
        List<UserMapping> userMappings = this.userMappingRepository.findByTenantSidAndAccountAndAppIdAndVerifyUserId(tenantSid, userMappingVO.getAccount(), userMappingVO.getIdentityId(), userMappingVO.getVerifyUserId());
        boolean error = false;
        if (userMappings.size() > 0) {
            error = true;
            if (userMappings.size() == 1 && userMappings.get(0).getUserSid() == userSid) {
                error = false;
            }
        }
        if (error) {
            throw new BusinessException((ErrorHandler)I18nError.USER_HAS_REFLECT_TENANT, new Object[]{userMappingVO.getVerifyUserId(), tenantSid, userMappings.get(0).getUserSid()});
        }
        UserMapping userMapping = this.userMappingCrudService.findByUnionKey(tenantSid, userSid, userMappingVO.getIdentityId(), userMappingVO.getAccount());
        if (userMapping == null) {
            userMapping = new UserMapping();
            userMapping.setUserSid(userSid);
            userMapping.setVerifyUserId(userMappingVO.getVerifyUserId());
            userMapping.setAppId(userMappingVO.getIdentityId());
            userMapping.setTenantSid(tenantSid);
            userMapping.setAccount(userMappingVO.getAccount());
            this.userMappingCrudService.create((BaseEntity)userMapping);
            this.changeLogService.createChangeLog(ChangeTypeEnum.USERMAPPING_CREATE.getName(), (Object)userMapping, ChangeTypeEnum.USERMAPPING_CREATE.getPrimaryKey(), String.valueOf(userMapping.getSid()));
        } else {
            UserMapping oldMapping = new UserMapping();
            BeanUtils.copyProperties((Object)((Object)userMapping), (Object)((Object)oldMapping));
            if (frontend) {
                if (userMapping.getVerifyUserId().equals(userMappingVO.getVerifyUserId()) && !force) {
                    throw new BusinessException((ErrorHandler)I18nError.IAM_USER_MAPPING_EXIST_ERROR);
                }
            } else if (!userMapping.getVerifyUserId().equals(userMappingVO.getVerifyUserId()) && !force) {
                throw new BusinessException((ErrorHandler)I18nError.USER_HAS_REFLECT_TENANT, new Object[]{userMappingVO.getVerifyUserId(), tenantSid, userMappingVO.getUserId()});
            }
            userMapping.setUserSid(userSid);
            userMapping.setVerifyUserId(userMappingVO.getVerifyUserId());
            userMapping.setTenantSid(tenantSid);
            userMapping.setAccount(userMappingVO.getAccount());
            this.userMappingCrudService.update((BaseEntity)userMapping);
            this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.USERMAPPING_UPDATE.getName(), (Object)oldMapping, (Object)userMapping, Arrays.asList(ChangeTypeEnum.USERMAPPING_CREATE.getPrimaryKey()), Arrays.asList("userSid", "tenantSid", "verifyUserId"));
        }
        if (ComeFromEnum.LINE.getId().equals(userMapping.getAccount())) {
            MetadataColumn oldMetadataColumn = this.metadataColumnCrudService.getByCatalogIdAndKey("integrationUserId", "line_" + userMappingVO.getIdentityId());
            if (Objects.isNull((Object)oldMetadataColumn)) {
                MetadataColumn metadataColumn = new MetadataColumn();
                metadataColumn.setName("line_" + userMappingVO.getIdentityId());
                metadataColumn.setCatalogId("integrationUserId");
                metadataColumn.setKey("line_" + userMappingVO.getIdentityId());
                metadataColumn.setTenantSid(0L);
                metadataColumn.setType("string");
                metadataColumn.setTypeParameter("[]");
                this.metadataColumnCrudService.create(metadataColumn);
            }
            UserMetadataVO userMetadataVO = new UserMetadataVO();
            userMetadataVO.setUserSid(userSid);
            userMetadataVO.setTenantSid(0L);
            userMetadataVO.setValue(userMappingVO.getVerifyUserId());
            userMetadataVO.setCatalogId("integrationUserId");
            userMetadataVO.setKey("line_" + userMappingVO.getIdentityId());
            this.metadataUpdateService.updateMetadataValue(userMetadataVO);
        }
    }

    @Override
    public void map(long tenantSid, UserMappingVO userMappingVO, boolean force) {
        this.map(tenantSid, userMappingVO, force, false);
    }

    @Override
    public void deleteMap(long tenantSid, UserMappingVO userMappingVO) {
        Assert.hasText((String)userMappingVO.getUserId(), (String)"userId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)userMappingVO.getVerifyUserId(), (String)"verifyUserId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)userMappingVO.getIdentityId(), (String)"identityId\u4e0d\u80fd\u4e3a\u7a7a");
        long userSid = this.userCrudService.getSidById(userMappingVO.getUserId());
        if (userSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{userMappingVO.getUserId()});
        }
        this.userMappingCrudService.deleteByUnionKey(tenantSid, userSid, userMappingVO.getIdentityId(), userMappingVO.getAccount());
        if ("line".equals(userMappingVO.getAccount())) {
            this.metadataCrudService.removeMetadata(0L, userSid, "integrationUserId", "line_" + userMappingVO.getIdentityId());
        }
    }

    @Override
    public void deleteAccountMapping(long tenantSid, String userId, List<String> accountList) {
        Assert.hasText((String)userId, (String)"userId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(accountList, (String)"accountList\u4e0d\u80fd\u4e3a\u7a7a");
        long userSid = this.userCrudService.getSidById(userId);
        if (userSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{userId});
        }
        this.userMappingMapper.deleteAccountMappingByTenantSidAndUserSid(tenantSid, userSid, accountList);
    }

    @Override
    public List<UserMappingQueryResultVO> getMappedByUser(long tenantSid, long userSid) {
        if (tenantSid > 0L) {
            return this.userMappingMapper.findByTenantAndUser(tenantSid, userSid);
        }
        return this.userMappingMapper.findByUser(userSid);
    }

    @Override
    public List<UserMappingQueryResultVO> getMappedByApp(long tenantSid, String sysId, String account) {
        return this.userMappingMapper.findByApp(tenantSid, sysId, account);
    }

    @Override
    public List<UserMappingQueryResultVO> getMappedByUserAndApp(long tenantSid, long userSid, String sysId) {
        return this.userMappingMapper.findByUserAndApp(tenantSid, userSid, sysId);
    }

    @Override
    public void populateEmp(Long tenantSid, String userId, List<UserMappingQueryResultVO> identityInfos) {
        EmpInfoVO empInfoVO = this.remoteEocService.getEmpByTenantAndUserId(tenantSid, userId);
        if (empInfoVO != null) {
            for (UserMappingQueryResultVO identityInfo : identityInfos) {
                identityInfo.setEmpId(empInfoVO.getId());
            }
        }
    }

    @Override
    public List<UserMappingQueryResultVO> getMappedByCondition(long tenantSid, UserMappingVO userMappingVO) {
        return this.userMappingMapper.findByCondition(tenantSid, userMappingVO);
    }

    @Override
    public Long getUserSidByVerifyUserId(Long tenantSid, String sysId, String verifyUserId, String account) {
        return this.userMappingMapper.findUserSidByVerifyUserId(tenantSid, verifyUserId, sysId, account);
    }

    @Override
    public UserMappingQueryResultVO getUserByMapping(Long tenantSid, String sysId, String account, String verifyUserId) {
        return this.userMappingMapper.findUserByMapping(tenantSid, verifyUserId, sysId, account);
    }

    @Override
    public List<UserMappingQueryResultVO> getMappings(Long tenantSid, String account, String verifyUserId) {
        return this.userMappingMapper.findUsersByMapping(tenantSid, verifyUserId, account);
    }

    @Override
    public File export(long tenantSid) {
        List<UserMappingQueryResultVO> byCondition = this.userMappingMapper.findByCondition(tenantSid, null);
        return null;
    }

    @Override
    @Transactional
    public int clearUserMapping() {
        return this.userMappingRepository.deleteByTenantSid(UserUtils.getTenantSid());
    }

    @Override
    public List<UserMappingQueryResultVO> getMappedByAppAndAccount(Long syncTenantSid, String syncAppId, String account) {
        return this.userMappingMapper.findByAppAndAccount(syncTenantSid, syncAppId, account);
    }

    @Override
    public List<BatchMappingQueryResponse> batchQueryMapping(long tenantSid, List<BatchMappingQueryRequest> input) {
        List<String> appIds = input.stream().map(BatchMappingQueryRequest::getAppId).collect(Collectors.toList());
        List<String> thirdIds = input.stream().flatMap(a -> a.getVerifyUserIdList().stream()).collect(Collectors.toList());
        if (appIds.isEmpty() || thirdIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<UserMappingQueryResultVO> raw = this.userMappingMapper.findUserMappingBatch(tenantSid, appIds, thirdIds);
        Map<String, List<UserMappingQueryResultVO>> byApp = raw.stream().collect(Collectors.groupingBy(UserMappingQueryResultVO::getProviderId));
        ArrayList<BatchMappingQueryResponse> result = new ArrayList<BatchMappingQueryResponse>();
        for (Map.Entry<String, List<UserMappingQueryResultVO>> entry : byApp.entrySet()) {
            input.stream().filter(a -> ((String)entry.getKey()).equals(a.getAppId())).findFirst().ifPresent(app -> {
                ((List)entry.getValue()).removeIf(t -> !app.getVerifyUserIdList().contains(t.getVerifyUserId()));
                result.add(new BatchMappingQueryResponse((String)entry.getKey(), (List)entry.getValue()));
            });
        }
        return result;
    }

    @Override
    public List<UserMappingQueryResultVO> getByVerifyUserIdAndAppIdAndAccount(String verifyUserId, String appId, String account) {
        return this.userMappingMapper.findByVerifyUserIdAndAppIdAndAccount(verifyUserId, appId, account);
    }
}

