/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class DeferredExecutionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeferredExecutionService.class);
    @Autowired
    private ThreadPoolTaskExecutor dapTaskExecutor;

    public void runAfterCommitAsync(final Runnable task) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    DeferredExecutionService.this.runAsync(task);
                }
            });
        } else {
            this.runAsync(task);
        }
    }

    public void runAfterCommit(final Runnable task) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    DeferredExecutionService.this.runNow(task);
                }
            });
        } else {
            this.runNow(task);
        }
    }

    public void runAsync(Runnable task) {
        this.dapTaskExecutor.execute(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public void runNow(Runnable task) {
        try {
            task.run();
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }
}

