/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.datapolicy.ActionIdEnum;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataTargetVO;
import com.digiwin.dap.middleware.iam.entity.DevSys;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.mapper.AuthMapper;
import com.digiwin.dap.middleware.iam.repository.DevSysRepository;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.permission.AuthService;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.util.ExecutorUtil;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DataPolicyInterceptor
implements Interceptor {
    public static final String DATA_POLICY_QUERY = "DevSysMapper.findDevSysList";
    private Logger LOGGER = LoggerFactory.getLogger(DataPolicyInterceptor.class);
    private static final int PARAM_COUNT = 4;
    @Lazy
    @Autowired
    private AuthService authService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private DevSysRepository devSysRepository;
    @Lazy
    @Autowired
    private AuthMapper authMapper;
    @Autowired
    private ModuleCrudService moduleCrudService;
    @Autowired
    private ActionCrudService actionCrudService;

    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        String dataPolicySql = boundSql.getSql();
        if (!this.envProperties.getInvalidateDevCurrentDataPolicy().booleanValue() && ms.getId().endsWith(DATA_POLICY_QUERY)) {
            dataPolicySql = this.getSql(dataPolicySql);
        }
        BoundSql dataBoundSql = new BoundSql(ms.getConfiguration(), dataPolicySql, boundSql.getParameterMappings(), parameter);
        Map additionalParameters = ExecutorUtil.getAdditionalParameter((BoundSql)boundSql);
        for (String key : additionalParameters.keySet()) {
            dataBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
        }
        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, dataBoundSql);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private String getSql(String sql) {
        if (this.envProperties.getManagerTenant().equals(UserUtils.getTenantId())) {
            return sql;
        }
        try {
            DataTargetVO targetVO = this.getDataTargetVO();
            List<Map> devAppInfos = this.authService.getDataPermissionRow(targetVO);
            List<DevSys> unBindSysList = this.devSysRepository.findDevSysByTenantSidAndEnableAuth(UserUtils.getTenantSid(), false);
            List<String> devAppIds = unBindSysList.stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
            devAppInfos.forEach(a -> {
                if (!devAppIds.contains(String.valueOf(a.get("id")))) {
                    devAppIds.add(String.valueOf(a.get("id")));
                }
            });
            sql = !devAppIds.isEmpty() ? String.format("%s and ds.id in %s", sql, this.getSql(devAppIds)) : String.format("%s and ds.sid=0", sql);
            return sql;
        }
        catch (Exception exception) {
            this.LOGGER.error("\u6570\u636e\u6743\u9650\u8fc7\u6ee4\u5931\u8d25", (Throwable)exception);
            return String.format("%s and ds.sid=0", sql);
        }
    }

    private DataTargetVO getDataTargetVO() {
        long actionSid;
        DataTargetVO dataTargetVO = new DataTargetVO();
        dataTargetVO.setSysId("dap");
        dataTargetVO.setModuleId("dap-workbench");
        dataTargetVO.setActionId(ActionIdEnum.DEV_APPLICATION_MANAGEMENT.getId());
        dataTargetVO.setTenantId(UserUtils.getTenantId());
        dataTargetVO.setTenantSid(UserUtils.getTenantSid());
        dataTargetVO.setUserId(UserUtils.getUserId());
        dataTargetVO.setUserSid(UserUtils.getUserSid());
        Sys sys = this.authMapper.findSysByTenantSidAndSysId(UserUtils.getTenantSid(), dataTargetVO.getSysId());
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.PERMISSION_SYS_NO_TENANT, new Object[]{dataTargetVO.getSysId(), UserUtils.getTenantId()});
        }
        dataTargetVO.setSysSid(sys.getSid());
        long moduleSid = this.moduleCrudService.getSidByUnionKey(new Object[]{dataTargetVO.getModuleId(), dataTargetVO.getSysSid()});
        if (moduleSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.PERMISSION_MODULE_NO_SYS, new Object[]{dataTargetVO.getModuleId(), dataTargetVO.getSysId()});
        }
        dataTargetVO.setModuleSid(moduleSid);
        long tempSid = 0L;
        if (dataTargetVO.getSelf()) {
            tempSid = dataTargetVO.getTenantSid();
        }
        if ((actionSid = this.actionCrudService.getSidByUnionKey(new Object[]{dataTargetVO.getActionId(), moduleSid, tempSid})) == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.PERMISSION_ACTION_NO_MODULE, new Object[]{dataTargetVO.getActionId(), dataTargetVO.getModuleId()});
        }
        dataTargetVO.setActionSid(actionSid);
        return dataTargetVO;
    }

    private String getSql(List<String> values) {
        StringBuilder sql = new StringBuilder("(");
        for (String value : values) {
            sql.append("'").append(value).append("',");
        }
        sql = new StringBuilder(sql.substring(0, sql.length() - 1) + ")");
        return sql.toString();
    }
}

