/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect;

import com.digiwin.dap.middleware.iam.domain.policy.BatchSaveTargetPolicyRequestVO;
import com.digiwin.dap.middleware.iam.domain.policy.CopyPermissionDataVO;
import com.digiwin.dap.middleware.iam.domain.policy.CopyPermissionVO;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyTargetVO;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetPolicy;
import com.digiwin.dap.middleware.iam.mapper.CacheMapper;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RefreshPermission {
    private static final Logger logger = LoggerFactory.getLogger(RefreshPermission.class);
    @Autowired
    private CacheMapper cacheMapper;
    @Autowired
    private RefreshCacheService refreshCacheService;

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.user.UserInRoleService.deleteRoleInUser(long ,long))&& args(tenantSid, userSid)", argNames="tenantSid,userSid")
    public void afterDeleteRoleInUser(long tenantSid, long userSid) {
        this.refreshCacheService.deletePermissionByUserAndTenant(userSid, tenantSid);
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.user.UserInRoleService.deleteUserInRole(..))&& args(roleSid, tenantSid, sysId)", argNames="roleSid,tenantSid,sysId")
    public void afterDeleteUserInRole(long roleSid, long tenantSid, String sysId) {
        this.refreshCacheService.deletePermissionByTenant(tenantSid);
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.iam.service.user.impl.UserInRoleServiceImpl.deleteUsersInRole(..))")
    public void afterDeleteUsersInRole(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        this.refreshCacheService.deletePermissionByTenant((Long)args[2]);
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.user.impl.UserInRoleServiceImpl.addUsersInRole(..))")
    public void afterAddUsersInRole(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        this.refreshCacheService.deletePermissionByTenant((Long)args[2]);
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.policy.impl.PolicyHandleServiceImpl.update(long,com.digiwin.dap.middleware.iam.domain.policy.v2.TargetPolicy)) && args(tenantSid,targetPolicy)")
    public void addActionPolicy(long tenantSid, TargetPolicy targetPolicy) {
        this.refreshCacheService.deletePermissionByPolicy(tenantSid, targetPolicy.getType(), targetPolicy.getTargetSid(), targetPolicy.getSysSid());
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.policy.impl.PolicyHandleServiceImpl.batchUpdate(com.digiwin.dap.middleware.iam.domain.policy.BatchSaveTargetPolicyRequestVO)) && args(input)")
    public void addActionPolicyBatch(BatchSaveTargetPolicyRequestVO input) {
        this.refreshCacheService.deletePermissionByPolicy(input.getTenantSid(), input.getType(), input.getTargetSid(), input.getSysSid());
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.policy.impl.PolicyHandleServiceImpl.delete(long, long, long, String))  && args(tenantSid, sysSid, targetSid, type)", argNames="tenantSid,sysSid,targetSid,type")
    public void afterDeletePolicy(long tenantSid, long sysSid, long targetSid, String type) {
        this.refreshCacheService.deletePermissionByPolicy(tenantSid, type, targetSid, sysSid);
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.policy.impl.PolicyHandleServiceImpl.saveConditionValue(long,com.digiwin.dap.middleware.iam.domain.policy.v2.TargetPolicy)) && args(policySid, targetVO)", argNames="policySid,targetVO")
    public void saveConditionValue(long policySid, TargetPolicy targetVO) {
        this.refreshCacheService.deletePermissionByPolicy(targetVO.getTenantSid(), targetVO.getType(), targetVO.getTargetSid(), targetVO.getSysSid());
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.policy.impl.PolicyCopyServiceImpl.copyPolicy(long, com.digiwin.dap.middleware.iam.domain.policy.CopyPermissionVO)) && args(tenantSid, copyInfo)", argNames="tenantSid,copyInfo")
    public void copyPolicy(long tenantSid, CopyPermissionVO copyInfo) {
        try {
            String tenantId = this.cacheMapper.findTenantIdByTenantSid(tenantSid);
            CopyPermissionDataVO source = copyInfo.getSource();
            List<Object> sysIds = new ArrayList();
            if ("role".equals(source.getType())) {
                sysIds = this.cacheMapper.findSysIdsByRoleSidAndTenantSid(source.getSid(), tenantSid);
            } else if ("org".equals(source.getType())) {
                sysIds = this.cacheMapper.findSysIdsByOrgSid(source.getSid(), tenantSid);
            }
            sysIds.forEach(sysId -> this.refreshCacheService.deletePermissionBySysAndTenant((String)sysId, tenantId));
        }
        catch (Exception e) {
            logger.error("\u3010\u6e05\u7a7a\u6743\u9650\u7f13\u5b58\u3011\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.policy.impl.PolicyHandleOldServiceImpl.*(long,long,String,com.digiwin.dap.middleware.iam.domain.policy.PolicyTargetVO)) && args(tenantSid, sysSid, sysId, input)", argNames="tenantSid,sysSid,sysId,input")
    public void updatePolicy(long tenantSid, long sysSid, String sysId, PolicyTargetVO input) {
        String tenantId = this.cacheMapper.findTenantIdByTenantSid(tenantSid);
        this.refreshCacheService.deletePermissionBySysAndTenant(sysId, tenantId);
    }
}

