/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect.entity;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DigiSecurityAspect {
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private WhiteListService whiteListService;

    @Before(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.create(..))&& target(com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService)")
    public void banNonAdFromDigi(JoinPoint joinPoint) {
        User user;
        UserInTenant uit = (UserInTenant)((Object)joinPoint.getArgs()[0]);
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(uit.getTenantSid());
        if ("99990000".equals(tenant.getId()) && (user = (User)this.userCrudService.findBySid(uit.getUserSid())).normal() && !user.getId().toLowerCase().endsWith("@digiwin.com")) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_DIGI_SECURITY_AD);
        }
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.create(..))&& target(com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService)")
    public void controlDigiAdmin(JoinPoint joinPoint) {
        List<String> whiteList;
        Tenant tenant;
        Association association = (Association)((Object)joinPoint.getArgs()[0]);
        Role role = this.roleCrudService.findByTenantSidAndSid(association.getTenantSid(), association.getRoleSid());
        if (role != null && "superadmin".equals(role.getId()) && "99990000".equals((tenant = (Tenant)this.tenantCrudService.findBySid(role.getTenantSid())).getId()) && !(whiteList = this.whiteListService.getWhiteList("ALLOW_GRANT_ADMIN")).contains(UserUtils.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_DIGI_SECURITY_ADMIN);
        }
    }
}

