/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect.entity;

import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.mapper.CacheMapper;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteLMCService;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RefreshRole {
    @Autowired
    private CacheMapper cacheMapper;
    @Autowired
    private RefreshCacheService refreshCacheService;
    @Autowired
    private RemoteLMCService remoteLMCService;

    @Before(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.update(..))&& target(com.digiwin.dap.middleware.iam.service.role.RoleCrudService)")
    public void refreshUpdate(JoinPoint joinPoint) {
        Role role = (Role)((Object)joinPoint.getArgs()[0]);
        this.refreshCacheService.deletePermissionByTenant(role.getTenantSid());
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.deleteById(long))&& target(com.digiwin.dap.middleware.iam.service.role.RoleCrudService)&& args(sid)")
    public void refreshDelete(long sid) {
        Role role = this.cacheMapper.findTenantSidByRoleSid(sid);
        if (role != null) {
            this.refreshCacheService.deletePermissionByTenant(role.getTenantSid());
        }
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.service.EntityWithPartitionManagerService.deleteBySidAndTenantSid(long,long))&& target(com.digiwin.dap.middleware.iam.service.role.RoleCrudService)&& args(sid,tenantSid)")
    public void logDelete(long sid, long tenantSid) {
    }
}

