/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect.entity;

import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RefreshSysInTenant {
    @Autowired
    private RefreshCacheService refreshCacheService;

    @Before(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.create(..)) && target(com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService)")
    public void refreshCreate(JoinPoint joinPoint) {
        SysInTenant sysInTenant = (SysInTenant)((Object)joinPoint.getArgs()[0]);
        this.refreshCacheService.deleteSysInTenant(sysInTenant.getTenantSid(), sysInTenant.getSysSid());
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.update(..)) && target(com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService)")
    public void refreshUpdate(JoinPoint joinPoint) {
        SysInTenant sysInTenant = (SysInTenant)((Object)joinPoint.getArgs()[0]);
        this.refreshCacheService.deleteSysInTenant(sysInTenant.getTenantSid(), sysInTenant.getSysSid());
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.saveAll(..)) && target(com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService)")
    public void refreshSaveAll(JoinPoint joinPoint) {
        Iterable sysInTenantIterable = (Iterable)joinPoint.getArgs()[0];
        for (SysInTenant sysInTenant : sysInTenantIterable) {
            this.refreshCacheService.deleteSysInTenant(sysInTenant.getTenantSid(), sysInTenant.getSysSid());
        }
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService.deleteByUnionKey(..)) && args(tenantSid, sysSid)", argNames="tenantSid,sysSid")
    public void refreshDelete(long tenantSid, long sysSid) {
        this.refreshCacheService.deleteSysInTenant(tenantSid, sysSid);
    }
}

