/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect.entity;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.iam.entity.SysOnPlatform;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RefreshSysOnPlatform {
    private static final Logger logger = LoggerFactory.getLogger(RefreshSysOnPlatform.class);
    @Autowired
    private RefreshCacheService refreshCacheService;

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.repository.SysOnPlatformRepository.saveAll(..))")
    public void refreshCreate(JoinPoint joinPoint) {
        this.deleteSelfCache(joinPoint);
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.iam.repository.SysOnPlatformRepository.deleteAll(..))")
    public void refreshDelete(JoinPoint joinPoint) {
        this.deleteSelfCache(joinPoint);
    }

    private void deleteSelfCache(JoinPoint joinPoint) {
        try {
            Object[] args = joinPoint.getArgs();
            List sysOnPlatforms = (List)args[0];
            if (sysOnPlatforms != null && !sysOnPlatforms.isEmpty()) {
                HashSet<String> keys = new HashSet<String>();
                String sysIdKey = String.format("dap:entity:sysonplatform:sys:%s", ((SysOnPlatform)((Object)sysOnPlatforms.get(0))).getSysId());
                keys.add(sysIdKey);
                List<String> platformIds = sysOnPlatforms.stream().map(SysOnPlatform::getPlatformSysId).collect(Collectors.toList());
                platformIds.forEach(p -> {
                    String platformIdKey = String.format("dap:entity:sysonplatform:platform:%s", p);
                    keys.add(platformIdKey);
                });
                RedisUtils.delete(keys);
                this.refreshCacheService.deleteCacAuthBySysAsync(platformIds);
            }
        }
        catch (Exception ex) {
            logger.error("\u6e05\u9664\u5e94\u7528\u5e73\u53f0\u5173\u7cfb\u7f13\u5b58\u51fa\u9519", (Throwable)ex);
        }
    }
}

