/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect.entity;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.domain.MessageType;
import com.digiwin.dap.middle.tx.stream.producer.TxProducerService;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.iam.constant.enums.TenantChangeType;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantChangeInfoDTO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.mapper.CacheMapper;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class RefreshTenant {
    @Autowired
    private CacheMapper cacheMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RefreshCacheService refreshCacheService;
    @Autowired
    private TxProducerService txProducerService;

    @Around(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.update(..))&& target(com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService)")
    public Object refreshUpdate(ProceedingJoinPoint joinPoint) throws Throwable {
        Tenant tenant = (Tenant)((Object)joinPoint.getArgs()[0]);
        Tenant oldTenant = this.cacheMapper.findTenantByTenantSid(tenant.getSid());
        Object result = joinPoint.proceed();
        if (!Objects.equals(tenant.getName(), oldTenant.getName()) && !StringUtils.isEmpty((Object)this.envProperties.getImgUri())) {
            this.refreshCacheService.updateImgTenantNameAsync(tenant.getSid(), tenant.getName());
        }
        if (tenant.isDealer() != oldTenant.isDealer()) {
            this.refreshCacheService.deletePermissionBySys("DigiwinCloud");
        }
        RedisUtils.delete((String)String.format("dap:entity:tenant:%s", tenant.getSid()));
        if (tenant.certainFieldChanged(oldTenant)) {
            List<String> userIds = this.cacheMapper.findUserIdsByTenantSid(tenant.getSid());
            String sysId = this.cacheMapper.findSysIdBySysId("DigiwinCloud");
            this.deleteRedis(userIds, tenant.getId(), sysId);
        }
        this.pushTenantInfoChange(tenant, TenantChangeType.UPDATE);
        return result;
    }

    private void deleteRedis(List<String> userIds, String tenantId, String sysId) {
        ArrayList allKeys = new ArrayList();
        userIds.stream().distinct().forEach(userId -> allKeys.add(String.format("iam:permission:auth:%s::%s::%s", userId, tenantId, sysId)));
        RedisUtils.delete(allKeys);
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.deleteById(long))&& target(com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService)&& args(sid)")
    public void refreshDelete(long sid) {
        RedisUtils.delete((String)String.format("dap:entity:tenant:%s", sid));
        this.refreshCacheService.deletePermissionByTenant(sid);
        Tenant tenant = new Tenant();
        tenant.setSid(sid);
        this.pushTenantInfoChange(tenant, TenantChangeType.DELETE);
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.saveAll(..))&& target(com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService)")
    public void refreshSaveAll(JoinPoint joinPoint) {
        Iterable tenantIterable = (Iterable)joinPoint.getArgs()[0];
        for (Tenant tenant : tenantIterable) {
            this.pushTenantInfoChange(tenant, TenantChangeType.UPDATE);
        }
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.create(..))&& target(com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService)")
    public void refreshCreate(JoinPoint joinPoint) {
        Tenant tenant = (Tenant)((Object)joinPoint.getArgs()[0]);
        this.pushTenantInfoChange(tenant, TenantChangeType.CREATE);
    }

    private void pushTenantInfoChange(Tenant tenant, TenantChangeType changeType) {
        if (tenant == null) {
            return;
        }
        MessageBody messageBody = new MessageBody();
        messageBody.setOpType(MessageType.INTERNAL.name());
        messageBody.setHeaderTag("tenantInfoChange");
        TenantChangeInfoDTO tenantChangeInfoDTO = new TenantChangeInfoDTO();
        tenantChangeInfoDTO.setTenantSid(tenant.getSid());
        tenantChangeInfoDTO.setTenantId(tenant.getId());
        tenantChangeInfoDTO.setChangeType(changeType.getValue());
        messageBody.setData((Object)tenantChangeInfoDTO);
        this.txProducerService.internal(messageBody, true);
    }
}

