/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect.entity;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.CacheMapper;
import com.digiwin.dap.middleware.iam.support.DeferredExecutionService;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RefreshUser {
    @Autowired
    private CacheMapper cacheMapper;
    @Autowired
    private RefreshCacheService refreshCacheService;
    @Autowired
    private DeferredExecutionService deferredExecutionService;

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.create(..)) && target(com.digiwin.dap.middleware.iam.service.user.UserCrudService)")
    public void refreshCreate(JoinPoint joinPoint) {
        User user = (User)((Object)joinPoint.getArgs()[0]);
        this.refreshCacheService.updateMetadata(user);
    }

    @Around(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.update(..))&& target(com.digiwin.dap.middleware.iam.service.user.UserCrudService)")
    public Object refreshUpdate(ProceedingJoinPoint joinPoint) throws Throwable {
        User user = (User)((Object)joinPoint.getArgs()[0]);
        String oldName = this.cacheMapper.findUserNameByUserSid(user.getSid());
        Object result = joinPoint.proceed();
        if (!Objects.equals(user.getName(), oldName)) {
            this.deferredExecutionService.runAfterCommit(() -> this.refreshCacheService.updateEocUserNameAsync(user, UserUtils.getToken()));
        }
        RedisUtils.delete((String)String.format("dap:entity:user:%s", user.getSid()));
        return result;
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.deleteById(long))&& target(com.digiwin.dap.middleware.iam.service.user.UserCrudService)&& args(sid)")
    public void refreshDelete(long sid) {
        RedisUtils.delete((String)String.format("dap:entity:user:%s", sid));
    }
}

