/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect.entity;

import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.UserInOrg;
import com.digiwin.dap.middleware.iam.mapper.CacheMapper;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class RefreshUserInOrg {
    @Autowired
    private CacheMapper cacheMapper;
    @Autowired
    private RefreshCacheService refreshCacheService;

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.create(..)) && target(com.digiwin.dap.middleware.iam.service.user.UserInOrgCrudService)")
    public void refreshCreate(JoinPoint joinPoint) {
        UserInOrg userInOrg = (UserInOrg)((Object)joinPoint.getArgs()[0]);
        this.deleteByUserAndOrg(userInOrg.getOrgSid(), Collections.singletonList(userInOrg.getUserSid()));
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.saveAll(java.util.List)) && target(com.digiwin.dap.middleware.iam.service.user.UserInOrgCrudService)")
    public void refreshCreateAll(JoinPoint joinPoint) {
        List list = (List)joinPoint.getArgs()[0];
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        this.deleteByUserAndOrg(((UserInOrg)((Object)list.get(0))).getOrgSid(), list.stream().map(UserInOrg::getUserSid).distinct().collect(Collectors.toList()));
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.iam.service.user.UserInOrgCrudService.deleteByUnionKey(long,long))&& args(userSid, orgSid)", argNames="userSid,orgSid")
    public void refreshUpdate(long userSid, long orgSid) {
        this.deleteByUserAndOrg(orgSid, Collections.singletonList(userSid));
    }

    @Before(value="execution(public * com.digiwin.dap.middleware.iam.service.user.UserInOrgCrudService.deleteByUserSidAndOrgSidIn(long, java.util.List))&& args(userSid, orgSids)", argNames="userSid,orgSids")
    public void refreshUpdate(long userSid, List<Long> orgSids) {
        if (CollectionUtils.isEmpty(orgSids)) {
            return;
        }
        this.deleteByUserAndOrg(orgSids.get(0), Collections.singletonList(userSid));
    }

    private void deleteByUserAndOrg(Long orgSids, List<Long> userSid) {
        Org org = this.cacheMapper.findOrgUriByOrgSid(orgSids);
        if (org != null) {
            this.refreshCacheService.deletePermissionByUserAndTenant(userSid, org.getTenantSid());
        }
    }
}

