/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect.entity;

import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.repository.AssociationRepository;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class RefreshUserInRole {
    @Autowired
    private RefreshCacheService refreshCacheService;
    @Autowired
    private AssociationRepository associationRepository;

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.create(..)) && target(com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService)")
    public void refreshCreate(JoinPoint joinPoint) {
        Association userInRole = (Association)((Object)joinPoint.getArgs()[0]);
        this.refreshCacheService.deletePermissionByUserAndTenant(userInRole.getUserSid(), userInRole.getTenantSid());
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.saveAll(java.util.List)) && target(com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService)")
    public void refreshCreateAll(JoinPoint joinPoint) {
        List list = (List)joinPoint.getArgs()[0];
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        this.refreshCacheService.deletePermissionByUserAndTenant(list.stream().map(Association::getUserSid).distinct().collect(Collectors.toList()), ((Association)((Object)list.get(0))).getTenantSid());
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.insertAll(java.util.List)) && target(com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService)")
    public void refreshInsertAll(JoinPoint joinPoint) {
        List associations = (List)joinPoint.getArgs()[0];
        if (CollectionUtils.isEmpty((Collection)associations)) {
            return;
        }
        this.refreshCacheService.deletePermissionByUserAndTenant(associations.stream().map(Association::getUserSid).collect(Collectors.toList()), ((Association)((Object)associations.get(0))).getTenantSid());
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.update(..)) && target(com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService)")
    public void refreshUpdate(JoinPoint joinPoint) {
        Association association = (Association)((Object)joinPoint.getArgs()[0]);
        this.refreshCacheService.deletePermissionByUserAndTenant(association.getUserSid(), association.getTenantSid());
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.repository.BaseEntityRepository.save(..)) && target(com.digiwin.dap.middleware.iam.repository.AssociationRepository)")
    public void refreshSave(JoinPoint joinPoint) {
        Association association = (Association)((Object)joinPoint.getArgs()[0]);
        this.refreshCacheService.deletePermissionByUserAndTenant(association.getUserSid(), association.getTenantSid());
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService.updateStatus(..))&& args(tenantSid, status, sids)", argNames="tenantSid, status, sids")
    public void refreshUpdate(long tenantSid, boolean status, List<Long> sids) {
        List<Association> associations = this.associationRepository.findBySidIn(sids);
        if (CollectionUtils.isEmpty(associations)) {
            return;
        }
        this.refreshCacheService.deletePermissionByUserAndTenant(associations.stream().map(Association::getUserSid).collect(Collectors.toList()), tenantSid);
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService.deleteByUnionKey(long,long,long))&& args(tenantSid, userSid, roleSid)", argNames="tenantSid,userSid,roleSid")
    public void refreshDelete(long tenantSid, long userSid, long roleSid) {
        this.refreshCacheService.deletePermissionByUserAndTenant(userSid, tenantSid);
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService.deleteByUnionKeyRoleSids(long,long,java.util.Collection))&& args(tenantSid, userSid, roleSids)", argNames="tenantSid,userSid,roleSids")
    public void refreshDelete(long tenantSid, long userSid, Collection<Long> roleSids) {
        this.refreshCacheService.deletePermissionByUserAndTenant(userSid, tenantSid);
    }
}

