/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.aspect.entity;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RefreshUserInTenant {
    @Autowired
    private RefreshCacheService refreshCacheService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService.deleteByUnionKey(long,long))&& args(tenantSid, userSid)", argNames="tenantSid,userSid")
    public void refreshCreate(long tenantSid, long userSid) {
        RedisUtils.delete((String)String.format("dap:entity:userintenant:%s:%s", tenantSid, userSid));
        this.refreshCacheService.deletePermissionByUserAndTenant(userSid, tenantSid);
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService.disable(long,long))&& args(tenantSid, userSid)", argNames="tenantSid,userSid")
    public void refreshDisable(long tenantSid, long userSid) {
        RedisUtils.delete((String)String.format("dap:entity:userintenant:%s:%s", tenantSid, userSid));
        this.refreshCacheService.deletePermissionByUserAndTenant(userSid, tenantSid);
    }

    @AfterReturning(value="execution(public * com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService.enable(long,long))&& args(tenantSid, userSid)", argNames="tenantSid,userSid")
    public void refreshEnable(long tenantSid, long userSid) {
        RedisUtils.delete((String)String.format("dap:entity:userintenant:%s:%s", tenantSid, userSid));
        this.refreshCacheService.deletePermissionByUserAndTenant(userSid, tenantSid);
    }

    @Around(value="execution(public * com.digiwin.dap.middleware.service.impl.BaseEntityManagerService.update(..))&& target(com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService)")
    public Object refreshStatus(ProceedingJoinPoint joinPoint) throws Throwable {
        UserInTenant userInTenant = (UserInTenant)((Object)joinPoint.getArgs()[0]);
        Object result = joinPoint.proceed();
        if (null != userInTenant) {
            RedisUtils.delete((String)String.format("dap:entity:userintenant:%s:%s", userInTenant.getTenantSid(), userInTenant.getUserSid()));
            this.refreshCacheService.deletePermissionByUserAndTenant(userInTenant.getUserSid(), userInTenant.getTenantSid());
        }
        return result;
    }
}

