/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.auth.domain;

import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class IamAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 500L;
    private LoginUser loginUser;
    private IamAuthoredUser user;

    public IamAuthenticationToken(LoginUser loginUser) {
        super(null);
        this.loginUser = loginUser;
        this.setAuthenticated(false);
    }

    public IamAuthenticationToken(IamAuthoredUser user, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.user = user;
        super.setAuthenticated(true);
    }

    public IamAuthoredUser getUser() {
        return this.user;
    }

    public LoginUser getLoginUser() {
        return this.loginUser;
    }

    public Object getCredentials() {
        if (this.isAuthenticated()) {
            return "";
        }
        return this.loginUser.getPassword();
    }

    public Object getDetails() {
        if (this.isAuthenticated()) {
            return this.user;
        }
        return this.loginUser;
    }

    public Object getPrincipal() {
        if (this.isAuthenticated()) {
            return this.user.getUserId();
        }
        return this.loginUser.getUserId();
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        if (isAuthenticated) {
            throw new IllegalArgumentException("Cannot set this token to trusted - use constructor which takes a GrantedAuthority list instead");
        }
        super.setAuthenticated(false);
    }

    public void eraseCredentials() {
        super.eraseCredentials();
        this.loginUser = null;
        this.user = null;
    }
}

