/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.auth.domain;

import com.digiwin.dap.middleware.auth.AuthoredDevice;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginSource;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthScopeApiVO;
import com.digiwin.dap.middleware.iam.domain.user.UserAndTenantSimpleInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.fasterxml.jackson.annotation.JsonProperty;
import eu.bitwalker.useragentutils.DeviceType;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class IamAuthoredUser
extends AuthoredUser
implements Serializable {
    private static final long serialVersionUID = -1870753571916142911L;
    private String email;
    private String telephone;
    private String address;
    @JsonProperty(value="isActivated")
    private boolean activated;
    @JsonProperty(value="isEnterprise")
    private Boolean enterprise;
    private Integer userType;
    private String comefrom;
    private boolean changed = true;
    private Boolean agreeAgreement;
    private String hash;
    @JsonProperty(value="isConfirm")
    private boolean confirm;
    @JsonProperty(value="isOwner")
    private boolean owner;
    @JsonProperty(value="isDealer")
    private boolean dealer;
    @JsonProperty(value="isEoc")
    private boolean eoc;
    private boolean corpWechat;
    private Integer enterpriseTenantType;
    private Boolean experience;
    private String version;
    private String appId;
    private boolean shared = true;
    private String tokenExpireSysId;
    private String dept;
    private String jobCode;
    private boolean kicked = false;
    private LocalDateTime kickedTime;
    private long tokenExpiresIn;
    private long tokenExpiresAt;
    private IdentityType identityType;
    private DeviceType deviceType = DeviceType.UNKNOWN;
    private Boolean needVerificationCode = false;
    private LocalDateTime verificationcodeTime;
    private String verificationcode;
    private String identityCodeAcceptType;
    private String userToken;
    private String setBy;
    private List<UserMetadataVO> metadata;
    private String acceptLanguage;
    private String loginInfo;
    private LoginSource loginSource;
    private AuthoredDevice device;
    private String tokenType = "digiwin";
    private LocalDate createBy;
    private List<UserMappingQueryResultVO> mapping;
    private List<OauthScopeApiVO> authoredApis = new ArrayList<OauthScopeApiVO>();
    private String agentAuthorizationCode;
    private List<UserAndTenantSimpleInfo> agentUserList;
    private String agentUserId;

    public static IamAuthoredUser createAuthoredUser(User user) {
        IamAuthoredUser authoredUser = new IamAuthoredUser();
        authoredUser.setCreateDate(LocalDateTime.now());
        authoredUser.setModifyDate(LocalDateTime.now());
        authoredUser.updateUser(user);
        return authoredUser;
    }

    public static IamAuthoredUser createAuthoredUser(User user, Tenant tenant) {
        IamAuthoredUser authoredUser = IamAuthoredUser.createAuthoredUser(user);
        authoredUser.updateTenant(tenant);
        return authoredUser;
    }

    public void updateUser(User user) {
        if (user != null) {
            this.setSid(user.getSid());
            this.setUserId(user.getId());
            this.setUserName(user.getName());
            this.setEmail(user.getEmail());
            this.setTelephone(user.getTelephone());
            this.setAddress(user.getAddress());
            this.setActivated(user.isActivated());
            this.setEnterprise(user.isEnterprise());
            this.setUserType(user.getType());
            this.setComefrom(user.getComeFrom());
            this.setChanged(user.isChanged());
            this.setAgreeAgreement(user.getAgreeAgreement());
            this.setHash(user.getHash());
        }
    }

    public void updateTenant(Tenant tenant) {
        if (tenant != null) {
            this.setTenantSid(tenant.getSid());
            this.setTenantId(tenant.getId());
            this.setTenantName(tenant.getName());
            this.setConfirm(tenant.getConfirm() == 1);
            this.setOwner(this.getSid() == tenant.getOwnerUserSid());
            this.setDealer(tenant.isDealer());
            this.setEoc(tenant.isEoc());
            this.setCorpWechat(tenant.isCorpWechat());
            this.setEnterpriseTenantType(tenant.getEnterpriseType());
            this.setExperience(tenant.isExperience());
            this.setVersion(tenant.getVersion());
        }
    }

    public void updateSys(Sys sys) {
        if (sys != null) {
            this.appId = sys.getId();
            this.shared = sys.isMultiLogin();
        }
    }

    public void renewal(String tokenKey, Long tokenExpire, Function<IamAuthoredUser, Long> tokenExpireFunction, boolean customizeTokenExpired) {
        if (this.renewal(customizeTokenExpired)) {
            this.setModifyDate(LocalDateTime.now());
            if (IdentityType.crossRegion == this.getIdentityType()) {
                this.setTokenExpiresAt(System.currentTimeMillis() + Duration.ofHours(2L).toMillis());
                this.setTokenExpiresIn(Duration.ofHours(2L).toMillis());
                String loginKey = LoginUser.uniqueKey(this.getUserId(), this.getTenantId(), this.getAppId(), this.getDeviceType(), this.getIdentityType(), this.getAgentUserId(), this.getDevice(), this.isShared());
                RedisUtils.set((String)loginKey, (Object)this.getToken(), (Duration)Duration.ofHours(2L));
                RedisUtils.set((String)tokenKey, (Object)this, (Duration)Duration.ofHours(2L));
            } else {
                if (Objects.isNull(tokenExpire)) {
                    tokenExpire = tokenExpireFunction.apply(this);
                }
                this.setTokenExpiresAt(System.currentTimeMillis() + Duration.ofMinutes(tokenExpire).toMillis());
                this.setTokenExpiresIn(Duration.ofMinutes(tokenExpire).toMillis());
                String loginKey = LoginUser.uniqueKey(this.getUserId(), this.getTenantId(), this.getAppId(), this.getDeviceType(), this.getIdentityType(), this.getAgentUserId(), this.getDevice(), this.isShared());
                RedisUtils.set((String)loginKey, (Object)this.getToken(), (Duration)Duration.ofMinutes(tokenExpire));
                RedisUtils.set((String)tokenKey, (Object)this, (Duration)Duration.ofMinutes(tokenExpire));
            }
        }
    }

    public boolean renewal(boolean customizeTokenExpired) {
        if (IdentityType.crossRegion == this.getIdentityType()) {
            return this.getTokenExpiresAt() - System.currentTimeMillis() < Duration.ofHours(1L).toMillis();
        }
        if ("virtual".equalsIgnoreCase(this.getUserId()) || "integration".equalsIgnoreCase(this.getUserId()) || DeviceType.MOBILE.equals((Object)this.getDeviceType()) || IamConstants.ALLOW_LONG_TOKEN_SOURCE.contains(Optional.ofNullable(this.getDevice()).map(AuthoredDevice::getSourceType).orElse(null))) {
            return super.renewal();
        }
        if (customizeTokenExpired) {
            return super.renewal(600000L);
        }
        if (this.getTokenExpiresAt() - System.currentTimeMillis() < Duration.ofDays(1L).toMillis()) {
            return super.renewal(600000L);
        }
        return super.renewal();
    }

    public void fixData(String deployArea) {
        if (!DeployAreaEnum.isProd((String)deployArea)) {
            this.mapping = new ArrayList<UserMappingQueryResultVO>();
        }
        if (!DeployAreaEnum.DevelopDev.name().equals(deployArea)) {
            this.loginInfo = null;
            this.loginSource = null;
            this.device = null;
        }
        if (this.getTokenExpiresAt() > 0L) {
            this.setTokenExpiresIn(this.getTokenExpiresAt() - System.currentTimeMillis());
        }
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public Boolean getEnterprise() {
        return this.enterprise;
    }

    public void setEnterprise(Boolean enterprise) {
        this.enterprise = enterprise;
    }

    public Integer getUserType() {
        return this.userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getComefrom() {
        return this.comefrom;
    }

    public void setComefrom(String comefrom) {
        this.comefrom = comefrom;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public Boolean getAgreeAgreement() {
        return this.agreeAgreement;
    }

    public void setAgreeAgreement(Boolean agreeAgreement) {
        this.agreeAgreement = agreeAgreement;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public boolean isOwner() {
        return this.owner;
    }

    public void setOwner(boolean owner) {
        this.owner = owner;
    }

    public boolean isDealer() {
        return this.dealer;
    }

    public void setDealer(boolean dealer) {
        this.dealer = dealer;
    }

    public boolean isEoc() {
        return this.eoc;
    }

    public void setEoc(boolean eoc) {
        this.eoc = eoc;
    }

    public boolean isCorpWechat() {
        return this.corpWechat;
    }

    public void setCorpWechat(boolean corpWechat) {
        this.corpWechat = corpWechat;
    }

    public Integer getEnterpriseTenantType() {
        return this.enterpriseTenantType;
    }

    public void setEnterpriseTenantType(Integer enterpriseTenantType) {
        this.enterpriseTenantType = enterpriseTenantType;
    }

    public Boolean getExperience() {
        return this.experience;
    }

    public void setExperience(Boolean experience) {
        this.experience = experience;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public String getDept() {
        return this.dept;
    }

    public void setDept(String dept) {
        this.dept = dept;
    }

    public String getJobCode() {
        return this.jobCode;
    }

    public void setJobCode(String jobCode) {
        this.jobCode = jobCode;
    }

    public boolean isKicked() {
        return this.kicked;
    }

    public void setKicked(boolean kicked) {
        this.kicked = kicked;
    }

    public LocalDateTime getKickedTime() {
        return this.kickedTime;
    }

    public void setKickedTime(LocalDateTime kickedTime) {
        this.kickedTime = kickedTime;
    }

    public long getTokenExpiresIn() {
        return this.tokenExpiresIn;
    }

    public void setTokenExpiresIn(long tokenExpiresIn) {
        this.tokenExpiresIn = tokenExpiresIn;
    }

    public long getTokenExpiresAt() {
        return this.tokenExpiresAt;
    }

    public void setTokenExpiresAt(long tokenExpiresAt) {
        this.tokenExpiresAt = tokenExpiresAt;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public void setIdentityType(IdentityType identityType) {
        this.identityType = identityType;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public Boolean getNeedVerificationCode() {
        return this.needVerificationCode;
    }

    public void setNeedVerificationCode(Boolean needVerificationCode) {
        this.needVerificationCode = needVerificationCode;
    }

    public LocalDateTime getVerificationcodeTime() {
        return this.verificationcodeTime;
    }

    public void setVerificationcodeTime(LocalDateTime verificationcodeTime) {
        this.verificationcodeTime = verificationcodeTime;
    }

    public String getVerificationcode() {
        return this.verificationcode;
    }

    public void setVerificationcode(String verificationcode) {
        this.verificationcode = verificationcode;
    }

    public String getIdentityCodeAcceptType() {
        return this.identityCodeAcceptType;
    }

    public void setIdentityCodeAcceptType(String identityCodeAcceptType) {
        this.identityCodeAcceptType = identityCodeAcceptType;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public List<UserMetadataVO> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<UserMetadataVO> metadata) {
        this.metadata = metadata;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public List<OauthScopeApiVO> getAuthoredApis() {
        return this.authoredApis;
    }

    public void setAuthoredApis(List<OauthScopeApiVO> authoredApis) {
        this.authoredApis = authoredApis;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public LocalDate getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(LocalDate createBy) {
        this.createBy = createBy;
    }

    public List<UserMappingQueryResultVO> getMapping() {
        return this.mapping;
    }

    public void setMapping(List<UserMappingQueryResultVO> mapping) {
        this.mapping = mapping;
    }

    public String getLoginInfo() {
        return this.loginInfo;
    }

    public void setLoginInfo(String loginInfo) {
        this.loginInfo = loginInfo;
    }

    public LoginSource getLoginSource() {
        return this.loginSource;
    }

    public void setLoginSource(LoginSource loginSource) {
        this.loginSource = loginSource;
    }

    public String getAgentAuthorizationCode() {
        return this.agentAuthorizationCode;
    }

    public void setAgentAuthorizationCode(String agentAuthorizationCode) {
        this.agentAuthorizationCode = agentAuthorizationCode;
    }

    public List<UserAndTenantSimpleInfo> getAgentUserList() {
        return this.agentUserList;
    }

    public void setAgentUserList(List<UserAndTenantSimpleInfo> agentUserList) {
        this.agentUserList = agentUserList;
    }

    public String getAgentUserId() {
        return this.agentUserId;
    }

    public void setAgentUserId(String agentUserId) {
        this.agentUserId = agentUserId;
    }

    public String getSetBy() {
        return this.setBy;
    }

    public void setSetBy(String setBy) {
        this.setBy = setBy;
    }

    public AuthoredDevice getDevice() {
        return this.device;
    }

    public void setDevice(AuthoredDevice device) {
        this.device = device;
    }

    public String getTokenExpireSysId() {
        return this.tokenExpireSysId;
    }

    public void setTokenExpireSysId(String tokenExpireSysId) {
        this.tokenExpireSysId = tokenExpireSysId;
    }
}

