/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.auth.filter;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthenticationToken;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.util.StringUtils;

public class OauthAccessTokenAuthenticationFilter
extends BasicAuthenticationFilter {
    private AuthoredUserService authoredUserService;

    public OauthAccessTokenAuthenticationFilter(AuthenticationManager authenticationManager, AuthoredUserService authoredUserService) {
        super(authenticationManager);
        this.authoredUserService = authoredUserService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String accessToken;
        String string = accessToken = StringUtils.isEmpty((Object)request.getHeader(GlobalConstants.HTTP_HEADER_OAUTH_ACCESS_TOKEN_KEY)) ? request.getHeader("authorization") : request.getHeader(GlobalConstants.HTTP_HEADER_OAUTH_ACCESS_TOKEN_KEY);
        if (StringUtils.isEmpty((Object)accessToken)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (accessToken.contains("Basic")) {
            return;
        }
        if (accessToken.contains("Bearer")) {
            accessToken = accessToken.replace("Bearer", "").trim();
        }
        IamAuthoredUser iamAuthoredUser = this.authoredUserService.getOauthUser(accessToken, request);
        IamAuthenticationToken authentication = new IamAuthenticationToken(iamAuthoredUser, null);
        request.setAttribute("digi-middleware-auth-user-data", authentication.getDetails());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        AppAuthContextHolder.getContext().setAuthoredUser((AuthoredUser)authentication.getUser());
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

