/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.cache.impl;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.iam.domain.app.ActionTenantVO;
import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuEffect;
import com.digiwin.dap.middleware.iam.domain.sys.SysWithPlatformVO;
import com.digiwin.dap.middleware.iam.domain.sys.tree.ActionNode;
import com.digiwin.dap.middleware.iam.domain.sys.tree.BaseNode;
import com.digiwin.dap.middleware.iam.domain.sys.tree.ConditionNode;
import com.digiwin.dap.middleware.iam.domain.sys.tree.SysNode;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.MetadataMapper;
import com.digiwin.dap.middleware.iam.mapper.SysInTenantMapper;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInTenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@CacheConfig(cacheNames={"default"}, cacheManager="dapCommonCacheManager")
@Service
public class CommonCacheServiceImpl
implements CommonCacheService {
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private MetadataMapper metadataMapper;
    @Autowired
    private UserInTenantMapper userInTenantMapper;
    @Autowired
    private SysInTenantMapper sysInTenantMapper;

    @Override
    @Cacheable(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).METADATA_PREFIX + #tenantSid + ':' + #userSid")
    public List<UserMetadataVO> getMetadata(long tenantSid, long userSid) {
        return this.metadataMapper.findByTenantSidAndUserSid(tenantSid, userSid);
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).SYS_PREFIX + #sysId + '::' + #tenantId")
    public boolean existsBySysIdAndTenantId(String sysId, String tenantId) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            return false;
        }
        Sys sys = this.sysMapper.findByTenantSidAndId(tenant.getSid(), sysId);
        return sys != null;
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).SYS_PREFIX + #sysId")
    public Sys getSysById(String sysId) {
        return this.sysMapper.findById(sysId);
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).SOP_PLATFORM_PREFIX + #platformId")
    public List<String> getSysByPlatformId(String platformId) {
        return this.sysMapper.getSysByPlatformId(platformId);
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).SOP_SYS_PREFIX + #sysId")
    public List<String> getPlatformSysBySysId(String sysId) {
        return this.sysMapper.getPlatformSysBySysId(sysId);
    }

    @Override
    public List<SysWithPlatformVO> getPlatformSysInSysIds(List<String> sysIds) {
        List<SysWithPlatformVO> results = this.sysMapper.findPlatformBySysIds(sysIds);
        results.forEach(s -> {
            String redisKey = "entity:sysonplatform:sys:" + s.getId();
            RedisUtils.set((String)redisKey, s.getAppIds());
        });
        return results;
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).USER_PREFIX + #userSid")
    public User getUserBySid(long userSid) {
        return this.userMapper.findBySid(userSid);
    }

    @Override
    @CacheEvict(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).USER_PREFIX + #userSid")
    public void deleteUserCacheBySid(long userSid) {
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).TENANT_PREFIX + #tenantSid")
    public Tenant getTenantBySid(long tenantSid) {
        return this.tenantMapper.findBySid(tenantSid);
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).USER_IN_TENANT_PREFIX + #tenantSid + ':' + #userSid", unless="#result==null")
    public UserInTenant getUserInTenant(long tenantSid, long userSid) {
        return this.userInTenantMapper.getUserInTenant(tenantSid, userSid);
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).SYS_IN_TENANT_PREFIX + #sysId + ':' + #tenantSid")
    public SysInTenant getSysInTenant(String sysId, Long tenantSid) {
        return this.sysInTenantMapper.getSysInTenantSimpleInfoBySysIdAndTenantSid(tenantSid, sysId);
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).PERMISSION_SYS_TREE_PREFIX + #sysSid", cacheManager="cacheManager")
    public SysNode getSysTree(long sysSid) {
        SysNode sysNode = this.sysMapper.findSys(sysSid);
        sysNode.setModules(this.sysMapper.findModules(sysSid));
        sysNode.setActions(this.sysMapper.findActions(sysSid, 0L));
        List<ConditionNode> conditions = this.sysMapper.findConditions(sysSid, 0L);
        Map<Long, List<ConditionNode>> actionConditionMap = conditions.stream().collect(Collectors.groupingBy(ConditionNode::getActionSid));
        sysNode.getActions().forEach(action -> {
            List conditionNodes = actionConditionMap.getOrDefault(action.getSid(), new ArrayList());
            if (Boolean.TRUE.equals(action.getRegardlessAuth())) {
                conditionNodes.forEach(c -> {
                    if (ObjectUtils.nullSafeEquals((Object)MenuEffect.allow.name(), (Object)c.getValue())) {
                        c.setValue(MenuEffect.allow.name());
                    }
                });
            }
            action.setCondition(conditionNodes.stream().collect(Collectors.toMap(BaseNode::getId, ConditionNode::getValue)));
            action.setConditions(conditionNodes);
        });
        return sysNode;
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).PERMISSION_SYS_TREE_PREFIX + #sysSid+ ':' + #tenantSid", cacheManager="cacheManager")
    public List<ActionNode> getSysTree(long sysSid, long tenantSid) {
        List<ActionNode> actions = this.sysMapper.findActions(sysSid, tenantSid);
        List<ConditionNode> conditions = this.sysMapper.findConditions(sysSid, tenantSid);
        Map<Long, Map<String, String>> conditionsMap = conditions.stream().collect(Collectors.groupingBy(ConditionNode::getActionSid, Collectors.toMap(BaseNode::getId, ConditionNode::getValue)));
        actions.forEach(action -> action.setCondition(conditionsMap.getOrDefault(action.getSid(), new HashMap())));
        return actions;
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).PERMISSION_ACTION_TENANT_PREFIX + #sysSid", cacheManager="cacheManager")
    public List<ActionTenantVO> getActionTenant(long sysSid) {
        return this.sysMapper.findActionTenant(sysSid);
    }
}

